# Contributing

Thank you for your interest in contributing to this project! Here’s how you can get started:

## Before You Start

1. Check the [existing issues](https://github.com/sean1832/pinterest-dl/issues) to ensure your idea or bug isn’t already being addressed.
2. If it’s new, feel free to open an issue or proceed with your contribution.

## Getting Started

1. Fork the repository.
2. Create a new branch for your changes.
3. Make your changes.
4. Submit a pull request (PR) to the main branch.

## Commit Message Guidelines

Use [semantic commit messages](https://www.conventionalcommits.org/en/v1.0.0/) to ensure clarity and consistency. Each commit message should follow this format:

```
<type>: <short description>

<optional detailed description>
```

### Commit Types
- **feat**: A new feature (e.g., `feat: add image download functionality`).
- **fix**: A bug fix (e.g., `fix: resolve null pointer error in parser`).
- **docs**: Documentation changes (e.g., `docs: update README for installation`).
- **style**: Code style changes that do not affect logic (e.g., `style: reformat code with black`).
- **chore**: Maintenance tasks (e.g., `chore: update dependencies`).

## Installation

Use a virtual environment to keep dependencies isolated:

```bash
git clone https://github.com/sean1832/pinterest-dl.git
pip install -e .
```

## Submitting a Pull Request

- **Start Early**: Submit your PR even if it’s a work-in-progress (WIP). Include a clear description of your changes and the purpose.
- **Document**: Add or update documentation if your changes impact the functionality or usage.
- **Communicate**: Mention any pending items that need resolution before the PR can be merged.


## Code of Conduct

We are committed to fostering a welcoming and inclusive community. Please be respectful and considerate when participating.

Thank you for contributing!

