"""Tests for MaxNTO encoding."""

from ferrmion.encode import MaxNTO
from ferrmion.utils import check_trivial_overlap
import numpy as np

def test_max_nto(water_integrals):
    mnto = MaxNTO(14)
    ipowers, symplectics = mnto._build_symplectic_matrix()
    valid, nto = check_trivial_overlap(symplectics)

    assert valid
    assert np.all(ipowers == np.array([0,1,0,1,2,3,2,3,0,1,0,1,2,3,2,3,0,1,0,1,2,3,2,3,0,1,0,1], dtype=np.uint8))
    assert np.all(symplectics == np.array([[False,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True, False, False, False,
        False, False, False, False, False, False, False, False, False,
        False],
       [False,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True, False,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True, False, False,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True, False,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True, False, False, False,
        False, False, False, False, False, False, False, False, False,
        False],
       [ True,  True, False,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True, False,
        False, False, False, False, False, False, False, False, False,
        False],
       [ True,  True, False,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True, False, False,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True, False,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True, False, False, False, False,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True, False,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True, False,
        False, False, False, False, False, False, False, False, False,
        False],
       [ True,  True,  True,  True, False,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True, False, False, False, False, False, False, False, False,
        False],
       [ True,  True,  True,  True, False,  True,  True,  True,  True,
         True,  True,  True,  True,  True, False, False, False, False,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True, False,  True,  True,  True,
         True,  True,  True,  True,  True, False, False, False, False,
        False, False,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True, False,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True, False, False, False, False, False, False, False, False,
        False],
       [ True,  True,  True,  True,  True,  True, False,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True, False, False, False, False, False, False,
        False],
       [ True,  True,  True,  True,  True,  True, False,  True,  True,
         True,  True,  True,  True,  True, False, False, False, False,
        False, False,  True,  True,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True, False,  True,
         True,  True,  True,  True,  True, False, False, False, False,
        False, False, False, False,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True, False,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True, False, False, False, False, False, False,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True, False,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True, False, False, False, False,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True, False,
         True,  True,  True,  True,  True, False, False, False, False,
        False, False, False, False,  True,  True,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
        False,  True,  True,  True,  True, False, False, False, False,
        False, False, False, False, False, False,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
        False,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True, False, False, False, False,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True, False,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True, False, False,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True, False,  True,  True,  True, False, False, False, False,
        False, False, False, False, False, False,  True,  True,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True, False,  True,  True, False, False, False, False,
        False, False, False, False, False, False, False, False,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True, False,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True, False, False,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True, False,  True,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True, False,  True, False, False, False, False,
        False, False, False, False, False, False, False, False,  True,
         True],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True, False, False, False, False, False,
        False, False, False, False, False, False, False, False, False,
        False],
       [ True,  True,  True,  True,  True,  True,  True,  True,  True,
         True,  True,  True,  True, False,  True,  True,  True,  True,
         True,  True,  True,  True,  True,  True,  True,  True,  True,
        False]]))
    assert np.all(nto == np.array([[ 0., 13., 13.,  1.,  3., 13., 11.,  3.,  5., 11.,  9.,  5.,  7.,
         9.,  7.,  7.,  9.,  7.,  5.,  9., 11.,  5.,  3., 11., 13.,  3.,
         1., 13.],
       [13.,  0.,  1., 13., 13.,  3.,  3., 11., 11.,  5.,  5.,  9.,  9.,
         7.,  7.,  7.,  7.,  9.,  9.,  5.,  5., 11., 11.,  3.,  3., 13.,
        13.,  1.],
       [13.,  1.,  0., 13., 13.,  1.,  1., 11., 11.,  3.,  3.,  9.,  9.,
         5.,  5.,  7.,  7.,  7.,  7.,  5.,  5.,  9.,  9.,  3.,  3., 11.,
        11.,  1.],
       [ 1., 13., 13.,  0.,  1., 13., 11.,  1.,  3., 11.,  9.,  3.,  5.,
         9.,  7.,  5.,  7.,  7.,  5.,  7.,  9.,  5.,  3.,  9., 11.,  3.,
         1., 11.],
       [ 3., 13., 13.,  1.,  0., 13., 13.,  1.,  3., 13., 11.,  3.,  5.,
        11.,  9.,  5.,  7.,  9.,  7.,  7.,  9.,  7.,  5.,  9., 11.,  5.,
         3., 11.],
       [13.,  3.,  1., 13., 13.,  0.,  1., 13., 13.,  3.,  3., 11., 11.,
         5.,  5.,  9.,  9.,  7.,  7.,  7.,  7.,  9.,  9.,  5.,  5., 11.,
        11.,  3.],
       [11.,  3.,  1., 11., 13.,  1.,  0., 13., 13.,  1.,  1., 11., 11.,
         3.,  3.,  9.,  9.,  5.,  5.,  7.,  7.,  7.,  7.,  5.,  5.,  9.,
         9.,  3.],
       [ 3., 11., 11.,  1.,  1., 13., 13.,  0.,  1., 13., 11.,  1.,  3.,
        11.,  9.,  3.,  5.,  9.,  7.,  5.,  7.,  7.,  5.,  7.,  9.,  5.,
         3.,  9.],
       [ 5., 11., 11.,  3.,  3., 13., 13.,  1.,  0., 13., 13.,  1.,  3.,
        13., 11.,  3.,  5., 11.,  9.,  5.,  7.,  9.,  7.,  7.,  9.,  7.,
         5.,  9.],
       [11.,  5.,  3., 11., 13.,  3.,  1., 13., 13.,  0.,  1., 13., 13.,
         3.,  3., 11., 11.,  5.,  5.,  9.,  9.,  7.,  7.,  7.,  7.,  9.,
         9.,  5.],
       [ 9.,  5.,  3.,  9., 11.,  3.,  1., 11., 13.,  1.,  0., 13., 13.,
         1.,  1., 11., 11.,  3.,  3.,  9.,  9.,  5.,  5.,  7.,  7.,  7.,
         7.,  5.],
       [ 5.,  9.,  9.,  3.,  3., 11., 11.,  1.,  1., 13., 13.,  0.,  1.,
        13., 11.,  1.,  3., 11.,  9.,  3.,  5.,  9.,  7.,  5.,  7.,  7.,
         5.,  7.],
       [ 7.,  9.,  9.,  5.,  5., 11., 11.,  3.,  3., 13., 13.,  1.,  0.,
        13., 13.,  1.,  3., 13., 11.,  3.,  5., 11.,  9.,  5.,  7.,  9.,
         7.,  7.],
       [ 9.,  7.,  5.,  9., 11.,  5.,  3., 11., 13.,  3.,  1., 13., 13.,
         0.,  1., 13., 13.,  3.,  3., 11., 11.,  5.,  5.,  9.,  9.,  7.,
         7.,  7.],
       [ 7.,  7.,  5.,  7.,  9.,  5.,  3.,  9., 11.,  3.,  1., 11., 13.,
         1.,  0., 13., 13.,  1.,  1., 11., 11.,  3.,  3.,  9.,  9.,  5.,
         5.,  7.],
       [ 7.,  7.,  7.,  5.,  5.,  9.,  9.,  3.,  3., 11., 11.,  1.,  1.,
        13., 13.,  0.,  1., 13., 11.,  1.,  3., 11.,  9.,  3.,  5.,  9.,
         7.,  5.],
       [ 9.,  7.,  7.,  7.,  7.,  9.,  9.,  5.,  5., 11., 11.,  3.,  3.,
        13., 13.,  1.,  0., 13., 13.,  1.,  3., 13., 11.,  3.,  5., 11.,
         9.,  5.],
       [ 7.,  9.,  7.,  7.,  9.,  7.,  5.,  9., 11.,  5.,  3., 11., 13.,
         3.,  1., 13., 13.,  0.,  1., 13., 13.,  3.,  3., 11., 11.,  5.,
         5.,  9.],
       [ 5.,  9.,  7.,  5.,  7.,  7.,  5.,  7.,  9.,  5.,  3.,  9., 11.,
         3.,  1., 11., 13.,  1.,  0., 13., 13.,  1.,  1., 11., 11.,  3.,
         3.,  9.],
       [ 9.,  5.,  5.,  7.,  7.,  7.,  7.,  5.,  5.,  9.,  9.,  3.,  3.,
        11., 11.,  1.,  1., 13., 13.,  0.,  1., 13., 11.,  1.,  3., 11.,
         9.,  3.],
       [11.,  5.,  5.,  9.,  9.,  7.,  7.,  7.,  7.,  9.,  9.,  5.,  5.,
        11., 11.,  3.,  3., 13., 13.,  1.,  0., 13., 13.,  1.,  3., 13.,
        11.,  3.],
       [ 5., 11.,  9.,  5.,  7.,  9.,  7.,  7.,  9.,  7.,  5.,  9., 11.,
         5.,  3., 11., 13.,  3.,  1., 13., 13.,  0.,  1., 13., 13.,  3.,
         3., 11.],
       [ 3., 11.,  9.,  3.,  5.,  9.,  7.,  5.,  7.,  7.,  5.,  7.,  9.,
         5.,  3.,  9., 11.,  3.,  1., 11., 13.,  1.,  0., 13., 13.,  1.,
         1., 11.],
       [11.,  3.,  3.,  9.,  9.,  5.,  5.,  7.,  7.,  7.,  7.,  5.,  5.,
         9.,  9.,  3.,  3., 11., 11.,  1.,  1., 13., 13.,  0.,  1., 13.,
        11.,  1.],
       [13.,  3.,  3., 11., 11.,  5.,  5.,  9.,  9.,  7.,  7.,  7.,  7.,
         9.,  9.,  5.,  5., 11., 11.,  3.,  3., 13., 13.,  1.,  0., 13.,
        13.,  1.],
       [ 3., 13., 11.,  3.,  5., 11.,  9.,  5.,  7.,  9.,  7.,  7.,  9.,
         7.,  5.,  9., 11.,  5.,  3., 11., 13.,  3.,  1., 13., 13.,  0.,
         1., 13.],
       [ 1., 13., 11.,  1.,  3., 11.,  9.,  3.,  5.,  9.,  7.,  5.,  7.,
         7.,  5.,  7.,  9.,  5.,  3.,  9., 11.,  3.,  1., 11., 13.,  1.,
         0., 13.],
       [13.,  1.,  1., 11., 11.,  3.,  3.,  9.,  9.,  5.,  5.,  7.,  7.,
         7.,  7.,  5.,  5.,  9.,  9.,  3.,  3., 11., 11.,  1.,  1., 13.,
        13.,  0.]]))
