import time
import re
from threading import Thread

def esperar(tiempo_str, continuar=False, accion=None):
    """
    Función que acepta una cadena con un tiempo en formato amigable
    y hace un sleep correspondiente.
    
    Ejemplo de uso: esperar("1m") para 1 minuto, esperar("2h") para 2 horas.
    
    Si continuar es True, el código seguirá ejecutándose mientras espera.
    También se puede pasar una función a "accion" que se ejecutará
    después de que termine de esperar.
    """
    # Usamos expresiones regulares para extraer el valor y la unidad
    match = re.match(r"(\d+)([smhd])", tiempo_str.lower())
    
    if match:
        valor = int(match.group(1))
        unidad = match.group(2)
        
        # Convertir el tiempo a segundos según la unidad
        if unidad == "s":  # segundos
            tiempo_en_segundos = valor
        elif unidad == "m":  # minutos
            tiempo_en_segundos = valor * 60
        elif unidad == "h":  # horas
            tiempo_en_segundos = valor * 3600
        elif unidad == "d":  # días
            tiempo_en_segundos = valor * 86400
        else:
            raise ValueError("Unidad de tiempo no válida")
        
        print(f"Esperando durante {valor} {unidad}.")
        
        if continuar:
            # Usamos un hilo en segundo plano para no bloquear el código
            def espera():
                time.sleep(tiempo_en_segundos)
                if accion:  # Si se pasó una acción, la ejecutamos
                    exec(accion)  # Ejecutamos la acción como un bloque de código
            Thread(target=espera).start()
        else:
            time.sleep(tiempo_en_segundos)
            if accion:  # Si se pasó una acción, la ejecutamos al finalizar
                exec(accion)  # Ejecutamos la acción como un bloque de código
    else:
        raise ValueError("Formato de tiempo no válido. Usa 's', 'm', 'h' o 'd'. Ejemplo: '1m' para un minuto.")

# Ejemplos de uso:

# Definir la acción como un bloque de código en el mismo momento
esperar("10s", continuar=False, accion="print('¡Han pasado 10 segundos!')")

# Esperar 1 minuto y ejecutar una función en el mismo lugar
esperar("1m", continuar=False, accion="print('¡1 minuto ha pasado!')")

# Función más compleja como acción
esperar("2h", continuar=True, accion="""
def tarea_despues_de_esperar():
    print("¡Ya pasaron 2 horas! Realizando tarea.")
tarea_despues_de_esperar()
""")
