"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/cdk");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
const loggingBucket = new s3.Bucket(stack, 'Bucket', {
    removalPolicy: cdk.RemovalPolicy.Destroy
});
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ]
        }
    ],
    loggingConfig: {
        bucket: loggingBucket,
        includeCookies: true,
        prefix: 'test-prefix'
    }
});
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably2', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ]
        }
    ],
    loggingConfig: {}
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2xvdWRmcm9udC1idWNrZXQtbG9nZ2luZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmNsb3VkZnJvbnQtYnVja2V0LWxvZ2dpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxzQ0FBdUM7QUFDdkMsb0NBQXFDO0FBQ3JDLHFDQUFzQztBQUV0QyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFFOUQsTUFBTSxhQUFhLEdBQUcsSUFBSSxFQUFFLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7SUFDbkQsYUFBYSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTztDQUN6QyxDQUFDLENBQUM7QUFFSCxJQUFJLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxLQUFLLEVBQUUsMEJBQTBCLEVBQUU7SUFDMUUsYUFBYSxFQUFFO1FBQ2I7WUFDRSxhQUFhLEVBQUU7Z0JBQ2IsaUJBQWlCLEVBQUUsV0FBVzthQUMvQjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixVQUFVLEVBQUUsa0JBQWtCO2FBQy9CO1lBQ0QsU0FBUyxFQUFFO2dCQUNUO29CQUNBLGlCQUFpQixFQUFFLElBQUk7aUJBQ3RCO2FBQ0Y7U0FDRjtLQUNGO0lBQ0QsYUFBYSxFQUFFO1FBQ2IsTUFBTSxFQUFFLGFBQWE7UUFDckIsY0FBYyxFQUFFLElBQUk7UUFDcEIsTUFBTSxFQUFFLGFBQWE7S0FDdEI7Q0FDRixDQUFDLENBQUM7QUFFSCxJQUFJLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxLQUFLLEVBQUUsMkJBQTJCLEVBQUU7SUFDM0UsYUFBYSxFQUFFO1FBQ2I7WUFDRSxhQUFhLEVBQUU7Z0JBQ2IsaUJBQWlCLEVBQUUsV0FBVzthQUMvQjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixVQUFVLEVBQUUsa0JBQWtCO2FBQy9CO1lBQ0QsU0FBUyxFQUFFO2dCQUNUO29CQUNBLGlCQUFpQixFQUFFLElBQUk7aUJBQ3RCO2FBQ0Y7U0FDRjtLQUNGO0lBQ0QsYUFBYSxFQUFFLEVBQUU7Q0FDbEIsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHMzID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLXMzJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgY2xvdWRmcm9udCA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1jbG91ZGZyb250LWN1c3RvbScpO1xuXG5jb25zdCBsb2dnaW5nQnVja2V0ID0gbmV3IHMzLkJ1Y2tldChzdGFjaywgJ0J1Y2tldCcsIHtcbiAgcmVtb3ZhbFBvbGljeTogY2RrLlJlbW92YWxQb2xpY3kuRGVzdHJveVxufSk7XG5cbm5ldyBjbG91ZGZyb250LkNsb3VkRnJvbnRXZWJEaXN0cmlidXRpb24oc3RhY2ssICdBbkFtYXppbmdXZWJzaXRlUHJvYmFibHknLCB7XG4gIG9yaWdpbkNvbmZpZ3M6IFtcbiAgICB7XG4gICAgICBvcmlnaW5IZWFkZXJzOiB7XG4gICAgICAgIFwiWC1DdXN0b20tSGVhZGVyXCI6IFwic29tZXZhbHVlXCIsXG4gICAgICB9LFxuICAgICAgY3VzdG9tT3JpZ2luU291cmNlOiB7XG4gICAgICAgIGRvbWFpbk5hbWU6IFwiYnJlbGFuZG0uYTJ6LmNvbVwiLFxuICAgICAgfSxcbiAgICAgIGJlaGF2aW9yczogW1xuICAgICAgICB7XG4gICAgICAgIGlzRGVmYXVsdEJlaGF2aW9yOiB0cnVlLFxuICAgICAgICB9XG4gICAgICBdXG4gICAgfVxuICBdLFxuICBsb2dnaW5nQ29uZmlnOiB7XG4gICAgYnVja2V0OiBsb2dnaW5nQnVja2V0LFxuICAgIGluY2x1ZGVDb29raWVzOiB0cnVlLFxuICAgIHByZWZpeDogJ3Rlc3QtcHJlZml4J1xuICB9XG59KTtcblxubmV3IGNsb3VkZnJvbnQuQ2xvdWRGcm9udFdlYkRpc3RyaWJ1dGlvbihzdGFjaywgJ0FuQW1hemluZ1dlYnNpdGVQcm9iYWJseTInLCB7XG4gIG9yaWdpbkNvbmZpZ3M6IFtcbiAgICB7XG4gICAgICBvcmlnaW5IZWFkZXJzOiB7XG4gICAgICAgIFwiWC1DdXN0b20tSGVhZGVyXCI6IFwic29tZXZhbHVlXCIsXG4gICAgICB9LFxuICAgICAgY3VzdG9tT3JpZ2luU291cmNlOiB7XG4gICAgICAgIGRvbWFpbk5hbWU6IFwiYnJlbGFuZG0uYTJ6LmNvbVwiLFxuICAgICAgfSxcbiAgICAgIGJlaGF2aW9yczogW1xuICAgICAgICB7XG4gICAgICAgIGlzRGVmYXVsdEJlaGF2aW9yOiB0cnVlLFxuICAgICAgICB9XG4gICAgICBdXG4gICAgfVxuICBdLFxuICBsb2dnaW5nQ29uZmlnOiB7fVxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19