"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-cloudfront-custom');
new cloudfront.CloudFrontWebDistribution(stack, 'AnAmazingWebsiteProbably', {
    originConfigs: [
        {
            originHeaders: {
                "X-Custom-Header": "somevalue",
            },
            customOriginSource: {
                domainName: "brelandm.a2z.com",
            },
            behaviors: [
                {
                    isDefaultBehavior: true,
                }
            ],
        }
    ],
    defaultRootObject: ''
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2xvdWRmcm9udC1lbXB0eS1yb290LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuY2xvdWRmcm9udC1lbXB0eS1yb290LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0Esb0NBQXFDO0FBQ3JDLHFDQUFzQztBQUV0QyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDJCQUEyQixDQUFDLENBQUM7QUFFOUQsSUFBSSxVQUFVLENBQUMseUJBQXlCLENBQUMsS0FBSyxFQUFFLDBCQUEwQixFQUFFO0lBQzFFLGFBQWEsRUFBRTtRQUNiO1lBQ0UsYUFBYSxFQUFFO2dCQUNiLGlCQUFpQixFQUFFLFdBQVc7YUFDL0I7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsVUFBVSxFQUFFLGtCQUFrQjthQUMvQjtZQUNELFNBQVMsRUFBRTtnQkFDVDtvQkFDQSxpQkFBaUIsRUFBRSxJQUFJO2lCQUN0QjthQUNGO1NBQ0Y7S0FDRjtJQUNELGlCQUFpQixFQUFFLEVBQUU7Q0FDdEIsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiXG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgY2xvdWRmcm9udCA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1jbG91ZGZyb250LWN1c3RvbScpO1xuXG5uZXcgY2xvdWRmcm9udC5DbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uKHN0YWNrLCAnQW5BbWF6aW5nV2Vic2l0ZVByb2JhYmx5Jywge1xuICBvcmlnaW5Db25maWdzOiBbXG4gICAge1xuICAgICAgb3JpZ2luSGVhZGVyczoge1xuICAgICAgICBcIlgtQ3VzdG9tLUhlYWRlclwiOiBcInNvbWV2YWx1ZVwiLFxuICAgICAgfSxcbiAgICAgIGN1c3RvbU9yaWdpblNvdXJjZToge1xuICAgICAgICBkb21haW5OYW1lOiBcImJyZWxhbmRtLmEyei5jb21cIixcbiAgICAgIH0sXG4gICAgICBiZWhhdmlvcnM6IFtcbiAgICAgICAge1xuICAgICAgICBpc0RlZmF1bHRCZWhhdmlvcjogdHJ1ZSxcbiAgICAgICAgfVxuICAgICAgXSxcbiAgICB9XG4gIF0sXG4gIGRlZmF1bHRSb290T2JqZWN0OiAnJ1xufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19