"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/cdk");
const cloudfront = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integ-cloudfront-s3');
const bucket = new s3.Bucket(stack, 'Bucket', { removalPolicy: cdk.RemovalPolicy.Destroy });
const oai = new cloudfront.CfnCloudFrontOriginAccessIdentity(stack, 'OAI', {
    cloudFrontOriginAccessIdentityConfig: {
        comment: 'Allows CloudFront to reach to the bucket!',
    }
});
const dist = new cloudfront.CloudFrontWebDistribution(stack, 'Distribution', {
    originConfigs: [{
            behaviors: [{ isDefaultBehavior: true }],
            s3OriginSource: {
                s3BucketSource: bucket,
                originAccessIdentityId: oai.refAsString,
            },
        }]
});
bucket.addToResourcePolicy(new iam.PolicyStatement({
    actions: ['s3:Get*', 's3:List*'],
    resources: [bucket.bucketArn, bucket.arnForObjects('*')],
    principals: [new iam.CanonicalUserPrincipal(oai.attrS3CanonicalUserId)],
}));
new cdk.CfnOutput(stack, 'DistributionDomainName', { value: dist.domainName });
//# sourceMappingURL=data:application/json;base64,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