#
#    ICRAR - International Centre for Radio Astronomy Research
#    (c) UWA - The University of Western Australia, 2020
#    Copyright by UWA (in the framework of the ICRAR)
#    All rights reserved
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#    MA 02111-1307  USA
#
import os
import subprocess


def get_git_version():
    out = subprocess.check_output(["git", "rev-parse", "HEAD"])
    return out.strip().decode("ascii")


def get_version_info(version, is_release):
    git_version = "Unknown"
    if os.path.exists("../.git"):
        git_version = get_git_version()
    full_version = version
    if not is_release:
        full_version = "%s.dev0+%s" % (version, git_version[:7])
    return full_version, git_version


def version_as_string(version_tuple):
    return "%d.%d.%d" % version_tuple


def write_version_info(version_tuple, version_file, is_release):
    tpl = """
# THIS FILE IS GENERATED BY version_helper.py
# DO NOT MODIFY BY HAND
version = '%(version)s'
git_version = '%(git_version)s'
full_version = '%(full_version)s'
is_release = %(is_release)s

if not is_release:
    version = full_version
"""
    version = version_as_string(version_tuple)
    full_version, git_version = get_version_info(version, is_release)
    with open(version_file, "w") as f:
        info = tpl % {
            "version": version,
            "full_version": full_version,
            "git_version": git_version,
            "is_release": is_release,
        }
        f.write(info.strip())
    return full_version
