/**
 * @file ${obj.name.lower()}_gatt_server.h
 * @brief ${obj.desc.strip()}
 * @author auto-generated by mrt-gatt (https://mrt.readthedocs.io/en/latest/pages/mrtutils/mrt-gatt.html)
 * @date ${obj.genTime}
 * 
 * Using this file
 * ===============
 * 
 * Basic Use: 
 * ----------
 * 
 * Basic use lets this module and the ${obj.name.lower()}_gatts_evt_handler take care of everything. This means
 * To use this, just call '${obj.name.lower()}_gatts_start()' in your application after initializing the esp ble system. 
 * 
 * #include "${obj.name.lower()}_gatt_server.h"
 * 
 * void app_main_old(void)
 * {
 * 
 *     // Initialize NVS.
 *     nvs_flash_init();
 *     esp_bt_controller_config_t bt_cfg = BT_CONTROLLER_INIT_CONFIG_DEFAULT();
 *     esp_bt_controller_init(&bt_cfg);
 *     esp_bt_controller_enable(ESP_BT_MODE_BLE);
 *     esp_bluedroid_init();
 *     esp_bluedroid_enable();
 *     esp_ble_gap_register_callback(gap_event_handler);
 * 
 *     ${obj.name.lower()}_gatts_start();
 * 
 *     return;
 * }
 * 
 * 
 * 
 * 
 * Advanced Use:
 * -------------
 * 
 * For more advanced control of the gatt server (such as manually handling read requests and security) 
 * see the documentation for the mrt_gatt_interface (https://mrt.readthedocs.io/en/latest/pages/mrtutils/mrt-gatt.html)
 * 
 */

#ifdef __cplusplus
extern "C"
{
#endif

/* Includes ------------------------------------------------------------------*/
#include "interface/esp32_gatt_adapter.h"

%for svc in obj.services:
#include "svc/${svc.prefix}_svc.h"
%endfor



/*user-block-top-start*/
/*user-block-top-end*/

/* Exported Macros ------------------------------------------------------------*/

/* Exported types ------------------------------------------------------------*/

/**
 * While everything can be managed using the mrt_gatt_interface structs (mrt_gatt_pro_t, mrt_gatt_svc_t, mrt_gatt_char_t)
 * These implementation specific structs provide a much easier structure for debug and testing
 */
typedef struct{
    mrt_gatt_pro_t mPro;
%for svc in obj.services:
    ${t.padAfter("{0}_svc_t* m{1};".format(svc.prefix,t.camelCase(svc.name) ), 45)}/* ${svc.desc} */
%endfor
}${obj.name.lower()}_profile_t;

/* Exported constants --------------------------------------------------------*/
extern ${obj.name.lower()}_profile_t ${obj.name.lower()}_profile;

/* Exported functions ------------------------------------------------------- */

/**
 * @brief Initializes the profile service structs
 * @return mrt_status_t 
 */
mrt_status_t ${obj.name.lower()}_profile_init(void);

/**
 * @brief Registers the services with the esp ble component
 * @return MRT_STATUS_OK or MRT_STATUS_ERROR 
 */
mrt_status_t ${obj.name.lower()}_profile_register_services(esp_gatt_if_t gatts_if);

/**
 * @brief Starts the gatt server.
 * @note this function will register a new gatts_event_handler
 */
esp_err_t ${obj.name.lower()}_gatts_start(void);


/**
 * @brief Gatts event handler. This will manage the gatt server events
 */
void ${obj.name.lower()}_gatts_evt_handler(esp_gatts_cb_event_t event, esp_gatt_if_t gatts_if,esp_ble_gatts_cb_param_t *param);

/**
 * @brief Gap event handler. You can register this one, or define and register your own
 */
void ${obj.name.lower()}_gap_evt_handler(esp_gap_ble_cb_event_t event, esp_ble_gap_cb_param_t *param);

/**
 * @brief Use this to start the gatt server as a task
 */
void task_${obj.name.lower()}_gatts( void * pvParameters );

/*user-block-functions-start*/
/*user-block-functions-end*/

#ifdef __cplusplus
}
#endif
