/**
  * @file ${obj.name.lower()}.c
  * @author generated by mrt-device utility 
  * @link [https://mrt.readthedocs.io/en/latest/pages/mrtutils/mrt-device.html]
  * @brief Device driver for ${obj.name} device
  *
  */


/* Includes ------------------------------------------------------------------*/
#include "${obj.name.lower()}.h"

/*user-block-top-start*/
/* Private Variables ---------------------------------------------------------*/
/* Private Functions ---------------------------------------------------------*/
/*user-block-top-end*/


/**
 * @brief initializes device
 * @param dev ptr to ${obj.name} device
 * @return status 
 */
static mrt_status_t ${obj.prefix.lower()}_init(${obj.name.lower()}_t* dev)
{   
    /* Initialize Register Descriptors */
% for key,reg in obj.regs.items():
    REG_INIT( dev->${"m" + obj.camelCase(reg.name)} , ${obj.prefix.upper() +"_REG_"+reg.name.upper()+"_ADDR"} , ${t.cTypeDict[reg.type]}, REG_PERM_${reg.perm} , ${reg.formatHex(reg.default)}  );
% endfor

%if 'init' in obj.configs:
    /* Load Configuration 'init' */
%for regVal in obj.configs['init'].regVals:
    ${obj.getConfigLine(regVal, 48)} ${obj.configs['init'].getDesc(regVal)}
%endfor
%endif

    /*user-block-init-start*/
    /*user-block-init-end*/

    return MRT_STATUS_OK;
}


% if "I2C" in obj.bus.upper():
mrt_status_t ${obj.prefix.lower()}_init_i2c(${obj.name.lower()}_t* dev, mrt_i2c_handle_t i2c)
{
    mrt_status_t status;

    status = init_i2c_register_device(&dev->mRegDev, i2c, ${obj.name.upper()}_I2C_ADDRESS, ${obj.name.upper()}_REG_ADDR_SIZE );

    ${obj.prefix.lower()}_init(dev);


    /*user-block-init-i2c-start*/
    /*user-block-init-i2c-end*/
    
    return status;
}
% endif
% if "SPI" in obj.bus.upper():
mrt_status_t ${obj.prefix.lower()}_init_spi(${obj.name.lower()}_t* dev, mrt_spi_handle_t spi, mrt_gpio_t chipSelect)
{
    mrt_status_t status;

    status = init_spi_register_device(&dev->mRegDev, spi, chipSelect, ${obj.name.upper()}_REG_ADDR_SIZE );

    ${obj.prefix.lower()}_init(dev);

    /*user-block-spi-start*/
    /*user-block-spi-end*/

    return status;
}
% endif

mrt_status_t ${obj.prefix.lower()}_test(${obj.name.lower()}_t* dev)
{
    mrt_status_t status = MRT_STATUS_ERROR;
    /*user-block-test-start*/

    /*user-block-test-end*/
    return status;
}


/*user-block-bottom-start*/
/*user-block-bottom-end*/

