JAVA_SLIPS = [
    {
        "slipNo": 1,
        "questions": [
            {
                "question": """Write a Program to print all Prime numbers in an array of ‘n’ elements.
                            (use command line arguments)""",
                "filenames": ["prime.java"]
            },
            {
                "question": """Define an abstract class Staff with protected members id and name. Define a parameterized
                            constructor. Define one subclass OfficeStaff with member department. Create n objects of
                            OfficeStaff and display all details""",
                "filenames": ["Q2.java"]
            },
        ],
        "answers": {
            "prime.java": """class prime {
    public static boolean isPrime(int num) {
        if (num <= 1) {
            return false;
        } else {
            for (int i = 2; i < (num / 2); i++) {
                if (num % i == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public static void main(String args[]) {
        if (args.length == 0) {
            System.out.println("please enter the command line arguments");
        }
        int num = 0;
        for (int i = 0; i < args.length; i++) {
            num = Integer.parseInt(args[i]);
            if (isPrime(num)) {
                System.out.println(num + " is a prime number");
            }else{
                System.out.println(num + " is not prime number");
            }
        }
    }
}
""",
            "Q2.java": """import java.util.*;
abstract class staff {
    protected int id;
    protected String name;

    public staff(int no, String str) {
        this.id = no;
        this.name = str;
    }
}

class OfficeStaff extends staff {
    public String department;

    OfficeStaff(int id, String name, String department) {
        super(id, name);
        this.department = department;
    }

    public void Display() {
        System.out.println("ID: " + id + ", Name: " + name + ", Department: " + department);
    }
}

public class Q2 {
    public static void main(String args[]) {
        Scanner sc = new Scanner(System.in);
        System.out.print("Enter number of Office Staff: ");
        int n = sc.nextInt();

        OfficeStaff[] ofs = new OfficeStaff[n];
        for (int i = 0; i < n; i++) {
            System.out.println("Enter details of staff " + (i + 1));
            System.out.print("Enter ID: ");
            int id = sc.nextInt();
              sc.nextLine();
            System.out.print("Enter Name: ");
            String name = sc.nextLine();
            System.out.print("Enter Department: ");
            String dept = sc.nextLine();
            ofs[i] = new OfficeStaff(id, name, dept);
        }
        System.out.println("--- Staff Details ---");
        for (int i = 0; i < n; i++) {
            ofs[i].Display();
        }
    }
}
"""
        }
    },
    {
        "slipNo": 2,
        "questions": [
            {
                "question": """Write a program to read the First Name and Last Name of a person, his weight and height using
command line arguments. Calculate the BMI Index which is defined as the individual's body mass divided by the square of their height.
(Hint : BMI = Wts. In kgs / (ht)2)""",
                "filenames": ["BMI.java"]
            },
            {
                "question": """Define a class CricketPlayer (name,no_of_innings,no_of_times_notout, totatruns, bat_avg).
Create an array of n player objects .Calculate the batting average for each player using static
method avg(). Define a static sort method which sorts the array on the basis of average. Display
the player details in sorted order.""",
                "filenames": ["battingAvg.java"]
            },
        ],
        "answers": {
            "BMI.java": """public class BMI {
    public static void main(String args[]) {
        String fname = args[0];
        String lname = args[1];
        double wet = Double.parseDouble(args[2]);
        double heig = Double.parseDouble(args[3]);

        double bmi = wet / (heig * heig);

        System.out.println("Name: " + fname + " " + lname);
        System.out.println("Weight: " + wet);
        System.out.println("Height: " + heig);
        System.out.printf("BMI:" + bmi);
    }
}
""",
            "battingAvg.java": """import java.util.*;

class CricketPlayer {
    String name;
    int no_of_innings;
    int no_of_times_notout;
    int total_runs;
    double bat_avg;

    CricketPlayer(String name, int innings, int notout, int runs) {
        this.name = name;
        this.no_of_innings = innings;
        this.no_of_times_notout = notout;
        this.total_runs = runs;
        this.bat_avg = 0.0;
    }

    public static void avg(CricketPlayer player) {
        int outs = player.no_of_innings - player.no_of_times_notout;
        if (outs > 0) {
            player.bat_avg = (double) player.total_runs / outs;
        } else {
            player.bat_avg = player.total_runs;
        }
    }

    public static void sort(CricketPlayer[] players) {
    for (int i = 0; i < players.length - 1; i++) {
        for (int j = i + 1; j < players.length; j++) {
            if (players[i].bat_avg < players[j].bat_avg) {
                CricketPlayer temp = players[i];
                players[i] = players[j];
                players[j] = temp;
            }
        }
    }
}


    public void Display() {
    System.out.println(" Name:" + name + " Innings:" + no_of_innings +
                      " NotOut:" + no_of_times_notout +
                      " Runs: " + total_runs +
                      " Avg: " + bat_avg + " ");}

}

public class battingAvg {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of players: ");
        int n = sc.nextInt();
        sc.nextLine();
        CricketPlayer[] cp = new CricketPlayer[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for Player " + (i + 1));
            System.out.print("Name: ");
            String name = sc.nextLine();
            System.out.print("Number of Innings: ");
            int innings = sc.nextInt();
            System.out.print("Number of times Not Out: ");
            int notout = sc.nextInt();
            System.out.print("Total Runs: ");
            int run = sc.nextInt();
            sc.nextLine();

            cp[i] = new CricketPlayer(name, innings, notout, run);

            CricketPlayer.avg(cp[i]);
        }
        CricketPlayer.sort(cp);
        System.out.println(" Sorted Player Details  by Batting Average");
        for (CricketPlayer p : cp) {
            p.Display();
        }
    }
}
"""
        }
    },
    {
        "slipNo": 3,
        "questions": [
            {
                "question": """Write a program to accept ‘n’ name of cities from the user and sort them in ascending
order""",
                "filenames": ["sortCity.java"]
            },
            {
                "question": """Define a class patient (patient_name, patient_age, patient_oxy_level,patient_HRCT_report).
Create an object of patient. Handle appropriate exception while patient oxygen level less than
95% and HRCT scan report greater than 10, then throw user defined Exception “Patient is Covid
Positive(+) and Need to Hospitalized” otherwise display its information""",
                "filenames": ["HRCTReport.java"]
            },
        ],
        "answers": {
            "sortCity.java": """import java.util.*;

public class sortCity {

    public static void Display_Or(String arr[]) {

        for (int i = 0; i < arr.length; i++) {
            System.out.println(" " + arr[i]);
        }
    }

    public static void Display_sorted(String arr[]) {
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; i++) {
            System.out.println(" " + arr[i]);
        }
    }

    public static void main(String args[]) {
        Scanner sc = new Scanner(System.in);
        System.out.print("how many cities you enter: ");
        int len = sc.nextInt();
         sc.nextLine();

        String arr[] = new String[len];

        System.out.println("Enter cities :");
        for (int i = 0; i < len; i++) {
            arr[i] = sc.nextLine();
        }
        System.out.println("----Display original----");
        Display_Or(arr);
        System.out.println("----Display original sorted----");
        Display_sorted(arr);
    }
}
""",
            "HRCTReport.java": """import java.util.*;

class CovidPositiveException extends Exception {
    public CovidPositiveException(String msg) {
        super(msg);
    }
}

class Patient {
    String pname;
    int page;
    int p_oxy_level;
    int p_hrct_report;

    public Patient(String str, int age, int oxy, int hrct) {
        this.pname = str;
        this.page = age;
        this.p_oxy_level = oxy;
        this.p_hrct_report = hrct;
    }

    public void checkPatient() throws CovidPositiveException {
        if (p_oxy_level < 95 && p_hrct_report > 10) {
            throw new CovidPositiveException("Patient is Covid Positive and Need to Hospital");
        } else {
            System.out.println("----Patient Information----");
            System.out.println("Name: " + pname);
            System.out.println("Age: " + page);
            System.out.println("Oxygen Level: " + p_oxy_level);
            System.out.println("HRCT Report: " + p_hrct_report);
        }
    }
}

public class HRCTReport {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter Patient Name: ");
        String name = sc.nextLine();

        System.out.print("Enter Patient Age: ");
        int age = sc.nextInt();

        System.out.print("Enter Oxygen Level: ");
        int oxy = sc.nextInt();

        System.out.print("Enter HRCT Report Score: ");
        int hrct = sc.nextInt();

        Patient p = new Patient(name, age, oxy, hrct);

        try {
            p.checkPatient();
        } catch (CovidPositiveException e) {
            System.out.println("Exception: " + e.getMessage());
        }
    }
}
"""
        }
    },
    {
        "slipNo": 4,
        "questions": [
            {
                "question": """Write a program to print an array after changing the rows and columns of a given
two-dimensional array""",
                "filenames": ["ArrayTranspose.java"]
            },
            {
                "question": """Write a program to design a screen using Awt that will take a user name and password. If
the user name and password are not same, raise an Exception with appropriate message.
User can have 3 login chances only. Use clear button to clear the TextFields.""",
                "filenames": ["LoginScreen.java"]
            },
        ],
        "answers": {
            "ArrayTranspose.java": """import java.util.Scanner;

public class ArrayTranspose {
    public static void main(String[] args) {

        Scanner sc = new Scanner(System.in);
        System.out.print("Enter size of row: ");
        int row = sc.nextInt();
        System.out.print("Enter size of col: ");
        int col = sc.nextInt();

        int[][] arr = new int[row][col];

        System.out.println("Enter  elements in 2D Array :");
        for (int i = 0; i < row; i++) {
            for (int j = 0; j < col; j++) {
                arr[i][j] = sc.nextInt();
            }
        }

        int[][] trans = new int[col][row];

        for (int i = 0; i < row; i++) {
            for (int j = 0; j < col; j++) {
                trans[j][i] = arr[i][j];
            }
        }

        System.out.println("---Transpose matrix---");
        for (int i = 0; i < col; i++) {
            for (int j = 0; j < row; j++) {
                System.out.print(trans[i][j] + " ");
            }
            System.out.println();
        }

    }
}
""",
            "LoginScreen.java": """import java.awt.*;
import java.awt.event.*;

class InvalidLoginException extends Exception {
    public InvalidLoginException(String msg) {
        super(msg);
    }
}

public class LoginScreen extends Frame implements ActionListener {
    Label l1, l2, lmsg;
    TextField tuser, tpass;
    Button blogin, bclear;
    int attempts = 0;

    public LoginScreen() {
        setTitle("Login Screen");
        setSize(350, 200);
        setLayout(new GridLayout(4, 2, 10, 10));

        l1 = new Label("Username:");
        l2 = new Label("Password:");
        lmsg = new Label("");

        tuser = new TextField(20);
        tpass = new TextField(20);
         tpass.setEchoChar('*');

        blogin = new Button("Login");
        bclear = new Button("Clear");

        add(l1); add(tuser);
        add(l2); add(tpass);
        add(blogin); add(bclear);
        add(lmsg);

        blogin.addActionListener(this);
        bclear.addActionListener(this);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });

        setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == blogin) {
            try {
                String user = tuser.getText();
                String pass = tpass.getText();

                if (!user.equals(pass)) {
                    attempts++;
                    throw new InvalidLoginException("Invalid Login! Username and Password must match.");
                } else {
                    lmsg.setText("Login Successful!");
                }
            } catch (InvalidLoginException e) {
                if (attempts >= 3) {
                    lmsg.setText("Max Attempts Reached. Access Denied!");
                    blogin.setEnabled(false);
                } else {
                    lmsg.setText(e.getMessage() + " Attempts left: " + (3 - attempts));
                }
            }
        } else if (ae.getSource() == bclear) {
            tuser.setText("");
            tpass.setText("");
            lmsg.setText("");
        }
    }

    public static void main(String[] args) {
        new LoginScreen();
    }
}
"""
        }
    },
    {
        "slipNo": 5,
        "questions": [
            {
                "question": """Write a program for multilevel inheritance such that Country is inherited from Continent.
State is inherited from Country. Display the place, State, Country and Continent.""",
                "filenames": ["MultiInherit.java"]
            },
            {
                "question": """Write a menu driven program to perform the following operations on multidimensional array
ie matrices :
 Addition
 Multiplication
 Exit""",
                "filenames": ["MatrixOperations.java"]
            },
        ],
        "answers": {
            "MultiInherit.java": """import java.util.Scanner;

class Continent {
    String continentName;

    Continent(String cname) {
        continentName = cname;
    }
}

class Country extends Continent {
    String countryName;

    Country(String cname, String coname) {
        super(coname);
        countryName = cname;
    }
}

class State extends Country {
    String stateName;

    State(String sname, String cname, String coname) {
        super(cname, coname);
        stateName = sname;
    }
}

class Place extends State {
    String placeName;

    Place(String pname, String sname, String cname, String coname) {
        super(sname, cname, coname);
        placeName = pname;
    }

    void display() {
        System.out.println("--- Location Details ---");
        System.out.println("Place     : " + placeName);
        System.out.println("State     : " + stateName);
        System.out.println("Country   : " + countryName);
        System.out.println("Continent : " + continentName);
    }
}

public class MultiInherit {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter Continent: ");
        String continent = sc.nextLine();

        System.out.print("Enter Country: ");
        String country = sc.nextLine();

        System.out.print("Enter State: ");
        String state = sc.nextLine();

        System.out.print("Enter Place: ");
        String place = sc.nextLine();

        Place p = new Place(place, state, country, continent);
        p.display();


    }
}
""",
            "MatrixOperations.java": """import java.util.*;

public class MatrixOperations {

    public static void Add(int arr[][], int brr[][], int row, int col) {
        for (int i = 0; i < row; i++) {
            for (int j = 0; j < col; j++) {
                System.out.print(" " +( arr[i][j] + brr[i][j]));
            }
            System.out.println();
        }
    }

    public static void Mut(int arr[][], int brr[][], int row, int col) {
        for (int i = 0; i < row; i++) {
            for (int j = 0; j < col; j++) {
                System.out.print(" " + arr[i][j] * brr[i][j]);
            }
            System.out.println();
        }
    }

    public static void main(String args[]) {
        Scanner sc = new Scanner(System.in);

        System.out.println("Enter row size: ");
        int row = sc.nextInt();

        System.out.println("Enter row size: ");
        int col = sc.nextInt();

        int arr[][] = new int[row][col];
        int brr[][] = new int[row][col];

        System.out.println("Enter 1st arr elements :");
        for (int i = 0; i < row; i++) {
            for (int j = 0; j < row; j++) {
                arr[i][j] = sc.nextInt();
            }
        }

        System.out.println("Enter 2nd arr elements :");
        for (int i = 0; i < row; i++) {
            for (int j = 0; j < row; j++) {
                brr[i][j] = sc.nextInt();
            }
        }

        int ch = 0;
        do {
            System.out.println("0.Exit");
            System.out.println("1.Addition");
            System.out.println("2.Mutiplication");
            System.out.println("--Enter your choice--");
            ch = sc.nextInt();
            switch (ch) {
                case 0:
                    return;
                case 1:
                    Add(arr, brr, row, col);
                    break;
                case 2:
                    Mut(arr, brr, row, col);
                    break;
            }
        } while (ch != 3);

    }
}"""
        }
    },
    {
        "slipNo": 6,
        "questions": [
            {
                "question": """Write a program to display the Employee(Empid, Empname, Empdesignation, Empsal)
information using toString().""",
                "filenames": ["Emp.java"]
            },
            {
                "question": """Create an abstract class “order” having members id, description. Create two subclasses
“PurchaseOrder” and “Sales Order” having members customer name and Vendor name
respectively. Definemethods accept and display in all cases. Create 3 objects each of Purchase
Order and Sales Order and accept and display details.""",
                "filenames": ["OrderDemo.java"]
            },
        ],
        "answers": {
            "Emp.java": """import java.util.*;

class Employee {
    int Eid;
    String Ename;
    String Edest;
    Double Esal;

    Employee(int id, String str1, String str2, double sl) {
        this.Eid = id;
        this.Ename = str1;
        this.Edest = str2;
        this.Esal = sl;
    }

    public String toString() {
        return ("Eid: " + Eid +
                " Ename: " + Ename +
                " Edest: " + Edest +
                " Esal: " + Esal);
    }
}

public class Emp {
    public static void main(String args[]) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter Employee ID: ");
        int id = sc.nextInt();
        sc.nextLine(); // consume newline

        System.out.print("Enter Employee Name: ");
        String name = sc.nextLine();

        System.out.print("Enter Employee Designation: ");
        String designation = sc.nextLine();

        System.out.print("Enter Employee Salary: ");
        double salary = sc.nextDouble();

        Employee emp = new Employee(id, name, designation, salary);

        System.out.println("--- Employee Details ---");
        System.out.println(emp);
    }
}
""",
            "OrderDemo.java": """import java.util.*;

abstract class Order {
    int id;
    String description;

    abstract void accept(Scanner sc);
    abstract void display();
}

class PurchaseOrder extends Order {
    String customerName;

    void accept(Scanner sc) {
        System.out.print("Enter Purchase Order ID: ");
        id = sc.nextInt();
        sc.nextLine();

        System.out.print("Enter Description: ");
        description = sc.nextLine();

        System.out.print("Enter Customer Name: ");
        customerName = sc.nextLine();
    }

    void display() {
        System.out.println("--- Purchase Order ---");
        System.out.println("Order ID      : " + id);
        System.out.println("Description   : " + description);
        System.out.println("Customer Name : " + customerName);
    }
}

class SalesOrder extends Order {
    String vendorName;
    void accept(Scanner sc) {
        System.out.print("Enter Sales Order ID: ");
        id = sc.nextInt();
        sc.nextLine();

        System.out.print("Enter Description: ");
        description = sc.nextLine();

        System.out.print("Enter Vendor Name: ");
        vendorName = sc.nextLine();
    }
    void display() {
        System.out.println("--- Sales Order ---");
        System.out.println("Order ID     : " + id);
        System.out.println("Description  : " + description);
        System.out.println("Vendor Name  : " + vendorName);
    }
}

public class OrderDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        PurchaseOrder[] po = new PurchaseOrder[3];
        for (int i = 0; i < 3; i++) {
            po[i] = new PurchaseOrder();
            System.out.println("Enter details for Purchase Order " + (i + 1));
            po[i].accept(sc);
        }
        SalesOrder[] so = new SalesOrder[3];
        for (int i = 0; i < 3; i++) {
            so[i] = new SalesOrder();
            System.out.println("Enter details for Sales Order " + (i + 1));
            so[i].accept(sc);
        }

        System.out.println("---Purchase Orders---");
        for (PurchaseOrder p : po) {
            p.display();
        }
        System.out.println("---Sales Orders---");
        for (SalesOrder s : so) {
            s.display();
        }

    }
}
"""
        }
    },
    {
        "slipNo": 7,
        "questions": [
            {
                "question": """Design a class for Bank. Bank Class should support following operations;
a. Deposit a certain amount into an account
b. Withdraw a certain amount from an account
c. Return a Balance value specifying the amount with details""",
                "filenames": ["BankAccount.java"]
            },
            {
                "question": """Write a program to accept a text file from user and display the contents of a file in
reverse order and change its case.""",
                "filenames": ["FileReverse.java"]
            },
            {
                "question": """Text File""",
                "filenames": ["data.txt"]
            },
        ],
        "answers": {
            "BankAccount.java": """
import java.util.Scanner;

class BankAccount {
    int accNo;
    String accHolderName;
    double bal;

    public BankAccount(int accNo, String accHolderName, double initialBal) {
        this.accNo = accNo;
        this.accHolderName = accHolderName;
        this.bal = initialBal;
    }

    public void deposit(double amount) {
        if (amount > 0) {
            bal += amount;
            System.out.println("Amount " + amount + " deposited successfully");
        } else {
            System.out.println("Invalid deposit amount");
        }
    }

    public void withdraw(double amount) {
        if (amount > 0 && amount <= bal) {
            bal -= amount;
            System.out.println("" + amount + " withdrawn successfully.");
        } else if (amount > bal) {
            System.out.println("Insufficient balance");
        } else {
            System.out.println("Invalid withdrawal amount");
        }
    }

    public void getBalance() {
        System.out.println("Account Details:");
        System.out.println("Account No: " + accNo);
        System.out.println("Account Holder: " + accHolderName);
        System.out.println("Current Balance: " + bal);
    }

    public static void main(String[] args) {

        Scanner sc = new Scanner(System.in);

        BankAccount act = new BankAccount(99, "Abc", 9999.99);

        int ch;
        do {

            System.out.println("0. Exit");
            System.out.println("1. Deposit");
            System.out.println("2. Withdraw");
            System.out.println("3. Check Balance");
            System.out.print("Enter your choice: ");
            ch = sc.nextInt();

            switch (ch) {
                case 0:
                    return;
                case 1:
                    System.out.print("Enter amount to deposit: ");
                    double dep = sc.nextDouble();
                    act.deposit(dep);
                    break;
                case 2:
                    System.out.print("Enter amount to withdraw: ");
                    double wth = sc.nextDouble();
                    act.withdraw(wth);
                    break;
                case 3:
                    act.getBalance();
                    break;
            }
        } while (ch != 4);

    }
}
""",
            "FileReverse.java": """
import java.io.*;
import java.util.*;

public class FileReverse {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.print("Enter file txt name : ");
        String fileName = sc.nextLine();

        try {
            StringBuilder content = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line).append("\\n");
            }

            content.reverse();

            StringBuilder modified = new StringBuilder();
            for (int i = 0; i < content.length(); i++) {
                char ch = content.charAt(i);
                if (Character.isUpperCase(ch)) {
                    modified.append(Character.toLowerCase(ch));
                } else if (Character.isLowerCase(ch)) {
                    modified.append(Character.toUpperCase(ch));
                } else {
                    modified.append(ch);
                }
            }

            System.out.println("---Modified File Content---");
            System.out.println(modified);

        } catch (IOException e) {
            System.out.println("error: " + e.getMessage());
        }

    }
}
""",
            "data.txt": """This is a programming world"""
        }
    },
    {
        "slipNo": 8,
        "questions": [
            {
                "question": """Create a class Sphere, to calculate the volume and surface area of sphere.
(Hint : Surface area=4*3.14(r*r), Volume=(4/3)3.14(r*r*r))""",
                "filenames": ["SphereDemo.java"]
            },
            {
                "question": """Design a screen to handle the Mouse Events such as MOUSE_MOVED
and MOUSE_CLICKED and display the position of the Mouse_Click in a TextField.""",
                "filenames": ["MouseEventDemo.java"]
            },
        ],
        "answers": {
            "SphereDemo.java": """import java.util.*;

class Sphere {
    private double radius;

    public Sphere(double radius) {
        this.radius = radius;
    }

    public double getSurfaceArea() {
        return 4 * 3.14 * (radius * radius);
    }

    public double getVolume() {
        return (4.0 / 3.0) * 3.14 * (radius * radius * radius);
    }

    public void display() {
        System.out.println("radius: " + radius);
        System.out.println("surface area: " + getSurfaceArea());
        System.out.println("volume: " + getVolume());
    }
}

public class SphereDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.print("enter radius of sphere: ");
        double r = sc.nextDouble();

        Sphere sp = new Sphere(r);
        sp.display();

    }
}
""",
            "MouseEventDemo.java": """import java.awt.*;
import java.awt.event.*;

public class MouseEventDemo extends Frame implements MouseListener, MouseMotionListener {
    TextField tf;

    public MouseEventDemo() {
        setTitle("mouse event");
        setSize(400, 300);
        setLayout(new FlowLayout());

        tf = new TextField(30);
        tf.setEditable(false);
        add(tf);

        addMouseListener(this);
        addMouseMotionListener(this);

        setVisible(true);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
    }

    public void mouseClicked(MouseEvent e) {
        tf.setText("mouse clicked at: x=" + e.getX() + ", y=" + e.getY());
    }

    public void mouseMoved(MouseEvent e) {
        setTitle("mouse moved at: x=" + e.getX() + ", y=" + e.getY());
    }

    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}

    public static void main(String[] args) {
        new MouseEventDemo();
    }
}
"""
        }
    },
    {
        "slipNo": 9,
        "questions": [
            {
                "question": """Define a “Clock” class that doesthe following ;
a. Accept Hours, Minutes and Seconds
b. Check the validity of numbers
c. Set the time to AM/PM mode
Use the necessary constructors and methods to do the above task""",
                "filenames": ["ClockDemo.java"]
            },
            {
                "question": """Write a program to using marker interface create a class Product (product_id, product_name,
product_cost, product_quantity) default and parameterized constructor. Create objectsof class
product and display the contents of each object and Also display the object count.""",
                "filenames": ["ProductDemo.java"]
            },
        ],
        "answers": {
            "ClockDemo.java": """import java.util.*;

class Clock {
    private int hr;
    private int min;
    private int sec;

    public Clock(int hours, int minutes, int seconds) {
        if (isValid(hours, minutes, seconds)) {
            this.hr= hours;
            this.min = minutes;
            this.sec = seconds;
        } else {
            System.out.println("invalid time setting default 12:00:00");
            this.hr = 12;
            this.min = 00;
            this.sec = 00;
        }
    }

    private boolean isValid(int h, int m, int s) {
        return (h >= 0 && h < 24) && (m >= 0 && m < 60) && (s >= 0 && s < 60);
    }

    public void displayTime() {
        String amPm = (hr < 12) ? "am" : "pm";
        int displayHour = (hr == 0) ? 12 : (hr > 12 ? hr - 12 : hr);
        System.out.printf("time: %02d:%02d:%02d %s ", displayHour, min, sec, amPm);
    }

    public void setTime(int h, int m, int s) {
        if (isValid(h, m, s)) {
            this.hr = h;
            this.min = m;
            this.sec = s;
        } else {
            System.out.println("invalid time time not updated.");
        }
    }
}

public class ClockDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.print("enter hours: ");
        int hh = sc.nextInt();
        System.out.print("enter minutes: ");
        int mm = sc.nextInt();
        System.out.print("enter seconds: ");
        int ss = sc.nextInt();

        Clock clk = new Clock(hh, mm, ss);
        clk.displayTime();

    }
}
""",
            "ProductDemo.java": """import java.util.*;

interface Marker {
}

class Product implements Marker {
    int productId;
    String productName;
    double productCost;
    int productQuantity;
    static int count = 0;

    Product() {
        productId = 0;
        productName = "Unknown";
        productCost = 0.0;
        productQuantity = 0;
        count++;
    }

    Product(int id, String name, double cost, int qty) {
        productId = id;
        productName = name;
        productCost = cost;
        productQuantity = qty;
        count++;
    }

    void display() {
        System.out.println("ID: " + productId +
                           ", Name: " + productName +
                           ", Cost: " + productCost +
                           ", Quantity: " + productQuantity);
    }
}

public class ProductDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of products: ");
        int n = sc.nextInt();
        sc.nextLine();

        Product[] products = new Product[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for Product " + (i + 1));

            System.out.print("Product ID: ");
            int id = sc.nextInt();
            sc.nextLine();

            System.out.print("Product Name: ");
            String name = sc.nextLine();

            System.out.print("Product Cost: ");
            double cost = sc.nextDouble();

            System.out.print("Product Quantity: ");
            int qty = sc.nextInt();
            sc.nextLine();

            products[i] = new Product(id, name, cost, qty);
        }

        System.out.println("--- Product Details ---");
        for (Product p : products) {
            p.display();
        }

        System.out.println("Total Products Created: " + Product.count);


    }
}
"""
        }
    },
    {
        "slipNo": 10,
        "questions": [
            {
                "question": """Write a program to find the cube of given number using functional interface.""",
                "filenames": ["CubeDemo.java"]
            },
            {
                "question": """Write a program to create a package name student. Define class StudentInfo with method to
display information about student such as rollno, class, and percentage. Create another class
StudentPer with method to find percentage of the student. Accept student details like
rollno, name, class and marks of 6 subject from user.""",
                "filenames": ["StudentResult.java"]
            },
            {
                "question": """student/StudentInfo.java""",
                "filenames": ["student/StudentInfo.java"]
            },
            {
                "question": """student/StudentPer.java""",
                "filenames": ["student/StudentPer.java"]
            },
        ],
        "answers": {
            "CubeDemo.java": """import java.util.*;

interface Cube {
    int calculate(int n);
}

public class CubeDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.print("enter a number: ");
        int num = sc.nextInt();

        Cube cube = n -> n * n * n;

        int result = cube.calculate(num);
        System.out.println("cube of " + num + " is: " + result);
    }
}
""",
            "StudentResult.java": """import student.StudentInfo;
import student.StudentPer;

import java.util.Scanner;

public class StudentResult {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("enter roll number: ");
        int rollNo = sc.nextInt();
        sc.nextLine();

        System.out.print("enter name: ");
        String name = sc.nextLine();

        System.out.print("enter class: ");
        String studentClass = sc.nextLine();

        int[] marks = new int[6];
        System.out.println("enter marks for 6 subjects:");
        for (int i = 0; i < 6; i++) {
            System.out.print("subject " + (i + 1) + ": ");
            marks[i] = sc.nextInt();
        }

        StudentPer percentageCal = new StudentPer();
        double percentage = percentageCal.calculatePercentage(marks);

        StudentInfo stud = new StudentInfo(rollNo, name, studentClass, percentage);
        stud.display();
    }
}
""",
            "student/StudentInfo.java": """package student;

public class StudentInfo {
    private int rollno;
    private String name;
    private String cls;
    private double percentage;

    public StudentInfo(int rollno, String name, String cls, double percentage) {
        this.rollno = rollno;
        this.name = name;
        this.cls = cls;
        this.percentage = percentage;
    }

    public void display() {
        System.out.println("--- student information ---");
        System.out.println("roll no   : " + rollno);
        System.out.println("name      : " + name);
        System.out.println("class     : " + cls);
        System.out.println("percentage: " + percentage + "%");
    }
}
""",
            "student/StudentPer.java": """package student;

public class StudentPer {
    public double calculatePercentage(int marks[]) {
        int total = 0;
        for (int m : marks) {
            total += m;
        }
        return (total / 6.0);
    }
}
""",
        }
    },
    {
        "slipNo": 11,
        "questions": [
            {
                "question": """Define an interface “Operation” which has method volume( ).Define a constant PI having a value
3.142 Create a class cylinder which implements this interface (members – radius,height). Create
one object and calculate the volume.""",
                "filenames": ["CylinderVolume.java"]
            },
            {
                "question": """Write a program to accept the username and password from user if username and password are
not same then raise "Invalid Password" with appropriate msg.""",
                "filenames": ["LoginValidation.java"]
            },
        ],
        "answers": {
            "CylinderVolume.java": """import java.util.*;

interface Operation {
    double PI = 3.142;
    double volume();
}

class Cylinder implements Operation {
    private double radius;
    private double height;

    public Cylinder(double radius, double height) {
        this.radius = radius;
        this.height = height;
    }

    public double volume() {
        return PI * radius * radius * height;
    }
}

public class CylinderVolume {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("enter radius: ");
        double r = sc.nextDouble();

        System.out.print("enter height: ");
        double h = sc.nextDouble();

        Cylinder c = new Cylinder(r, h);
        System.out.println("volume of cylinder: " + c.volume());


    }
}
""",
            "LoginValidation.java": """import java.util.Scanner;

class InvalidPasswordException extends Exception {
    public InvalidPasswordException(String message) {
        super(message);
    }
}

public class LoginValidation {
    public static void main(String[] args) {
        Scanner input = new Scanner(System.in);

        System.out.print("enter username: ");
        String username = input.nextLine();

        System.out.print("enter password: ");
        String password = input.nextLine();

        try {
            if (!username.equals(password)) {
                throw new InvalidPasswordException("invalid password: username and password must be same");
            }
            System.out.println("login successful!");
        } catch (InvalidPasswordException e) {
            System.out.println(e.getMessage());
        }

        input.close();
    }
}
"""
        }
    },
    {
        "slipNo": 12,
        "questions": [
            {
                "question": """Write a program to create parent class College(cno, cname, caddr) and derived class
Department(dno, dname) from College. Write a necessary methods to display College details.""",
                "filenames": ["clgDemo.java"]
            },
            {
                "question": """Write a java program that works as a simple calculator. Use a grid layout to arrange buttons for
the digits and for the +, -, *, % operations. Add a text field to display the result.""",
                "filenames": ["CalculatorGUI.java"]
            },
        ],
        "answers": {
            "clgDemo.java": """import java.util.Scanner;

class College {
    private int cno;
    private String cname;
    private String caddr;

    public College(int cno, String cname, String caddr) {
        this.cno = cno;
        this.cname = cname;
        this.caddr = caddr;
    }

    public void showCollegeDetails() {
        System.out.println("--- College Details ---");
        System.out.println("College No   : " + cno);
        System.out.println("College Name : " + cname);
        System.out.println("College Addr : " + caddr);
    }
}

class Department extends College {
    private int dno;
    private String dname;

    public Department(int cno, String cname, String caddr, int dno, String dname) {
        super(cno, cname, caddr);
        this.dno = dno;
        this.dname = dname;
    }

    public void showDepartmentDetails() {
        showCollegeDetails();
        System.out.println("Department No   : " + dno);
        System.out.println("Department Name : " + dname);
    }
}

public class clgDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter College Number: ");
        int cno = sc.nextInt();
        sc.nextLine();

        System.out.print("Enter College Name: ");
        String cname = sc.nextLine();

        System.out.print("Enter College Address: ");
        String caddr = sc.nextLine();

        System.out.print("Enter Department Number: ");
        int dno = sc.nextInt();
        sc.nextLine();

        System.out.print("Enter Department Name: ");
        String dname = sc.nextLine();

        Department dept = new Department(cno, cname, caddr, dno, dname);
        dept.showDepartmentDetails();


    }
}
""",
            "CalculatorGUI.java": """import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class CalculatorGUI extends JFrame implements ActionListener {
    JTextField display;
    double num1 = 0, num2 = 0, result = 0;
    String operator = "";

    public CalculatorGUI() {
        setTitle("basic calculator");
        setSize(250, 300);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        display = new JTextField();
        display.setEditable(false);
        add(display, BorderLayout.NORTH);

        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 4));

        String[] buttons = {
            "1","2","3","+",
            "4","5","6","-",
            "7","8","9","*",
            "0","=","/","%"
        };

        for (String text : buttons) {
            JButton b = new JButton(text);
            b.addActionListener(this);
            panel.add(b);
        }

        add(panel, BorderLayout.CENTER);
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();

        if (command.matches("[0-9]")) {
            display.setText(display.getText() + command);
        } else if (command.matches("[+\\-*/%]")) {
            num1 = Double.parseDouble(display.getText());
            operator = command;
            display.setText("");
        } else if (command.equals("=")) {
            num2 = Double.parseDouble(display.getText());
            switch (operator) {
                case "+": result = num1 + num2; break;
                case "-": result = num1 - num2; break;
                case "*": result = num1 * num2; break;
                case "/": result = num1 / num2; break;
                case "%": result = num1 % num2; break;
            }
            display.setText("" + result);
        }
    }

    public static void main(String[] args) {
        new CalculatorGUI();
    }
}
"""
        }
    },
    {
        "slipNo": 13,
        "questions": [
            {
                "question": """Write a program to accept a file name from command prompt, if the file exits then display
number of words and lines in that file.""",
                "filenames": ["wordCount.java"]
            },
            {
                "question": """Write a program to display the system date and time in various formats shown below:
Current date is : 31/08/2021
Current date is : 08-31-2021
Current date is : Tuesday August 31 2021
Current date and time is : Fri August 31 15:25:59 IST 2021
Current date and time is : 31/08/21 15:25:59 PM +0530""",
                "filenames": ["DateFormat.java"]
            },
            {
                "question": """data.txt""",
                "filenames": ["data.txt"]
            }
        ],
        "answers": {
            "wordCount.java": """import java.io.*;
import java.util.*;

public class wordCount {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: java FileWordLineCount filename");
            return;
        }

        String fileName = args[0];
        File file = new File(fileName);

        if (!file.exists()) {
            System.out.println("file does not exist");
            return;
        }

        int lines = 0, words = 0;

        try (Scanner sc = new Scanner(file)) {
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                lines++;
                String[] w = line.trim().split("s+");
                if (!(w.length == 1 && w[0].equals(""))) {
                    words += w.length;
                }
            }
        } catch (FileNotFoundException e) {
            System.out.println("error reading file");
        }

        System.out.println("number of lines: " + lines);
        System.out.println("number of words: " + words);
    }
}
""",
            "DateFormat.java": """import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormat {
    public static void main(String[] args) {
        Date now = new Date();

        SimpleDateFormat f1 = new SimpleDateFormat("dd/MM/yyyy");
        System.out.println("current date is : " + f1.format(now));

        SimpleDateFormat f2 = new SimpleDateFormat("MM-dd-yyyy");
        System.out.println("current date is : " + f2.format(now));

        SimpleDateFormat f3 = new SimpleDateFormat("EEEE MMMM dd yyyy");
        System.out.println("current date is : " + f3.format(now));

        SimpleDateFormat f4 = new SimpleDateFormat("E MMMM dd HH:mm:ss z yyyy");
        System.out.println("current date and time is : " + f4.format(now));

        SimpleDateFormat f5 = new SimpleDateFormat("dd/MM/yy hh:mm:ss a Z");
        System.out.println("current date and time is : " + f5.format(now));
    }
}
""",
            "data.txt": """this is programig world.
hello world
this is programig world.
hello world"""
        }
    },
    {
        "slipNo": 14,
        "questions": [
            {
                "question": """Write a program to accept a number from the user, if number is zero then throw user defined
exception “Number is 0” otherwise check whether no is prime or not (Use static keyword).""",
                "filenames": ["PrimeCheck.java"]
            },
            {
                "question": """Write a Java program to create a Package “SY” which has a class SYMarks (members –
ComputerTotal, MathsTotal, and ElectronicsTotal). Create another package TY which has a
class TYMarks (members – Theory, Practicals). Create ‘n’ objects of Student class (having
rollNumber, name, SYMarks and TYMarks). Add the marks of SY and TY computer subjects
and calculate the Grade (‘A’ for >= 70, ‘B’ for >= 60 ‘C’ for >= 50, Pass Class for > =40
else‘FAIL’) and display the result of the student in proper format.""",
                "filenames": ["StudentResult.java"]
            },
            {
                "question": """sy/SYMarks.java""",
                "filenames": ["sy/SYMarks.java"]
            },
            {
                "question": """ty/TYMarks.java""",
                "filenames": ["ty/TYMarks.java"]
            },
        ],
        "answers": {
            "PrimeCheck.java": """import java.util.*;

class NumberZeroException extends Exception {
    public NumberZeroException(String msg) {
        super(msg);
    }
}

public class PrimeCheck {

    static boolean isPrime(int num) {
        if (num <= 1) return false;
        for (int i = 2; i <= (num/2); i++) {
            if (num % i == 0) return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.print("enter a number: ");
        int num = sc.nextInt();

        try {
            if (num == 0) {
                throw new NumberZeroException("number is 0");
            }
            if (isPrime(num)) {
                System.out.println(num + " is prime");
            } else {
                System.out.println(num + " is not prime");
            }
        } catch (NumberZeroException e) {
            System.out.println(e.getMessage());
        }
    }
}
""",
            "StudentResult.java": """import sy.*;
import ty.*;
import java.util.*;

class Student {
    public int rollNumber;
    public String name;
    public SYMarks syMarks;
    public TYMarks tyMarks;

    public Student(int rollNumber, String name, SYMarks syMarks, TYMarks tyMarks) {
        this.rollNumber = rollNumber;
        this.name = name;
        this.syMarks = syMarks;
        this.tyMarks = tyMarks;
    }

    public int totalComputerMarks() {
        return syMarks.computerTotal + tyMarks.theory + tyMarks.practicals;
    }

    public String calculateGrade() {
        int total = totalComputerMarks();
        if (total >= 70) return "A";
        else if (total >= 60) return "B";
        else if (total >= 50) return "C";
        else if (total >= 40) return "Pass Class";
        else return "FAIL";
    }

    public void display() {
        System.out.println("Roll No: " + rollNumber);
        System.out.println("Name: " + name);
        System.out.println("SY Marks - Computer: " + syMarks.computerTotal
                + ", Maths: " + syMarks.mathsTotal
                + ", Electronics: " + syMarks.electronicsTotal);
        System.out.println("TY Marks - Theory: " + tyMarks.theory
                + ", Practicals: " + tyMarks.practicals);
        System.out.println("Total Computer Marks: " + totalComputerMarks());
        System.out.println("Grade: " + calculateGrade());
    }
}

public class StudentResult {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of students: ");
        int n = sc.nextInt();
        sc.nextLine();

        Student[] std = new Student[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for student " + (i + 1) + ":");

            System.out.print("Roll Number: ");
            int roll = sc.nextInt();
            sc.nextLine();

            System.out.print("Name: ");
            String name = sc.nextLine();

            System.out.println("Enter SY Marks:");
            System.out.print("Computer: ");
            int compSY = sc.nextInt();
            System.out.print("Maths: ");
            int mathsSY = sc.nextInt();
            System.out.print("Electronics: ");
            int elecSY = sc.nextInt();

            System.out.println("Enter TY Marks (Computer subject):");
            System.out.print("Theory: ");
            int theory = sc.nextInt();
            System.out.print("Practicals: ");
            int practicals = sc.nextInt();
            sc.nextLine();

            SYMarks sy = new SYMarks(compSY, mathsSY, elecSY);
            TYMarks ty = new TYMarks(theory, practicals);

            std[i] = new Student(roll, name, sy, ty);
            System.out.println();
        }

        System.out.println("---Student Results---");
        for (Student s : std) {
            s.display();
        }


    }
}""",
            "sy/SYMarks.java": """package sy;

public class SYMarks {
    public int computerTotal;
    public int mathsTotal;
    public int electronicsTotal;

    public SYMarks(int computerTotal, int mathsTotal, int electronicsTotal) {
        this.computerTotal = computerTotal;
        this.mathsTotal = mathsTotal;
        this.electronicsTotal = electronicsTotal;
    }
}
""",
            "ty/TYMarks.java": """package ty;

public class TYMarks {
    public int theory;
    public int practicals;

    public TYMarks(int theory, int practicals) {
        this.theory = theory;
        this.practicals = practicals;
    }
}
"""
        }
    },
    {
        "slipNo": 15,
        "questions": [
            {
                "question": """Accept the names of two files and copy the contents of the first to the second. First file having
Book name and Author name in file.""",
                "filenames": ["FileCopy.java"]
            },
            {
                "question": """Write a program to define a class Account having members custname, accno. Define default
and parameterized constructor. Create a subclass called SavingAccount with member savingbal,
minbal. Create a derived class AccountDetail that extends the class SavingAccount with
members, depositamt and withdrawalamt. Write a appropriate method to display customer
details.""",
                "filenames": ["AccountDetail.java"]
            },
            {
                "question": """src.txt""",
                "filenames": ["src.txt"]
            },
            {
                "question": """dest.txt""",
                "filenames": ["dest.txt"]
            },
        ],
        "answers": {
            "FileCopy.java": """import java.io.*;
import java.util.*;

public class FileCopy {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter 1st file name src.txt : ");
        String srcFile = sc.nextLine();

        System.out.print("Enter 2nd file name dest.txt : ");
        String destFile = sc.nextLine();

        try (BufferedReader br = new BufferedReader(new FileReader(srcFile));
             BufferedWriter bw = new BufferedWriter(new FileWriter(destFile))) {

            String line;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }

            System.out.println("Contents copied from 1st file to 2nd file successfully.");

        } catch (FileNotFoundException e) {
            System.out.println("File not found: " + e.getMessage());
        } catch (IOException e) {
            System.out.println("Error: " + e.getMessage());
        }

    }
}
""",
            "AccountDetail.java": """import java.util.*;

class Acct {
    String custName;
    long accNo;

    public Acct() {
        custName = "";
        accNo = 0;
    }

    public Acct(String custName, long accNo) {
        this.custName = custName;
        this.accNo = accNo;
    }
}

class SavAcct extends Acct {
    double savingBal;
    double minBal;

    public SavAcct() {
        super();
        savingBal = 0.0;
        minBal = 0.0;
    }

    public SavAcct(String custName, long accNo, double savingBal, double minBal) {
        super(custName, accNo);
        this.savingBal = savingBal;
        this.minBal = minBal;
    }
}

class AcctDtl extends SavAcct {
    double depositAmt;
    double withdrawalAmt;

    public AcctDtl(String custName, long accNo, double savingBal, double minBal,
                         double depositAmt, double withdrawalAmt) {
        super(custName, accNo, savingBal, minBal);
        this.depositAmt = depositAmt;
        this.withdrawalAmt = withdrawalAmt;
    }

    public void displayDetails() {
        System.out.println("customer name: " + custName);
        System.out.println("account number: " + accNo);
        System.out.println("saving balance: " + savingBal);
        System.out.println("minimum balance: " + minBal);
        System.out.println("deposit amount: " + depositAmt);
        System.out.println("withdrawal amount: " + withdrawalAmt);
        double NBal = savingBal + depositAmt - withdrawalAmt;
        System.out.println("updated balance: " + NBal);
        if (NBal < minBal) {
            System.out.println(" balance below minimum required");
        }
    }
}

public class AccountDetail {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("enter customer name: ");
        String name = sc.nextLine();

        System.out.print("enter account number: ");
        long accNo = sc.nextLong();

        System.out.print("enter saving balance: ");
        double savingBal = sc.nextDouble();

        System.out.print("enter minimum balance: ");
        double minBal = sc.nextDouble();

        System.out.print("enter deposit amount: ");
        double deposit = sc.nextDouble();

        System.out.print("enter withdrawal amount: ");
        double withdrawal = sc.nextDouble();

        AcctDtl customer = new AcctDtl(name, accNo, savingBal, minBal, deposit, withdrawal);
        System.out.println("--- customer account details ---");
        customer.displayDetails();
    }
}
""",
            "src.txt": """this is programig world.
hello world""",
            "dest.txt": ""
        }
    },
    {
        "slipNo": 16,
        "questions": [
            {
                "question": """Write a program to find the Square of given number using function interface""",
                "filenames": ["Square.java"]
            },
            {
                "question": """Write a program to design a screen using Awt that,""",
                "filenames": ["AWTDemo.java"]
            },
        ],
        "answers": {
            "Square.java": """import java.util.*;

interface SqrOpr {
    int square(int num);
}

public class Square {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("enter  number: ");
        int number = sc.nextInt();

        SqrOpr sq = n -> n * n;

        int result = sq.square(number);

        System.out.println("square is " + result);
    }
}
""",
            "AWTDemo.java": """import java.awt.*;
import java.awt.event.*;

public class AWTDemo {
    public static void main(String[] args) {
        Frame f = new Frame(" awt examples");

        MenuBar mb = new MenuBar();

        Menu file = new Menu("File");
        Menu edit = new Menu("Edit");
        Menu about = new Menu("About");

        MenuItem newItem = new MenuItem("New");
        MenuItem openItem = new MenuItem("Open");
        MenuItem saveItem = new MenuItem("Save");
        MenuItem showAbout = new MenuItem("Show About");
        MenuItem exitItem = new MenuItem("Exit");

        file.add(newItem);
        file.add(openItem);
        file.add(saveItem);
        about.add(showAbout);
        file.add(exitItem);

        mb.add(file);
        mb.add(edit);
        mb.add(about);

        f.setMenuBar(mb);

        f.setSize(400, 300);
        f.setLayout(null);
        f.setVisible(true);

        exitItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });

        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                f.dispose();
            }
        });
    }
}
"""
        }
    },
    {
        "slipNo": 17,
        "questions": [
            {
                "question": """Design a Super class Customer (name, phone-number). Derive a class Depositor(accno , balance)
from Customer. Again, derive a class Borrower (loan-no, loan-amt) from Depositor. Write
necessary member functions to read and display the details of ‘n’customers.""",
                "filenames": ["CustomerDemo.java"]
            },
            {
                "question": """Write Java program to design three text boxes and two buttons using swing. Enter different
strings in first and second textbox. On clicking the First command button, concatenation of
two strings should be displayed in third text box and on clicking second command button,
reverse of string should display in third text box""",
                "filenames": ["SwingDemo.java"]
            },
        ],
        "answers": {
            "CustomerDemo.java": """import java.util.*;

class Customer {
    private String name;
    private String phoneNumber;

    public void readDetails(Scanner sc) {
        System.out.print("Enter customer name: ");
        name = sc.nextLine();
        System.out.print("Enter phone number: ");
        phoneNumber = sc.nextLine();
    }

    public void displayDetails() {
        System.out.println("Name          : " + name);
        System.out.println("Phone Number  : " + phoneNumber);
    }
}

class Depositor extends Customer {
    private String accountNumber;
    private double balance;

    @Override
    public void readDetails(Scanner sc) {
        super.readDetails(sc);
        System.out.print("Enter account number: ");
        accountNumber = sc.nextLine();
        System.out.print("Enter balance: ");
        balance = Double.parseDouble(sc.nextLine());
    }

    @Override
    public void displayDetails() {
        super.displayDetails();
        System.out.println("Account Number: " + accountNumber);
        System.out.println("Balance       : " + balance);
    }
}

class Borrower extends Depositor {
    private String loanNumber;
    private double loanAmount;

    @Override
    public void readDetails(Scanner sc) {
        super.readDetails(sc);
        System.out.print("Enter loan number: ");
        loanNumber = sc.nextLine();
        System.out.print("Enter loan amount: ");
        loanAmount = Double.parseDouble(sc.nextLine());
    }

    @Override
    public void displayDetails() {
        super.displayDetails();
        System.out.println("Loan Number   : " + loanNumber);
        System.out.println("Loan Amount   : " + loanAmount);
    }
}

public class CustomerDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of customers: ");
        int n = Integer.parseInt(sc.nextLine());

        Borrower[] customers = new Borrower[n];

        for (int i = 0; i < n; i++) {
            System.out.println("--- Enter details for Customer " + (i + 1) + " ---");
            customers[i] = new Borrower();
            customers[i].readDetails(sc);
        }

        System.out.println("=========== Customer Details ===========");
        for (int i = 0; i < n; i++) {
            System.out.println("Customer " + (i + 1) + " Information:");
            System.out.println("------------------------------------");
            customers[i].displayDetails();
        }
    }
}
""",
            "SwingDemo.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class SwingDemo extends JFrame implements ActionListener {
    JTextField t1, t2, t3;
    JButton b1, b2;

    public SwingDemo() {
        setTitle("String Operations");
        setSize(400, 200);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        setLayout(new FlowLayout());

        t1 = new JTextField(10);
        t2 = new JTextField(10);
        t3 = new JTextField(15);

        b1 = new JButton("Concatenate");
        b2 = new JButton("Reverse");

        add(new JLabel("First String:"));
        add(t1);
        add(new JLabel("Second String:"));
        add(t2);
        add(new JLabel("Result:"));
        add(t3);
        add(b1);
        add(b2);

        b1.addActionListener(this);
        b2.addActionListener(this);

        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == b1) {
            String s1 = t1.getText();
            String s2 = t2.getText();
            t3.setText(s1 + s2);
        } else if (e.getSource() == b2) {
            String s1 = t1.getText();
            StringBuilder sb = new StringBuilder(s1);
            t3.setText(sb.reverse().toString());
        }
    }

    public static void main(String args[]) {
        new SwingDemo();
    }
}
"""
        }
    },
    {
        "slipNo": 18,
        "questions": [
            {
                "question": """Write a program to implement Border Layout Manager.""",
                "filenames": ["Layout.java"]
            },
            {
                "question": """Define a class CricketPlayer (name,no_of_innings,no_of_times_notout, totatruns, bat_avg).
Create an array of n player objects. Calculate the batting average for each player using static
method avg(). Define a static sort method which sorts the array on the basis of average.
Display the player details in sorted order.""",
                "filenames": ["BattingAvg.java"]
            },
        ],
        "answers": {
            "Layout.java": """import javax.swing.*;
import java.awt.*;

 class Layout {
      public static void main(String args[]) {
        JFrame frm = new JFrame("Border Layout");
        frm.setSize(400, 300);
        frm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        frm.setLayout(new BorderLayout());

        frm.add(new JButton("north"), BorderLayout.NORTH);
        frm.add(new JButton("south"), BorderLayout.SOUTH);
        frm.add(new JButton("east"), BorderLayout.EAST);
        frm.add(new JButton("west"), BorderLayout.WEST);
        frm.add(new JButton("center"), BorderLayout.CENTER);

        frm.setVisible(true);
    }
}
""",
            "BattingAvg.java": """import java.util.*;

class CricketPlayer {
    String name;
    int no_of_innings;
    int no_of_times_notout;
    int total_runs;
    double bat_avg;

    CricketPlayer(String name, int innings, int notout, int runs) {
        this.name = name;
        this.no_of_innings = innings;
        this.no_of_times_notout = notout;
        this.total_runs = runs;
        this.bat_avg = 0.0;
    }

    public static void avg(CricketPlayer player) {
        int outs = player.no_of_innings - player.no_of_times_notout;
        if (outs > 0) {
            player.bat_avg = (double) player.total_runs / outs;
        } else {
            player.bat_avg = player.total_runs;
        }
    }

    public static void sort(CricketPlayer[] players) {
        for (int i = 0; i < players.length - 1; i++) {

        for (int j = i + 1; j < players.length; j++) {
        if (players[i].bat_avg < players[j].bat_avg) {

        CricketPlayer temp = players[i];
        players[i] = players[j];
        players[j] = temp;
        }
        }
        }
    }

    public void Display() {
        System.out.println("Name       : " + name);
        System.out.println("Innings    : " + no_of_innings);
        System.out.println("Not Out    : " + no_of_times_notout);
        System.out.println("Runs       : " + total_runs);
        System.out.printf("Average    : %.2f%n", bat_avg);
        System.out.println("---------------------------------------");
    }
}

public class BattingAvg {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of players: ");
        int n = sc.nextInt();
sc.nextLine();
        CricketPlayer[] cp = new CricketPlayer[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for Player " + (i + 1));
            System.out.print("Name: ");
            String name = sc.nextLine();
            System.out.print("Number of Innings: ");
            int innings = sc.nextInt();
            System.out.print("Number of times Not Out: ");
            int notout = sc.nextInt();
            System.out.print("Total Runs: ");
            int run = sc.nextInt();
            sc.nextLine();

            cp[i] = new CricketPlayer(name, innings, notout, run);

            CricketPlayer.avg(cp[i]);
        }
        CricketPlayer.sort(cp);
        System.out.println(" Sorted Player Details  by Batting Average");
        for (CricketPlayer p : cp) {
            p.Display();
        }
    }
}
"""
        }
    },
    {
        "slipNo": 19,
        "questions": [
            {
                "question": """Write a program to accept the two dimensional array from user and display sum of its diagonal elements.""",
                "filenames": ["diagSum.java"]
            },
            {
                "question": """Write a program which shows the combo box which includes list of T.Y.B.Sc.(Comp. Sci)
subjects. Display the selected subject in a text field.""",
                "filenames": ["ComboBox.java"]
            },
        ],
        "answers": {
            "diagSum.java": """import java.util.*;

public class diagSum {

public static void main(String args[]) {
        Scanner sc = new Scanner(System.in);

        System.out.print("enter number of row and col: ");
        int n = sc.nextInt();

        int[][] arr = new int[n][n];
        System.out.println("Enter the elements of 2D:");

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                arr[i][j] = sc.nextInt();
            }
        }

        int sum = 0;
        for (int i = 0; i < n; i++) {
            sum = sum + arr[i][i];
        }

        System.out.println("Sum of diagonal elements = " + sum);
    }

}
""",
            "ComboBox.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class ComboBox extends JFrame implements ActionListener {
    JComboBox<String> comboBox;
    JTextField textField;

    public ComboBox() {
        setTitle("T.Y.B.Sc.(Comp. Sci) Subjects");
        setSize(400, 200);
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        setLayout(new FlowLayout());

        String subjects[] = {
            "Java Programming",
            "Software Testing",
            "Computer Networks",
            "Data Science",
            "Operating Systems",
            "Web Technologies"
        };

        comboBox = new JComboBox<>(subjects);
        textField = new JTextField(20);

        add(new JLabel("Select Subject:"));
        add(comboBox);
        add(new JLabel("Selected Subject:"));
        add(textField);

        comboBox.addActionListener(this);

        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String subject = (String) comboBox.getSelectedItem();
        textField.setText(subject);
    }

    public static void main(String ar[]) {
        new ComboBox();
    }
}
"""
        }
    },
    {
        "slipNo": 20,
        "questions": [
            {
                "question": """Write a Program to illustrate multilevel Inheritance such that country is inherited from
continent. State is inherited from country. Display the place, state, country and continent.""",
                "filenames": ["PlaceInfo.java"]
            },
            {
                "question": """Write a package for Operation, which has two classes, Addition and Maximum. Addition has
two methods add () and subtract (), which are used to add two integers and subtract two,
float values respectively. Maximum has a method max () to display the maximum of two
integers""",
                "filenames": ["OperationDemo.java"]
            },
            {
                "question": """operation/Addition.java""",
                "filenames": ["operation/Addition.java"]
            },
            {
                "question": """operation/Maximum.java""",
                "filenames": ["operation/Maximum.java"]
            },
        ],
        "answers": {
            "PlaceInfo.java": """import java.util.Scanner;

class Continent {
    String continentName;

    Continent(String cname) {
        continentName = cname;
    }
}

class Country extends Continent {
    String countryName;

    Country(String cname, String coname) {
        super(coname);
        countryName = cname;
    }
}

class State extends Country {
    String stateName;

    State(String sname, String cname, String coname) {
        super(cname, coname);
        stateName = sname;
    }
}

class Place extends State {
    String placeName;

    Place(String pname, String sname, String cname, String coname) {
        super(sname, cname, coname);
        placeName = pname;
    }

    void display() {
        System.out.println("--- Location Details ---");
        System.out.println("Place     : " + placeName);
        System.out.println("State     : " + stateName);
        System.out.println("Country   : " + countryName);
        System.out.println("Continent : " + continentName);
    }
}

public class PlaceInfo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter Continent: ");
        String continent = sc.nextLine();

        System.out.print("Enter Country: ");
        String country = sc.nextLine();

        System.out.print("Enter State: ");
        String state = sc.nextLine();

        System.out.print("Enter Place: ");
        String place = sc.nextLine();

        // create object with user input
        Place p = new Place(place, state, country, continent);

        // display details
        p.display();
    }
}
""",
            "OperationDemo.java": """
import operation.Addition;
import operation.Maximum;

public class OperationDemo {
    public static void main(String[] args) {
        Addition aobj = new Addition();
        Maximum mobj = new Maximum();

        int sum = aobj.add(10, 20);
        float diff = aobj.subtract(15.5f, 5.2f);
        int maximum = mobj.max(50, 40);

        System.out.println("Addition is: " + sum);
        System.out.println("Subtraction is: " + diff);
        System.out.println("Max is: " + maximum);
    }
}
""",
            "operation/Addition.java": """
package operation;

public class Addition {
    public int add(int a, int b) {
        return a + b;
    }

    public float subtract(float a, float b) {
        return a - b;
    }
}
""",
            "operation/Maximum.java": """package operation;

public class Maximum {
       public int max(int a, int b) {
        if (a > b)
            return a;
        else
            return b;
    }
}
""",

        }
    },
    {
        "slipNo": 21,
        "questions": [
            {
                "question": """Define a class MyDate(Day, Month, year) with methods to accept and display a MyDateobject.
Accept date as dd,mm,yyyy. Throw user defined exception "InvalidDateException" if the date
is invalid.
""",
                "filenames": ["MyDateDemo.java"]
            },
            {
                "question": """Create an employee class(id,name,deptname,salary). Define a default and parameterized
constructor. Use ‘this’ keyword to initialize instance variables. Keep a count of objects
created. Create objects using parameterized constructor and display the object count after
each object is created. (Use static member and method). Also display the contents of each
object.""",
                "filenames": ["EmpDemo.java"]
            },
        ],
        "answers": {
            "MyDateDemo.java": """import java.util.*;

class InvalidDateException extends Exception {
    public InvalidDateException(String msg) {
        super(msg);
    }
}

class Mydate {
    private int day, month, year;

    public void acceptDate() throws InvalidDateException {
        Scanner sc = new Scanner(System.in);
        System.out.print("Enter day: ");
        day = sc.nextInt();
        System.out.print("Enter month: ");
        month = sc.nextInt();
        System.out.print("Enter year: ");
        year = sc.nextInt();

        if (!isValidDate(day, month, year)) {
            throw new InvalidDateException("Invalid Date ");
        }
    }

    public void displayDate() {
        System.out.println(String.format("%02d", day) + "/" +
                           String.format("%02d", month) + "/" + year);
    }

    private boolean isValidDate(int d, int m, int y) {
        if (y <= 0 || m <= 0 || m > 12 || d <= 0)
            return false;

        int maxday;
        switch (m) {
            case 1: case 3: case 5: case 7: case 8: case 10: case 12:
                maxday= 31; break;
            case 4: case 6: case 9: case 11:
                maxday= 30; break;
            case 2:
                if ((y % 4 == 0 && y % 100 != 0) || (y % 400 == 0))
                    maxday= 29;
                else
                    maxday= 28;
                break;
            default:
                return false;
        }

        return d <= maxday;
    }
}

public class MyDateDemo {
    public static void main(String a[]) {
        Mydate date = new Mydate();
        try {
            date.acceptDate();
            date.displayDate();
        } catch (InvalidDateException e) {
            System.out.println(e.getMessage());
        }
    }
}
""",
            "EmpDemo.java": """import java.util.Scanner;

class Employee {
    int id;
    String name;
    String department;
    double salary;
    static int count = 0;

    Employee(int id, String name, String department, double salary) {
        this.id = id;
        this.name = name;
        this.department = department;
        this.salary = salary;
        count++;
    }

    void display() {
        System.out.println("ID        : " + id);
        System.out.println("Name      : " + name);
        System.out.println("Department: " + department);
        System.out.println("Salary    : " + salary);
        System.out.println("---------------------------");
    }

    static int getCount() {
        return count;
    }
}

public class EmpDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of employees: ");
        int n = sc.nextInt();
        sc.nextLine();

        Employee[] employees = new Employee[n];

        for (int i = 0; i < n; i++) {
            System.out.println("--- Enter details for Employee " + (i + 1) + " ---");

            System.out.print("Enter ID: ");
            int id = sc.nextInt();
            sc.nextLine();

            System.out.print("Enter Name: ");
            String name = sc.nextLine();

            System.out.print("Enter Department: ");
            String department = sc.nextLine();

            System.out.print("Enter Salary: ");
            double salary = sc.nextDouble();
            sc.nextLine();

            employees[i] = new Employee(id, name, department, salary);
        }

        System.out.println("=========== Employee Details ===========");
        for (int i = 0; i < n; i++) {
            System.out.println("Employee " + (i + 1));
            employees[i].display();
            System.out.println("Total Employees: " + Employee.getCount());
        }

    }
}
"""
        }
    },
    {
        "slipNo": 22,
        "questions": [
            {
                "question": """Write a program to create an abstract class named Shape that contains two integers and an
empty method named printArea(). Provide three classes named Rectangle, Triangle and Circle
such that each one of the classes extends the class Shape. Each one of the classes contain only
the method printArea() that prints the area of the given shape. (use method overriding).""",
                "filenames": ["ShapeDemo.java"]
            },
            {
                "question": """Write a program that handles all mouse events and shows the event name at the center of the Window, red in color when a mouse event is fired. (Use adapter classes).""",
                "filenames": ["MouseEventDemo.java"]
            },
        ],
        "answers": {
            "ShapeDemo.java": """abstract class Shape {
    int a, b;

    Shape(int a, int b) {
        this.a = a;
        this.b = b;
    }

    abstract void displayArea();
}

class Rectangle extends Shape {
    Rectangle(int length, int breadth) {
        super(length, breadth);
    }

    @Override
    void displayArea() {
        System.out.println("Area of Rectangle = " + (a * b));
    }
}

class Triangle extends Shape {
    Triangle(int base, int height) {
        super(base, height);
    }

    @Override
    void displayArea() {
        System.out.println("Area of Triangle  = " + (0.5 * a * b));
    }
}

class Circle extends Shape {
    Circle(int radius) {
        super(radius, 0);
    }

    @Override
    void displayArea() {
        System.out.println("Area of Circle    = " + (Math.PI * a * a));
    }
}

public class ShapeDemo {
    public static void main(String[] args) {
        Shape[] shapes = new Shape[3];

        shapes[0] = new Rectangle(10, 5);
        shapes[1] = new Triangle(8, 6);
        shapes[2] = new Circle(7);

        System.out.println("=== Shape Areas ===");
        for (Shape s : shapes) {
            s.displayArea();
        }
    }
}
""",
            "MouseEventDemo.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class MouseEventDemo extends JFrame {
    String message = "";

    public MouseEventDemo() {
        setTitle("Mouse Event");
        setSize(400, 300);
        setDefaultCloseOperation(EXIT_ON_CLOSE);

        addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                message = "mouse clicked";
                repaint();
            }

            public void mousePressed(MouseEvent e) {
                message = "mouse pressed";
                repaint();
            }

            public void mouseReleased(MouseEvent e) {
                message = "mouse released";
                repaint();
            }

            public void mouseEntered(MouseEvent e) {
                message = "mouse entered";
                repaint();
            }

            public void mouseExited(MouseEvent e) {
                message = "mouse exited";
                repaint();
            }
        });

        addMouseMotionListener(new MouseAdapter() {
            public void mouseDragged(MouseEvent e) {
                message = "mouse dragged";
                repaint();
            }

            public void mouseMoved(MouseEvent e) {
                message = "mouse moved";
                repaint();
            }
        });

        setVisible(true);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.RED);
        g.setFont(new Font("Arial", Font.BOLD, 20));
        g.drawString(message, getWidth()/2 - 70, getHeight()/2);
    }

    public static void main(String arg[]) {
        new MouseEventDemo();
    }
}
"""
        }
    },
    {
        "slipNo": 23,
        "questions": [
            {
                "question": """Define a class MyNumber having one private int data member. Write a default constructor to
initialize it to 0 and another constructor to initialize it to a value (Use this). Write methods
isNegative, isPositive, isZero, isOdd, isEven. Create an object in main.Use command line
arguments to pass a value to the Object.""",
                "filenames": ["MyNumber.java"]
            },
            {
                "question": """Write a simple currency converter, as shown in the figure. User can enter the amount of
"Singapore Dollars", "US Dollars", or "Euros", in floating-point number. The converted
values shall be displayed to 2 decimal places. Assume that 1 USD = 1.41 SGD,
1 USD = 0.92 Euro, 1 SGD = 0.65 Euro.""",
                "filenames": ["CurrencyConverter.java"]
            },
        ],
        "answers": {
            "MyNumber.java": """import java.util.Scanner;

class MyNum {
    private int num;

    MyNum() {
        this.num = 0;
    }

    MyNum(int num) {
        this.num = num;
    }

    boolean isNegative() {
        return num < 0;
    }

    boolean isPositive() {
        return num > 0;
    }

    boolean isZero() {
        return num == 0;
    }

    boolean isOdd() {
        return num % 2 != 0;
    }

    boolean isEven() {
        return num % 2 == 0;
    }

    void display() {
        System.out.println("--- Number Details ---");
        System.out.println("Number   : " + num);
        System.out.println("Negative : " + isNegative());
        System.out.println("Positive : " + isPositive());
        System.out.println("Zero     : " + isZero());
        System.out.println("Odd      : " + isOdd());
        System.out.println("Even     : " + isEven());
    }
}

public class MyNumber {
    public static void main(String arg[]) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter a number: ");
        int value = sc.nextInt();

        MyNum nm = new MyNum(value);
        nm.display();
    }
}
""",
            "CurrencyConverter.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class CurrencyConverter extends JFrame implements ActionListener {
    JTextField tfSGD, tfUSD, tfEuro;
    JButton convert;

    public CurrencyConverter() {
        setTitle("currency converter");
        setSize(350, 200);
        setLayout(new GridLayout(4, 2, 5, 5));
        setDefaultCloseOperation(EXIT_ON_CLOSE);

        tfSGD = new JTextField();
        tfUSD = new JTextField();
        tfEuro = new JTextField();

        convert = new JButton("Convert");
        convert.addActionListener(this);

        add(new JLabel("singapore dollars (sgd):"));
        add(tfSGD);
        add(new JLabel("us dollars (usd):"));
        add(tfUSD);
        add(new JLabel("euros (eur):"));
        add(tfEuro);
        add(convert);

        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (!tfSGD.getText().isEmpty()) {
                double sgd = Double.parseDouble(tfSGD.getText());
                double usd = sgd / 1.41;
                double euro = sgd * 0.65;
                tfUSD.setText(String.format("%.2f", usd));
                tfEuro.setText(String.format("%.2f", euro));
            } else if (!tfUSD.getText().isEmpty()) {
                double usd = Double.parseDouble(tfUSD.getText());
                double sgd = usd * 1.41;
                double euro = usd * 0.92;
                tfSGD.setText(String.format("%.2f", sgd));
                tfEuro.setText(String.format("%.2f", euro));
            } else if (!tfEuro.getText().isEmpty()) {
                double euro = Double.parseDouble(tfEuro.getText());
                double usd = euro / 0.92;
                double sgd = euro / 0.65;
                tfUSD.setText(String.format("%.2f", usd));
                tfSGD.setText(String.format("%.2f", sgd));
            }
        } catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "enter  valid number");
        }
    }

    public static void main(String arg[]) {
        new CurrencyConverter();
    }
}
"""
        }
    },
    {
        "slipNo": 24,
        "questions": [
            {
                "question": """Create an abstract class 'Bank' with an abstract method 'getBalance'. Rs.100, Rs.150 and
Rs.200 are deposited in banks A, B and C respectively. 'BankA', 'BankB' and 'BankC'
are subclasses of class 'Bank', each having a method named 'getBalance'. Call this method
by creating an object of each of the three classes.""",
                "filenames": ["BankDemo.java"]
            },
            {
                "question": """Program that displays three concentric circles where ever the user clicks the mouse on a frame. The program must exit when user clicks ‘X’ on the frame.""",
                "filenames": ["ConcentricCircles.java"]
            },
        ],
        "answers": {
            "BankDemo.java": """abstract class Bank {
    abstract void DisplayBal();
}

class BankA extends Bank {
    private int bal = 100;
    void DisplayBal() {
        System.out.println("Balance in Bank A is :" + bal);
    }
}

class BankB extends Bank {
    private int bal = 150;
    void DisplayBal() {
        System.out.println("Balance in Bank B is :" + bal);
    }
}

class BankC extends Bank {
    private int bal = 200;
    void DisplayBal() {
        System.out.println("Balance in Bank C is :" + bal);
    }
}

public class BankDemo {
    public static void main(String args[]) {

        BankA a = new BankA();
        BankB b = new BankB();
        BankC c = new BankC();

        a.DisplayBal();
        b.DisplayBal();
        c.DisplayBal();
    }
}
""",
            "ConcentricCircles.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class ConcentricCircles extends JFrame {
    private int x = -1, y = -1;

    public ConcentricCircles() {
        setTitle("concentric circles on click");
        setSize(500, 500);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLocationRelativeTo(null);

        addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                x = e.getX();
                y = e.getY();
                repaint();
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (x != -1 && y != -1) {
            g.setColor(Color.RED);
            g.drawOval(x - 30, y - 30, 60, 60);

            g.setColor(Color.BLUE);
            g.drawOval(x - 20, y - 20, 40, 40);

            g.setColor(Color.GREEN);
            g.drawOval(x - 10, y - 10, 20, 20);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            new ConcentricCircles().setVisible(true);
        });
    }
}
"""
        }
    },
    {
        "slipNo": 25,
        "questions": [
            {
                "question": """Create a class Student(rollno, name ,class, per), to read student information from the console and display them (Using BufferedReader class)
""",
                "filenames": ["StudentDemo.java"]
            },
            {
                "question": """Create the following GUI screen using appropriate layout manager. Accept the name, class,
hobbies from the user and display the selected options in a textbox""",
                "filenames": ["StudentInfoGUI.java"]
            },
        ],
        "answers": {
            "StudentDemo.java": """import java.io.*;

class student {
    int rollno;
    String name;
    String cls;
    double per;

    void Acptdata() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.print("enter roll number: ");
        rollno = Integer.parseInt(br.readLine());

        System.out.print("enter name: ");
        name = br.readLine();

        System.out.print("enter class: ");
        cls = br.readLine();

        System.out.print("enter percentage: ");
        per = Double.parseDouble(br.readLine());
    }

    void display() {
        System.out.println("roll number: " + rollno);
        System.out.println("name: " + name);
        System.out.println("class: " + cls);
        System.out.println("percentage: " + per);
    }
}

public class StudentDemo {
    public static void main(String ar[]) throws IOException {
        student s = new student();
        s.Acptdata();
        s.display();
    }
}
""",
            "StudentInfoGUI.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

class StudentInfoGUI extends JFrame implements ActionListener {
    JTextField nameField;
    JCheckBox classFY, classSY, classTY;
    JCheckBox hobbyMusic, hobbyDance, hobbySport;
    JTextArea output;
    JButton submit;

    public StudentInfoGUI() {
        setTitle("Student Information");
        setSize(400, 300);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new BorderLayout());

        JPanel inputPanel = new JPanel(new GridLayout(3, 2));

        inputPanel.add(new JLabel("Name:"));
        nameField = new JTextField();
        inputPanel.add(nameField);

        inputPanel.add(new JLabel("Class:"));
        JPanel classPanel = new JPanel();
        classFY = new JCheckBox("FY");
        classSY = new JCheckBox("SY");
        classTY = new JCheckBox("TY");
        classPanel.add(classFY);
        classPanel.add(classSY);
        classPanel.add(classTY);
        inputPanel.add(classPanel);

        inputPanel.add(new JLabel("Hobbies:"));
        JPanel hobbyPanel = new JPanel();
        hobbyMusic = new JCheckBox("Music");
        hobbyDance = new JCheckBox("Dance");
        hobbySport = new JCheckBox("Sport");
        hobbyPanel.add(hobbyMusic);
        hobbyPanel.add(hobbyDance);
        hobbyPanel.add(hobbySport);
        inputPanel.add(hobbyPanel);

        add(inputPanel, BorderLayout.NORTH);

        output = new JTextArea(5, 30);
        output.setEditable(false);
        add(new JScrollPane(output), BorderLayout.CENTER);

        submit = new JButton("Submit");
        submit.addActionListener(this);
        add(submit, BorderLayout.SOUTH);

        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String name = nameField.getText();

        StringBuilder selectedClass = new StringBuilder();
        if (classFY.isSelected()) selectedClass.append("FY ");
        if (classSY.isSelected()) selectedClass.append("SY ");
        if (classTY.isSelected()) selectedClass.append("TY ");

        StringBuilder selectedHobbies = new StringBuilder();
        if (hobbyMusic.isSelected()) selectedHobbies.append("Music ");
        if (hobbyDance.isSelected()) selectedHobbies.append("Dance ");
        if (hobbySport.isSelected()) selectedHobbies.append("Sport ");

        output.setText("Name: " + name + " Class: " + selectedClass.toString() + " Hobbies: " + selectedHobbies.toString());
    }

    public static void main(String[] args) {
        new StudentInfoGUI();
    }
}
"""
        }
    },
    {
        "slipNo": 26,
        "questions": [
            {
                "question": """Define a Item class (item_number, item_name, item_price). Define a default and parameterized constructor. Keep a count of objects created. Create objects using parameterized constructor and display the object count after each object is created.(Use static member and method). Also display the contents of each object.
""",
                "filenames": ["ItemDemo.java"]
            },
            {
                "question": """Define a class ‘Donor’ to store the below mentioned details of a blood donor. name, age,
address, contactnumber, bloodgroup, date of last donation. Create ‘n’ objects of this class for
all the regular donors at Pune. Write these objects to a file. Read these objects from the file and
display only those donors’ details whose blood group is ‘A+ve’ and had not donated for the
recent six months.""",
                "filenames": ["BloodDonor.java"]
            },
        ],
        "answers": {
            "ItemDemo.java": """import java.util.Scanner;

class Item {
    int item_num;
    String item_name;
    double item_price;
    static int count = 0;

    Item() {
        item_num = 0;
        item_name = "";
        item_price = 0.0;
        count++;
    }

    Item(int number, String name, double price) {
        item_num = number;
        item_name = name;
        item_price = price;
        count++;
    }

    static int getCount() {
        return count;
    }

    void display() {
        System.out.println("--- Item Details ---");
        System.out.println("Item Number : " + item_num);
        System.out.println("Item Name   : " + item_name);
        System.out.println("Item Price  : " + item_price);
        System.out.println("Total Objects Created: " + getCount());
    }
}

public class ItemDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("How many items do you want to enter? ");
        int n = sc.nextInt();
        sc.nextLine();

        Item[] items = new Item[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for Item " + (i + 1));
            System.out.print("Enter item number: ");
            int num = sc.nextInt();
            sc.nextLine();

            System.out.print("Enter item name: ");
            String name = sc.nextLine();

            System.out.print("Enter item price: ");
            double price = sc.nextDouble();
            sc.nextLine();

            items[i] = new Item(num, name, price);
        }

        System.out.println("===== All Item Details =====");
        for (Item it : items) {
            it.display();
        }

    }
}
""",
            "BloodDonor.java": """import java.io.*;
import java.util.*;
import java.text.*;

class Donor implements Serializable {
    String name;
    int age;
    String address;
    int cont_No;
    String bloodGroup;
    String lastDonationDate;

    Donor(String name, int age, String address, int cont_no, String bloodGroup, String lastDonationDate) {
        this.name = name;
        this.age = age;
        this.address = address;
        this.cont_No = cont_no;
        this.bloodGroup = bloodGroup;
        this.lastDonationDate = lastDonationDate;
    }

    void display() {
        System.out.println("name: " + name);
        System.out.println("age: " + age);
        System.out.println("address: " + address);
        System.out.println("contact number: " + cont_No);
        System.out.println("blood group: " + bloodGroup);
        System.out.println("last donation date: " + lastDonationDate);

    }
}

public class BloodDonor {
    public static void main(String arg[]) {
        Scanner sc = new Scanner(System.in);

        System.out.print("enter number of donors: ");
        int n = Integer.parseInt(sc.nextLine());

        Donor[] dor = new Donor[n];

        for (int i = 0; i < n; i++) {
            System.out.println("enter details of donor " + (i + 1));
            System.out.print("name: ");
            String name = sc.nextLine();
            System.out.print("age: ");
            int age = Integer.parseInt(sc.nextLine());
            System.out.print("address: ");
            String add = sc.nextLine();
            System.out.print("contact number: ");
            int cont = Integer.parseInt(sc.nextLine());
            System.out.print("blood group: ");
            String bloodGroup = sc.nextLine();
            System.out.print("last donation date (dd-MM-yyyy): ");
            String lastdonation_date = sc.nextLine();

            dor[i] = new Donor(name, age, add, cont, bloodGroup, lastdonation_date);
        }

        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("donors.dat"))) {
            for (Donor d : dor) {
                oos.writeObject(d);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        System.out.println("donors with blood group a+ve and not donated in last 6 months:");
        Date currentDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        cal.add(Calendar.MONTH, -6);
        Date sixMonthsAgo = cal.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");

        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream("donors.dat"))) {
            while (true) {
                try {
                    Donor d = (Donor) ois.readObject();
                    Date lastDonation = sdf.parse(d.lastDonationDate);
                    if (d.bloodGroup.equalsIgnoreCase("A+ve") && lastDonation.before(sixMonthsAgo)) {
                        d.display();
                    }
                } catch (EOFException eof) {
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
"""
        }
    },
    {
        "slipNo": 27,
        "questions": [
            {
                "question": """Define an Employee class with suitable attributes having getSalary() method, which returns
salary withdrawn by a particular employee. Write a class Manager which extends a class
Employee, override the getSalary() method, which will return salary of manager by adding
traveling allowance, house rent allowance etc.""",
                "filenames": ["EmployeeManager.java"]
            },
            {
                "question": """Write a program to accept a string as command line argument and check whether it is a file or directory. Also perform operations as follows:
i)If it is a directory,delete all text files in that directory. Confirm delete operation from
user before deleting text files. Also, display a count showing the number of files deleted,
if any, from the directory.
ii)If it is a file display various details of that file""",
                "filenames": ["FileOperations.java"]
            },
        ],
        "answers": {
            "EmployeeManager.java": """import java.util.Scanner;

class Emp {
    String name;
    double salary;

    Emp(String name, double salary) {
        this.name = name;
        this.salary = salary;
    }

    double getSalary() {
        return salary;
    }
}

class Manager extends Emp {
    double ta;
    double hra;

    Manager(String name, double salary, double ta, double hra) {
        super(name, salary);
        this.ta = ta;
        this.hra = hra;
    }

    @Override
    double getSalary() {
        return salary + ta + hra;
    }
}

public class EmployeeManager {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.println("Enter Employee Details:");
        System.out.print("Name: ");
        String empName = sc.nextLine();
        System.out.print("Salary: ");
        double empSalary = sc.nextDouble();

        Emp e = new Emp(empName, empSalary);

        sc.nextLine();
        System.out.println("Enter Manager Details:");
        System.out.print("Name: ");
        String mgrName = sc.nextLine();
        System.out.print("Basic Salary: ");
        double mgrSalary = sc.nextDouble();
        System.out.print("Travel Allowance: ");
        double ta = sc.nextDouble();
        System.out.print("House Rent Allowance: ");
        double hra = sc.nextDouble();

        Manager m = new Manager(mgrName, mgrSalary, ta, hra);

        System.out.println("===== Salary Details =====");
        System.out.println("Employee Name   : " + e.name);
        System.out.println("Employee Salary : " + e.getSalary());
        System.out.println("Manager Name    : " + m.name);
        System.out.println("Manager Salary  : " + m.getSalary());


    }
}
""",
            "FileOperations.java": """import java.io.File;
import java.util.Scanner;

public class FileOperations
 {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("plz enter either file name or directory name as command line argument");
            return;
        }

        String path = args[0];
        File f = new File(path);

        if (!f.exists()) {
            System.out.println("The path does not exist");
            return;
        }

        if (f.isDirectory()) {
            System.out.println("It is a Directory.");
            File[] files = f.listFiles((dir, name) -> name.toLowerCase().endsWith(".txt"));
            if (files != null && files.length > 0) {
                System.out.println("Text files found in directory: " + files.length);
                Scanner sc = new Scanner(System.in);
                System.out.print("Do you want to delete all text files?[ yes/no ]: ");
                String confirm = sc.nextLine();

                if (confirm.equalsIgnoreCase("yes")) {
                    int count = 0;
                    for (File file : files) {
                        if (file.delete()) {
                            count++;
                        }
                    }
                    System.out.println("Deleted " + count + " text files.");
                } else {
                    System.out.println("Deletion cancelled.");
                }
            } else {
                System.out.println("No txt files found in this directory.");
            }
        } else if (f.isFile()) {
            System.out.println("It is a File.");
            System.out.println("Name: " + f.getName());
            System.out.println("Path: " + f.getAbsolutePath());
            System.out.println("Readable: " + f.canRead());
            System.out.println("Writable: " + f.canWrite());
            System.out.println("File size (bytes): " + f.length());
            System.out.println("Parent directory: " + f.getParent());
        } else {
            System.out.println("The given path is neither a regular file nor a directory.");
        }
    }
}
"""
        }
    },
    {
        "slipNo": 28,
        "questions": [
            {
                "question": """Write a program that reads on file name from the user, then displays information about
whether the file exists, whether the file is readable, whether the file is writable, the type of
file and the length of the file in bytes.
""",
                "filenames": ["FileInfo.java"]
            },
            {
                "question": """Write a program called SwingTemperatureConverter to convert temperature values
between Celsius and Fahrenheit. User can enter either the Celsius or the Fahrenheit value,
in floating-point number. Hints: To display a floating-point number in a specific format
(e.g., 1 decimal place), use the static method String.format(), which has the same form
as printf(). For example, String.format("%.1f", 1.234) returns String "1.2".""",
                "filenames": ["TempConverter.java"]
            },
        ],
        "answers": {
            "FileInfo.java": """import java.io.File;
import java.util.*;

public class FileInfo {
    public static void main(String arg[]) {
        Scanner sc = new Scanner(System.in);
        System.out.print("Enter file name: ");
        String fName = sc.nextLine();

        File file = new File(fName);

        if (file.exists()) {
            System.out.println("File exists: Yes");
            System.out.println("readable: " + file.canRead());
            System.out.println("writable: " + file.canWrite());

            if (file.isFile()) {
                System.out.println("Type Regular file");
            } else if (file.isDirectory()) {
                System.out.println("Type directory");
            } else {
                System.out.println("Type  unknown");
            }

            System.out.println(" file length: " + file.length());
        } else {
            System.out.println("file does not exist!");
        }

    }
}
""",
            "TempConverter.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TempConverter extends JFrame implements ActionListener {
    private JTextField celsiusField, fahrenheitField;
    private JButton cToFButton, fToCButton;

    public TempConverter() {
        setTitle("Temperature Converter");
        setSize(300, 150);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new GridLayout(3, 2, 5, 5));

        add(new JLabel("Celsius-->"));
        celsiusField = new JTextField();
        add(celsiusField);

        add(new JLabel("Fahrenheit-->"));
        fahrenheitField = new JTextField();
        add(fahrenheitField);

        cToFButton = new JButton("C -> F");
        fToCButton = new JButton("F -> C");

        cToFButton.addActionListener(this);
        fToCButton.addActionListener(this);

        add(cToFButton);
        add(fToCButton);

        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == cToFButton) {
                double celsius = Double.parseDouble(celsiusField.getText());
                double fahrenheit = (celsius * 9 / 5) + 32;
                fahrenheitField.setText(String.format("%.1f", fahrenheit));
            } else if (e.getSource() == fToCButton) {
                double fahrenheit = Double.parseDouble(fahrenheitField.getText());
                double celsius = (fahrenheit - 32) * 5 / 9;
                celsiusField.setText(String.format("%.1f", celsius));
            }
        } catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Plz enter a valid number", "Error", JOptionPane.ERROR_MESSAGE);
        }
    }

    public static void main(String[] args) {
        new TempConverter();
    }
}
"""
        }
    },
    {
        "slipNo": 29,
        "questions": [
            {
                "question": """Write a program to create a class Customer(custno,custname,contactnumber,custaddr).
Write a method to search the customer name with given contact number and display the
details.""",
                "filenames": ["CustSearch.java"]
            },
            {
                "question": """Write a program to create a super class Vehicle having members Company and price.
Derive two different classes LightMotorVehicle(mileage) and HeavyMotorVehicle
(capacity_in_tons). Accept the information for "n" vehicles and display the information in
appropriate form. While taking data, ask user about the type of vehicle first.""",
                "filenames": ["VehicleDemo.java"]
            },
        ],
        "answers": {
            "CustSearch.java": """import java.util.Scanner;

class Customer {
    private int customerId;
    private String name;
    private String contact;
    private String address;

    Customer(int customerId, String name, String contact, String address) {
        this.customerId = customerId;
        this.name = name;
        this.contact = contact;
        this.address = address;
    }

    public String getContact() {
        return contact;
    }

    void display() {
        System.out.println("--- Customer Details ---");
        System.out.println("Customer No : " + customerId);
        System.out.println("Name        : " + name);
        System.out.println("Contact     : " + contact);
        System.out.println("Address     : " + address);
    }
}

public class CustSearch {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of customers: ");
        int n = sc.nextInt();
        sc.nextLine();

        Customer[] customers = new Customer[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for customer " + (i + 1) + ":");

            System.out.print("Customer No: ");
            int id = sc.nextInt();
            sc.nextLine();

            System.out.print("Name: ");
            String name = sc.nextLine();

            System.out.print("Contact: ");
            String contact = sc.nextLine();

            System.out.print("Address: ");
            String address = sc.nextLine();

            customers[i] = new Customer(id, name, contact, address);
        }

        System.out.print("Enter contact number to search: ");
        String searchContact = sc.nextLine();

        boolean found = false;
        for (Customer c : customers) {
            if (c.getContact().equals(searchContact)) {
                System.out.println("Customer Found!");
                c.display();
                found = true;
                break;
            }
        }

        if (!found) {
            System.out.println("No customer found with contact: " + searchContact);
        }

    }
}
""",
            "VehicleDemo.java": """import java.util.Scanner;

class Vehicle {
    String company;
    double price;

    Vehicle(String company, double price) {
        this.company = company;
        this.price = price;
    }

    void display() {
        System.out.println("Company : " + company);
        System.out.println("Price   : " + price);
    }
}

class LightMotorVehicle extends Vehicle {
    double mileage;

    LightMotorVehicle(String company, double price, double mileage) {
        super(company, price);
        this.mileage = mileage;
    }

    @Override
    void display() {
        super.display();
        System.out.println("Mileage : " + mileage + " km/l");
    }
}

class HeavyMotorVehicle extends Vehicle {
    double capacityInTons;

    HeavyMotorVehicle(String company, double price, double capacityInTons) {
        super(company, price);
        this.capacityInTons = capacityInTons;
    }

    @Override
    void display() {
        super.display();
        System.out.println("Capacity: " + capacityInTons + " tons");
    }
}

public class VehicleDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of vehicles: ");
        int n = sc.nextInt();
        sc.nextLine();

        Vehicle[] vehicles = new Vehicle[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for Vehicle " + (i + 1));
            System.out.print("Enter type of vehicle [light/heavy]: ");
            String type = sc.nextLine();

            System.out.print("Enter company name: ");
            String company = sc.nextLine();

            System.out.print("Enter price: ");
            double price = sc.nextDouble();

            if (type.equalsIgnoreCase("light")) {
                System.out.print("Enter mileage (km/l): ");
                double mileage = sc.nextDouble();
                vehicles[i] = new LightMotorVehicle(company, price, mileage);
            } else if (type.equalsIgnoreCase("heavy")) {
                System.out.print("Enter capacity (tons): ");
                double capacity = sc.nextDouble();
                vehicles[i] = new HeavyMotorVehicle(company, price, capacity);
            } else {
                System.out.println("Invalid type. Try again!");
                i--;
            }
            sc.nextLine();
        }

        System.out.println("===== Vehicle Information =====");
        for (int i = 0; i < n; i++) {
            System.out.println("Vehicle " + (i + 1));
            vehicles[i].display();
        }
    }
}
"""
        }
    },
    {
        "slipNo": 30,
        "questions": [
            {
                "question": """Write program to define class Person with data member as Personname,Aadharno, Panno.
Accept information for 5 objects and display appropriate information (use this keyword).""",
                "filenames": ["PersonDemo.java"]
            },
            {
                "question": """Write a program that creates a user interface to perform integer divisions. The user enters two
numbers in the text fields, Number1 and Number2. The division of Number1 and Number2 is
displayed in the Result field when the Divide button is clicked. If Number1 or Number2 were
not an integer, the program would throw a NumberFormatException. If Number2 were Zero,
the program would throw an Arithmetic Exception Display the exception in a message
dialog box.""",
                "filenames": ["IntDivGUI.java"]
            },
        ],
        "answers": {
            "PersonDemo.java": """import java.util.Scanner;

class Person {
    private String name;
    private String aadhar;
    private String pan;

    Person(String name, String aadhar, String pan) {
        this.name = name;
        this.aadhar = aadhar;
        this.pan = pan;
    }

    void display() {
        System.out.println("--- Person Details ---");
        System.out.println("Name   : " + name);
        System.out.println("Aadhar : " + aadhar);
        System.out.println("PAN    : " + pan);
    }
}

public class PersonDemo {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        System.out.print("Enter number of persons: ");
        int n = sc.nextInt();
        sc.nextLine();

        Person[] persons = new Person[n];

        for (int i = 0; i < n; i++) {
            System.out.println("Enter details for Person " + (i + 1) + ":");
            System.out.print("Name: ");
            String name = sc.nextLine();

            System.out.print("Aadhar No: ");
            String aadhar = sc.nextLine();

            System.out.print("PAN No: ");
            String pan = sc.nextLine();

            persons[i] = new Person(name, aadhar, pan);
        }

        System.out.println("===== All Person Details =====");
        for (Person p : persons) {
            p.display();
        }


    }
}
""",
            "IntDivGUI.java": """import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class IntDivGUI extends JFrame implements ActionListener {
    private JTextField t1, t2, tres;
    private JButton divideBtn;

    public IntDivGUI() {
        setTitle("Integer Division");
        setSize(300, 150);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new GridLayout(4, 2, 5, 5));

        add(new JLabel("Num 1st:"));
        t1 = new JTextField();
        add(t1);

        add(new JLabel("Num 2:"));
        t2 = new JTextField();
        add(t2);

        add(new JLabel("Result:"));
        tres = new JTextField();
        tres.setEditable(false);
        add(tres);

        divideBtn = new JButton("Divide");
        divideBtn.addActionListener(this);
        add(divideBtn);

        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int n1 = Integer.parseInt(t1.getText());
            int n2 = Integer.parseInt(t2.getText());

            int res = n1 / n2;
            tres.setText(String.valueOf(res));
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "please enter integers.", "Error", JOptionPane.ERROR_MESSAGE);
        }
        catch (ArithmeticException ex) {
            JOptionPane.showMessageDialog(this, "Division by 0 not allowed", "Error", JOptionPane.ERROR_MESSAGE);
        }
    }

    public static void main(String[] args) {
        new IntDivGUI();
    }
}
"""
        }
    },
]