OS_SLIPS = [
    {
        "slipNo": 1,
        "questions": [
            {
                "question": """Write the simulation program to implement demand paging and show the page scheduling and total number of page faults according to the LFU page replacement algorithm. Assume the memory of n frames.\nReference String : 3,4,5,4,3,4,7,2,4,5,6,7,2,4,6""",
                "filenames": ["slip1Q1.c"]
            },
            {
                "question": """Write a C program to implement the shell which displays the command prompt “myshell$”. It accepts the command, tokenize the command line and execute it by creating the child process. Also implement the additional command \"typeline\" as\ntypeline +n filename :- To print first n lines in the file.\ntypeline -a filename :- To print all lines in the file.""",
                "filenames": ["slip1Q2.c"]
            }
        ],
        "answers": {
            "slip1Q1.c": """#include <stdio.h>
#include <stdlib.h>

int main()
{
    int n, i, j, k, page_faults = 0, min_freq, replace_index;

    printf("Enter number of frames: ");
    scanf("%d", &n);

    int frames[n];
    int freq[n];
    for (i = 0; i < n; i++)
    {
        frames[i] = -1;
        freq[i] = 0;
    }

    int ref_str[] = {3, 4, 5, 4, 3, 4, 7, 2, 4, 5, 6, 7, 2, 4, 6};
    int ref_len = sizeof(ref_str) / sizeof(ref_str[0]);

    printf("\\nPage reference string: ");
    for (i = 0; i < ref_len; i++)
        printf("%d ", ref_str[i]);
    printf("\\n\\n");

    printf("Page frames status:\\n");

    for (i = 0; i < ref_len; i++)
    {
        int found = 0;
        for (j = 0; j < n; j++)
        {
            if (frames[j] == ref_str[i])
            {
                freq[j]++;
                found = 1;
                break;
            }
        }

        if (!found)
        {
            page_faults++;
            int empty_found = 0;
            for (j = 0; j < n; j++)
            {
                if (frames[j] == -1)
                {
                    frames[j] = ref_str[i];
                    freq[j] = 1;
                    empty_found = 1;
                    break;
                }
            }

            if (!empty_found)
            {
                min_freq = freq[0];
                replace_index = 0;
                for (j = 1; j < n; j++)
                {
                    if (freq[j] < min_freq)
                    {
                        min_freq = freq[j];
                        replace_index = j;
                    }
                }
                frames[replace_index] = ref_str[i];
                freq[replace_index] = 1;
            }
        }

        for (k = 0; k < n; k++)
        {
            if (frames[k] != -1)
                printf("%d\\t", frames[k]);
            else
                printf("-\\t");
        }
        if (found)
            printf("No Page Fault\\n");
        else
            printf("Page Fault\\n");
    }

    printf("\\nTotal Page Faults = %d\\n", page_faults);

    return 0;
}
""",
            "slip1Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>

      void typeline(char *op, char *fname)
      {
          char ch, str[20];
          FILE *fp;
          int lc = 0, skip, count = 0;
          fp = fopen(fname, "r");
          if (fp == NULL)
              printf("file does not exist\\n");
          else
              printf("file exist\\n");

          if (strcmp(op, "-a") == 0)
          {
              while (!feof(fp))
              {
                  ch = fgetc(fp);
                  printf("%c", ch);
              }
          }
          else
          {
              int n = atoi(op);
              if (n > 0)
              {
                  while (lc < n)
                  {
                      ch = fgetc(fp);
                      if (ch == '\\n')
                          lc++;
                      printf("%c", ch);
                  }
              }

              if (n < 0)
              {
                  while (!feof(fp))
                  {
                      ch = fgetc(fp);
                      if (ch == '\\n')
                          lc++;
                  }
                  skip = lc + n;
                  fseek(fp, 0, SEEK_SET);
                  while (fgets(str, 80, fp) != NULL)
                  {
                      count++;
                      if (count <= skip)
                      {
                      }
                      else
                          printf("%s", str);
                  }
              }
          }
      }

      int main(int argc, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20], tok4[20], fname[30];
          int choice, f;
          char cmd[40];
          while (1)
          {
              printf("\\nMyshell $:");
              gets(cmd);
              if (strcmp(cmd, "exit") == 0)
                  exit(0);
              int choice = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
              if (choice == 3)
              {
                  if (strcmp(tok1, "typeline") == 0)
                      typeline(tok2, tok3);
                  continue;
              }
              if (fork() == 0)
              {
                  switch (choice)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  case 4:
                      execlp(tok1, tok2, tok3, tok4, NULL);
                      break;
                  }
                  exit(0);
              }
          }
      }
// Myshell $:typeline -a data.txt
// Myshell $:typeline 2 data.txt
      """
        }
    },
    {
        "slipNo": 2,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the FIFO page replacement algorithm. Assume the memory of n frames.\nReference String : 3, 4, 5, 6, 3, 4, 7, 3, 4, 5, 6, 7, 2, 4, 6""",
                "filenames": ["slip2Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following ‘list’ commands as\nmyshell$ list f dirname :- To print names of all the files in current directory.\nmyshell$ list n dirname :- To print the number of all entries in the current directory.""",
                "filenames": ["slip2Q2.c"]
            }
        ],
        "answers": {
            "slip2Q1.c": """#include <stdio.h>

      int page[50];
      int n, frame[5], refLen, victim = -1, pf = 0;

      int searchPage(int p)
      {
          for (int i = 0; i < n; i++)
          {
              if (frame[i] == p)
                  return i;
          }
          return -1;
      }

      int selectVictim()
      {
          victim++;
          return victim % n;
      }

      int main()
      {
          int i, j;

          refLen = 15;
          int reference[] = {3, 4, 5, 6, 3, 4, 7, 3, 4, 5, 6, 7, 2, 4, 6};

          printf("Enter number of frames: ");
          scanf("%d", &n);

          for (i = 0; i < n; i++)
              frame[i] = -1;

          printf("\\nPage\\tFrames\\n");
          printf("-------------------\\n");

          for (i = 0; i < refLen; i++)
          {
              int k = searchPage(reference[i]);

              if (k == -1)
              {
                  pf++;
                  int victimIndex = selectVictim();
                  frame[victimIndex] = reference[i];
              }

              printf("%d\\t", reference[i]);
              for (j = 0; j < n; j++)
                  if (frame[j] != -1)
                      printf("%d ", frame[j]);
              printf("\\n");
          }

          printf("\\nTotal Page Faults = %d\\n", pf);

          return 0;
      }
      """,
            "slip2Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>
      #include <dirent.h>

      void list(char *tok2, char *tok3)
      {
          DIR *dp;
          int c = 0;
          struct dirent *dir;
          dp = opendir(tok3);
          if (dp == NULL)
              printf("%s directory not exist", tok3);
          else
          {
              if (strcmp(tok2, "n") == 0)
              {
                  while ((dir = readdir(dp)) != NULL)
                      c++;
                  printf("No. of files in directory = %d", c);
              }
              if (strcmp(tok2, "f") == 0)
              {
                  while ((dir = readdir(dp)) != NULL)
                      printf("%s\\n", dir->d_name);
              }
              if (strcmp(tok2,"i") == 0)
              {
                  while((dir=readdir(dp))!=NULL)
                      printf("%s\\t\\t%d\\n",dir->d_name,dir->d_ino);
              }
          }
      }

      void main(int argc, char *argv[])
      {
          char cmd[20], tok1[20], tok2[20], tok3[20], tok4[20];
          while (1)
          {
              printf("\\nMyShell $:");
              fgets(cmd, sizeof(cmd), stdin);
              if (strcmp(cmd, "exit") == 0)
                  exit(0);
              int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);

              if (ch == 3)
              {
                  if (strcmp(tok1, "list") == 0)
                      list(tok2, tok3);
                  continue;
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  }
              }
          }
      }
      """
        }
    },
    {
        "slipNo": 3,
        "questions": [
            {
                "question": """Write the simulation program to implement demand paging and show the page scheduling and total number of page faults according to the LRU (using counter method) page replacement algorithm. Assume the memory of n frames.\nReference String : 3,5,7,2,5,1,2,3,1,3,5,3,1,6,2""",
                "filenames": ["slip3Q1.c"]
            },
            {
                "question": """Write a program to implement the toy shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\ncount c filename :- To print number of characters in the file.\ncount w filename :- To print number of words in the file.\ncount l filename :- To print number of lines in the file.""",
                "filenames": ["slip3Q2.c"]
            }
        ],
        "answers": {
            "slip3Q1.c": """#include <stdio.h>
      int pf = 0, pg;
      int f, frame[5], ref[50], victim = 0, time[50];
      int searchpage(int p)
      {
          int i;
          for (i = 0; i < f; i++)
              if (frame[i] == p)
                  return i;
          return -1;
      }
      int selectvictim()
      {
          int min = 0, i;
          for (i = 1; i < f; i++)
          {
              if (time[i] < time[min])
                  min = i;
          }
          return min;
      }
      int main()
      {
          int i;
          printf("\\nEnter the no.of frames : ");
          scanf("%d", &f);
          for (i = 0; i < f; i++)
              frame[i] = -1;
          for (i = 0; i < f; i++)
              time[i] = -1;
          printf("\\nEnter the no. of pages : ");
          scanf("%d", &pg);
          printf("\\nEnter the page(reference string) : ");
          for (i = 0; i < pg; i++)
              scanf("%d", &ref[i]);
          for (i = 0; i < pg; i++)
          {
              int k, j;
              k = searchpage(ref[i]);
              if (k == -1)
              {
                  pf++;
                  k = selectvictim();
                  frame[k] = ref[i];
              }
              time[k] = i;
              printf("\\n pg=%d |", ref[i]);
              for (j = 0; j < f; j++)
                  printf("\\t%d", frame[j]);
          }
          printf("\\nPage Fault is = %d", pf);
      }
      """,
            "slip3Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>

      void count(char *tok2, char *tok3)
      {
          int w = 0, c = 0, l = 0;
          FILE *fp;
          fp = fopen(tok3, "r");
          if (fp == NULL)
              printf("File does not exist");
          {
              while (!feof(fp))
              {
                  char ch;
                  ch = fgetc(fp);
                  if (ch == ' ')
                      w++;
                  else if (ch == '\\n')
                  {
                      w++;
                      l++;
                  }
                  else
                      c++;
              }
              if (strcmp(tok2, "w") == 0)
                  printf("Word count = %d", w);
              if (strcmp(tok2, "c") == 0)
                  printf("Character count = %d", c);
              if (strcmp(tok2, "l") == 0)
                  printf("Line count = %d", l);
          }
      }

      void main(int argc, char *argv[])
      {
          char cmd[20], tok1[20], tok2[20], tok3[20];
          while (1)
          {
              printf("\\nMyshell$:");
              fgets(cmd, sizeof(cmd), stdin);
              if (strcmp(cmd, "exit") == 0)
                  exit(0);
              int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);
              if (ch == 3)
              {
                  if (strcmp(tok1, "count") == 0)
                      count(tok2, tok3);
                  continue;
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  }
              }
          }
      }
      """
        }
    },
    {
        "slipNo": 4,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the MFU page replacement algorithm. Assume the memory of n frames.\nReference String : 8, 5, 7, 8, 5, 7, 2, 3, 7, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip4Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\nmyshell$ search a filename pattern :- To search all the occurrence of pattern in the file.\nmyshell$ search c filename pattern :- To count the number of occurrence of pattern in the file""",
                "filenames": ["slip4Q2.c"]
            }
        ],
        "answers": {
            "slip4Q1.c":"""#include <stdio.h>
      struct node
      {
          int pno, freq;
      } frames[20];
      int n;
      int page_found(int pno)
      {
          int fno;
          for (fno = 0; fno < n; fno++)
              if (frames[fno].pno == pno)
                  return fno;
          return -1;
      }
      int get_free_frame()
      {
          int fno;
          for (fno = 0; fno <= n; fno++)
              if (frames[fno].pno == -1)
                  return (fno);
          return (-1);
      }
      int get_mfu_frame()
      {
          int fno;
          int selfno = 0;
          for (fno = 1; fno < n; fno++)
              if (frames[fno].freq > frames[selfno].freq)
                  selfno = fno;
          return selfno;
      }
      void main()
      {
          int p_request[100];
          int size;
          int page_fault = 0, i, j, fno;
          printf("\\nEnter how many pages : ");
          scanf("%d", &size);
          printf("\\nEnter Reference string : ");
          for (i = 0; i < size; i++)
              scanf("%d", &p_request[i]);
          printf("\\nHow many frames:");

          for (i = 0; i < n; i++)
          {
              frames[i].pno = -1;
              frames[i].freq = 0;
          }
          scanf("%d", &n);
          printf("\\nPageNoPage FramesPage Fault");
          printf("\\n---------------------------------------------------");
          for (i = 0; i < size; i++)
          {
              j = page_found(p_request[i]);
              if (j == -1)
              {
                  j = get_free_frame();
                  if (j == -1)
                      j = get_mfu_frame();
                  page_fault++;
                  frames[j].pno = p_request[i];
                  frames[j].freq = 1;
                  printf("\\n%d\\t ", p_request[i]);
                  for (fno = 0; fno < n; fno++)
                      printf("%d\\t", frames[fno].pno);
                  printf(" : YES");
              }
              else
              {
                  printf("\\n%d\\t ", p_request[i]);
                  frames[j].freq++;
                  for (fno = 0; fno < n; fno++)
                      printf("%d\\t", frames[fno].pno);
                  printf(" : NO");
              }
          }
          printf("\\n-------------------------------------------------------");
          printf("\\n Number of Page_Falts=%d", page_fault);
      }
      """,

            "slip4Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
          FILE *fp;
          char str[256];
          fp = fopen(tok4, "r");
          if (fp == NULL)
          {
              printf("File does not exist!");
          }
          else
          {
              int lineno = 0;
              int count = 0;

              if (strcmp(tok2, "f") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      lineno++;
                      if (strstr(str, tok3))
                      {
                          printf("First Occurance of %s is on line no : %d", tok3, lineno);
                          break;
                      }
                  }
              }

              if (strcmp(tok2, "c") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      if (strstr(str, tok3))
                      {
                          count++;
                      }
                  }
                  printf("TOtal number of Occurance of pattern ( %s ) is : %d", tok3, count);
              }

              if (strcmp(tok2, "a") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      lineno++;
                      if (strstr(str, tok3))
                      {
                          printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                      }
                  }
              }
          }
      }

      void main(int args, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20], tok4[20], fname[20];
          char cmd[40];
          while (1)
          {
              printf("\\nMyshells : ");
              gets(cmd);

              if (strcmp(cmd, "exit") == 0)
              {
                  exit(0);
              }

              int ch = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
              if (ch == 4)
              {
                  if (strcmp(tok1, "search") == 0)
                  {
                      search(tok2, tok3, tok4);
                      continue;
                  }
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  case 4:
                      execlp(tok1, tok2, tok3, tok4, NULL);
                      break;
                  }
              }
          }
      }
      """
        }
    },
    {
        "slipNo": 5,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the optimal page replacement algorithm. Assume the memory of n frames.\nReference String : 8, 5, 7, 8, 5, 7, 2, 3, 7, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip5Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\nmyshell$ search f filename pattern :- To display first occurrence of pattern in the file.\nmyshell$ search c filename pattern :- To count the number of occurrence of pattern in the file""",
                "filenames": ["slip5Q2.c"]
            }
        ],
        "answers": {
            "slip5Q1.c": """#include <stdio.h>
      int main()
      {
          int frames, n;

          printf("Enter the number of frames: ");
          scanf("%d", &frames);

          printf("Enter the number of pages in the reference string: ");
          scanf("%d", &n);
          int pages[n];
          int frame[frames];
          int pageFaults = 0;

          for (int i = 0; i < frames; i++)
          {
              frame[i] = -1;
          }

          printf("Enter the reference string: ");
          for (int i = 0; i < n; i++)
          {
              scanf("%d", &pages[i]);
          }

          for (int i = 0; i < n; i++)
          {
              int page = pages[i];
              int pageFound = 0;

              for (int j = 0; j < frames; j++)
              {
                  if (frame[j] == page)
                  {
                      pageFound = 1;
                      break;
                  }
              }
              if (!pageFound)
              {
                  int replaceIndex = -1;

                  for (int j = 0; j < frames; j++)
                  {
                      int nextPage = -1;
                      for (int k = i + 1; k < n; k++)
                      {
                          if (pages[k] == frame[j])
                          {
                              nextPage = k;
                              break;
                          }
                      }

                      if (nextPage == -1)
                      {
                          replaceIndex = j;
                          break;
                      }

                      if (replaceIndex == -1 || nextPage > i + 1)
                      {
                          replaceIndex = j;
                      }
                  }

                  frame[replaceIndex] = page;
                  pageFaults++;
              }

              printf("Page %d -> [", page);
              for (int j = 0; j < frames; j++)
              {
                  printf("%d ", frame[j]);
              }
              printf("] Page Faults: %d\\n", pageFaults);
          }

          printf("Total Page Faults: %d\\n", pageFaults);
          return 0;
      }
      """,

            "slip5Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
          FILE *fp;
          char str[256];
          fp = fopen(tok4, "r");
          if (fp == NULL)
          {
              printf("File does not exist!");
          }
          else
          {
              int lineno = 0;
              int count = 0;

              if (strcmp(tok2, "f") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      lineno++;
                      if (strstr(str, tok3))
                      {
                          printf("First Occurance of %s is on line no : %d", tok3, lineno);
                          break;
                      }
                  }
              }

              if (strcmp(tok2, "c") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      if (strstr(str, tok3))
                      {
                          count++;
                      }
                  }
                  printf("TOtal number of Occurance of pattern ( %s ) is : %d", tok3, count);
              }

              if (strcmp(tok2, "a") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      lineno++;
                      if (strstr(str, tok3))
                      {
                          printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                      }
                  }
              }
          }
      }

      void main(int args, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20], tok4[20], fname[20];
          char cmd[40];
          while (1)
          {
              printf("\\nMyshells : ");
              gets(cmd);

              if (strcmp(cmd, "exit") == 0)
              {
                  exit(0);
              }

              int ch = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
              if (ch == 4)
              {
                  if (strcmp(tok1, "search") == 0)
                  {
                      search(tok2, tok3, tok4);
                      continue;
                  }
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  case 4:
                      execlp(tok1, tok2, tok3, tok4, NULL);
                      break;
                  }
              }
          }
      }
      """
        }
    },
    {
        "slipNo": 6,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the MRU page replacement algorithm. Assume the memory of n frames.\nReference String : 8, 5, 7, 8, 5, 7, 2, 3, 7, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip6Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\nmyshell$ search a filename pattern :- To search all the occurrence of pattern in the file.\nmyshell$ search f filename pattern :- To display first occurrence of pattern in the file""",
                "filenames": ["slip6Q2.c"]
            }
        ],
        "answers": {
            "slip6Q1.c": """#include <stdio.h>

      int main()
      {
          int n, pages[50], frames[10], pageCount, i, j;
          int pageFaults = 0, mru = 0;
          int lastUsed[10];

          for (i = 0; i < 10; i++)
              frames[i] = -1, lastUsed[i] = -1;

          printf("Enter number of frames: ");
          scanf("%d", &n);

          printf("Enter number of pages: ");
          scanf("%d", &pageCount);

          printf("Enter reference string: ");
          for (i = 0; i < pageCount; i++)
              scanf("%d", &pages[i]);

          printf("\\nPage\\tFrames\\n");

          for (i = 0; i < pageCount; i++)
          {
              int k, replaceIndex = 0, found = 0;

              for (k = 0; k < n; k++)
              {
                  if (frames[k] == pages[i])
                  {
                      found = 1;
                      mru = i;
                      lastUsed[k] = i;
                      break;
                  }
              }

              if (!found)
              {
                  pageFaults++;

                  int maxUsed = -1;
                  for (k = 0; k < n; k++)
                  {
                      if (lastUsed[k] > maxUsed)
                      {
                          maxUsed = lastUsed[k];
                          replaceIndex = k;
                      }
                  }

                  frames[replaceIndex] = pages[i];
                  lastUsed[replaceIndex] = i;
                  mru = i;
              }

              printf("%d\\t", pages[i]);
              for (j = 0; j < n; j++)
                  printf("%d\\t", frames[j]);
              printf("\\n");
          }

          printf("\\nTotal Page Faults = %d\\n", pageFaults);

          return 0;
      }
      """,

            "slip6Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
          FILE *fp;
          char str[256];
          fp = fopen(tok4, "r");
          if (fp == NULL)
          {
              printf("File does not exist!");
          }
          else
          {
              int lineno = 0;
              int count = 0;

              if (strcmp(tok2, "f") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      lineno++;
                      if (strstr(str, tok3))
                      {
                          printf("First Occurance of %s is on line no : %d", tok3, lineno);
                          break;
                      }
                  }
              }

              if (strcmp(tok2, "c") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      if (strstr(str, tok3))
                      {
                          count++;
                      }
                  }
                  printf("Total number of Occurance of pattern ( %s ) is : %d", tok3, count);
              }

              if (strcmp(tok2, "a") == 0)
              {
                  while (!feof(fp))
                  {
                      fgets(str, sizeof(str), fp);
                      lineno++;
                      if (strstr(str, tok3))
                      {
                          printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                      }
                  }
              }
          }
      }

      void main(int args, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20], tok4[20], fname[20];
          char cmd[40];
          while (1)
          {
              printf("\\nMyshells : ");
              gets(cmd);

              if (strcmp(cmd, "exit") == 0)
              {
                  exit(0);
              }

              int ch = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
              if (ch == 4)
              {
                  if (strcmp(tok1, "search") == 0)
                  {
                      search(tok2, tok3, tok4);
                      continue;
                  }
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  case 4:
                      execlp(tok1, tok2, tok3, tok4, NULL);
                      break;
                  }
              }
          }
      }
      """
        }
    },
    {
        "slipNo": 7,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the optimal page replacement algorithm. Assume the memory of n frames.\nReference String : 7, 5, 4, 8, 5, 7, 2, 3, 1, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip7Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\nmyshell$ search a filename pattern :- To search all the occurrence of pattern in the file.\nmyshell$ search c filename pattern :- To count the number of occurrence of pattern in the file""",
                "filenames": ["slip7Q2.c"]
            }
        ],
        "answers": {
            "slip7Q1.c": """#include <stdio.h>
      int main()
      {
          int frames, n;

          printf("Enter the number of frames: ");
          scanf("%d", &frames);

          printf("Enter the number of pages in the reference string: ");
          scanf("%d", &n);
          int pages[n];
          int frame[frames];
          int pageFaults = 0;

          for (int i = 0; i < frames; i++)
          {
              frame[i] = -1;
          }

          printf("Enter the reference string: ");
          for (int i = 0; i < n; i++)
          {
              scanf("%d", &pages[i]);
          }

          for (int i = 0; i < n; i++)
          {
              int page = pages[i];
              int pageFound = 0;

              for (int j = 0; j < frames; j++)
              {
                  if (frame[j] == page)
                  {
                      pageFound = 1;
                      break;
                  }
              }
              if (!pageFound)
              {
                  int replaceIndex = -1;

                  for (int j = 0; j < frames; j++)
                  {
                      int nextPage = -1;
                      for (int k = i + 1; k < n; k++)
                      {
                          if (pages[k] == frame[j])
                          {
                              nextPage = k;
                              break;
                          }
                      }

                      if (nextPage == -1)
                      {
                          replaceIndex = j;
                          break;
                      }

                      if (replaceIndex == -1 || nextPage > i + 1)
                      {
                          replaceIndex = j;
                      }
                  }

                  frame[replaceIndex] = page;
                  pageFaults++;
              }

              printf("Page %d -> [", page);
              for (int j = 0; j < frames; j++)
              {
                  printf("%d ", frame[j]);
              }
              printf("] Page Faults: %d\\n", pageFaults);
          }

          printf("Total Page Faults: %d\\n", pageFaults);
          return 0;
      }""",
            "slip7Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
         FILE *fp;
         char str[256];
         fp = fopen(tok4, "r");
         if (fp == NULL)
         {
             printf("File does not exist!");
         }
         else
         {
             int lineno = 0;
             int count = 0;

             if (strcmp(tok2, "f") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("First Occurance of %s is on line no : %d", tok3, lineno);
                         break;
                     }
                 }
             }

             if (strcmp(tok2, "c") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     if (strstr(str, tok3))
                     {
                         count++;
                     }
                 }
                 printf("TOtal number of Occurance of pattern ( %s ) is : %d", tok3, count);
             }

             if (strcmp(tok2, "a") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                     }
                 }
             }
         }
      }

      void main(int args, char *argv[])
      {
         char tok1[20], tok2[20], tok3[20], tok4[20], fname[20];
         char cmd[40];
         while (1)
         {
             printf("\\nMyshells : ");
             gets(cmd);

             if (strcmp(cmd, "exit") == 0)
             {
                 exit(0);
             }

             int ch = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
             if (ch == 4)
             {
                 if (strcmp(tok1, "search") == 0)
                 {
                     search(tok2, tok3, tok4);
                     continue;
                 }
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok2, tok3, NULL);
                     break;
                 case 4:
                     execlp(tok1, tok2, tok3, tok4, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 8,
        "questions": [
            {
                "question": """Write the simulation program to implement demand paging and show the page scheduling and total number of page faults according to the LRU (using counter method) page replacement algorithm. Assume the memory of n frames.\nReference String : 8, 5, 7, 8, 5, 7, 2, 3, 7, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip8Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\nmyshell$ search f filename pattern :- To display first occurrence of pattern in the file.\nmyshell$ search c filename pattern :- To count the number of occurrence of pattern in the file""",
                "filenames": ["slip8Q2.c"]
            }
        ],
        "answers": {
            "slip8Q1.c": """#include <stdio.h>
      int pf = 0, pg;
      int f, frame[5], ref[50], victim = 0, time[50];
      int searchpage(int p)
      {
          int i;
          for (i = 0; i < f; i++)
              if (frame[i] == p)
                  return i;
          return -1;
      }
      int selectvictim()
      {
          int min = 0, i;
          for (i = 1; i < f; i++)
          {
              if (time[i] < time[min])
                  min = i;
          }
          return min;
      }
      int main()
      {
          int i;
          printf("\\nEnter the no.of frames : ");
          scanf("%d", &f);
          for (i = 0; i < f; i++)
              frame[i] = -1;
          for (i = 0; i < f; i++)
              time[i] = -1;
          printf("\\nEnter the no. of pages : ");
          scanf("%d", &pg);
          printf("\\nEnter the page(reference string) : ");
          for (i = 0; i < pg; i++)
              scanf("%d", &ref[i]);
          for (i = 0; i < pg; i++)
          {
              int k, j;
              k = searchpage(ref[i]);
              if (k == -1)
              {
                  pf++;
                  k = selectvictim();
                  frame[k] = ref[i];
              }
              time[k] = i;
              printf("\\n pg=%d |", ref[i]);
              for (j = 0; j < f; j++)
                  printf("\\t%d", frame[j]);
          }
          printf("\\nPage Fault is = %d", pf);
      }""",
            "slip8Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
         FILE *fp;
         char str[256];
         fp = fopen(tok4, "r");
         if (fp == NULL)
         {
             printf("File does not exist!");
         }
         else
         {
             int lineno = 0;
             int count = 0;

             if (strcmp(tok2, "f") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("First Occurance of %s is on line no : %d", tok3, lineno);
                         break;
                     }
                 }
             }

             if (strcmp(tok2, "c") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     if (strstr(str, tok3))
                     {
                         count++;
                     }
                 }
                 printf("Total number of Occurance of pattern ( %s ) is : %d", tok3, count);
             }

             if (strcmp(tok2, "a") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                     }
                 }
             }
         }
      }

      void main(int args, char *argv[])
      {
         char tok1[20], tok2[20], tok3[20], tok4[20], fname[20];
         char cmd[40];
         while (1)
         {
             printf("\\nMyshells : ");
             gets(cmd);

             if (strcmp(cmd, "exit") == 0)
             {
                 exit(0);
             }

             int ch = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
             if (ch == 4)
             {
                 if (strcmp(tok1, "search") == 0)
                 {
                     search(tok2, tok3, tok4);
                     continue;
                 }
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok2, tok3, NULL);
                     break;
                 case 4:
                     execlp(tok1, tok2, tok3, tok4, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 9,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according to the FIFO page replacement algorithm. Assume the memory of n frames.\nReference String : 8, 5, 7, 8, 5, 7, 2, 3, 7, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip9Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\nmyshell$ search a filename pattern :- To search all the occurrence of pattern in the file.\nmyshell$ search f filename pattern :- To display first occurrence of pattern in the file""",
                "filenames": ["slip9Q2.c"]
            }
        ],
        "answers": {
            "slip9Q1.c": """#include <stdio.h>

      int page[50];
      int n, frame[5], refLen, victim = -1, pf = 0;

      int searchPage(int p)
      {
          for (int i = 0; i < n; i++)
          {
              if (frame[i] == p)
                  return i;
          }
          return -1;
      }

      int selectVictim()
      {
          victim++;
          return victim % n;
      }

      int main()
      {
          int i, j;

          refLen = 15;
          int reference[] = {8, 5, 7, 8, 5, 7, 2, 3, 7, 3, 5, 9, 4, 6, 2};

          printf("Enter number of frames: ");
          scanf("%d", &n);

          for (i = 0; i < n; i++)
              frame[i] = -1;

          printf("\\nPage\\tFrames\\n");
          printf("-------------------\\n");

          for (i = 0; i < refLen; i++)
          {
              int k = searchPage(reference[i]);

              if (k == -1)
              {
                  pf++;
                  int victimIndex = selectVictim();
                  frame[victimIndex] = reference[i];
              }

              printf("%d\\t", reference[i]);
              for (j = 0; j < n; j++)
                  if (frame[j] != -1)
                      printf("%d ", frame[j]);
              printf("\\n");
          }

          printf("\\nTotal Page Faults = %d\\n", pf);

          return 0;
      }""",
            "slip9Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
         FILE *fp;
         char str[256];
         fp = fopen(tok4, "r");
         if (fp == NULL)
         {
             printf("File does not exist!");
         }
         else
         {
             int lineno = 0;
             int count = 0;

             if (strcmp(tok2, "f") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("First Occurance of %s is on line no : %d", tok3, lineno);
                         break;
                     }
                 }
             }

             if (strcmp(tok2, "c") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     if (strstr(str, tok3))
                     {
                         count++;
                     }
                 }
                 printf("Total number of Occurance of pattern ( %s ) is : %d", tok3, count);
             }

             if (strcmp(tok2, "a") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                     }
                 }
             }
         }
      }

      void main(int args, char *argv[])
      {
         char tok1[20], tok2[20], tok3[20], tok4[20], fname[20];
         char cmd[40];
         while (1)
         {
             printf("\\nMyshells : ");
             gets(cmd);

             if (strcmp(cmd, "exit") == 0)
             {
                 exit(0);
             }

             int ch = sscanf(cmd, "%s%s%s%s", &tok1, &tok2, &tok3, &tok4);
             if (ch == 4)
             {
                 if (strcmp(tok1, "search") == 0)
                 {
                     search(tok2, tok3, tok4);
                     continue;
                 }
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok2, tok3, NULL);
                     break;
                 case 4:
                     execlp(tok1, tok2, tok3, tok4, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 10,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the FIFO page replacement algorithm. Assume the memory of n frames.\nReference String : 2, 4, 5, 6, 9, 4, 7, 3, 4, 5, 6, 7, 2, 4, 7, 1""",
                "filenames": ["slip10Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following ‘list’ commands as\nmyshell$ list f dirname :- To print names of all the files in current directory.\nmyshell$ list i dirname :- To print the names and inodes of the files in the current directory.""",
                "filenames": ["slip10Q2.c"]
            }
        ],
        "answers": {
            "slip10Q1.c": """#include <stdio.h>

      int page[50];
      int n, frame[5], refLen, victim = -1, pf = 0;

      int searchPage(int p)
      {
          for (int i = 0; i < n; i++)
          {
              if (frame[i] == p)
                  return i;
          }
          return -1;
      }

      int selectVictim()
      {
          victim++;
          return victim % n;
      }

      int main()
      {
          int i, j;

          refLen = 15;
          int reference[] = {2, 4, 5, 6, 9, 4, 7, 3, 4, 5, 6, 7, 2, 4, 7, 1};

          printf("Enter number of frames: ");
          scanf("%d", &n);

          for (i = 0; i < n; i++)
              frame[i] = -1;

          printf("\\nPage\\tFrames\\n");
          printf("-------------------\\n");

          for (i = 0; i < refLen; i++)
          {
              int k = searchPage(reference[i]);

              if (k == -1)
              {
                  pf++;
                  int victimIndex = selectVictim();
                  frame[victimIndex] = reference[i];
              }

              printf("%d\\t", reference[i]);
              for (j = 0; j < n; j++)
                  if (frame[j] != -1)
                      printf("%d ", frame[j]);
              printf("\\n");
          }

          printf("\\nTotal Page Faults = %d\\n", pf);

          return 0;
      }""",
            "slip10Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>
      #include <dirent.h>

      void list(char *tok2, char *tok3)
      {
         DIR *dp;
         int c = 0;
         struct dirent *dir;
         dp = opendir(tok3);
         if (dp == NULL)
             printf("%s directory not exist", tok3);
         else
         {
             if (strcmp(tok2, "n") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     c++;
                 printf("No. of files in directory = %d", c);
             }
             if (strcmp(tok2, "f") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     printf("%s\\n", dir->d_name);
             }
             if (strcmp(tok2,"i") == 0)
             {
                 while((dir=readdir(dp))!=NULL)
                     printf("%s\\t\\t%d\\n",dir->d_name,dir->d_ino);
             }
         }
      }

      void main(int argc, char *argv[])
      {
         char cmd[20], tok1[20], tok2[20], tok3[20], tok4[20];
         while (1)
         {
             printf("\\nMyShell $:");
             fgets(cmd, sizeof(cmd), stdin);
             if (strcmp(cmd, "exit") == 0)
                 exit(0);
             int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);

             if (ch == 3)
             {
                 if (strcmp(tok1, "list") == 0)
                     list(tok2, tok3);
                 continue;
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok2, tok3, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 11,
        "questions": [
            {
                "question": """Write the simulation program to implement demand paging and show the page scheduling and total number of page faults according to the LFU page replacement algorithm. Assume the memory of n frames.\nReference String : 3,4,5,4,3,4,7,2,4,5,6,7,2,4,6""",
                "filenames": ["slip11Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following ‘list’ commands as\nmyshell$ list f dirname :- To print names of all the files in current directory.\nmyshell$ list n dirname :- To print the number of all entries in the current directory.""",
                "filenames": ["slip11Q2.c"]
            }
        ],
        "answers": {
            "slip11Q1.c": """#include <stdio.h>

      #define MAX_FRAMES 10
      #define MAX_REF 50

      int main() {
          int n, m, i, j, k, page, found, minFreq, lfuIndex;
          int frames[MAX_FRAMES], freq[MAX_FRAMES], refString[MAX_REF];

          // Reference string
          int refLen = 15;
          int reference[] = {3,4,5,4,3,4,7,2,4,5,6,7,2,4,6};

          printf("Enter number of frames (n): ");
          scanf("%d", &n);

          // Initialize frames and frequency
          for(i = 0; i < n; i++) {
              frames[i] = -1;
              freq[i] = 0;
          }

          int pageFaults = 0;

          printf("\\nPage\\tFrames\\n");
          printf("--------------------\\n");

          for(i = 0; i < refLen; i++) {
              page = reference[i];
              found = 0;

              // Check if page is already in frames
              for(j = 0; j < n; j++) {
                  if(frames[j] == page) {
                      freq[j]++;
                      found = 1;
                      break;
                  }
              }

              if(!found) {
                  pageFaults++;

                  // Find empty frame
                  int emptyFound = 0;
                  for(j = 0; j < n; j++) {
                      if(frames[j] == -1) {
                          frames[j] = page;
                          freq[j] = 1;
                          emptyFound = 1;
                          break;
                      }
                  }

                  // If no empty frame, replace LFU page
                  if(!emptyFound) {
                      minFreq = freq[0];
                      lfuIndex = 0;
                      for(j = 1; j < n; j++) {
                          if(freq[j] < minFreq) {
                              minFreq = freq[j];
                              lfuIndex = j;
                          }
                      }

                      frames[lfuIndex] = page;
                      freq[lfuIndex] = 1; // reset frequency for new page
                  }
              }

              // Print current frames
              printf("%d\\t", page);
              for(j = 0; j < n; j++) {
                  if(frames[j] != -1)
                      printf("%d ", frames[j]);
              }
              printf("\\n");
          }

          printf("\\nTotal Page Faults: %d\\n", pageFaults);

          return 0;
      }""",
            "slip11Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>
      #include <dirent.h>

      void list(char *tok2, char *tok3)
      {
         DIR *dp;
         int c = 0;
         struct dirent *dir;
         dp = opendir(tok3);
         if (dp == NULL)
             printf("%s directory not exist", tok3);
         else
         {
             if (strcmp(tok2, "n") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     c++;
                 printf("No. of files in directory = %d", c);
             }
             if (strcmp(tok2, "f") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     printf("%s\\n", dir->d_name);
             }
             if (strcmp(tok2,"i") == 0)
             {
                 while((dir=readdir(dp))!=NULL)
                     printf("%s\\t\\t%d\\n",dir->d_name,dir->d_ino);
             }
         }
      }

      void main(int argc, char *argv[])
      {
         char cmd[20], tok1[20], tok2[20], tok3[20], tok4[20];
         while (1)
         {
             printf("\\nMyShell $:");
             fgets(cmd, sizeof(cmd), stdin);
             if (strcmp(cmd, "exit") == 0)
                 exit(0);
             int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);

             if (ch == 3)
             {
                 if (strcmp(tok1, "list") == 0)
                     list(tok2, tok3);
                 continue;
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok2, tok3, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 12,
        "questions": [
            {
                "question": """Write the simulation program to implement demand paging and show the page scheduling and total number of page faults according to the LRU (using counter method) page replacement algorithm. Assume the memory of n frames.\nReference String : 3, 4, 5, 6, 3, 4, 7, 3, 4, 5, 6, 7, 2, 4, 6""",
                "filenames": ["slip12Q1.c"]
            },
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following ‘list’ commands as\nmyshell$ list f dirname :- To print names of all the files in current directory.\nmyshell$ list n dirname :- To print the number of all entries in the current directory.""",
                "filenames": ["slip12Q2.c"]
            }
        ],
        "answers": {
            "slip12Q1.c": """#include <stdio.h>
      int pf = 0, pg;
      int f, frame[5], ref[50], victim = 0, time[50];
      int searchpage(int p)
      {
          int i;
          for (i = 0; i < f; i++)
              if (frame[i] == p)
                  return i;
          return -1;
      }
      int selectvictim()
      {
          int min = 0, i;
          for (i = 1; i < f; i++)
          {
              if (time[i] < time[min])
                  min = i;
          }
          return min;
      }
      int main()
      {
          int i;
          printf("\\nEnter the no.of frames : ");
          scanf("%d", &f);
          for (i = 0; i < f; i++)
              frame[i] = -1;
          for (i = 0; i < f; i++)
              time[i] = -1;
          printf("\\nEnter the no. of pages : ");
          scanf("%d", &pg);
          printf("\\nEnter the page(reference string) : ");
          for (i = 0; i < pg; i++)
              scanf("%d", &ref[i]);
          for (i = 0; i < pg; i++)
          {
              int k, j;
              k = searchpage(ref[i]);
              if (k == -1)
              {
                  pf++;
                  k = selectvictim();
                  frame[k] = ref[i];
              }
              time[k] = i;
              printf("\\n pg=%d |", ref[i]);
              for (j = 0; j < f; j++)
                  printf("\\t%d", frame[j]);
          }
          printf("\\nPage Fault is = %d", pf);
      }""",

            "slip12Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>
      #include <dirent.h>
      void list(char *tok2, char *tok3)
      {
         DIR *dp;
         int c = 0;
         struct dirent *dir;
         dp = opendir(tok3);
         if (dp == NULL)
             printf("%s directory not exist", tok3);
         else
         {
             if (strcmp(tok2, "n") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     c++;
                 printf("No. of files in directory = %d", c);
             }
             if (strcmp(tok2, "f") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     printf("%s\\n", dir->d_name);
             }
             if (strcmp(tok2,"i") == 0)
             {
                 while((dir=readdir(dp))!=NULL)
                     printf("%s\\t\\t%d\\n",dir->d_name,dir->d_ino);
             }
         }
      }
      void main(int argc, char *argv[])
      {
         char cmd[20], tok1[20], tok2[20], tok3[20], tok4[20];
         while (1)
         {
             printf("\\nMyShell $:");
             fgets(cmd, sizeof(cmd), stdin);
             if (strcmp(cmd, "exit") == 0)
                 exit(0);
             int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);

             if (ch == 3)
             {
                 if (strcmp(tok1, "list") == 0)
                     list(tok2, tok3);
                 continue;
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok2, tok3, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 13,
        "questions": [
            {
                "question": """Write a C program to implement the shell which displays the command prompt “myshell$”. It accepts the command, tokenize the command line and execute it by creating the child process. Also implement the additional command \"typeline\" as\ntypeline -a filename :- To print all lines in the file.""",
                "filenames": ["slip13Q1.c"]
            },
            {
                "question": """Write the simulation program for Round Robin scheduling for given time quantum. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give the Gantt chart, turnaround time and waiting time for each process. Also display the average turnaround time and average waiting time.""",
                "filenames": ["slip13Q2.c"]
            }
        ],
        "answers": {
            "slip13Q1.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void typeline(char *tok2, char *tok3)
      {
          FILE *fp;
          int lc = 0;
          int count = 0;
          char str[256];
          fp = fopen(tok3, "r");
          if (fp == NULL)
          {
              printf("File does not exist!");
          }
          else
          {
              if (strcmp(tok2, "-a") == 0)
              {
                  while (!feof(fp))
                  {
                      char ch = fgetc(fp);
                      printf("%c", ch);
                  }
              }
              else
              {
                  int n = atoi(tok2);
                  if (n > 0)
                  {
                      while (lc < n)
                      {
                          char ch = fgetc(fp);
                          if (ch == '\\n')
                              lc++;
                          printf("%c", ch);
                      }
                  }
                  if (n < 0)
                  {
                      while (!feof(fp))
                      {
                          char ch = fgetc(fp);
                          if (ch == '\\n')
                              lc++;
                      }
                      int skip = lc + n;
                      fseek(fp, 0, SEEK_SET);
                      while (fgets(str, sizeof(str), fp) != NULL)
                      {
                          count++;
                          if (count >= skip)
                              printf("%s", str);
                      }
                  }
              }
          }
      }

      void main(int args, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20], fname[20];
          char cmd[40];
          while (1)
          {
              printf("\\nMyshells : ");
              gets(cmd);

              if (strcmp(cmd, "exit") == 0)
                  exit(0);

              int ch = sscanf(cmd, "%s%s%s", &tok1, &tok2, &tok3);
              if (ch == 3)
              {
                  if (strcmp(tok1, "typeline") == 0)
                  {
                      typeline(tok2, tok3);
                      continue;
                  }
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  }
                  exit(0);
              }
          }
      }""",

            "slip13Q2.c": """#include <stdio.h>
      #include <stdlib.h>

      int main()
      {
          int i, limit, total = 0, x, counter = 0, time_quantum;
          int wait_time = 0, turnaround_time = 0, arrival_time[10], burst_time[10], temp[10];
          float average_wait_time, average_turnaround_time;

          printf("\\nEnter Total Number of Processes:\\t");
          scanf("%d", &limit);
          x = limit;

          for (i = 0; i < limit; i++)
          {
              printf("\\nEnter Details of Process[%d]\\n", i + 1);
              printf("Arrival Time:\\t");
              scanf("%d", &arrival_time[i]);
              printf("Burst Time:\\t");
              scanf("%d", &burst_time[i]);
              temp[i] = burst_time[i];
          }

          printf("\\nEnter Time Quantum:\\t");
          scanf("%d", &time_quantum);

          printf("\\nProcess ID\\t\\tBurst Time\\t Turnaround Time\\t Waiting Time\\n");

          for (total = 0, i = 0; x != 0;)
          {
              if (temp[i] <= time_quantum && temp[i] > 0)
              {
                  total = total + temp[i];
                  temp[i] = 0;
                  counter = 1;
              }
              else if (temp[i] > 0)
              {
                  temp[i] = temp[i] - time_quantum;
                  total = total + time_quantum;
              }

              if (temp[i] == 0 && counter == 1)
              {
                  x--;
                  printf("\\nProcess[%d]\\t\\t%d\\t\\t %d\\t\\t\\t %d", i + 1, burst_time[i], total - arrival_time[i], total - arrival_time[i] - burst_time[i]);
                  wait_time += total - arrival_time[i] - burst_time[i];
                  turnaround_time += total - arrival_time[i];
                  counter = 0;
              }

              if (i == limit - 1)
                  i = 0;
              else if (arrival_time[i + 1] <= total)
                  i++;
              else
                  i = 0;
          }

          average_wait_time = wait_time * 1.0 / limit;
          average_turnaround_time = turnaround_time * 1.0 / limit;

          printf("\\n\\nAverage Waiting Time:\\t%f", average_wait_time);
          printf("\\nAvg Turnaround Time:\\t%f\\n", average_turnaround_time);

          return 0;
      }"""
        }
    },
    {
        "slipNo": 14,
        "questions": [
            {
                "question": """Write a C program to implement the shell which displays the command prompt “myshell$”. It accepts the command, tokenize the command line and execute it by creating the child process. Also implement the additional command \"typeline\" as\ntypeline +n filename :- To print first n lines in the file""",
                "filenames": ["slip14Q1.c"]
            },
            {
                "question": """Write a C program to simulate Non-preemptive Shortest Job First (SJF) – scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time""",
                "filenames": ["slip14Q2.c"]
            }
        ],
        "answers": {
            "slip14Q1.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void typeline(char *tok2, char *tok3)
      {
          FILE *fp;
          int lc = 0;
          char str[256];
          fp = fopen(tok3, "r");
          if (fp == NULL)
          {
              printf("File does not exist!");
          }
          else
          {
              int n = atoi(tok2); // number of lines to print
              while (lc < n && fgets(str, sizeof(str), fp) != NULL)
              {
                  printf("%s", str);
                  lc++;
              }
          }
      }

      void main(int args, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20];
          char cmd[40];
          while (1)
          {
              printf("\\nMyshells : ");
              gets(cmd);

              if (strcmp(cmd, "exit") == 0)
                  exit(0);

              int ch = sscanf(cmd, "%s%s%s", &tok1, &tok2, &tok3);
              if (ch == 3)
              {
                  if (strcmp(tok1, "typeline") == 0)
                  {
                      typeline(tok2, tok3);
                      continue;
                  }
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  }
                  exit(0);
              }
          }
      }
      // Example usage: Myshells : typeline 2 data.txt",

            "slip14Q2.c": "#include <stdio.h>
      #include <stdlib.h>

      struct job
      {
          int atime; // arrival time
          int btime; // burst time
          int ft;    // finish time
          int tat;   // turnaround time
          int wt;    // waiting time
      } p[10];

      int arr[10], burst[10], n, rq[10], no_rq = 0, time = 0;

      int addrq();
      int selectionjob();
      int deleteq(int j);
      int fsahll();

      void main()
      {
          int i, j;
          printf("Enter the job number:");
          scanf("%d", &n);

          for (i = 0; i < n; i++)
          {
              printf("Enter the arrival time p%d:", i);
              scanf("%d", &p[i].atime);
              arr[i] = p[i].atime;
          }

          for (i = 0; i < n; i++)
          {
              printf("Enter the burst time p%d:", i);
              scanf("%d", &p[i].btime);
              burst[i] = p[i].btime;
          }

          addrq(); // add processes to ready queue

          printf("Gantt Chart is:");
          while (1)
          {
              j = selectionjob(); // select next process
              if (j == -1)
              {
                  printf("CPU is idle");
                  time++;
                  addrq();
              }
              else
              {
                  while (burst[j] != 0)
                  {
                      printf("\\t j %d", j);
                      burst[j]--;
                      time++;
                      addrq();
                  }
                  p[j].ft = time;
              }
              if (fsahll() == 1)
                  break;
          }

          int Tat = 0, Twt = 0;
          printf("\\n\\nJob \\t FT \\t TAT \\t WT");
          for (i = 0; i < n; i++)
          {
              p[i].tat = p[i].ft - p[i].atime;
              p[i].wt = p[i].tat - p[i].btime;
              printf("\\nJob %d \\t %d \\t %d \\t %d", i, p[i].ft, p[i].tat, p[i].wt);
              Tat += p[i].tat;
              Twt += p[i].wt;
          }

          float avgtat = (float)Tat / n;
          float avgwt = (float)Twt / n;
          printf("\\nAverage Turnaround Time: %f", avgtat);
          printf("\\nAverage Waiting Time: %f\\n", avgwt);
      }

      int addrq()
      {
          for (int i = 0; i < n; i++)
          {
              if (arr[i] == time)
              {
                  rq[no_rq++] = i;
              }
          }
      }

      int selectionjob()
      {
          if (no_rq == 0) return -1;
          int j = rq[0];
          for (int i = 1; i < no_rq; i++)
              if (burst[j] > burst[rq[i]]) j = rq[i];
          deleteq(j);
          return j;
      }

      int deleteq(int j)
      {
          int i;
          for (i = 0; i < no_rq; i++)
              if (rq[i] == j) break;
          for (int k = i + 1; k < no_rq; k++)
              rq[k - 1] = rq[k];
          no_rq--;
      }

      int fsahll()
      {
          for (int i = 0; i < n; i++)
              if (burst[i] != 0) return -1;
          return 1;
      }"""
        }
    },
    {
        "slipNo": 15,
        "questions": [
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following ‘list’ commands as\nmyshell$ list f dirname :- To print names of all the files in current directory.""",
                "filenames": ["slip15Q1.c"]
            },
            {
                "question": """Write the program to simulate preemptive Shortest Job First (SJF) – scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time""",
                "filenames": ["slip15Q2.c"]
            }
        ],
        "answers": {
            "slip15Q1.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>
      #include <dirent.h>

      void list(char *tok2, char *tok3)
      {
         DIR *dp;
         struct dirent *dir;
         dp = opendir(tok3);
         if (dp == NULL)
             printf("%s directory not exist", tok3);
         else
         {
             if (strcmp(tok2, "f") == 0)
             {
                 while ((dir = readdir(dp)) != NULL)
                     printf("%s\\n", dir->d_name);
             }
         }
      }

      void main(int argc, char *argv[])
      {
         char cmd[100], tok1[20], tok2[20], tok3[20];
         while (1)
         {
             printf("\\nMyShell $:");
             fgets(cmd, sizeof(cmd), stdin);

             if (strncmp(cmd, "exit", 4) == 0)
                 exit(0);

             int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);
             if (ch == 3 && strcmp(tok1, "list") == 0)
             {
                 list(tok2, tok3);
                 continue;
             }

             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok1, tok2, tok3, NULL);
                     break;
                 }
                 exit(0);
             }
         }
      }""",

            "slip15Q2.c": """#include <stdio.h>
      #include <stdbool.h>

      typedef struct process
      {
          bool isc;
          int bt, at, st, wt, ft, tat, nst, oft, pcount;
      } PP;

      PP P[100];
      int tm = 0, n, arr[100], arrv = 0, count = 0;
      float atat = 0, awt = 0;

      void minb(int a[], int k);
      void finda();
      int proc(int s);

      void main()
      {
          int i, a[100], k = 0;
          printf("How many process : ");
          scanf("%d", &n);
          printf("Enter:-\\nprocess BTime ATime \\n");
          for (i = 1; i <= n; i++)
          {
              printf("P%d\\t", i);
              scanf("%d%d", &P[i].bt, &P[i].at);
              P[i].isc = false;
              P[i].pcount = 0;
              count += P[i].bt;
              P[i].wt = 0;
          }

          printf("\\nDetails about processes as follows\\n\\n");
          printf("Process\\tBTime\\tATime \\n");
          for (i = 1; i <= n; i++)
              printf("P%d\\t%d\\t%d\\n", i, P[i].bt, P[i].at);

          printf("\\nGantt chart\\n");
          for (i = 1; i <= n; i++)
              if (P[i].at == 0) a[++k] = i;

          minb(a, k);

          while (tm != count)
          {
              finda();
              if (arrv == 0)
              {
                  printf("|idl");
                  tm++;
                  count++;
              }
              else
              {
                  minb(arr, arrv);
                  arrv = 0;
              }
          }

          printf("|\\n\\nDetails about processes as follows\\n");
          printf("Process\\tBT\\tAT \\tST\\tWT\\tFT\\tTAT\\n");
          for (i = 1; i <= n; i++)
              printf("P%d\\t%d\\t%d\\t%d\\t%d\\t%d\\t%d\\n", i, P[i].bt, P[i].at, P[i].st, P[i].wt, P[i].ft, P[i].tat);

          printf("\\nAvg wait time=%f\\nAvg TAT=%f\\n", awt / n, atat / n);
      }

      void finda()
      {
          for (int l = 1; l <= n; l++)
          {
              if (P[l].at <= tm && P[l].isc == false)
                  arr[++arrv] = l;
          }
      }

      void minb(int a[], int k)
      {
          int min = P[a[1]].bt, i, m = a[1];
          for (i = 1; i <= k; i++)
          {
              if (P[a[i]].bt < min)
              {
                  min = P[a[i]].bt;
                  m = a[i];
              }
          }
          proc(m);
      }

      int proc(int s)
      {
          P[s].pcount++;
          if (P[s].pcount == 1)
          {
              P[s].st = tm;
              P[s].wt = P[s].st - P[s].at;
          }
          P[s].nst = tm;
          tm++;
          int k = P[s].nst - P[s].oft;
          P[s].oft = tm;
          if (k > 0) P[s].wt += k;
          if (P[s].pcount == P[s].bt)
          {
              P[s].isc = true;
              P[s].ft = tm;
              P[s].tat = P[s].ft - P[s].at;
              atat += P[s].tat;
              awt += P[s].wt;
          }
          printf("| P%d", s);
          return 0;
      }"""
        }
    },
    {
        "slipNo": 16,
        "questions": [
            {
                "question": """Write a program to implement the toy shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following commands.\ncount c filename :- To print number of characters in the file.\ncount w filename :- To print number of words in the file.""",
                "filenames": ["slip16Q1.c"]
            },
            {
                "question": """Write the program to simulate Non preemptive priority scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time.""",
                "filenames": ["slip16Q2.c"]
            }
        ],
        "answers": {
            "slip16Q1.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>

      void count(char *tok2, char *tok3)
      {
          int w = 0, c = 0, l = 0;
          FILE *fp = fopen(tok3, "r");
          if (fp == NULL)
          {
              printf("File does not exist");
              return;
          }
          char ch;
          while ((ch = fgetc(fp)) != EOF)
          {
              if (ch == ' ' || ch == '\\t')
                  w++;
              else if (ch == '\\n')
              {
                  w++;
                  l++;
              }
              else
                  c++;
          }
          if (strcmp(tok2, "w") == 0)
              printf("Word count = %d\\n", w);
          else if (strcmp(tok2, "c") == 0)
              printf("Character count = %d\\n", c);
          else if (strcmp(tok2, "l") == 0)
              printf("Line count = %d\\n", l);
          fclose(fp);
      }

      void main(int argc, char *argv[])
      {
          char cmd[100], tok1[20], tok2[20], tok3[20];
          while (1)
          {
              printf("\\nMyshell$:");
              fgets(cmd, sizeof(cmd), stdin);

              if (strncmp(cmd, "exit", 4) == 0)
                  exit(0);

              int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);
              if (ch == 3 && strcmp(tok1, "count") == 0)
              {
                  count(tok2, tok3);
                  continue;
              }

              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok1, tok2, tok3, NULL);
                      break;
                  }
                  exit(0);
              }
          }
      }""",

            "slip16Q2.c": """#include <stdio.h>
      #include <stdlib.h>

      struct job
      {
          int atime;
          int btime;
          int ft;
          int tat;
          int wt;
          int pri;
      } p[10];

      int arr[10], brust[10], n, rq[10], no_rq = 0, time = 0, j = -1;

      int addrq();
      int selectionjob();
      int deleteq(int k);
      int fsahll();

      void main()
      {
          int i;
          printf("Enter the number of jobs: ");
          scanf("%d", &n);

          for (i = 0; i < n; i++)
          {
              printf("Enter arrival time p%d: ", i);
              scanf("%d", &p[i].atime);
              arr[i] = p[i].atime;
          }

          for (i = 0; i < n; i++)
          {
              printf("Enter burst time p%d: ", i);
              scanf("%d", &p[i].btime);
              brust[i] = p[i].btime;
          }

          for (i = 0; i < n; i++)
          {
              printf("Enter priority p%d: ", i);
              scanf("%d", &p[i].pri);
          }

          addrq();

          while (1)
          {
              j = selectionjob();
              if (j == -1)
              {
                  printf("CPU is idle\\n");
                  time++;
                  addrq();
              }
              else
              {
                  while (brust[j] != 0)
                  {
                      printf("\\t j %d", j);
                      brust[j]--;
                      time++;
                      addrq();
                  }
                  p[j].ft = time;
              }
              if (fsahll() == 1)
                  break;
          }

          int Tat = 0, Twt = 0;
          printf("\\nJob \\t FT \\t TAT \\t WT\\n");
          for (i = 0; i < n; i++)
          {
              p[i].tat = p[i].ft - p[i].atime;
              p[i].wt = p[i].tat - p[i].btime;
              printf("Job %d \\t %d \\t %d \\t %d\\n", i, p[i].ft, p[i].tat, p[i].wt);
              Tat += p[i].tat;
              Twt += p[i].wt;
          }
          printf("Average Turnaround Time: %f\\n", (float)Tat / n);
          printf("Average Waiting Time: %f\\n", (float)Twt / n);
      }

      int addrq()
      {
          for (int i = 0; i < n; i++)
          {
              if (arr[i] == time)
              {
                  rq[no_rq++] = i;
              }
          }
      }

      int selectionjob()
      {
          if (no_rq == 0)
              return -1;
          int k = rq[0];
          for (int i = 1; i < no_rq; i++)
              if (p[k].pri < p[rq[i]].pri)
                  k = rq[i];
          deleteq(k);
          return k;
      }

      int deleteq(int k)
      {
          int i;
          for (i = 0; i < no_rq; i++)
              if (rq[i] == k)
                  break;
          for (i = i + 1; i < no_rq; i++)
              rq[i - 1] = rq[i];
          no_rq--;
      }

      int fsahll()
      {
          for (int i = 0; i < n; i++)
              if (brust[i] != 0)
                  return -1;
          return 1;
      }"""
        }
    },
    {
        "slipNo": 17,
        "questions": [
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the optimal page replacement algorithm. Assume the memory of n frames.\nReference String : 7, 5, 4, 8, 5, 7, 2, 3, 1, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip17Q1.c"]
            },
            {
                "question": """Write the program to simulate FCFS CPU-scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time.""",
                "filenames": ["slip17Q2.c"]
            }
        ],
        "answers": {
            "slip17Q1.c": """#include <stdio.h>
int main()
{
    int frames, n;
    printf("Enter the number of frames: ");
    scanf("%d", &frames);

    printf("Enter the number of pages in the reference string: ");
    scanf("%d", &n);

    int pages[n], frame[frames], pageFaults = 0;

    for (int i = 0; i < frames; i++)
        frame[i] = -1;

    printf("Enter the reference string: ");
    for (int i = 0; i < n; i++)
        scanf("%d", &pages[i]);

    for (int i = 0; i < n; i++)
    {
        int page = pages[i], pageFound = 0;

        for (int j = 0; j < frames; j++)
        {
            if (frame[j] == page)
            {
                pageFound = 1;
                break;
            }
        }

        if (!pageFound)
        {
            int replaceIndex = -1;

            for (int j = 0; j < frames; j++)
            {
                int nextPage = -1;
                for (int k = i + 1; k < n; k++)
                {
                    if (pages[k] == frame[j])
                    {
                        nextPage = k;
                        break;
                    }
                }

                if (nextPage == -1)
                {
                    replaceIndex = j;
                    break;
                }

                if (replaceIndex == -1 || nextPage > i + 1)
                    replaceIndex = j;
            }

            frame[replaceIndex] = page;
            pageFaults++;
        }

        printf("Page %d -> [", page);
        for (int j = 0; j < frames; j++)
            printf("%d ", frame[j]);
        printf("] Page Faults: %d\\n", pageFaults);
    }

    printf("Total Page Faults: %d\\n", pageFaults);
    return 0;
      }""",

            "slip17Q2.c": """#include <stdio.h>
#include <stdlib.h>

struct job
{
    int atime;
    int btime;
    int ft;
    int tat;
    int wt;
} p[10];

int arr[10], burst[10], rq[10], no_rq = 0, time = 0, n;

void addrq();
int selectjob();
void delq(int j);
int finishall();

void main()
{
    int i;
    printf("Enter number of jobs : ");
    scanf("%d", &n);

    for (i = 0; i < n; i++)
    {
        printf("Enter arrival time of p%d : ", i);
        scanf("%d", &p[i].atime);
        arr[i] = p[i].atime;
    }

    for (i = 0; i < n; i++)
    {
        printf("Enter burst time of p%d : ", i);
        scanf("%d", &p[i].btime);
        burst[i] = p[i].btime;
    }

    addrq();

    while (1)
    {
        int j = selectjob();
        if (j == -1)
        {
            printf("CPU is Idle\\n");
            time++;
            addrq();
        }
        else
        {
            while (burst[j] != 0)
            {
                printf("\\tj%d", j);
                burst[j]--;
                time++;
                addrq();
            }
            p[j].ft = time;
        }
        if (finishall() == 1)
            break;
    }

    int Ttat = 0, Twt = 0;
    printf("\\n\\n Job\\t Finish time\\t TAT\\t WT\\n");
    for (i = 0; i < n; i++)
    {
        p[i].tat = p[i].ft - p[i].atime;
        p[i].wt = p[i].tat - p[i].btime;
        printf("job%d \\t %d\\t \\t%d\\t %d\\n", i, p[i].ft, p[i].tat, p[i].wt);
        Ttat += p[i].tat;
        Twt += p[i].wt;
    }

    printf("\\nAverage Turn Around Time = %f", (float)Ttat / n);
    printf("\\nAverage Waiting Time = %f", (float)Twt / n);
}

void addrq()
{
    for (int i = 0; i < n; i++)
        if (arr[i] == time)
            rq[no_rq++] = i;
}

int selectjob()
{
    if (no_rq == 0)
        return -1;
    int j = rq[0];
    delq(j);
    return j;
}

void delq(int j)
{
    int i;
    for (i = 0; i < no_rq; i++)
        if (rq[i] == j)
            break;
    for (i = i + 1; i < no_rq; i++)
        rq[i - 1] = rq[i];
    no_rq--;
}

int finishall()
{
    for (int i = 0; i < n; i++)
        if (burst[i] != 0)
            return -1;
    return 1;
      }"""
        }
    },
    {
        "slipNo": 18,
        "questions": [
            {
                "question": """Write the simulation program to implement demand paging and show the page scheduling and total number of page faults according to the LRU (using counter method) page replacement algorithm. Assume the memory of n frames.\nReference String : 3, 4, 5, 6, 3, 4, 7, 3, 4, 5, 6, 7, 2, 4, 6""",
                "filenames": ["slip18Q1.c"]
            },
            {
                "question": """Write the program to simulate FCFS CPU-scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time.""",
                "filenames": ["slip18Q2.c"]
            }
        ],
        "answers": {
            "slip18Q1.c": """#include <stdio.h>
      int pf = 0, pg;
      int f, frame[5], ref[50], victim = 0, time[50];

      int searchpage(int p)
      {
          for (int i = 0; i < f; i++)
              if (frame[i] == p)
                  return i;
          return -1;
      }

      int selectvictim()
      {
          int min = 0;
          for (int i = 1; i < f; i++)
              if (time[i] < time[min])
                  min = i;
          return min;
      }

      int main()
      {
          printf("\\nEnter the no.of frames : ");
          scanf("%d", &f);

          for (int i = 0; i < f; i++)
          {
              frame[i] = -1;
              time[i] = -1;
          }

          printf("\\nEnter the no. of pages : ");
          scanf("%d", &pg);

          printf("\\nEnter the page(reference string) : ");
          for (int i = 0; i < pg; i++)
              scanf("%d", &ref[i]);

          for (int i = 0; i < pg; i++)
          {
              int k = searchpage(ref[i]);
              if (k == -1)
              {
                  pf++;
                  k = selectvictim();
                  frame[k] = ref[i];
              }
              time[k] = i;

              printf("\\n pg=%d |", ref[i]);
              for (int j = 0; j < f; j++)
                  printf("\\t%d", frame[j]);
          }

          printf("\\nPage Fault is = %d", pf);
          return 0;
      }""",

            "slip18Q2.c": """#include <stdio.h>
      #include <stdlib.h>

      struct job
      {
          int atime;
          int btime;
          int ft;
          int tat;
          int wt;
      } p[10];

      int arr[10], burst[10], rq[10], no_rq = 0, time = 0, n;

      void addrq();
      int selectjob();
      void delq(int j);
      int finishall();

      void main()
      {
          printf("Enter number of jobs : ");
          scanf("%d", &n);

          for (int i = 0; i < n; i++)
          {
              printf("Enter arrival time of p%d : ", i);
              scanf("%d", &p[i].atime);
              arr[i] = p[i].atime;
          }

          for (int i = 0; i < n; i++)
          {
              printf("Enter burst time of p%d : ", i);
              scanf("%d", &p[i].btime);
              burst[i] = p[i].btime;
          }

          addrq();

          while (1)
          {
              int j = selectjob();
              if (j == -1)
              {
                  printf("CPU is Idle\\n");
                  time++;
                  addrq();
              }
              else
              {
                  while (burst[j] != 0)
                  {
                      printf("\\tj%d", j);
                      burst[j]--;
                      time++;
                      addrq();
                  }
                  p[j].ft = time;
              }
              if (finishall() == 1)
                  break;
          }

          int Ttat = 0, Twt = 0;
          printf("\\n\\n Job\\t Finish time\\t TAT\\t WT\\n");
          for (int i = 0; i < n; i++)
          {
              p[i].tat = p[i].ft - p[i].atime;
              p[i].wt = p[i].tat - p[i].btime;
              printf("job%d \\t %d\\t \\t%d\\t %d\\n", i, p[i].ft, p[i].tat, p[i].wt);
              Ttat += p[i].tat;
              Twt += p[i].wt;
          }

          printf("\\nAverage Turn Around Time = %f", (float)Ttat / n);
          printf("\\nAverage Waiting Time = %f", (float)Twt / n);
      }

      void addrq()
      {
          for (int i = 0; i < n; i++)
              if (arr[i] == time)
                  rq[no_rq++] = i;
      }

      int selectjob()
      {
          if (no_rq == 0)
              return -1;
          int j = rq[0];
          delq(j);
          return j;
      }

      void delq(int j)
      {
          int i;
          for (i = 0; i < no_rq; i++)
              if (rq[i] == j)
                  break;
          for (i = i + 1; i < no_rq; i++)
              rq[i - 1] = rq[i];
          no_rq--;
      }

      int finishall()
      {
          for (int i = 0; i < n; i++)
              if (burst[i] != 0)
                  return -1;
          return 1;
      }"""
        }
    },
    {
        "slipNo": 19,
        "questions": [
            {
                "question": """Write a program to implement the shell. It should display the command prompt “myshell$”. Tokenize the command line and execute the given command by creating the child process. Additionally it should interpret the following ‘list’ commands as\nmyshell$ list f dirname :- To print names of all the files in current directory.""",
                "filenames": ["slip19Q1.c"]
            },
            {
                "question": """Write the simulation program for Round Robin scheduling for given time quantum. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give the Gantt chart, turnaround time and waiting time for each process. Also display the average turnaround time and average waiting time.""",
                "filenames": ["slip19Q2.c"]
            }
        ],
        "answers": {
            "slip19Q1.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>
      #include <dirent.h>

      void list(char *tok2, char *tok3)
      {
          DIR *dp;
          int c = 0;
          struct dirent *dir;
          dp = opendir(tok3);
          if (dp == NULL)
              printf("%s directory not exist", tok3);
          else
          {
              if (strcmp(tok2, "n") == 0)
              {
                  while ((dir = readdir(dp)) != NULL)
                      c++;
                  printf("No. of files in directory = %d", c);
              }
              if (strcmp(tok2, "f") == 0)
              {
                  while ((dir = readdir(dp)) != NULL)
                      printf("%s\\n", dir->d_name);
              }
              if (strcmp(tok2,"i") == 0)
              {
                  while((dir=readdir(dp))!=NULL)
                      printf("%s\\t\\t%d\\n",dir->d_name,dir->d_ino);
              }
          }
      }

      void main(int argc, char *argv[])
      {
          char cmd[20], tok1[20], tok2[20], tok3[20], tok4[20];
          while (1)
          {
              printf("\\nMyShell $:");
              fgets(cmd, sizeof(cmd), stdin);
              if (strcmp(cmd, "exit") == 0)
                  exit(0);
              int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);

              if (ch == 3)
              {
                  if (strcmp(tok1, "list") == 0)
                      list(tok2, tok3);
                  continue;
              }
              if (fork() == 0)
              {
                  switch (ch)
                  {
                  case 1:
                      execlp(tok1, NULL);
                      break;
                  case 2:
                      execlp(tok1, tok2, NULL);
                      break;
                  case 3:
                      execlp(tok1, tok2, tok3, NULL);
                      break;
                  }
              }
          }
      }""",
            "slip19Q2.c": """#include <stdio.h>
      #include <stdlib.h>

      int main()
      {
          int i, limit, total = 0, x, counter = 0, time_quantum;
          int wait_time = 0, turnaround_time = 0, arrival_time[10], burst_time[10], temp[10];
          float average_wait_time, average_turnaround_time;

          printf("\\nEnter Total Number of Processes:\\t");
          scanf("%d", &limit);
          x = limit;

          for (i = 0; i < limit; i++)
          {
              printf("\\nEnter Details of Process[%d]\\n", i + 1);
              printf("Arrival Time:\\t");
              scanf("%d", &arrival_time[i]);
              printf("Burst Time:\\t");
              scanf("%d", &burst_time[i]);
              temp[i] = burst_time[i];
          }

          printf("\\nEnter Time Quantum:\\t");
          scanf("%d", &time_quantum);
          printf("\\nProcess ID\\t\\tBurst Time\\t Turnaround Time\\t Waiting Time\\n");

          for (total = 0, i = 0; x != 0;)
          {
              if (temp[i] <= time_quantum && temp[i] > 0)
              {
                  total += temp[i];
                  temp[i] = 0;
                  counter = 1;
              }
              else if (temp[i] > 0)
              {
                  temp[i] -= time_quantum;
                  total += time_quantum;
              }
              if (temp[i] == 0 && counter == 1)
              {
                  x--;
                  printf("\\nProcess[%d]\\t\\t%d\\t\\t %d\\t\\t\\t %d", i + 1, burst_time[i], total - arrival_time[i], total - arrival_time[i] - burst_time[i]);
                  wait_time += total - arrival_time[i] - burst_time[i];
                  turnaround_time += total - arrival_time[i];
                  counter = 0;
              }
              if (i == limit - 1) i = 0;
              else if (arrival_time[i + 1] <= total) i++;
              else i = 0;
          }

          average_wait_time = wait_time * 1.0 / limit;
          average_turnaround_time = turnaround_time * 1.0 / limit;
          printf("\\n\\nAverage Waiting Time:\\t%f", average_wait_time);
          printf("\\nAvg Turnaround Time:\\t%f\\n", average_turnaround_time);

          return 0;
      }"""
        }
    },
    {
        "slipNo": 20,
        "questions": [
            {
                "question": """Write a C program to implement the shell which displays the command prompt “myshell$”. It accepts the command, tokenize the command line and execute it by creating the child process. Also implement the additional command \"typeline\" as\ntypeline -a filename :- To print all lines in the file""",
                "filenames": ["slip20Q1.c"]
            },
            {
                "question": """Write a C program to simulate Non-preemptive Shortest Job First (SJF) – scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time""",
                "filenames": ["slip20Q2.c"]
            }
        ],
        "answers": {
            "slip20Q1.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void typeline(char *tok2, char *tok3)
      {
          FILE *fp;
          int lc = 0;
          int count = 0;
          char str[256];
          fp = fopen(tok3, "r");
          if (fp == NULL)
          {
              printf("File does not exist!");
          }
          else
          {
              if (strcmp(tok2, "a") == 0)
              {
                  while (!feof(fp))
                  {
                      char ch = fgetc(fp);
                      printf("%c", ch);
                  }
              }
              else
              {
                  int n = atoi(tok2);
                  if (n > 0)
                  {
                      while (lc < n)
                      {
                          char ch = fgetc(fp);
                          if (ch == '\\n')
                              lc++;
                          printf("%c", ch);
                      }
                  }
                  if (n < 0)
                  {
                      while (!feof(fp))
                      {
                          char ch = fgetc(fp);
                          if (ch == '\\n')
                              lc++;
                      }
                      int skip = lc + n;
                      fseek(fp, 0, SEEK_SET);
                      while (fgets(str, sizeof(str), fp) != NULL)
                      {
                          count++;
                          if (count >= skip)
                              printf("%s", str);
                      }
                  }
              }
          }
      }

      void main(int args, char *argv[])
      {
          char tok1[20], tok2[20], tok3[20];
          char cmd[40];
          while (1)
          {
              printf("\\nMyshells : ");
              gets(cmd);

              if (strcmp(cmd, "exit") == 0)
                  exit(0);

              int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);
              if (ch == 3)
              {
                  if (strcmp(tok1, "typeline") == 0)
                  {
                      typeline(tok2, tok3);
                      continue;
                  }
              }
          }
      }""",
            "slip20Q2.c": """#include <stdio.h>
      #include <stdlib.h>

      struct job
      {
          int atime;
          int btime;
          int ft;
          int tat;
          int wt;
      } p[10];

      int arr[10], burst[10], n, rq[10], no_rq = 0, time = 0;

      int addrq();
      int selectionjob();
      int deleteq(int j);
      int fsahll();

      void main()
      {
          int i, j;
          printf("Enter the job number:");
          scanf("%d", &n);

          for (i = 0; i < n; i++)
          {
              printf("Enter the arrival time p%d:", i);
              scanf("%d", &p[i].atime);
              arr[i] = p[i].atime;
          }

          for (i = 0; i < n; i++)
          {
              printf("Enter the burst time p%d:", i);
              scanf("%d", &p[i].btime);
              burst[i] = p[i].btime;
          }

          addrq();
          printf("Gantt Chart is:");

          while (1)
          {
              j = selectionjob();
              if (j == -1)
              {
                  printf("CPU is ideal");
                  time++;
                  addrq();
              }
              else
              {
                  while (burst[j] != 0)
                  {
                      printf("\\t j %d", j);
                      burst[j]--;
                      time++;
                      addrq();
                  }
                  p[j].ft = time;
              }
              if (fsahll() == 1)
                  break;
          }

          int Tat = 0, Twt = 0;
          printf("\\n\\nJob \\t FT \\t TAT \\t WT");
          for (i = 0; i < n; i++)
          {
              p[i].tat = p[i].ft - p[i].atime;
              p[i].wt = p[i].tat - p[i].btime;
              printf("\\nJob %d \\t %d \\t %d \\t %d", i, p[i].ft, p[i].tat, p[i].wt);
              Tat += p[i].tat;
              Twt += p[i].wt;
          }

          float avgtat = (float)Tat / n;
          float avgwt = (float)Twt / n;
          printf("\\nAverage turnaround time: %f", avgtat);
          printf("\\nAverage waiting time: %f\\n", avgwt);
      }

      int addrq()
      {
          int i;
          for (i = 0; i < n; i++)
          {
              if (arr[i] == time)
              {
                  rq[no_rq] = i;
                  no_rq++;
              }
          }
      }

      int selectionjob()
      {
          int i, j;
          if (no_rq == 0)
              return -1;
          j = rq[0];
          for (i = 1; i < no_rq; i++)
              if (burst[j] > burst[rq[i]])
                  j = rq[i];
          deleteq(j);
          return j;
      }

      int deleteq(int j)
      {
          int i;
          for (i = 0; i < no_rq; i++)
              if (rq[i] == j)
                  break;
          for (i = i + 1; i < no_rq; i++)
              rq[i - 1] = rq[i];
          no_rq--;
      }

      int fsahll()
      {
          int i;
          for (i = 0; i < n; i++)
              if (burst[i] != 0)
                  return -1;
          return 1;
      }"""
        }
    },
    {
        "slipNo": 21,
        "questions": [
            {
                "question": """Write a C Program to create a child process using fork (), display parent and child process id. Child process will display the message “I am Child Process” and the parent process should display “I am Parent Process”.""",
                "filenames": ["slip21Q1.c"]
            },
            {
                "question": """Write a C program to simulate Preemptive Priority scheduling. The arrival time and first CPU-burst and priority for different n number of processes should be input to the algorithm. Assume the fixed IO waiting time (2 units). The next CPU-burst should be generated randomly. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time.""",
                "filenames": ["slip21Q2.c"]
            }
        ],
        "answers": {
            "slip21Q1.c": """#include <stdio.h>
      #include <unistd.h>
      #include <sys/types.h>

      int main()
      {
          int pid, ppid;
          pid = getpid();
          printf("pid before fork %d\\n", pid);
          pid = fork();
          if (pid < 0)
          {
              printf("fork failed");
              return 1;
          }
          if (pid == 0)
          {
              pid = getpid();
              ppid = getppid();
              printf("I am child\\n");
              printf("newly created process pid %d parent id %d\\n", pid, ppid);
              sleep(5);
          }
          else
          {
              pid = getpid();
              ppid = getppid();
              printf("I am parent\\n");
              printf("process pid %d parent id %d\\n", pid, ppid);
          }
      }""",
            "slip21Q2.c": """#include <stdio.h>
      #include <stdbool.h>
      #include <stdlib.h>

      void minbrust(int a[], int k);
      void process(int s);
      void selecta();

      struct job
      {
          bool isc;
          int at;
          int bt;
          int st;
          int nst;
          int oft;
          int pcount;
          int ft;
          int tat;
          int wt;
          int pri;
      } p[100];

      int n, arr[100], tm = 0, arrv = 0, count = 0, j = -1;
      float Tat, Wt;

      void main()
      {
          int i, k = 0, a[100];

          printf("How many Process: ");
          scanf("%d", &n);

          printf("Enter :-\\nProcess BT AT Priority\\n");
          for (i = 1; i <= n; i++)
          {
              printf("p%d\\t", i);
              scanf("%d%d%d", &p[i].bt, &p[i].at, &p[i].pri);
              p[i].isc = false;
              p[i].pcount = 0;
              count += p[i].bt;
              p[i].wt = 0;
          }

          printf("Process BT AT Priority\\n");
          for (i = 1; i <= n; i++)
              printf("p%d \\t%d \\t%d \\t%d\\n", i, p[i].bt, p[i].at, p[i].pri);

          printf("\\nGantt chart\\n");
          for (i = 1; i <= n; i++)
              if (p[i].at == 0)
                  a[++k] = i;

          minbrust(a, k);
          while (tm != count)
          {
              selecta();

              if (arrv == 0)
              {
                  printf("|idl");
                  tm += 1;
                  count += 1;
              }
              else
              {
                  minbrust(arr, arrv);
                  arrv = 0;
              }
          }

          printf("\\n _________________________#######################______________________\\n");
          printf("\\nProcess\\tBT\\tAT\\tPri\\tST\\tWT\\tFT\\tTAT\\n");
          for (i = 1; i <= n; i++)
              printf("P%d\\t%d\\t%d\\t%d\\t%d\\t%d\\t%d\\t%d\\n", i, p[i].bt, p[i].at, p[i].pri, p[i].st, p[i].wt, p[i].ft, p[i].tat);

          printf("\\nAvg wait time=%f", Wt / n);
          printf("\\nAvg TAT=%f\\n", Tat / n);
      }

      void selecta()
      {
          int i;
          for (i = 1; i <= n; i++)
              if (p[i].at <= tm && p[i].isc == false)
                  arr[++arrv] = i;
      }

      void process(int s)
      {
          int k;
          p[s].pcount++;
          if (p[s].pcount == 1)
          {
              p[s].wt = p[s].st - p[s].at;
              p[s].st = tm;
          }
          p[s].nst = tm;
          tm++;

          k = p[s].nst - p[s].oft;
          p[s].oft = tm;

          if (k > 0)
              p[s].wt += k;
          if (p[s].pcount == p[s].bt)
          {
              p[s].isc = true;
              p[s].ft = tm;
              p[s].tat = p[s].ft - p[s].at;
              Tat += p[s].tat;
              Wt += p[s].wt;
          }

          printf("p%d   ", s);
      }

      void minbrust(int a[], int k)
      {
          int min = p[a[1]].bt, i, m = a[1];
          for (i = 1; i <= k; i++)
          {
              if (p[a[i]].bt < min && j != -1 && p[i].pri > p[j].pri)
              {
                  min = p[a[i]].bt;
                  m = a[i];
              }
          }
          process(m);
      }"""
        }
    },
    {
        "slipNo": 22,
        "questions": [
            {
                "question": """Write a C program that demonstrates the use of nice() system call. After a child Process is started using fork (), assign higher priority to the child using nice () system call""",
                "filenames": ["slip22Q1.c"]
            },
            {
                "question": """Write the program to simulate Non preemptive priority scheduling. The arrival time and first CPU-burst of different jobs should be input to the system. Accept no. of Processes, arrival time and burst time. The output should give Gantt chart, turnaround time and waiting time for each process. Also find the average waiting time and turnaround time.""",
                "filenames": ["slip22Q2.c"]
            }
        ],
        "answers": {
            "slip22Q1.c": """#include <stdio.h>
      #include <sys/types.h>
      #include <unistd.h>
      #include <stdlib.h>

      int main()
      {
          int pid, retnice;
          printf("press DEL to stop process \\n");

          pid = fork();
          for (;;)
          {
              if (pid == 0)
              {
                  retnice = nice(-5);
                  printf("child gets higher CPU priority %d\\n", retnice);
                  sleep(1);
              }
              else
              {
                  retnice = nice(4);
                  printf("Parent gets lower CPU priority %d\\n", retnice);
                  sleep(1);
              }
          }
      }""",
            "slip22Q2.c": """#include <stdio.h>
      #include <stdlib.h>

      struct job
      {
         int atime;
         int btime;
         int ft;
         int tat;
         int wt;
         int pri;
      } p[10];

      int arr[10], brust[10], n, rq[10], no_rq = 0, time = 0, j = -1;
      int addrq();
      int selectionjob();
      int deleteq(int k);
      int fsahll();

      void main()
      {
         int i;
         printf("Enter the job number:");
         scanf("%d", &n);

         for (i = 0; i < n; i++)
         {
             printf("Enter the arrival time p%d:", i);
             scanf("%d", &p[i].atime);
             arr[i] = p[i].atime;
         }

         for (i = 0; i < n; i++)
         {
             printf("Enter the brust time p%d:", i);
             scanf("%d", &p[i].btime);
             brust[i] = p[i].btime;
         }

         for (i = 0; i < n; i++)
         {
             printf("Enter the Priority p%d:", i);
             scanf("%d", &p[i].pri);
         }

         addrq();

         while (1)
         {
             j = selectionjob();
             if (j == -1)
             {
                 printf("CPU is ideal");
                 time++;
                 addrq();
             }
             else
             {
                 while (brust[j] != 0)
                 {
                     printf("\\t j %d", j);
                     brust[j]--;
                     time++;
                     addrq();
                 }
                 p[j].ft = time;
             }
             if (fsahll() == 1)
                 break;
         }

         int Tat = 0, Twt = 0;
         printf("\\nJob \\t FT \\t TAT \\t WT\\n");
         for (i = 0; i < n; i++)
         {
             p[i].tat = p[i].ft - p[i].atime;
             p[i].wt = p[i].tat - p[i].btime;
             printf("\\nJob %d \\t %d \\t %d \\t %d", i, p[i].ft, p[i].tat, p[i].wt);
             Tat += p[i].tat;
             Twt += p[i].wt;
         }

         float avgtat = Tat / n;
         float avgwt = Twt / n;
         printf("\\nAverage turnaround time: %f", avgtat);
         printf("\\nAverage waiting time: %f\\n", avgwt);
      }

      int addrq()
      {
         int i;
         for (i = 0; i < n; i++)
         {
             if (arr[i] == time)
             {
                 if (j != -1 && p[i].pri > p[j].pri)
                 {
                     rq[no_rq] = i;
                     j = i;
                 }
                 else
                 {
                     rq[no_rq++] = i;
                 }
             }
         }
      }

      int selectionjob()
      {
         int i, k;
         if (no_rq == 0)
             return -1;
         k = rq[0];
         for (i = 1; i < no_rq; i++)
             if (p[k].pri < p[rq[i]].pri)
                 k = rq[i];
         deleteq(k);
         return k;
      }

      int deleteq(int k)
      {
         int i;
         for (i = 0; i < no_rq; i++)
             if (rq[i] == k)
                 break;
         for (i = i + 1; i < no_rq; i++)
             rq[i - 1] = rq[i];
         no_rq--;
      }

      int fsahll()
      {
         int i;
         for (i = 0; i < n; i++)
             if (brust[i] != 0)
                 return -1;
         return 1;
      }"""
        }
    },
    {
        "slipNo": 23,
        "questions": [
            {
                "question": """Write a C program to illustrate the concept of orphan process. Parent process creates a child and terminates before child has finished its task. So child process becomes orphan process. (Use fork(), sleep(), getpid(), getppid()).""",
                "filenames": ["slip23Q1.c"]
            },
            {
                "question": """Write the simulation program for demand paging and show the page scheduling and total number of page faults according the optimal page replacement algorithm. Assume the memory of n frames.\nReference String : 7, 5, 4, 8, 5, 7, 2, 3, 1, 3, 5, 9, 4, 6, 2""",
                "filenames": ["slip23Q2.c"]
            }
        ],
        "answers": {
            "slip23Q1.c": """#include <stdio.h>
      #include <sys/types.h>
      #include <unistd.h>

      int main()
      {
          int pid = fork();
          if (pid > 0)
          {
              printf("Parent process\\n");
              printf("ID : %d\\n\\n", getpid());
          }
          else if (pid == 0)
          {
              printf("Child process\\n");
              printf("ID: %d\\n", getpid());
              printf("Parent -ID: %d\\n\\n", getppid());

              sleep(10);
              printf("\\nChild process \\n");
              printf("ID: %d\\n", getpid());
              printf("Parent -ID: %d\\n", getppid());
          }
          else
          {
              printf("Failed to create child process");
          }

          return 0;
      }""",
            "slip23Q2.c": """#include <stdio.h>
      int main()
      {
         int frames, n;

         printf("Enter the number of frames: ");
         scanf("%d", &frames);

         printf("Enter the number of pages in the reference string: ");
         scanf("%d", &n);
         int pages[n];
         int frame[frames];
         int pageFaults = 0;

         for (int i = 0; i < frames; i++)
         {
             frame[i] = -1;
         }

         printf("Enter the reference string: ");
         for (int i = 0; i < n; i++)
         {
             scanf("%d", &pages[i]);
         }

         for (int i = 0; i < n; i++)
         {
             int page = pages[i];
             int pageFound = 0;

             for (int j = 0; j < frames; j++)
             {
                 if (frame[j] == page)
                 {
                     pageFound = 1;
                     break;
                 }
             }
             if (!pageFound)
             {
                 int replaceIndex = -1;

                 for (int j = 0; j < frames; j++)
                 {
                     int nextPage = -1;
                     for (int k = i + 1; k < n; k++)
                     {
                         if (pages[k] == frame[j])
                         {
                             nextPage = k;
                             break;
                         }
                     }

                     if (nextPage == -1)
                     {
                         replaceIndex = j;
                         break;
                     }

                     if (replaceIndex == -1 || nextPage > i + 1)
                     {
                         replaceIndex = j;
                     }
                 }

                 frame[replaceIndex] = page;
                 pageFaults++;
             }

             printf("Page %d -> [", page);
             for (int j = 0; j < frames; j++)
             {
                 printf("%d ", frame[j]);
             }
             printf("] Page Faults: %d\\n", pageFaults);
         }

         printf("Total Page Faults: %d\\n", pageFaults);
         return 0;
      }"""
        }
    },
    {
        "slipNo": 24,
        "questions": [
            {
                "question": """Write a C program to accept n integers to be sorted. Main function
      creates child process using fork system call. Parent process sorts the integers
      using bubble sort and waits for child process using wait system call. Child
      process sorts the integers using insertion sort.""",
                "filenames": ["slip24Q1.c"]
            },
            {
                "question": """Write a program to implement the toy shell. It should display the command
      prompt “myshell$”. Tokenize the command line and execute the given
      command by creating the child process. Additionally it should interpret the
      following commands.
      count c filename :- To print number of characters in the file.
      count w filename :- To print number of words in the file.
      count l filename :- To print number of lines in the file.""",
                "filenames": ["slip24Q2.c"]
            }
        ],
        "answers": {
            "slip24Q1.c": """#include <stdio.h>
      #include <sys/types.h>
      #include <unistd.h>
      #include <stdlib.h>

      void bass(int arr[], int n)
      {
          int i, j, temp;
          for (i = 0; i < n - 1; i++)
          {
              for (j = 0; j < n - i - 1; j++)
              {
                  if (arr[j] > arr[j + 1])
                  {
                      temp = arr[j];
                      arr[j] = arr[j + 1];
                      arr[j + 1] = temp;
                  }
              }
          }
          printf("\\nAscending order\\n");
          for (i = 0; i < n; i++)
              printf("\\t%d", arr[i]);
          printf("\\n\\n\\n");
      }

      void bdsc(int arr[], int n)
      {
          int i, j, temp;
          for (i = 0; i < n; i++)
          {
              for (j = 0; j < n - 1; j++)
              {
                  if (arr[j] < arr[j + 1])
                  {
                      temp = arr[j];
                      arr[j] = arr[j + 1];
                      arr[j + 1] = temp;
                  }
              }
          }
          printf("\\nDescending Sorting\\n\\n");
          for (i = 0; i < n; i++)
              printf("\\t%d", arr[i]);
          printf("\\n\\n\\n");
      }

      void forkeg()
      {
          int arr[25], n, i, status;
          printf("\\nEnter the no. of values of array");
          scanf("%d", &n);
          printf("Enter the array elements:");
          for (i = 0; i < n; i++)
              scanf("%d", &arr[i]);
          int pid = fork();
          if (pid == 0)
          {
              sleep(10);
              printf("\\n child process \\n");
              printf("child process id=%d\\n", getpid());
              bass(arr, n);
              printf("\\nElements Sorted using insertion sort\\n");
              for (i = 0; i < n; i++)
                  printf("%d ", arr[i]);
              printf("\\nParent process id=%d\\n", getppid());
              system("ps -x");
          }
          else
          {
              printf("\\nparent process \\n");
              printf("\\nparent process id=%d\\n", getppid());
              bdsc(arr, n);
              printf("Elements sorted using bubble sort\\n");
              for (i = 0; i < n; i++)
                  printf("%d ", arr[i]);
              printf("\\n\\n\\n");
          }
      }

      int main()
      {
          forkeg();
          return 0;
      }""",

            "slip24Q2.c": """#include <stdio.h>
      #include <unistd.h>
      #include <string.h>
      #include <stdlib.h>

      void count(char *tok2, char *tok3)
      {
         int w = 0, c = 0, l = 0;
         FILE *fp;
         fp = fopen(tok3, "r");
         if (fp == NULL)
             printf("File does not exist");
         else
         {
             while (!feof(fp))
             {
                 char ch;
                 ch = fgetc(fp);
                 if (ch == ' ')
                     w++;
                 else if (ch == '\\n')
                 {
                     w++;
                     l++;
                 }
                 else
                     c++;
             }
             if (strcmp(tok2, "w") == 0)
                 printf("Word count = %d", w);
             if (strcmp(tok2, "c") == 0)
                 printf("Character count = %d", c);
             if (strcmp(tok2, "l") == 0)
                 printf("Line count = %d", l);
         }
      }

      int main(int argc, char *argv[])
      {
         char cmd[100], tok1[20], tok2[20], tok3[20];
         while (1)
         {
             printf("\\nMyshell$:");
             fgets(cmd, sizeof(cmd), stdin);
             if (strncmp(cmd, "exit", 4) == 0)
                 exit(0);
             int ch = sscanf(cmd, "%s%s%s", tok1, tok2, tok3);
             if (ch == 3)
             {
                 if (strcmp(tok1, "count") == 0)
                     count(tok2, tok3);
                 continue;
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok1, tok2, tok3, NULL);
                     break;
                 }
             }
         }
      }"""
        }
    },
    {
        "slipNo": 25,
        "questions": [
            {
                "question": "",
                "filenames": []
            },
            {
                "question": """Write a program to implement the shell. It should display the command
      prompt “myshell$”. Tokenize the command line and execute the given
      command by creating the child process. Additionally it should interpret the
      following commands.
      myshell$ search f filename pattern :- To display first occurrence of
      pattern in the file.""",
                "filenames": ["slip25Q2.c"]
            }
        ],
        "answers": {
            "slip25Q2.c": """#include <stdio.h>
      #include <stdlib.h>
      #include <string.h>
      #include <unistd.h>

      void search(char *tok2, char *tok3, char *tok4)
      {
         FILE *fp;
         char str[256];
         fp = fopen(tok4, "r");
         if (fp == NULL)
         {
             printf("File does not exist!");
         }
         else
         {
             int lineno = 0;
             int count = 0;

             if (strcmp(tok2, "f") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("First Occurrence of %s is on line no : %d", tok3, lineno);
                         break;
                     }
                 }
             }

             if (strcmp(tok2, "c") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     if (strstr(str, tok3))
                     {
                         count++;
                     }
                 }
                 printf("Total number of Occurrences of pattern (%s) is : %d", tok3, count);
             }

             if (strcmp(tok2, "a") == 0)
             {
                 while (!feof(fp))
                 {
                     fgets(str, sizeof(str), fp);
                     lineno++;
                     if (strstr(str, tok3))
                     {
                         printf("line no : %d and pattern is : %s\\n", lineno, tok3);
                     }
                 }
             }
         }
      }

      int main(int args, char *argv[])
      {
         char tok1[20], tok2[20], tok3[20], tok4[20];
         char cmd[100];
         while (1)
         {
             printf("\\nMyshell$ : ");
             fgets(cmd, sizeof(cmd), stdin);

             if (strncmp(cmd, "exit", 4) == 0)
             {
                 exit(0);
             }

             int ch = sscanf(cmd, "%s%s%s%s", tok1, tok2, tok3, tok4);
             if (ch == 4)
             {
                 if (strcmp(tok1, "search") == 0)
                 {
                     search(tok2, tok3, tok4);
                     continue;
                 }
             }
             if (fork() == 0)
             {
                 switch (ch)
                 {
                 case 1:
                     execlp(tok1, tok1, NULL);
                     break;
                 case 2:
                     execlp(tok1, tok1, tok2, NULL);
                     break;
                 case 3:
                     execlp(tok1, tok1, tok2, tok3, NULL);
                     break;
                 case 4:
                     execlp(tok1, tok1, tok2, tok3, tok4, NULL);
                     break;
                 }
             }
         }
      }

      // Example usage:
      // Myshell$ : search f data.txt pattern
      """
        }
    },
];
