PHP_SLIPS = [
  {
    "slipNo": 1,
    "questions": [
      {
        "question": """Write the HTML code for generating the form as shown below. Apply the internal CSS to following form to change the font size of the heading to 6pt and change the color to red and also change the background color to yellow.""",
        "filenames": ["slip1Q1.html"]
      },
      {
        "question": """Write a Python program to create a Pie plot to get the frequency of the three species of the Iris data (Use iris.csv)""",
        "filenames": ["slip1Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to view basic statistical details of the data.(Use wineequality-red.csv)""",
        "filenames": ["slip1Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip1Q1.html": """<!DOCTYPE html>
<html>
  <head>
    <style>
      body {
        background-color: yellow;
        margin: 0;
        padding: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
        font-family: Arial, sans-serif;
      }

      .form-container {
        background: white;
        padding: 30px 40px;
        border-radius: 12px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        text-align: left;
        width: 350px;
      }

      h1 {
        font-size: 24px;
        color: red;
        text-align: center;
        margin-bottom: 20px;
      }

      label {
        font-weight: bold;
        display: block;
        margin-bottom: 6px;
      }

      input[type="text"],
      input[type="date"],
      textarea,
      select {
        width: 100%;
        padding: 8px;
        margin-bottom: 15px;
        border: 1px solid #ccc;
        border-radius: 6px;
      }

      input[type="radio"] {
        margin-right: 6px;
      }

      .btn-group {
        display: flex;
        justify-content: space-between;
      }

      input[type="submit"],
      input[type="reset"] {
        width: 48%;
        padding: 10px;
        font-size: 16px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        color: white;
      }

      input[type="submit"] {
        background-color: red;
      }

      input[type="reset"] {
        background-color: gray;
      }

      input[type="submit"]:hover {
        background-color: darkred;
      }

      input[type="reset"]:hover {
        background-color: dimgray;
      }
    </style>
  </head>
  <body>
    <div class="form-container">
      <form>
        <h1>Project Management</h1>

        <label>Project Name</label>
        <input type="text" />

        <label>Assigned to</label>
        <select name="Name_of_person" size="1">
          <option>Gautam</option>
          <option>Amol</option>
          <option>Mr Gajanan</option>
          <option>Mr Mahesh</option>
        </select>

        <label>Start Date</label>
        <input type="date" />

        <label>End Date</label>
        <input type="date" />

        <label>Priority</label>
        <div>
          <input type="radio" name="priority" /> High
          <input type="radio" name="priority" /> Average
          <input type="radio" name="priority" /> Low
        </div>

        <label>Description</label>
        <textarea rows="5"></textarea>

        <div class="btn-group">
          <input type="submit" value="Submit" />
          <input type="reset" value="Clear" />
        </div>
      </form>
    </div>
  </body>
</html>
""",
      "slip1Q2A.ipynb": """{
        cells: [
          {
            cell_type: "code",
            execution_count: null,
            metadata: {},
            outputs: [],
            source: [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "species_count = df['Species'].value_counts()\n",
              "plt.pie(\n",
              "    species_count,\n",
              "    labels=species_count.index,\n",
              "    autopct='%1.1f%%',\n",
              "    startangle=90,\n",
              "    colors=['#ff9999','#66b3ff','#99ff99']\n",
              ")\n",
              "plt.title(\"Frequency of Iris Species\")\n",
              "plt.show()\n"
            ]
          }
        ],
        metadata: {
          kernelspec: {
            display_name: "Python 3",
            language: "python",
            name: "python3"
          },
          language_info: {
            file_extension: ".py",
            mimetype: "text/x-python",
            name: "python",
            version: "3.x"
          }
        },
        nbformat: 4,
        nbformat_minor: 5
      }""",
      "slip1Q2B.ipynb": """{
        cells: [
          {
            cell_type: "code",
            execution_count: null,
            metadata: {},
            outputs: [],
            source: [
              "import pandas as pd\n",
              "df = pd.read_csv(\"winequality-red.csv\", sep=\";\")\n",
              "print(\"First 5 rows of the dataset:\")\n",
              "print(df.head())\n",
              "\n",
              "print(\"Basic Statistical Details:\")\n",
              "print(df.describe())"
            ]
          }
        ],
        metadata: {
          kernelspec: {
            display_name: "Python 3",
            language: "python",
            name: "python3"
          },
          language_info: {
            file_extension: ".py",
            mimetype: "text/x-python",
            name: "python",
            version: "3.x"
          }
        },
        nbformat: 4,
        nbformat_minor: 5
      }"""
    }
  },

  {
    "slipNo": 2,
    "questions": [
      {
        "question": """Create HTML5 page with following specifications	[15]
i)	Title should be about your City.
ii)	Color the background by Pink color.
iii)	Place your city name at the top of page in large text and in blue color.
iv)	Add names of the landmarks in your city, each in different color, style and font
v)	Add any image at the bottom. (Use inline CSS to format the web page)
""",
        "filenames": ["slip2Q1.html"]
      },
      {
        "question": """Write a Python program for Handling Missing Value. Replace missing value of salary, age column with mean of that column.(Use Data.csv file).""",
        "filenames": ["slip2Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to generate a line plot of name Vs salary""",
        "filenames": ["slip2Q2B.ipynb"]
      },
      {
        "question": """Download the heights and weights dataset and load the dataset froma given csv file into a dataframe. Print the first, last 10 rows and random 20 rows also display shape of the dataset.""",
        "filenames": ["slip2Q2C.ipynb"]
      },
    ],
    "answers": {
      "slip2Q1.html": """<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <title>Pune - The Cultural City</title>
    <!-- Title about the city -->
  </head>
  <body
    style="background-color: pink; margin: 0; font-family: Arial, sans-serif"
  >
    <!-- City name at top: large text and blue color -->
    <header style="text-align: center; padding: 40px 20px">
      <h1 style="color: blue; font-size: 48px; margin: 0">Pune</h1>
      <p style="margin-top: 8px; font-size: 16px; color: #333">
        Welcome to Pune — a city of history, education and hills.
      </p>
    </header>

    <!-- Landmarks: each in different color, style and font (all inline CSS) -->
    <main style="display: flex; justify-content: center; padding: 20px">
      <ul
        style="
          list-style: none;
          padding: 0;
          margin: 0;
          width: 90%;
          max-width: 800px;
        "
      >
        <li style="margin: 14px 0">
          <span
            style="
              color: #c2185b;
              font-style: italic;
              font-family: 'Georgia', serif;
              font-size: 22px;
            "
          >
            Shaniwar Wada
          </span>
          <div style="font-size: 14px; color: #333; margin-top: 6px">
            (Historic fortification at the heart of Pune)
          </div>
        </li>

        <li style="margin: 14px 0">
          <span
            style="
              color: #0d47a1;
              font-weight: 700;
              text-decoration: underline;
              font-family: 'Tahoma', Geneva, sans-serif;
              font-size: 22px;
            "
          >
            Aga Khan Palace
          </span>
          <div style="font-size: 14px; color: #333; margin-top: 6px">
            (A monument with strong ties to India’s independence history)
          </div>
        </li>

        <li style="margin: 14px 0">
          <span
            style="
              color: #2e7d32;
              font-style: oblique;
              font-family: 'Courier New', monospace;
              font-size: 22px;
            "
          >
            Sinhagad Fort
          </span>
          <div style="font-size: 14px; color: #333; margin-top: 6px">
            (A popular hill fortress and trekking spot)
          </div>
        </li>

        <li style="margin: 14px 0">
          <span
            style="
              color: #6a1b9a;
              font-weight: 600;
              letter-spacing: 0.5px;
              font-family: 'Verdana', sans-serif;
              font-size: 22px;
            "
          >
            Osho International Meditation Resort
          </span>
          <div style="font-size: 14px; color: #333; margin-top: 6px">
            (Well-known meditation & wellness centre)
          </div>
        </li>
      </ul>
    </main>

    <!-- Image at the bottom (inline CSS used). Replace the src with any image you like. -->
    <footer style="display: flex; justify-content: center; padding: 30px 20px">
      <img
        src="https://images.unsplash.com/photo-1553064483-f10fe837615f?fm=jpg&q=60&w=3000&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxzZWFyY2h8Mnx8cHVuZSUyMGNpdHl8ZW58MHx8MHx8fDA%3D"
        alt="Pune scenery"
        style="
          max-width: 95%;
          height: auto;
          border-radius: 10px;
          box-shadow: 0 6px 18px rgba(0, 0, 0, 0.2);
        "
      />
    </footer>
  </body>
</html>
""",
      "slip2Q2A.ipynb": """{
        cells: [
          {
            cell_type: "code",
            execution_count: null,
            metadata: {},
            outputs: [],
            source: [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "print(\"Original Data (with missing values):\")\n",
              "print(df, \"\")\n",
              "\n",
              "df['salary'].fillna(df['salary'].mean(), inplace=True)\n",
              "df['age'].fillna(df['age'].mean(), inplace=True)\n",
              "\n",
              "print(\"Data after handling missing values (salary & age replaced with mean):\")\n",
              "print(df)"
            ]
          }
        ],
        metadata: {
          kernelspec: {
            display_name: "Python 3",
            language: "python",
            name: "python3"
          },
          language_info: {
            file_extension: ".py",
            mimetype: "text/x-python",
            name: "python",
            version: "3.x"
          }
        },
        nbformat: 4,
        nbformat_minor: 5
      }""",
      "slip2Q2B.ipynb": """{
        cells: [
          {
            cell_type: "code",
            execution_count: null,
            metadata: {},
            outputs: [],
            source: [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "df['salary'].fillna(df['salary'].mean(), inplace=True)\n",
              "\n",
              "plt.figure(figsize=(10,6))\n",
              "plt.plot(df['name'], df['salary'], marker='o', linestyle='-', color='blue')\n",
              "\n",
              "plt.title(\"Name vs Salary\", fontsize=16)\n",
              "plt.xlabel(\"Name\", fontsize=12)\n",
              "plt.ylabel(\"Salary\", fontsize=12)\n",
              "plt.grid(True)\n",
              "\n",
              "plt.show()"
            ]
          }
        ],
        metadata: {
          kernelspec: {
            display_name: "Python 3",
            language: "python",
            name: "python3"
          },
          language_info: {
            file_extension: ".py",
            mimetype: "text/x-python",
            name: "python",
            version: "3.x"
          }
        },
        nbformat: 4,
        nbformat_minor: 5
      }""",
      "slip2Q2C.ipynb": """{
        cells: [
          {
            cell_type: "code",
            execution_count: null,
            metadata: {},
            outputs: [],
            source: [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"HeightWeight.csv\")\n",
              "\n",
              "print(\"First 10 rows:\")\n",
              "print(df.head(10))\n",
              "\n",
              "print(\"Last 10 rows:\")\n",
              "print(df.tail(10))\n",
              "\n",
              "print(\"Random 20 rows:\")\n",
              "print(df.sample(20))\n",
              "\n",
              "print(\"Shape of the dataset:\", df.shape)"
            ]
          }
        ],
        metadata: {
          kernelspec: {
            display_name: "Python 3",
            language: "python",
            name: "python3"
          },
          language_info: {
            file_extension: ".py",
            mimetype: "text/x-python",
            name: "python",
            version: "3.x"
          }
        },
        nbformat: 4,
        nbformat_minor: 5
      }"""
    }
  },

  {
    "slipNo": 3,
    "questions": [
      {
        "question": """Write a program using html with following CSS specifications

i.The background colour of the company name should be in green.
      ii.The text colour of the company name should be red.
        iii.The heading should be large –with font ''comic sans ms''
iv.The description of the company should be displayed in blue color in a paragraph.
""",
        "filenames": ["slip3Q1.html"]
      },
      {
        "question": """Write a Python program to create box plots to see how each feature i.e. Sepal Length, Sepal Width, Petal Length, Petal Width are distributed across the three species. (Use iris.csv dataset)""",
        "filenames": ["slip3Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to view basic statistical details of the data (Use Heights and Weights Dataset)""",
        "filenames": ["slip3Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip3Q1.html": """< !DOCTYPE html>
  <html lang="en">
    <head>
      <meta charset="UTF-8" />
      <title>Company Page</title>
    </head>
    <body style="margin: 0; padding: 20px; font-family: Arial, sans-serif">
      <h1
        style="
        background-color: green;
        color: red;
        font-family: 'Comic Sans MS', cursive, sans-serif;
        font-size: 48px;
        padding: 20px;
        text-align: center;
      "
      >
        TechNova Solutions
      </h1>

      <p style="color: blue; font-size: 18px; margin-top: 20px; line-height: 1.6">
        TechNova Solutions is a leading technology company specializing in
        innovative software development, cloud solutions, and cutting-edge AI
        technologies. We strive to provide high-quality products and services to
        empower businesses around the world.
      </p>
    </body>
  </html>
""",

      "slip3Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "\n",
              "features = ['SepalLengthCm', 'SepalWidthCm', 'PetalLengthCm', 'PetalWidthCm']\n",
              "\n",
              "plt.figure(figsize=(12, 10))\n",
              "\n",
              "for i, feature in enumerate(features, 1):\n",
              "    plt.subplot(2, 2, i)\n",
              "    data = [df[df['Species'] == s][feature] for s in df['Species'].unique()]\n",
              "    plt.boxplot(data, labels=df['Species'].unique())\n",
              "    plt.title(feature)\n",
              "\n",
              "plt.tight_layout()\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",

      "slip3Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "df = pd.read_csv(\"HeightWeight.csv\", sep=\";\")\n",
              "print(\"First 5 rows of the dataset:\")\n",
              "print(df.head())\n",
              "\n",
              "print(\"Basic Statistical Details:\")\n",
              "print(df.describe())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }"""
    }
  },

  {
    "slipNo": 4,
    "questions": [
      {
        "question": """Write a HTML code, which generate the following output""",
        "filenames": ["slip4Q1.html"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options.""",
        "filenames": ["slip4Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to print the shape, number of rows-columns, data types, feature names and the description of the data(Use User_Data.csv)""",
        "filenames": ["slip4Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip4Q1.html": """< !DOCTYPE html >
  <html lang="en">
    <head>
      <meta charset="UTF-8" />
      <title>List of Books</title>
    </head>
    <body>
      <table border="1" cellpadding="8" cellspacing="0">
        <tr>
          <th colspan="4" style="text-align: center; font-size: 24px">
            List of Books
          </th>
        </tr>
        <tr>
          <th>Item No</th>
          <th>Item Name</th>
          <th colspan="2">Price</th>
        </tr>
        <tr>
          <td></td>
          <td></td>
          <td>Rs.</td>
          <td>Paise</td>
        </tr>
        <tr>
          <td>1</td>
          <td>Programming in Python</td>
          <td>500</td>
          <td>50</td>
        </tr>
        <tr>
          <td>2</td>
          <td>Programming in Java</td>
          <td>345</td>
          <td>00</td>
        </tr>
      </table>
    </body>
  </html>
""",
      "slip4Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "data = np.random.randint(1, 101, 50)\n",
              "\n",
              "# Line Chart\n",
              "plt.figure(figsize = (12, 8))\n",
              "plt.subplot(2, 2, 1)\n",
              "plt.plot(data, color = 'blue')\n",
              "plt.title(\"Line Chart\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "\n",
              "# Scatter Plot\n",
              "plt.subplot(2, 2, 2)\n",
              "plt.scatter(range(50), data, color = 'red')\n",
              "plt.title(\"Scatter Plot\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "\n",
              "# Histogram\n",
              "plt.subplot(2, 2, 3)\n",
              "plt.hist(data, color = 'green')\n",
              "plt.title(\"Histogram\")\n",
              "plt.xlabel(\"Value\")\n",
              "plt.ylabel(\"Frequency\")\n",
              "\n",
              "# Box Plot\n",
              "plt.subplot(2, 2, 4)\n",
              "plt.boxplot(data)\n",
              "plt.title(\"Box Plot\")\n",
              "plt.ylabel(\"Value\")\n",
              "\n",
              "plt.tight_layout()\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",

      "slip4Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "print(\"Shape of dataset:\", df.shape)\n",
              "\n",
              "print(\"Number of rows:\", df.shape[0])\n",
              "print(\"Number of columns:\", df.shape[1])\n",
              "\n",
              "print(\"Data types of each column:\")\n",
              "print(df.dtypes)\n",
              "\n",
              "print(\"Feature names:\")\n",
              "print(df.columns.tolist())\n",
              "\n",
              "print(\"Description of data:\")\n",
              "print(df.describe())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }"""
    }
  },

  {
    "slipNo": 5,
    "questions": [
      {
        "question": """Create following Bootstrap Web Layout Design and change Title, add your personal information, educational information, job profile.""",
        "filenames": ["slip5Q1.html"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options""",
        "filenames": ["slip5Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to print the shape, number of rows-columns, data types, feature names and the description of the data(Use User_Data.csv)""",
        "filenames": ["slip5Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip5Q1.html": """< !DOCTYPE html >
  <html lang="en">
    <head>
      <meta charset="UTF-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      <title>Document</title>
    </head>
    <body style="margin:0; padding:0;">

      <div style="width: 100%; background-color: lightgray; padding: 20px; text-align: center;">
        <h1>My First Bootstrap Page</h1>
        <p>Resize this responsive page to see the effect!</p>
      </div>

      <div style="display: flex; flex-direction: row; gap: 20px; margin-top: 20px; justify-content: center;">
        <div>
          <h3>Personal Information</h3>
          <p>Add your personal information</p>
        </div>
        <div>
          <h3>Educational Information</h3>
          <p>Add your Educational information</p>
        </div>
        <div>
          <h3>Job Profile</h3>
          <p>Add your profile information</p>
        </div>
      </div>
    </body>
  </html>
""",
      "slip5Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "data = np.random.randint(1, 101, 50)\n",
              "\n",
              "# Create subplots\n",
              "plt.figure(figsize = (12, 10))\n",
              "\n",
              "# Line Chart\n",
              "plt.subplot(2, 2, 1)\n",
              "plt.plot(data, color = 'blue')\n",
              "plt.title(\"Line Chart\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "\n",
              "# Scatter Plot\n",
              "plt.subplot(2, 2, 2)\n",
              "plt.scatter(range(50), data, color = 'red')\n",
              "plt.title(\"Scatter Plot\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "\n",
              "# Histogram\n",
              "plt.subplot(2, 2, 3)\n",
              "plt.hist(data, color = 'green')\n",
              "plt.title(\"Histogram\")\n",
              "plt.xlabel(\"Value\")\n",
              "plt.ylabel(\"Frequency\")\n",
              "\n",
              "# Box Plot\n",
              "plt.subplot(2, 2, 4)\n",
              "plt.boxplot(data)\n",
              "plt.title(\"Box Plot\")\n",
              "plt.ylabel(\"Value\")\n",
              "\n",
              "plt.tight_layout()\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip5Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "print(\"Shape of dataset:\", df.shape)\n",
              "\n",
              "print(\"Number of rows:\", df.shape[0])\n",
              "print(\"Number of columns:\", df.shape[1])\n",
              "\n",
              "print(\"Data types of each column:\")\n",
              "print(df.dtypes)\n",
              "\n",
              "print(\"Feature names:\")\n",
              "print(df.columns.tolist())\n",
              "\n",
              "print(\"Description of data:\")\n",
              "print(df.describe())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }"""
    }
  },
  {
    "slipNo": 6,
    "questions": [
      {
        "question": """Create following Bootstrap Web Layout Design and set Header background color Blue, add your College name, set Menu section background color green create menu About Us, In content section add college information, background color yellow, Footer section background color red, add address of college.""",
        "filenames": ["slip6Q1.html"]
      },
      {
        "question": """Write a Python program for Handling Missing Value. Replace missing value of salary, age column with mean of that column.(Use Data.csv file).""",
        "filenames": ["slip6Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to generate a line plot of name Vs salary""",
        "filenames": ["slip6Q2B.ipynb"]
      },
      {
        "question": """Download the heights and weights dataset and load the dataset froma given csv file into a dataframe. Print the first, last 10 rows and random 20 rows also display shape of the dataset.""",
        "filenames": ["slip6Q2C.ipynb"]
      },
    ],
    "answers": {
      "slip6Q1.html": """< !DOCTYPE html >
  <html lang="en">
    <head>
      <meta charset="UTF-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      <title>College Web Layout</title>
      <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
        rel="stylesheet"
      />
      <style>
        html,
        body {
          height: 100%;
        margin: 0;
      }
        .main-content {
          height: calc(100vh - 120px);
      }
        .menu,
        .info {
          height: 100%;
        padding: 20px;
      }
      </style>
    </head>
    <body>
      <header class="bg-primary text-white text-center p-3" style="height: 10vh">
        <h1>My College Name</h1>
      </header>

      <div class="d-flex main-content" style="height: 80vh">
        <div class="menu bg-success text-white" style="width: 25%">
          <h3>Menu</h3>
          <ul class="nav flex-column">
            <li class="nav-item">
              <a class="nav-link text-white" href="#">About Us</a>
            </li>
          </ul>
        </div>

        <div class="info bg-warning" style="width: 75%">
          <h2>College Information</h2>
          <p>
            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer nec
            odio. Praesent libero. Sed cursus ante dapibus diam. Sed nisi. Nulla
            quis sem at nibh elementum imperdiet. Duis sagittis ipsum. Praesent
            mauris. Fusce nec tellus sed augue semper porta. Mauris massa.
            Vestibulum lacinia arcu eget nulla. Class aptent taciti sociosqu ad
            litora torquent per conubia nostra, per inceptos himenaeos. Curabitur
            sodales ligula in libero. Sed dignissim lacinia nunc.
          </p>
        </div>
      </div>

      <!-- Footer -->
      <footer class="bg-danger text-white text-center p-3" style="height: 10vh">
        <p>College Address: 123, College Street, City, State, ZIP</p>
      </footer>
    </body>
  </html>
""",
      "slip6Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "print(\"Original Data (with missing values):\")\n",
              "print(df)\n",
              "\n",
              "df['salary'].fillna(df['salary'].mean(), inplace = True)\n",
              "df['age'].fillna(df['age'].mean(), inplace = True)\n",
              "\n",
              "print(\"Data after handling missing values (salary & age replaced with mean):\")\n",
              "print(df)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",

      "slip6Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "df['salary'].fillna(df['salary'].mean(), inplace = True)\n",
              "\n",
              "plt.figure(figsize = (10, 6))\n",
              "plt.plot(df['name'], df['salary'], marker = 'o', linestyle = '-', color = 'blue')\n",
              "\n",
              "plt.title(\"Name vs Salary\", fontsize = 16)\n",
              "plt.xlabel(\"Name\", fontsize = 12)\n",
              "plt.ylabel(\"Salary\", fontsize = 12)\n",
              "plt.grid(True)\n",
              "\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",

      "slip6Q2C.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"HeightWeight.csv\")\n",
              "\n",
              "print(\"First 10 rows:\")\n",
              "print(df.head(10))\n",
              "\n",
              "print(\"Last 10 rows:\")\n",
              "print(df.tail(10))\n",
              "\n",
              "print(\"Random 20 rows:\")\n",
              "print(df.sample(20))\n",
              "\n",
              "print(\"Shape of the dataset:\", df.shape)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }"""
    }
  }, {
    "slipNo": 7,
    "questions": [
      {
        "question": """Design HTML 5 Page Using CSS Which Displays the following Navigation Bar""",
        "filenames": ["slip7Q1.html"]
      },
      {
        "question": """Write a Python program to perform the following tasks :
a.	Apply OneHot coding on Country column.
b.	Apply Label encoding on purchased column
(Data.csv have two categorical column the country column, and the purchased column).
""",
        "filenames": ["slip7Q2.ipynb"]
      },
    ],
    "answers": {
      "slip7Q1.html": """<!DOCTYPE html>
<html>
  <head>
    <style>
      ul {
        list-style-type: none;
        margin: 0;
        padding: 0;
        overflow: hidden;
        border: 1px solid #e7e7e7;
        background-color: #b0b0b0;
      }
      li {
        float: left;
      }
      li a {
        display: block;
        color: #0000ff;
        text-align: center;
        padding: 14px 16px;
        text-decoration: none;
      }
      li a:hover:not(.active) {
        background-color: #606060;
      }
      li a.active {
        color: white;
        background-color: #707070;
      }
    </style>
  </head>
  <body>
    <ul>
      <li><a class="active" href="#home">Home </a></li>
      <li><a href="#java">Java</a></li>
      <li><a href="#html">HTML</a></li>
      <li><a href="#css">CSS</a></li>
    </ul>
  </body>
</html>
""",
      "slip7Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "from sklearn.preprocessing import LabelEncoder\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "print(\"Original Data:\")\n",
              "print(df.head())\n",
              "\n",
              "df = pd.get_dummies(df, columns=['Country'])\n",
              "\n",
              "le = LabelEncoder()\n",
              "df['Purchased'] = le.fit_transform(df['Purchased'])\n",
              "\n",
              "print(\"\\nData after One-Hot and Label Encoding:\")\n",
              "print(df.head())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 8,
    "questions": [
      {
        "question": """Design an HTML form to accept two strings from the user. Write a PHP script for the following.
a.	Find whether the small string appears at the start of the large string.
b.	Find the position of the small string in the big string.
c.	Compare both the string for first n characters, also the comparison should not be case sensitive.""",
        "filenames": ["slip8Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip8Q1B.php"]
      },
      {
        "question": """Write a program in python to perform following task :	[15] Standardizing Data (transform them into a standard Gaussian distribution with a mean of 0 and a standard deviation of 1) (Use winequality-red.csv)""",
        "filenames": ["slip8Q2.ipynb"]
      },
    ],
    "answers": {
      "slip8Q1A.html": """<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Document</title>
  </head>
  <body>
    <h2>String Operations Form</h2>

    <form method="post" action="slip10Q1A.php">
      <label>Large String:</label><br />
      <input type="text" name="large" required /><br /><br />

      <label>Small String:</label><br />
      <input type="text" name="small" required /><br /><br />

      <input type="submit" name="submit" value="Submit" />
    </form>
  </body>
</html>
""",
      "slip8Q1B.php": """<?php
if (isset($_POST['submit'])) {
    $large = $_POST['large'];
    $small = $_POST['small'];

    echo "<h3>Results:</h3>";

    if (stripos($large, $small) === 0) {
        echo "a) The small string appears at the start of the large string.<br>";
    } else {
        echo "a) The small string does NOT appear at the start of the large string.<br>";
    }

    // b) Find position of small string in large string
    $pos = stripos($large, $small);
    if ($pos !== false) {
        echo "b) The small string appears at position: $pos<br>";
    } else {
        echo "b) The small string does not appear in the large string.<br>";
    }

    // c) Compare first n characters (case-insensitive)
    $large_sub = substr($large, 0,1);
    $small_sub = substr($small, 0,1);

    if (strcasecmp($large_sub, $small_sub) == 0) {
        echo "c) The first characters of both strings are equal (case-insensitive).<br>";
    } else {
        echo "c) The first characters of both strings are NOT equal.<br>";
    }
}
?>""",
      "slip8Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "from sklearn.preprocessing import StandardScaler\n",
              "\n",
              "df = pd.read_csv(\"winequality-red.csv\")\n",
              "\n",
              "print(\"Original Data (first 5 rows):\")\n",
              "print(df.head())\n",
              "\n",
              "features = df.drop('quality', axis=1) if 'quality' in df.columns else df\n",
              "\n",
              "scaler = StandardScaler()\n",
              "\n",
              "scaled_features = scaler.fit_transform(features)\n",
              "\n",
              "df_scaled = pd.DataFrame(scaled_features, columns=features.columns)\n",
              "\n",
              "if 'quality' in df.columns:\n",
              "    df_scaled['quality'] = df['quality']\n",
              "\n",
              "print(\"\\nStandardized Data (first 5 rows):\")\n",
              "print(df_scaled.head())\n",
              "\n",
              "print(\"\\nMean of each feature after standardization:\")\n",
              "print(df_scaled.mean())\n",
              "\n",
              "print(\"\\nStandard deviation of each feature after standardization:\")\n",
              "print(df_scaled.std())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 9,
    "questions": [
      {
        "question": """Write a PHP script for the following: Design a form having a text box and a drop down list containing any 3 separators(e.g. #, |, %, @, ! or comma) accept a strings from the user and also a separator.
a.	Split the string into separate words using the given separator.
b.	Replace all the occurrences of separator in the given string with some other separator.
c.	Find the last word in the given string.
""",
        "filenames": ["slip9Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip9Q1B.php"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot. Apply appropriate color, labels and styling options.""",
        "filenames": ["slip9Q2A.ipynb"]
      },
      {
        "question": """Create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in a pie chart.""",
        "filenames": ["slip9Q2B.ipynb"]
      },
      {
        "question": """Write a program in python to perform following task (Use winequality-red.csv ) [5] Import Dataset and do the followings:
a)	Describing the dataset
b)	Shape of the dataset
c)	Display first 3 rows from dataset
""",
        "filenames": ["slip9Q2C.ipynb"]
      },
    ],
    "answers": {
      "slip9Q1A.html": """<html>
  <head>
    <title>string operations</title>
  </head>
  <body>
    <form action="slip9Q1B.php" method="POST">
      Enter string:- <input type="text" name="str1" /> <br />
      <br />
      <br />
      Enter a separator:-
      <select name="separator" id="s">
        <option value="#">#</option>
        <option value="|">|</option>
        <option value="%">%</option>
        <option value="@">@</option>
        <option value="!">!</option>
        <option value=",">,</option>
      </select>
      <br />
      <br />
      <br />
      <input type="submit" name="Submit" value="string operations" />
      <input type="reset" name="Reset" />
    </form>
  </body>
</html>
""",
      "slip9Q1B.php": """<?php
$string=$_POST['str1'];
$seprtaor=$_POST['separator'];
echo "String is $string and separator is $seprtaor <br> <br>";
echo "Split the string into separate words using the given separator. <br> <br>";
$splitwords=explode($seprtaor,$string);
print_r($splitwords);
echo "<br> <br>";
echo "Replace all the occurrences of separator in the given string with some other
separator.<br> <br> ";
echo str_replace( "$seprtaor", "$", $string );
echo "<br><br><br>";
echo "Find the last word in the given string. <br> <br>";
$split = explode(" ", $string);
$lastWord = $split[count($split)-1];
var_dump($lastWord)
?>""",
      "slip9Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "import numpy as np\n",
              "\n",
              "data = np.random.randint(1, 101, 50)\n",
              "x = np.arange(1, 51)\n",
              "\n",
              "# Line chart\n",
              "plt.plot(x, data, color='blue', marker='o')\n",
              "plt.title('Line Chart')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Scatter plot\n",
              "plt.scatter(x, data, color='red')\n",
              "plt.title('Scatter Plot')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip9Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Lists\n",
              "subjects = ['Math', 'Physics', 'Chemistry', 'Biology', 'English']\n",
              "marks = [85, 78, 90, 75, 80]\n",
              "\n",
              "# Pie chart\n",
              "plt.pie(marks, labels=subjects, autopct='%1.1f%%', startangle=90)\n",
              "plt.title('Marks Distribution')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip9Q2C.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "# Load the dataset\n",
              "df = pd.read_csv(\"winequality-red.csv\")\n",
              "\n",
              "# a) Describe the dataset\n",
              "print(\"a) Dataset Description:\")\n",
              "print(df.describe())\n",
              "\n",
              "# b) Shape of the dataset\n",
              "print(\"\\nb) Shape of the dataset:\")\n",
              "print(df.shape)\n",
              "\n",
              "# c) Display first 3 rows\n",
              "print(\"\\nc) First 3 rows of the dataset:\")\n",
              "print(df.head(3))"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }"""
    }
  },

  {
    "slipNo": 10,
    "questions": [
      {
        "question": """Write a script to accept two integers(Use html form having 2 textboxes). Write a PHP script to,
a.	Find mod of the two numbers.
b.	Find the power of first number raised to the second.
c.	Find the sum of first n numbers (considering first number as n)
d.	Find the factorial of second number.
(Write separate function for each of the above operations.)
""",
        "filenames": ["slip10Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip10Q1B.php"]
      },
      {
        "question": """Write a python program to Display column-wise mean, and median for SOCR- HeightWeight dataset.""",
        "filenames": ["slip10Q2A.ipynb"]
      },
      {
        "question": "",
        "filenames": ["slip10Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip10Q1A.html": """<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Math Operations</title>
  </head>
  <body>
    <h2>Math Operations Form</h2>

    <form method="post" action="slip10Q1B.php">
      <label>Enter First Number:</label><br />
      <input type="number" name="num1" required /><br /><br />

      <label>Enter Second Number:</label><br />
      <input type="number" name="num2" required /><br /><br />

      <input type="submit" name="submit" value="Submit" />
    </form>
  </body>
</html>
""",
      "slip10Q1B.php": """<?php
if(isset($_POST['submit'])){
    $num1 = (int)$_POST['num1'];
    $num2 = (int)$_POST['num2'];

    function findMod($a, $b){
        return $a % $b;
    }

    function findPower($a, $b){
        return pow($a, $b);
    }

    function sumOfFirstN($n){
        return ($n * ($n + 1)) / 2;
    }

    function factorial($n){
        $fact = 1;
        for($i=1; $i<=$n; $i++){
            $fact *= $i;
        }
        return $fact;
    }

    echo "<h3>Results:</h3>";
    echo "a) Modulus of $num1 and $num2: " . findMod($num1, $num2) . "<br>";
    echo "b) $num1 raised to the power $num2: " . findPower($num1, $num2) . "<br>";
    echo "c) Sum of first $num1 numbers: " . sumOfFirstN($num1) . "<br>";
    echo "d) Factorial of $num2: " . factorial($num2) . "<br>";
}
?>""",
      "slip10Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"HeightWeight.csv\")\n",
              "\n",
              "print(\"Column-wise Mean:\")\n",
              "print(df.mean())\n",
              "\n",
              "print(\"\\nColumn-wise Median:\")\n",
              "print(df.median())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip10Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import itertools\n",
              "\n",
              "points = [(1, 2), (3, 4), (5, 0), (2, 1)]\n",
              "\n",
              "total_distance = 0\n",
              "\n",
              "for (x1, y1), (x2, y2) in itertools.combinations(points, 2):\n",
              "    total_distance += abs(x1 - x2) + abs(y1 - y2)\n",
              "\n",
              "print(\"Sum of Manhattan distances between all pairs:\", total_distance)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }"""
    }
  },

  {
    "slipNo": 11,
    "questions": [
      {
        "question": """Create a button with different style (Secondary, Primary, Success, Error, Info, Warning, Danger) using BootStrap.""",
        "filenames": ["slip11Q1.html"]
      },
      {
        "question": """Write a Python program to create a Pie plot to get the frequency of the three species of the Iris data (Use iris.csv)""",
        "filenames": ["slip11Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to view basic statistical details of the data.(Use wineequality-red.csv)""",
        "filenames": ["slip11Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip11Q1.html": """<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Bootstrap Buttons</title>
    <link
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
      rel="stylesheet"
    />
  </head>
  <body class="p-4">
    <h2>Bootstrap Buttons</h2>

    <button class="btn btn-primary">Primary</button>
    <button class="btn btn-secondary">Secondary</button>
    <button class="btn btn-success">Success</button>
    <button class="btn btn-danger">Error / Danger</button>
    <button class="btn btn-info">Info</button>
    <button class="btn btn-warning">Warning</button>
  </body>
</html>
""",
      "slip11Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "\n",
              "species_counts = df['Species'].value_counts()\n",
              "\n",
              "plt.pie(species_counts, labels=species_counts.index, autopct='%1.1f%%', startangle=90)\n",
              "plt.title('Frequency of Iris Species')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip11Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"winequality-red.csv\")\n",
              "\n",
              "print(df.describe())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 12,
    "questions": [
      {
        "question": """Write a PHP script for the following: Design a form to accept two numbers from the user. Give options to choose the arithmetic operation (use radio buttons). Display the result on the next form. (Use the concept of function and default parameters. Use „include‟ construct or require statement)""",
        "filenames": ["slip12Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip12Q1B.php"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options.""",
        "filenames": ["slip12Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to create data frame containing column name, salary, department add 10 rows with some missing and duplicate values to the data frame. Also drop all null and empty values. Print the modified data frame""",
        "filenames": ["slip12Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip12Q1A.html": """<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Arithmetic Operations</title>
  </head>
  <body>
    <h2>Arithmetic Operations Form</h2>

    <form method="post" action="slip12Q1B.php">
      <label>Enter First Number:</label><br />
      <input type="number" name="num1" required /><br /><br />

      <label>Enter Second Number:</label><br />
      <input type="number" name="num2" required /><br /><br />

      <label>Select Operation:</label><br />
      <input type="radio" name="operation" value="add" checked /> Add<br />
      <input type="radio" name="operation" value="subtract" /> Subtract<br />
      <input type="radio" name="operation" value="multiply" /> Multiply<br />
      <input type="radio" name="operation" value="divide" /> Divide<br /><br />

      <input type="submit" name="submit" value="Calculate" />
    </form>
  </body>
</html>
""",
      "slip12Q1B.php": """<?php

 $num1 = (float)$_POST['num1'];
    $num2 = (float)$_POST['num2'];
    $operation = $_POST['operation'];

    $result = calculate($num1, $num2, $operation);

    echo "<h2>Result:</h2>";
    echo "First Number: $num1 <br>";
    echo "Second Number: $num2 <br>";
    echo "Operation: $operation <br>";
    echo "Result: $result <br>";

function calculate($num1 = 0, $num2 = 0, $operation = "add") {
    switch($operation) {
        case "add":
            return $num1 + $num2;
        case "subtract":
            return $num1 - $num2;
        case "multiply":
            return $num1 * $num2;
        case "divide":
            return ($num2 != 0) ? $num1 / $num2 : "Division by zero!";
        default:
            return "Invalid operation";
    }
}
?>
""",
      "slip12Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "import numpy as np\n",
              "\n",
              "data = np.random.randint(1, 101, 50)\n",
              "x = np.arange(1, 51)\n",
              "\n",
              "# Line chart\n",
              "plt.plot(x, data)\n",
              "plt.title('Line Chart')\n",
              "plt.show()\n",
              "\n",
              "# Scatter plot\n",
              "plt.scatter(x, data)\n",
              "plt.title('Scatter Plot')\n",
              "plt.show()\n",
              "\n",
              "# Histogram\n",
              "plt.hist(data)\n",
              "plt.title('Histogram')\n",
              "plt.show()\n",
              "\n",
              "# Box plot\n",
              "plt.boxplot(data)\n",
              "plt.title('Box Plot')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip12Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import numpy as np\n",
              "\n",
              "data = {\n",
              "    'Name': ['John', 'Alice', 'Bob', 'David', 'Eva', 'Frank', 'Grace', 'Helen', None, 'John'],\n",
              "    'Salary': [50000, 60000, 55000, None, 75000, 62000, 60000, 58000, 70000, 50000],\n",
              "    'Department': ['HR', 'IT', 'Finance', 'IT', 'HR', None, 'Finance', 'IT', 'HR', 'HR']\n",
              "}\n",
              "\n",
              "df = pd.DataFrame(data)\n",
              "\n",
              "print(\"Original DataFrame:\")\n",
              "print(df)\n",
              "\n",
              "df_modified = df.dropna()\n",
              "df_modified = df_modified[~(df_modified == '').any(axis=1)]\n",
              "\n",
              "print(\"\\nModified DataFrame (after dropping null/empty values):\")\n",
              "print(df_modified)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },
  {
    "slipNo": 13,
    "questions": [
      {
        "question": """Write a PHP script to create a chess board using CSS on table cells.""",
        "filenames": ["slip13Q1.php"]
      },
      {
        "question": """Write a Python program to create a graph to find relationship between the petal length and petal width.(Use iris.csv dataset)""",
        "filenames": ["slip13Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to find the maximum and minimum value of a given flattened array.""",
        "filenames": ["slip13Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip13Q1.php": """<!DOCTYPE html>
<html>
<head>
<style>
 table {
 border-collapse: collapse;
 }
 td {
 width: 50px;
 height: 50px;
 text-align: center;
 vertical-align: middle;
 font-size: 24px;
 }
 .white {
 background-color: #FFFFFF;
 }
 .black {
 background-color: #000000;
 }
 </style>
</head>
<body>
 <table>
 <?php
 for ($row = 1; $row <= 8; $row++)
{
 echo "<tr>";
 for ($col = 1; $col <= 8; $col++)
{
 $class = ($row + $col) % 2 == 0 ? 'white' : 'black';
 echo "<td class='$class'></td>";
 }
echo "</tr>";
}
?>
</table>
</body>
</html>""",
      "slip13Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "\n",
              "plt.scatter(df['PetalLengthCm'], df['PetalWidthCm'])\n",
              "plt.xlabel('Petal Length')\n",
              "plt.ylabel('Petal Width')\n",
              "plt.title('Petal Length vs Petal Width')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip13Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "\n",
              "arr = np.array([[3, 7, 1], [9, 2, 5]])\n",
              "\n",
              "flat_arr = arr.flatten()\n",
              "\n",
              "max_val = flat_arr.max()\n",
              "min_val = flat_arr.min()\n",
              "\n",
              "print(\"Maximum value:\", max_val)\n",
              "print(\"Minimum value:\", min_val)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 14,
    "questions": [
      {
        "question": """Create a container add row inside it and add 3 columns inside row using BootStrap.""",
        "filenames": ["slip14Q1.html"]
      },
      {
        "question": """Write a Python NumPy program to compute the weighted average along the specified axis of a given flattened array.""",
        "filenames": ["slip14Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to view basic statistical details of the data (Use advertising.csv)""",
        "filenames": ["slip14Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip14Q1.html": """<html>
    <head>
        <title> Bootstrap Example </title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
rel="stylesheet" integrity="sha384-
T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN"
crossorigin="anonymous">
</head>
<body>
<h1 class="text-primary"> My First Bootstrap Page </h1>
<p class="text-danger"> Resize this responsive page to see the effect! </p>
</div>
<div class="container">
<div class="row">
 <div class="col-sm-4">
 <h3>Personal Information</h3>
 <p>Gautam Kudale</p>
 </div>
 <div class="col-sm-4">
 <h3>Educational Information</h3>
 <p>MCS, Mphil. (Computer Science)</p>
 </div>
 <div class="col-sm-4">
 <h3>Job Profile</h3>
 <p> Working as Assistant Professor in VPASC College, MIDC, Baramati, 413133 </p>
 </div>
</div>
</div>
</body>
</html>""",
      "slip14Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "\n",
              "arr = np.array([[3, 7, 1], [9, 2, 5]])\n",
              "\n",
              "flat_arr = arr.flatten()\n",
              "\n",
              "weights = np.array([0.1, 0.2, 0.1, 0.2, 0.2, 0.2])\n",
              "\n",
              "weighted_avg = np.average(flat_arr, weights=weights)\n",
              "\n",
              "print(\"Weighted average:\", weighted_avg)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip14Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "df = pd.read_csv(\"Data.csv\")\n",
              "\n",
              "print(df.describe())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 15,
    "questions": [
      {
        "question": """Design a form to accept string from the user and perform the following operations
a.	To select first 5 words from the string
b.	Convert the given string to lowercase and then to Title case.
c.	Pad the given string with “*” from left and right both the sides.
d.	Remove the leading whitespaces from the given string.
e.	Find the reverse of given string.""",
        "filenames": ["slip15Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip15Q1B.php"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options""",
        "filenames": ["slip15Q2A.ipynb"]
      },
      {
        "question": """Create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in a pie chart.""",
        "filenames": ["slip15Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip15Q1A.html": """<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>string operations</title>
  </head>
  <body>
    <form action="slip15Q1B.php" method="POST">
      Enter string:- <input type="text" name="str1" /> <br />
      <br />
      <br />
      <input type="submit" name="Submit" value="string operations" />
      <input type="reset" name="Reset" />
    </form>
  </body>
</html>
""",
      "slip15Q1B.php": """<?php
$string=$_POST['str1'];
echo "Original String is :- $string <br> <br>";
echo "To select first 5 words from the string <br><br>";
$ffivewords=substr($string,0,5);
echo "First 5 words from the string are:- $ffivewords <br> <br>";
echo "Convert the given string to lowercase and then to Title case.<br><br>";
$lcase=strtolower($string); echo "Lowercase String is :- $lcase <br><br>";
$tcase=ucwords(strtolower($string));
echo "Title case String is :- $tcase <br><br>";
echo "Pad the given string with “*” from left and right both the sides. <br><br>";
$bspad=str_pad($string,30,"*",STR_PAD_BOTH);
echo "paded string is $bspad <br> <br>";
echo "Remove the leading whitespaces from the given string.<br><br>";
$lwstring=ltrim($string);
echo "Removed leading whitespaces string is:- $lwstring <br> <br>";
echo "Find the reverse of given string.<br><br>";
$rstring=strrev($string);
echo "Reverse String is:- $rstring <br>";
?>""",
      "slip15Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "import numpy as np\n",
              "\n",
              "data = np.random.randint(1, 101, 50)\n",
              "x = np.arange(1, 51)\n",
              "\n",
              "# Line chart\n",
              "plt.plot(x, data, color='blue', marker='o')\n",
              "plt.title('Line Chart')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Scatter plot\n",
              "plt.scatter(x, data, color='red')\n",
              "plt.title('Scatter Plot')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Histogram\n",
              "plt.hist(data, bins=10, color='green', edgecolor='black')\n",
              "plt.title('Histogram')\n",
              "plt.xlabel('Value')\n",
              "plt.ylabel('Frequency')\n",
              "plt.show()\n",
              "\n",
              "# Box plot\n",
              "plt.boxplot(data, patch_artist=True, boxprops=dict(facecolor='orange'))\n",
              "plt.title('Box Plot')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip15Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Lists\n",
              "subjects = ['Math', 'Physics', 'Chemistry', 'Biology', 'English']\n",
              "marks = [85, 78, 90, 75, 80]\n",
              "\n",
              "# Pie chart\n",
              "plt.pie(marks, labels=subjects, autopct='%1.1f%%')\n",
              "plt.title('Marks Distribution')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },
  {
    "slipNo": 16,
    "questions": [
      {
        "question": """Write a PHP script for the following: Design a form to accept the marks of 5 different subjects of a student, having serial number, subject name & marks out of 100. Display the result in the tabular format which will have total, percentage and grade. Use only 3 text boxes.(Use array of form parameters)	""",
        "filenames": ["slip16Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip16Q1B.php"]
      },
      {
        "question": """Write a python program to create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in a pie chart and bar chart.""",
        "filenames": ["slip16Q2A.ipynb"]
      },
      {
        "question": """Write a python program to create a data frame for students‟ information such as name, graduation percentage and age. Display average age of students, average of graduation percentage.""",
        "filenames": ["slip16Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip16Q1A.html": """<html>
  <head>
    <style>
      table {
        border-collapse: collapse;
      }
      table,
      th,
      td {
        border: 1px solid blue;
      }
    </style>
  </head>
  <body>
    <form method="post" action="slip16Q1B.php">
      <center>
        <h1>Enter details of 5 Students</h1>
        <h3>
          Enter Serial Number
          <input type="text" name="snum" placeholder="ex 11,12,13,14,15" />
        </h3>
        <h3>Enter Subject Name <input type="text" name="sname" /></h3>
        <h3>Enter Marks <input type="text" name="smarks" /></h3>
        <input type="submit" value="Submit" />
        <input type="reset" name="Reset" />
      </center>
    </form>
  </body>
</html>
""",
      "slip16Q1B.php": """<?php
$sno = $_POST['snum'];
$sname = $_POST['sname'];
$marks = $_POST['smarks'];
$sno = explode(',',$sno);
$subname = explode(',',$sname);
$smarks = explode(',',$marks);
$total = (($smarks[0]+$smarks[1]+$smarks[2]+$smarks[3]+$smarks[4]));
$per=$total/5;
if($per>=70)
$grade="A";
elseif($per>=60)
$grade="B";
elseif($per>=50)
$grade="C";
elseif ($per>=40)
 $grade="D";
else
$grade="F";
echo "<table align=center border=1>";
echo "<tr>
<th> <b> Serial Number </b> </th>
<th> <b> Subject Name </b> </th>
<th> <b> Marks </b> </th>
</tr>";
for($i=0;$i<5;$i++)
echo "<tr>
<td>".$sno[$i]."</td>
<td>".$subname[$i]."</td>
<td>".$smarks[$i]."</td>
</tr>";
echo "<tr> <th colspan=2> Total Marks </th><td>".$total."</td> </tr>";
echo "<tr> <th colspan=2> Percentage:- </th> <td>" .$per. "</td> </tr>";
echo "<tr> <th colspan=2> Grade:- </th> <td>" .$grade. "</td> </tr>";
echo "</table>";
?>""",
      "slip16Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Lists\n",
              "subjects = ['Math', 'Physics', 'Chemistry', 'Biology', 'English']\n",
              "marks = [85, 78, 90, 75, 80]\n",
              "\n",
              "# Pie chart\n",
              "plt.pie(marks, labels=subjects, autopct='%1.1f%%')\n",
              "plt.title('Marks Distribution - Pie Chart')\n",
              "plt.show()\n",
              "\n",
              "# Bar chart\n",
              "plt.bar(subjects, marks, color='skyblue')\n",
              "plt.title('Marks Distribution - Bar Chart')\n",
              "plt.xlabel('Subjects')\n",
              "plt.ylabel('Marks')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip16Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "# Create DataFrame\n",
              "data = {\n",
              "    'Name': ['John', 'Alice', 'Bob', 'Eva', 'David'],\n",
              "    'Graduation_Percentage': [85, 90, 78, 92, 88],\n",
              "    'Age': [22, 23, 21, 24, 22]\n",
              "}\n",
              "\n",
              "df = pd.DataFrame(data)\n",
              "\n",
              "# Display DataFrame\n",
              "print(\"Students DataFrame:\")\n",
              "print(df)\n",
              "\n",
              "# Compute averages\n",
              "avg_age = df['Age'].mean()\n",
              "avg_percentage = df['Graduation_Percentage'].mean()\n",
              "\n",
              "print(\"\\nAverage Age of Students:\", avg_age)\n",
              "print(\"Average Graduation Percentage:\", avg_percentage)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 17,
    "questions": [
      {
        "question": """Write a PHP script to sort the following associative array : array(“Sagar"=>"31","Vicky"=>"41","Leena"=>"39","Ramesh"=>"40") in
a)	ascending order sort by Value
b)	ascending order sort by Key
c)	descending order sorting by Value
d)	descending order sorting by Key
""",
        "filenames": ["slip17Q1.php"]
      },
      {
        "question": """Write a Python program to draw scatter plots to compare two features of the iris dataset""",
        "filenames": ["slip17Q2A.ipynb"]
      },
      {
        "question": """Write a Python program to create a data frame containing columns name, age , salary, department . Add 10 rows to the data frame. View the data frame""",
        "filenames": ["slip17Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip17Q1.php": """<?php
$data=array("Sagar"=>"31","Vicky"=>"41","Leena"=>"39","Ramesh"=>"40");
echo " Original array is :- Sagar=>31,Vicky=>41,Leena=>39,Ramesh=>40 <br>";
echo "Ascending order sort by Value <br>";
asort($data);
foreach ($data as $k=>$v)
{
echo "$v <br>";
}
echo "Ascending order sort by Key <br>";
ksort($data);
foreach ($data as $k=>$v)
{
echo "$k <br>";
}
echo "Descending order sorting by Value <br>";
arsort($data);
foreach ($data as $k=>$v)
{
echo "$v <br>";
}
echo "Descending order sorting by Key <br>";
krsort($data);
foreach ($data as $k=>$v)
{
echo "$k <br>";
}
?>""",
      "slip17Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Load the Iris dataset\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "print(df)\n",
              "\n",
              "# Scatter plot: Sepal Length vs Sepal Width\n",
              "plt.scatter(df['SepalLengthCm'], df['SepalWidthCm'])\n",
              "plt.xlabel('Sepal Length')\n",
              "plt.ylabel('Sepal Width')\n",
              "plt.title('Sepal Length vs Sepal Width')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip17Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "data = {\n",
              "    'Name': ['John', 'Alice', 'Bob', 'Eva', 'David', 'Frank', 'Grace', 'Helen', 'Irene', 'Jack'],\n",
              "    'Age': [25, 30, 28, 35, 32, 29, 40, 31, 27, 26],\n",
              "    'Salary': [50000, 60000, 55000, 75000, 62000, 58000, 60000, 59000, 57000, 56000],\n",
              "    'Department': ['HR', 'IT', 'Finance', 'HR', 'IT', 'Finance', 'IT', 'HR', 'Finance', 'IT']\n",
              "}\n",
              "\n",
              "df = pd.DataFrame(data)\n",
              "\n",
              "print(df)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 18,
    "questions": [
      {
        "question": """Write a menu driven program to perform the following operations on an associative array
a.	Reverse the order of each element‟s key-value pair.
b.	Traverse the element in an array in random order.
c.	Convert the array elements into individual variables.
d.	Display the elements of an array along with key.
""",
        "filenames": ["slip18Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip18Q1B.php"]
      },
      {
        "question": """Write a Python program to create box plots to see how each feature i.e. Sepal Length, Sepal Width, Petal Length, Petal Width are distributed across the three species. (Use iris.csv dataset)""",
        "filenames": ["slip18Q2A.ipynb"]
      },
      {
        "question": """Use the heights and weights dataset and load the dataset from a given csv file into a dataframe. Print the first, last 5 rows and random 10 row""",
        "filenames": ["slip18Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip18Q1A.html": """<html>
  <head>
    <title>operations on an associative array</title>
  </head>
  <body>
    <form action="slip18Q1B.php" method="POST">
      <input type="radio" name="op" value="a" /> Reverse the order of each
      element‟s key-value pair. <br />
      <br />
      <input type="radio" name="op" value="b" /> Traverse the element in an
      array in random order. <br />
      <br />
      <input type="radio" name="op" value="c" /> Convert the array elements into
      individual variables. <br />
      <br />
      <input type="radio" name="op" value="d" /> Display the elements of an
      array along with key. <br />
      <br />
      <input type="submit" name="Submit" />
      <input type="reset" name="Reset" />
    </form>
  </body>
</html>
""",
      "slip18Q1B.php": """<?php $op=$_POST['op'];
$data=array("Sagar"=>"31","Vicky"=>"41","Leena"=>"39","Ramesh"=>"40");
switch($op)
{
case 'a':
echo "Original Array data :<br>";
print_r($data);
$result=array_flip($data);
echo "<br> Flipped Array data :<br>" ;
print_r($result);
break;
case 'b':
echo "Original Array data :<br>";
print_r($data);
$result=$data;
shuffle($result);
echo "<br> Shuffled Array data :<br>" ;
print_r($result);
break;
case 'c':
echo "Original Array data :<br>";
print_r($data);
$result=$data;
extract($result);
echo "<br> Extracting array elements in to individual variables :<br>" ;
echo "<br> \$Sagar = $Sagar; \$Vicky = $Vicky; \$Leena = $Leena \$Ramesh=
$Ramesh";
echo "<br> $Sagar"; break; case 'd': echo "Original Array data :<br>";
foreach($data as $k => $v)
{
echo "<br>Key is =$k value is =$v";
}
break;
}
?>""",
      "slip18Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "print(df)\n",
              "\n",
              "features = ['SepalLengthCm', 'SepalWidthCm', 'PetalLengthCm', 'PetalWidthCm']\n",
              "\n",
              "for feature in features:\n",
              "    df.boxplot(column=feature, by='Species')\n",
              "    plt.title(f'{feature} distribution by Species')\n",
              "    plt.suptitle('')\n",
              "    plt.xlabel('Species')\n",
              "    plt.ylabel(feature)\n",
              "    plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip18Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "\n",
              "# Load the dataset\n",
              "df = pd.read_csv(\"HeightWeight.csv\")\n",
              "\n",
              "print(\"First 5 rows:\")\n",
              "print(df.head())\n",
              "\n",
              "print(\"\\nLast 5 rows:\")\n",
              "print(df.tail())\n",
              "\n",
              "print(\"\\nRandom 10 rows:\")\n",
              "print(df.sample(10))"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 19,
    "questions": [
      {
        "question": """Write a PHP script to accept 2 strings from the user, the first string should be a sentence and second can be a word.
a.	Delete a small part from first string after accepting position and number of characters to remove.
b.	Insert the given small string in the given big string at specified position without removing any characters from the big string.
c.	Replace some characters/ words from given big string with the given small string at specified position.""",
        "filenames": ["slip19Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip19Q1B.php"]
      },
      {
        "question": """1.	To create a dataframe containing columns name, age and percentage. Add 10 rows to the dataframe. View the dataframe.
2.	To print the shape, number of rows-columns, data types, feature names and the description of the data
3.	To Add 5 rows with duplicate values and missing values. Add a column „remarks‟ with empty values. Display the data.
""",
        "filenames": ["slip19Q2.ipynb"]
      },
    ],
    "answers": {
      "slip19Q1A.html": """<html>
<title>String Operations</title>
</head>
<body>
 <form method="POST" action="slip19Q1B.php">
 <label for="sentence">Enter a sentence:</label>
 <input type="text" name="sentence" id="sentence" required><br>
 <label for="word">Enter a word to insert and replace:</label>
 <input type="text" name="word" id="word" required><br>
 <label for="position">Position to remove:</label>
 <input type="number" name="position" id="position" required><br>
 <label for="remove">Number of characters to remove:</label>
 <input type="number" name="remove" id="remove" required><br>
 <label for="replacePosition">Position to replace:</label>
 <input type="number" name="replacePosition" id="replacePosition" required><br>
 <input type="submit" value="Submit">
 </form>
</body>
</html>""",
      "slip19Q1B.php": """<?php
 $sentence = $_POST['sentence'];
 $word = $_POST['word'];
 $position = $_POST['position'];
 $charactersToRemove = $_POST['remove'];
 $replacePosition = $_POST['replacePosition'];

 $sentence = substr_replace($sentence, '', $position, $charactersToRemove);

 $sentence = substr_replace($sentence, $word, $position, 0);

 $sentence = substr_replace($sentence, $word, $replacePosition, strlen($word));
 echo "Modified Sentence: " . $sentence;
?>""",
      "slip19Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import numpy as np\n",
              "\n",
              "data = {\n",
              "    'Name': ['John', 'Alice', 'Bob', 'Eva', 'David', 'Frank', 'Grace', 'Helen', 'Irene', 'Jack'],\n",
              "    'Age': [22, 23, 21, 24, 22, 25, 23, 21, 24, 22],\n",
              "    'Percentage': [85, 90, 78, 92, 88, 80, 95, 87, 89, 91]\n",
              "}\n",
              "\n",
              "df = pd.DataFrame(data)\n",
              "\n",
              "print(\"Original DataFrame:\\n\", df)\n",
              "\n",
              "print(\"\\nShape of DataFrame:\", df.shape)\n",
              "print(\"Number of rows:\", df.shape[0])\n",
              "print(\"Number of columns:\", df.shape[1])\n",
              "print(\"\\nData Types:\\n\", df.dtypes)\n",
              "print(\"\\nFeature Names:\", df.columns.tolist())\n",
              "print(\"\\nDescription of Data:\\n\", df.describe())\n",
              "\n",
              "new_rows = pd.DataFrame({\n",
              "    'Name': ['John', 'Alice', None, 'Eva', 'Frank'],\n",
              "    'Age': [22, None, 21, 24, None],\n",
              "    'Percentage': [85, 90, None, None, 80]\n",
              "})\n",
              "\n",
              "df['Remarks'] = ''\n",
              "\n",
              "df = pd.concat([df, new_rows], ignore_index=True)\n",
              "\n",
              "print(\"\\nDataFrame after adding new rows and Remarks column:\\n\", df)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },
  {
    "slipNo": 20,
    "questions": [
      {
        "question": """Write a menu driven program to perform the following operations on associative arrays:
a)	Split an array into chunks
b)	Sort the array by values without changing the keys.
c)	Filter the even elements from an array.
""",
        "filenames": ["slip20Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip20Q1B.php"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options Add two outliers to the above data and display the box plot.""",
        "filenames": ["slip20Q2.ipynb"]
      },
    ],
    "answers": {
      "slip20Q1A.html": """<html>
  <head>
    <title>operations on an associative array</title>
  </head>
  <body>
    <form action="slip20Q1B.php" method="POST">
      <input type="radio" name="op" value="a" /> Split an array into chunks
      <br />
      <br />
      <input type="radio" name="op" value="b" /> Sort the array by values
      without changing the keys. <br />
      <br />
      <input type="radio" name="op" value="c" />Filter the even elements from an
      array. <br />
      <br />
      <input type="submit" name="Submit" />
      <input type="reset" name="Reset" />
    </form>
  </body>
</html>
""",
      "slip20Q1B.php": """<?php
$op=$_POST['op'];
$data=array("Sagar"=>"30","Vicky"=>"41","Leena"=>"39","Ramesh"=>"40","gautam"=>"45",
"gajanan"=>"50");
switch($op)
{
case 'a':
echo "Original Array data :<br>";
print_r($data);
$result=array_chunk($data,2);
echo "<br> Split an array into chunks :<br>" ;
print_r($result);
break;
case 'b':
echo "Original Array data :<br>";
print_r($data);
asort($data);
echo "<br> Sort the array by values without changing the keys. :<br>" ;
print_r($data);
break;
case 'c': echo "Original Array data :<br>";
print_r($data);
function iseven($element)
{
return($element%2==0);
}
$even=array_filter($data, "iseven");
echo "<br> Filter the even elements from an array. :<br>" ;
print_r($even);
break;
case 'default':
echo "Enter correct option"; break;
}
?>""",
      "slip20Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Generate random array of 50 integers\n",
              "data = np.random.randint(1, 101, 50)\n",
              "x = np.arange(1, 51)\n",
              "\n",
              "# Line Chart\n",
              "plt.plot(x, data, color='blue', marker='o')\n",
              "plt.title('Line Chart')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Scatter Plot\n",
              "plt.scatter(x, data, color='red')\n",
              "plt.title('Scatter Plot')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Histogram\n",
              "plt.hist(data, bins=10, color='green', edgecolor='black')\n",
              "plt.title('Histogram')\n",
              "plt.xlabel('Value')\n",
              "plt.ylabel('Frequency')\n",
              "plt.show()\n",
              "\n",
              "# Box Plot\n",
              "plt.boxplot(data, patch_artist=True, boxprops=dict(facecolor='orange'))\n",
              "plt.title('Box Plot')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 21,
    "questions": [
      {
        "question": """Create an array of 15 high temperatures, approximating the weather for a spring month, then find the average high temp, the five warmest high temps Display the result on the browser.
""",
        "filenames": ["slip21Q1.php"]
      },
      {
        "question": """A) Import dataset “iris.csv”. Write a Python program to create a Bar plot to get the frequency of the three species of the Iris data.	B)Write a Python program to create a histogram of the three species of the Iris data.
""",
        "filenames": ["slip21Q2.ipynb"]
      },

    ],
    "answers": {
      "slip21Q1.php": """<?php
$temp=array(35,45,50,44,42,36,38,30,40,47,60,48,24,38,36);
rsort($temp);
echo "Average high temp is:- <br> <br>";
$total=array_sum($temp);
$avgtemp=round(($total/15),2);
echo "$avgtemp&deg; <br> <br>";
$t=array_slice($temp,0,5);
echo "<br> <br>Five warmest high temps :- <br> <br>";
foreach($t as $v)
echo "$v&deg <br>";
?>""",
      "slip21Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Load dataset\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "\n",
              "# Bar Plot for frequency of species\n",
              "species_counts = df['Species'].value_counts()\n",
              "plt.bar(species_counts.index, species_counts.values, color=['red', 'green', 'blue'])\n",
              "plt.xlabel('Species')\n",
              "plt.ylabel('Frequency')\n",
              "plt.title('Frequency of Iris Species (Bar Plot)')\n",
              "plt.show()\n",
              "\n",
              "# Histogram for species\n",
              "plt.hist(df['Species'], color='skyblue', edgecolor='black')\n",
              "plt.xlabel('Species')\n",
              "plt.ylabel('Frequency')\n",
              "plt.title('Histogram of Iris Species')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 22,
    "questions": [
      {
        "question": """Write a menu driven program to perform the following queue related operations
a)	Insert an element in queue
b)	Delete an element from queue
c)	Display the contents of queue
""",
        "filenames": ["slip22Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip22Q1B.php"]
      },
      {
        "question": """Dataset Name: winequality-red.csv	[15]
Write a program in python to perform following tasks
a.	Rescaling: Normalised the dataset using MinMaxScaler class
b.	Standardizing Data (transform them into a standard Gaussian distribution with a mean of 0 and a standard deviation of 1)
c.	Normalizing Data ( rescale each observation to a length of 1 (a unit norm). For this, use the Normalizer class.)
""",
        "filenames": ["slip22Q2.ipynb"]
      },
    ],
    "answers": {
      "slip22Q1A.html": """<html>
  <head>
    <title>queue related operations</title>
  </head>
  <body>
    <form action="slip22Q1B.php" method="POST">
      <input type="radio" name="op" value="a" /> Insert an element in queue
      <br />
      <br />
      <input type="radio" name="op" value="b" /> Delete an element from queue
      <br />
      <br />
      <input type="radio" name="op" value="c" /> Display the contents of queue
      <br />
      <br />
      <input type="submit" name="Submit" />
      <input type="reset" name="Reset" />
    </form>
  </body>
</html>
""",
      "slip22Q1B.php": """<?php
$op=$_POST['op'];
$queue=array(1,2,3,4);
switch($op)
{
case 'a':
echo "Insert an element in queue :<br>";
array_shift($queue);
var_dump($queue);
break;
case 'b':
echo "Delete an element from queue :<br>";
array_unshift($queue,100);
var_dump($queue);
break;
case 'c':
echo "Display the contents of queue :<br>";
var_dump($queue);
break;
case 'default':
echo "Enter Correct Choice :<br>";
break;
}
?>""",
      "slip22Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "from sklearn.preprocessing import MinMaxScaler, StandardScaler, Normalizer\n",
              "\n",
              "# Load dataset\n",
              "df = pd.read_csv(\"winequality-red.csv\")\n",
              "\n",
              "# Select numeric columns for processing\n",
              "data = df.select_dtypes(include=['float64', 'int64'])\n",
              "\n",
              "# a) Rescaling using MinMaxScaler\n",
              "scaler = MinMaxScaler()\n",
              "data_rescaled = scaler.fit_transform(data)\n",
              "print(\"Rescaled Data (Min-Max):\")\n",
              "print(pd.DataFrame(data_rescaled, columns=data.columns).head())\n",
              "\n",
              "# b) Standardizing data using StandardScaler\n",
              "standardizer = StandardScaler()\n",
              "data_standardized = standardizer.fit_transform(data)\n",
              "print(\"\\nStandardized Data (Mean=0, Std=1):\")\n",
              "print(pd.DataFrame(data_standardized, columns=data.columns).head())\n",
              "\n",
              "# c) Normalizing data using Normalizer (unit norm)\n",
              "normalizer = Normalizer()\n",
              "data_normalized = normalizer.fit_transform(data)\n",
              "print(\"\\nNormalized Data (Unit Norm):\")\n",
              "print(pd.DataFrame(data_normalized, columns=data.columns).head())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },
  {
    "slipNo": 23,
    "questions": [
      {
        "question": """Write a menu driven program to perform the following stack related operations:
a)	Insert an element in stack
b)	Delete an element from stack
c)	Display the contents of stack
""",
        "filenames": ["slip23Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip23Q1B.php"]
      },
      {
        "question": """Q.2)	Dataset Name: winequality-red.csv	[15]
Write a program in python to perform following task
a.	Rescaling: Normalised the dataset using MinMaxScaler class
b.	Standardizing Data (transform them into a standard Gaussian distribution with a mean of 0 and a standard deviation of 1)
c.	Binarizing Data using we use the Binarizer class (Using a binary threshold, it is possible to transform our data by marking the values above it 1 and those equal to or below it, 0)
""",
        "filenames": ["slip23Q2.ipynb"]
      },
    ],
    "answers": {
      "slip23Q1A.html": """<html>
  <head>
    <title>stack related operations</title>
  </head>
  <body>
    <form action="slip23Q1B.php" method="POST">
      Enter element to push <input type="text" name="t1" /> <br />
      <br />
      <input type="radio" name="op" value="a" /> Insert an element in stack
      <br />
      <br />
      <input type="radio" name="op" value="b" /> Delete an element from stack
      <br />
      <br />
      <input type="radio" name="op" value="c" /> Display the contents of stack
      <br />
      <br />
      <input type="submit" name="Submit" />
      <input type="reset" name="Reset" />
    </form>
  </body>
</html>
""",
      "slip23Q1B.php": """<?php
$op=$_POST['op'];
$t1=$_POST['t1'];
$stack=array(1,2,3,4,5);
switch($op)
{
case 'a':
echo "Insert an element in stack :<br>";
array_push($stack,$t1);
var_dump($stack);
break;
case 'b':
echo "Delete an element from stack :<br>";
array_pop($stack);
var_dump($stack);
break;
case 'c':
echo "Display the contents of stack :<br>";
var_dump($stack);
break;
case 'default':
echo "Enter Correct Choice :<br>";
break;
}
?>""",
      "slip23Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "from sklearn.preprocessing import MinMaxScaler, StandardScaler, Binarizer\n",
              "\n",
              "# Load dataset\n",
              "df = pd.read_csv(\"winequality-red.csv\")\n",
              "\n",
              "# Select numeric columns for processing\n",
              "data = df.select_dtypes(include=['float64', 'int64'])\n",
              "\n",
              "# a) Rescaling using MinMaxScaler\n",
              "scaler = MinMaxScaler()\n",
              "data_rescaled = scaler.fit_transform(data)\n",
              "print(\"Rescaled Data (Min-Max):\")\n",
              "print(pd.DataFrame(data_rescaled, columns=data.columns).head())\n",
              "\n",
              "# b) Standardizing data using StandardScaler\n",
              "standardizer = StandardScaler()\n",
              "data_standardized = standardizer.fit_transform(data)\n",
              "print(\"\\nStandardized Data (Mean=0, Std=1):\")\n",
              "print(pd.DataFrame(data_standardized, columns=data.columns).head())\n",
              "\n",
              "# c) Binarizing data using Binarizer\n",
              "# Example threshold = 0.5 (for rescaled data)\n",
              "binarizer = Binarizer(threshold=0.5)\n",
              "data_binarized = binarizer.fit_transform(data_rescaled)  # using rescaled data\n",
              "print(\"\\nBinarized Data (Threshold=0.5):\")\n",
              "print(pd.DataFrame(data_binarized, columns=data.columns).head())"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 24,
    "questions": [
      {
        "question": """Write a PHP program to read two file names from user and append content of first file into second file.""",
        "filenames": ["slip24Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip24Q1B.php"]
      },
      {
        "question": "",
        "filenames": ["data1.txt"]
      },
      {
        "question": "",
        "filenames": ["data2.txt"]
      },
      {
        "question": """Import dataset “iris.csv”. Write a Python program to create a Bar plot to get the frequency of the three species of the Iris data. Write a Python program to create a histogram of the three species of the Iris data""",
        "filenames": ["slip24Q2.ipynb"]
      },
    ],
    "answers": {
      "data1.txt": """Import dataset “iris.csv”. Write a Python program to create a Bar plot to get the frequency of the three species of the Iris data. Write a Python program to create a histogram of the three species of the Iris data""",
      "data2.txt": "",
      "slip24Q1A.html": """<html>
<head>
<title> Append content of first file into second file </title>
</head>
<form action=slip24Q1B.php method=post>
Enter First File Name:- <input type="text" name=ffile> <br> <br>
Enter second File Name:- <input type="text" name=sfile> <br> <br>
<input type="submit" name="Submit" value="Append">
<input type="reset" name="Reset">
</form>
</body>
</html>""",
      "slip24Q1B.php": """<?php
$sfile=$_POST['ffile'];
$dfile=$_POST['sfile'];
$fp1=fopen($sfile,"r");
$fp2=fopen($dfile,"a");
// Method 1
$d=fread($fp1,filesize($sfile));
fwrite($fp2,$d);
// Method 2
fwrite($fp2,fread($fp1,filesize($sfile)));
echo "Appended content of $sfile file into $dfile file";
fclose($fp1);
fclose($fp2);
?>""",
      "slip24Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Load dataset\n",
              "df = pd.read_csv(\"iris.csv\")\n",
              "\n",
              "# Bar Plot for frequency of species\n",
              "species_counts = df['Species'].value_counts()\n",
              "plt.bar(species_counts.index, species_counts.values, color=['red', 'green', 'blue'])\n",
              "plt.xlabel('Species')\n",
              "plt.ylabel('Frequency')\n",
              "plt.title('Frequency of Iris Species (Bar Plot)')\n",
              "plt.show()\n",
              "\n",
              "# Histogram for species\n",
              "plt.hist(df['Species'], color='skyblue', edgecolor='black')\n",
              "plt.xlabel('Species')\n",
              "plt.ylabel('Frequency')\n",
              "plt.title('Histogram of Iris Species')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 25,
    "questions": [
      {
        "question": """Write a menu driven program to perform various file operations. Accept filename from user.	[15]
a)	Display type of file.
b)	Display last modification time of file
c)	Display the size of file
d)	Delete the file
""",
        "filenames": ["slip25Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip25Q1B.php"]
      },
      {
        "question": "",
        "filenames": ["data.txt"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options.""",
        "filenames": ["slip25Q2A.ipynb"]
      },
      {
        "question": """Create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in a pie chart.""",
        "filenames": ["slip25Q2B.ipynb"]
      },
    ],
    "answers": {
      "data.txt": """Create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in a pie chart.""",
      "slip25Q1A.html": """<html>
<head>
<title> Menu driven program to perform various file operations </title>
</head>
<form action=slip25Q1B.php method=post>
Enter File Name:- <input type="text" name=file> <br> <br>
<input type="radio" name="op" value="a"> Display type of file. <br> <br>
<input type="radio" name="op" value="b"> Display last modification time of file <br> <br>
<input type="radio" name="op" value="c"> Display the size of file <br> <br>
<input type="radio" name="op" value="d"> Delete the file <br> <br>
<input type="submit" name="Submit" value="File Oprations">
<input type="reset" name="Reset">
</form>
</body>
</html>""",
      "slip25Q1B.php": """<?php
$op=$_POST['op'];
$file=$_POST['file'];
switch($op)
{
case 'a':
$filetype=filetype($file);
echo "Type of File is:- $filetype";
break;
case 'b':
$lmodtime=filemtime($file);
echo "last modification time of file is:- $lmodtime";
break;
case 'c':
$fsize=filesize($file);
echo "Size of file is:- $fsize Bytes";
break;
case 'd':
unlink($file);
break;
case 'default':
echo "Enter correct option";
break;
}
?>""",
      "slip25Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "data = np.random.randint(1, 101, 50)\n",
              "x = np.arange(1, 51)\n",
              "\n",
              "# Line chart\n",
              "plt.plot(x, data, color='blue', marker='o')\n",
              "plt.title('Line Chart')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Scatter plot\n",
              "plt.scatter(x, data, color='red')\n",
              "plt.title('Scatter Plot')\n",
              "plt.xlabel('Index')\n",
              "plt.ylabel('Value')\n",
              "plt.show()\n",
              "\n",
              "# Histogram\n",
              "plt.hist(data, bins=10, color='green', edgecolor='black')\n",
              "plt.title('Histogram')\n",
              "plt.xlabel('Value')\n",
              "plt.ylabel('Frequency')\n",
              "plt.show()\n",
              "\n",
              "# Box plot\n",
              "plt.boxplot(data, patch_artist=True, boxprops=dict(facecolor='orange'))\n",
              "plt.title('Box Plot')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip25Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Lists\n",
              "subjects = ['Math', 'Physics', 'Chemistry', 'Biology', 'English']\n",
              "marks = [85, 78, 90, 75, 80]\n",
              "\n",
              "# Pie chart\n",
              "plt.pie(marks, labels=subjects, autopct='%1.1f%%')\n",
              "plt.title('Marks Distribution')\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },
  {
    "slipNo": 26,
    "questions": [
      {
        "question": """Consider the following entities and their relationship.	[15] Doctor ( doc_no, dname, address ,city ,area)
Hospital (hosp_no, hname, hcity)
Doctor-Hospital related with many-one relationship. Create a RDB in 3NF for above and solve the following.
Using above database write a script in PHP to print the Doctor visiting to the Hospital in tabular format. Accept Hospital name from user.
""",
        "filenames": ["slip26Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip26Q1B.php"]
      },
      {
        "question": """Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options.""",
        "filenames": ["slip26Q2A.ipynb"]
      },
      {
        "question": """Create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in bar chart.""",
        "filenames": ["slip26Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip26Q1A.html": """<html>
  <head>
    <title>Doctor visiting to the Hospital</title>
  </head>
  <body>
    <form action="slip26Q1B.php" method="POST">
      Enter Hospital Name:- <input type="text" name="hname" /> <br />
      <input type="submit" value="Hospital Name" />
      <input type="reset" value="Reset" />
    </form>
  </body>
</html>
""",
      "slip26Q1B.php": """<?php
$db=pg_connect("host=172.16.6.1 dbname=php21200 user=php21200 password=''");
$hname=$_POST['hname'];
if($db)
echo "connect <br>";
else
echo "error";
$q="select doctor.docno,dname from doctor,hospital where hospital.hospno=doctor.hospno and hname='$hname';";
$r=pg_exec($db,$q);
echo "<h1 align=center> Doctor visiting to the Hospital </h1>";
echo "<table border=2 bgcolor=red align=center>";
echo "<tr> <th> Doctor No </th> <th> Doc Name </th> <th> City </th></tr>";
while ($row=pg_fetch_array($r))
{
echo "<tr>";
echo "<td> $row[0] </td>";
echo "<td> $row[1] </td>";
echo "<td> $row[2] </td>";
echo "</tr>";
}
echo "</table>";
pg_close($db);
?>

*/

create table hospital(hospno int primary key,hname varchar(20),hcity varchar(10));

insert into hospital values(1,'life line','baramati');
insert into hospital values(2,'star','pune');
insert into hospital values(3,'city care','baramati');
insert into hospital values(4,'life care','pune');
insert into hospital values(5,'shree','baramati');

create table doctor(docno int primary key,dname varchar(20),address varchar(10),city varchar(10),area varchar(10),hospno int references hospital(hospno) on delete cascade on update set null );

insert into doctor values(1,'dhane','station rd','baramati','rural',1);
insert into doctor values(2,'kudale','cinema rd','pune','urban',2);
insert into doctor values(3,'joshi','main rd','baramati','rural',3);
insert into doctor values(4,'wable','cinema rd','pune','urban',4);
insert into doctor values(5,'rode','station rd','baramati','rural',5);


/*""",
      "slip26Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "data = np.random.randint(10, 100, 50)\n",
              "\n",
              "plt.figure(figsize=(12, 10))\n",
              "\n",
              "# Line Chart\n",
              "plt.subplot(2, 2, 1)\n",
              "plt.plot(data, marker='o', color='blue', linestyle='-', linewidth=2, markersize=6)\n",
              "plt.title(\"Line Chart of Random Integers\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "plt.grid(True, linestyle='--', alpha=0.6)\n",
              "\n",
              "# Scatter Plot\n",
              "plt.subplot(2, 2, 2)\n",
              "plt.scatter(range(len(data)), data, color='green', marker='x', s=80)\n",
              "plt.title(\"Scatter Plot of Random Integers\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "plt.grid(True, linestyle='--', alpha=0.6)\n",
              "\n",
              "# Histogram\n",
              "plt.subplot(2, 2, 3)\n",
              "plt.hist(data, bins=10, color='orange', edgecolor='black', alpha=0.7)\n",
              "plt.title(\"Histogram of Random Integers\")\n",
              "plt.xlabel(\"Value Range\")\n",
              "plt.ylabel(\"Frequency\")\n",
              "plt.grid(True, linestyle='--', alpha=0.6)\n",
              "\n",
              "# Box Plot\n",
              "plt.subplot(2, 2, 4)\n",
              "plt.boxplot(data, patch_artist=True, boxprops=dict(facecolor=\"lightblue\"))\n",
              "plt.title(\"Box Plot of Random Integers\")\n",
              "plt.ylabel(\"Value\")\n",
              "plt.grid(True, linestyle='--', alpha=0.6)\n",
              "\n",
              "# Adjust layout\n",
              "plt.tight_layout()\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip26Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Two lists\n",
              "subjects = [\"Math\", \"Science\", \"English\", \"History\", \"Geography\"]\n",
              "marks = [85, 90, 78, 88, 76]\n",
              "\n",
              "# Bar chart\n",
              "plt.bar(subjects, marks)\n",
              "plt.title(\"Marks in Subjects\")\n",
              "plt.xlabel(\"Subjects\")\n",
              "plt.ylabel(\"Marks\")\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 27,
    "questions": [
      {
        "question": """Write a PHP program to read two file names from user and copy the content of first file into second file.""",
        "filenames": ["slip27Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip27Q1B.php"]
      },
      {
        "question": "",
        "filenames": ["data1.txt"]
      },
      {
        "question": "",
        "filenames": ["data2.txt"]
      },
      {
        "question": """Create a dataset data.csv having two categorical column (the country column, and the purchased column).
a.	Apply OneHot coding on Country column.
b.	Apply Label encoding on purchased column
""",
        "filenames": ["slip27Q2.ipynb"]
      },
    ],
    "answers": {
      "data1.txt": """select student.sid,name,class from student,competition,studcomp where student.sid=studcomp.sid and competition.cno=studcomp.cno and rank=1 and cname""",
      "data2.txt": "",
      "slip27Q1A.html": """<html>
<head>
<title> copy content of first file into second file </title>
</head>
<form action=slip27Q1B.php method=post>
Enter First File Name:- <input type="text" name=ffile> <br> <br>
Enter second File Name:- <input type="text" name=sfile> <br> <br>
<input type="submit" name="Submit" value="Copy">
<input type="reset" name="Reset">
</form>
</body>
</html>
""",
      "slip27Q1B.php": """<?php
$sfile=$_POST['ffile'];
$dfile=$_POST['sfile'];
$fp1=fopen($sfile,"r");
$fp2=fopen($dfile,"w");
// Method 1 $d=fread($fp1,filesize($sfile));
fwrite($fp2,$d);
// Method 2
fwrite($fp2,fread($fp1,filesize($sfile)));
echo " $sfile file is copied into $dfile file";
fclose($fp1);
fclose($fp2);
?>""",
      "slip27Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "from sklearn.preprocessing import OneHotEncoder, LabelEncoder\n",
              "\n",
              "# Load dataset\n",
              "df = pd.read_csv(\"data.csv\")\n",
              "print(\"Original Data:\\n\", df)\n",
              "\n",
              "# a. Apply OneHot encoding on Country column\n",
              "onehot = OneHotEncoder()\n",
              "country_encoded = onehot.fit_transform(df[[\"country\"]]).toarray()\n",
              "country_df = pd.DataFrame(country_encoded, columns=onehot.get_feature_names_out([\"country\"]))\n",
              "\n",
              "# b. Apply Label encoding on Purchased column\n",
              "label = LabelEncoder()\n",
              "df[\"Purchased_Encoded\"] = label.fit_transform(df[\"purchased\"])\n",
              "\n",
              "# Combine results\n",
              "final_df = pd.concat([country_df, df[[\"purchased\", \"Purchased_Encoded\"]]], axis=1)\n",
              "print(\"\\nTransformed Data:\\n\", final_df)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 28,
    "questions": [
      {
        "question": """Write a program to read a flat file “student.dat”, calculate the percentage and display the data from file in tabular format.(Student.dat file contains rollno, name, OS, WT, DS, Python, Java, CN )""",
        "filenames": ["slip28Q1.php"]
      },
      {
        "question": "",
        "filenames": ["student.dat"]
      },
      {
        "question": """Write a Python program
1.	To create a dataframe containing columns name, age and percentage. Add 10 rows to the dataframe. View the dataframe.
2.	To print the shape, number of rows-columns, data types, feature names and the description of the data.
3.	To view basic statistical details of the data.
4.	To Add 5 rows with duplicate values and missing values. Add a column „remarks‟ with empty values. Display the data.
""",
        "filenames": ["slip28Q2A.ipynb"]
      },
    ],
    "answers": {
      "student.dat": """1 gautam 45 42 44 43 40 38
2 gajanan 42 42 48 43 45 37
3 amol 45 42 43 46 41 31
4 gauri 43 44 41 43 47 35
5 kiran 41 42 42 45 43 36""",
      "slip28Q1.php": """<?php
$fp=fopen("student.dat","r");
echo "<table border=2 color=red>";
echo "<tr>
<th> Roll No </th>
<th> Name </th>
<th> OS </th>
<th> WT </th>
<th> DS </th>
<th> Python </th>
<th> JAVA </th>
<th> CN </th>
<th> Total </th>
<th> Percentage</th>
</tr>";
while(($r=fscanf($fp,"%d %s %d %d %d %d %d %d"))!=NULL)
{
$total= $r[2]+$r[3]+$r[4]+$r[5]+$r[6]+$r[7];
$per=round(($total/6.0),2);
echo "<tr>
<td> $r[0] </td>
<td> $r[1] </td>
<td> $r[2] </td>
<td> $r[3] </td>
<td> $r[4] </td>
<td> $r[5] </td>
<td> $r[6] </td>
<td> $r[7] </td>
<td> $total </td>
<td> $per </td>
 </tr>";
}
echo "</table>";
fclose($fp);
?>""",
      "slip28Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "import numpy as np\n",
              "\n",
              "data = {\n",
              "    \"Name\": [\"Amit\", \"Neha\", \"Rahul\", \"Priya\", \"Ravi\", \"Sneha\", \"Arjun\", \"Kiran\", \"Pooja\", \"Raj\"],\n",
              "    \"Age\": [21, 22, 23, 21, 24, 22, 23, 25, 24, 22],\n",
              "    \"Percentage\": [78, 85, 67, 90, 76, 82, 88, 69, 95, 80]\n",
              "}\n",
              "df = pd.DataFrame(data)\n",
              "print(\"1. DataFrame:\\n\", df)\n",
              "\n",
              "print(\"\\n2. Shape of DataFrame:\", df.shape)\n",
              "print(\"Number of Rows:\", df.shape[0])\n",
              "print(\"Number of Columns:\", df.shape[1])\n",
              "print(\"\\nData Types:\\n\", df.dtypes)\n",
              "print(\"\\nFeature Names (Columns):\", df.columns.tolist())\n",
              "print(\"\\nDescription of Data:\\n\", df.describe(include='all'))\n",
              "\n",
              "print(\"\\n3. Basic Statistical Details:\\n\", df.describe())\n",
              "\n",
              "extra_data = {\n",
              "    \"Name\": [\"Amit\", \"Neha\", None, \"Priya\", None],\n",
              "    \"Age\": [21, None, 23, None, 22],\n",
              "    \"Percentage\": [78, 85, None, 90, None]\n",
              "}\n",
              "df_extra = pd.DataFrame(extra_data)\n",
              "df_final = pd.concat([df, df_extra], ignore_index=True)\n",
              "\n",
              "df_final[\"Remarks\"] = \"\"\n",
              "\n",
              "print(\"\\n4. Final Data with Duplicates, Missing values and Remarks column:\\n\", df_final)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 29,
    "questions": [
      {
        "question": """Q.1)	Consider the following entities and their relationships	[15] Event (eno , title , date )
Committee ( cno , name, head , from_time ,to_time , status)
Event and Committee have many to many relationship. Write a php script to accept title of event and modify status committee as working
""",
        "filenames": ["slip29Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip29Q1B.php"]
      },
      {
        "question": """Create a dataset data.csv having two categorical column (the country column, and the purchased column).
1.	Apply OneHot coding on Country column.
2.	Apply Label encoding on purchased column
""",
        "filenames": ["slip29Q2.ipynb"]
      },
    ],
    "answers": {
      "slip29Q1A.html": """<html>
  <head>
    <title>Update script</title>
  </head>
  <body>
    <form action="slip29Q1B.php" method="POST">
      Enter Title of Event:- <input type="text" name="title" /> <br />
      <input type="submit" value="Update" />
      <input type="reset" value="Reset" />
    </form>
  </body>
</html>
""",
      "slip29Q1B.php": """<?php
$db=pg_connect("host=172.16.6.1 dbname=php21200 user=php21200 password=''");
$title=$_POST['title'];
if($db)
echo "connect <br>";
else
echo "error";
$q="update committee set status='working' where cno=(select cno from evecom1 where
eno=(select eno from event where title='$title'));";
$r=pg_exec($db,$q);
if($r)
echo "Record is updated sucessfuly!";
else
echo "Error";
?>

*/

create table event(eno int primary key, title varchar(20), edate date);
insert into event values(1,'birthday','10-june-2023');
insert into event values(2,'marrige','15-july-2023');
insert into event values(3,'anniversary','13-june-2023');
insert into event values(4,'birthday','10-september-2023');

create table committee(cno int primary key, name varchar(20),head varchar(15),fromtime time,totime time,status varchar(10));
insert into committee values(1,'decoration','Mr.Kadam','02:30:00','05:30:00','Working');
insert into committee values(2,'food','Mr. jadhav ','06:30:00','09:30:00','Done');
insert into committee values(3,'cleaning','Mr. unde','09:30:00','10:30:00','Incomplete);

create table evecom1(eno int references event(eno) on delete cascade on update set null, cno int references committee(cno) on delete cascade on update set null);
insert into evecom1 values (1,1);
insert into evecom1 values (2,2);
insert into evecom1 values (3,3);
insert into evecom1 values (4,1);
insert into evecom1 values (1,2);

/*""",
      "slip29Q2.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import pandas as pd\n",
              "from sklearn.preprocessing import OneHotEncoder, LabelEncoder\n",
              "\n",
              "data = {\n",
              "    \"Country\": [\"India\", \"USA\", \"UK\", \"India\", \"USA\", \"UK\"],\n",
              "    \"Purchased\": [\"Yes\", \"No\", \"Yes\", \"No\", \"Yes\", \"No\"]\n",
              "}\n",
              "df = pd.DataFrame(data)\n",
              "df.to_csv(\"data.csv\", index=False)\n",
              "print(\"Original Dataset:\\n\", df)\n",
              "\n",
              "encoder = OneHotEncoder(sparse_output=False)\n",
              "country_encoded = encoder.fit_transform(df[[\"Country\"]])\n",
              "country_df = pd.DataFrame(country_encoded, columns=encoder.get_feature_names_out([\"Country\"]))\n",
              "\n",
              "label_encoder = LabelEncoder()\n",
              "df[\"Purchased_Encoded\"] = label_encoder.fit_transform(df[\"Purchased\"])\n",
              "\n",
              "final_df = pd.concat([country_df, df[\"Purchased_Encoded\"]], axis=1)\n",
              "print(\"\\nAfter Encoding:\\n\", final_df)"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },

  {
    "slipNo": 30,
    "questions": [
      {
        "question": """Q.1)	Consider the following entities and their relationships	[15] Student (Stud_id,name,class)
Competition (c_no,c_name,type)
Relationship between student and competition is many-many with attribute rank and year. Create a RDB in 3NF for the above and solve the following. Using above database write a script in PHP to accept a competition name from user and display information of student who has secured 1st rank in that competition
""",
        "filenames": ["slip30Q1A.html"]
      },
      {
        "question": "",
        "filenames": ["slip30Q1B.php"]
      },
      {
        "question": """a.	Generate a random array of 50 integers and display them using a line chart, scatter plot, histogram and box plot. Apply appropriate color, labels and styling options""",
        "filenames": ["slip30Q2A.ipynb"]
      },
      {
        "question": """b.	Create two lists, one representing subject names and the other representing marks obtained in those subjects. Display the data in bar chart.""",
        "filenames": ["slip30Q2B.ipynb"]
      },
    ],
    "answers": {
      "slip30Q1A.html": """<html>
  <head>
    <title>Student secured 1st rank</title>
  </head>
  <body>
    <form action="slip30Q1B.php" method="POST">
      Enter Competition Name:- <input type="text" name="cname" /> <br />
      <input type="submit" value="submit" />
      <input type="reset" value="Reset" />
    </form>
  </body>
</html>
""",
      "slip30Q1B.php": """<?php
$db=pg_connect("host=172.16.6.1 dbname=php21200 user=php21200 password=''");
$cname=$_POST['cname'];
if($db)
echo "connect <br>";
else
echo "error";
$q="select student.sid,name,class from student,competition,studcomp where student.sid=studcomp.sid and competition.cno=studcomp.cno and rank=1 and cname='$cname'";
$r=pg_exec($db,$q);
echo "<h1 align=center> Student who has secured 1st rank </h1>";
echo "<table border=2 bgcolor=red align=center>";
echo "<tr> <th> sno </th> <th> sname </th> <th> class </th></tr>";
while ($row=pg_fetch_array($r))
{
echo "<tr>";
echo "<td> $row[0] </td>";
echo "<td> $row[1] </td>";
echo "<td> $row[2] </td>";
echo "</tr>";
}
echo "</table>";
pg_close($db);
?>

*/

create table student(sid int primary key,name varchar(20),class varchar(10));
insert into student values(1,'kishor','fybcs');
insert into student values(2,'amol','sybcs');
insert into student values(3,'suhas','tybcs');
insert into student values(4,'rani','fybcs');
insert into student values(5,'gauri','sybcs');

create table competition(cno int primary key, cname varchar(20),type varchar(15));
insert into competition values(1,'quiz','individual');
insert into competition values(2,'khokho','group');
insert into competition values(3,'running','individual');
insert into competition values(4,'basketball','group');
insert into competition values(5,'football','group');

create table studcomp(sid int references student(sid) on delete cascade on update set null, cno int references competition(cno) on delete cascade on update set null,rank int, year int);
insert into studcomp values(1,4,1,2021);
insert into studcomp values(2,3,2,2022);
insert into studcomp values(3,2,3,2023);
insert into studcomp values(4,1,2,2023);
insert into studcomp values(5,5,1,2023);

/*""",
      "slip30Q2A.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import numpy as np\n",
              "import matplotlib.pyplot as plt\n",
              "\n",
              "data = np.random.randint(1, 100, 50)\n",
              "\n",
              "# Line Chart\n",
              "plt.plot(data, color='blue', marker='o')\n",
              "plt.title(\"Line Chart\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "plt.show()\n",
              "\n",
              "# Scatter Plot\n",
              "plt.scatter(range(len(data)), data, color='red')\n",
              "plt.title(\"Scatter Plot\")\n",
              "plt.xlabel(\"Index\")\n",
              "plt.ylabel(\"Value\")\n",
              "plt.show()\n",
              "\n",
              "# Histogram\n",
              "plt.hist(data, bins=10, color='green', edgecolor='black')\n",
              "plt.title(\"Histogram\")\n",
              "plt.xlabel(\"Value Range\")\n",
              "plt.ylabel(\"Frequency\")\n",
              "plt.show()\n",
              "\n",
              "# Box Plot\n",
              "plt.boxplot(data)\n",
              "plt.title(\"Box Plot\")\n",
              "plt.ylabel(\"Value\")\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
      "slip30Q2B.ipynb": """{
        "cells": [
          {
            "cell_type": "code",
            "execution_count": null,
            "metadata": {},
            "outputs": [],
            "source": [
              "import matplotlib.pyplot as plt\n",
              "\n",
              "# Lists\n",
              "subjects = [\"Math\", \"Science\", \"English\", \"History\", \"Computer\"]\n",
              "marks = [85, 90, 78, 88, 95]\n",
              "\n",
              "# Bar Chart\n",
              "plt.bar(subjects, marks, color='skyblue')\n",
              "plt.title(\"Marks in Subjects\")\n",
              "plt.xlabel(\"Subjects\")\n",
              "plt.ylabel(\"Marks\")\n",
              "plt.show()"
            ]
          }
        ],
        "metadata": {
          "kernelspec": {
            "display_name": "Python 3",
            "language": "python",
            "name": "python3"
          },
          "language_info": {
            "file_extension": ".py",
            "mimetype": "text/x-python",
            "name": "python",
            "version": "3.x"
          }
        },
        "nbformat": 4,
        "nbformat_minor": 5
      }""",
    }
  },
]