import abc
import typing

import Oanda.RestV20.Api
import Oanda.RestV20.Client
import Oanda.RestV20.Model
import System
import System.Collections.Generic
import System.Threading.Tasks

Oanda_RestV20_Client_ExceptionFactory = typing.Any


class IDefaultApi(Oanda.RestV20.Client.IApiAccessor, metaclass=abc.ABCMeta):
    """Represents a collection of functions to interact with the API endpoints"""

    def CancelOrder(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2009:
        ...

    def CancelOrderWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2009]:
        """
        Cancel Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2009.
        """
        ...

    def ClosePosition(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20014:
        """
        Close Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20014.
        """
        ...

    def ClosePositionWithHttpInfo(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20014]:
        """
        Close Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20014.
        """
        ...

    def CloseTrade(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20026:
        """
        Close Trade
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20026.
        """
        ...

    def CloseTradeWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20026]:
        """
        Close Trade
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20026.
        """
        ...

    def ConfigureAccount(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> Oanda.RestV20.Model.InlineResponse2004:
        """
        Configure Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: InlineResponse2004.
        """
        ...

    def ConfigureAccountWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2004]:
        """
        Configure Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: ApiResponse of InlineResponse2004.
        """
        ...

    def CreateOrder(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse201:
        """
        Create Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse201.
        """
        ...

    def CreateOrderWithHttpInfo(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse201]:
        """
        Create Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse201.
        """
        ...

    def GetAccount(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2001:
        """
        Account Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2001.
        """
        ...

    def GetAccountWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2001]:
        """
        Account Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2001.
        """
        ...

    def GetAccountChanges(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> Oanda.RestV20.Model.InlineResponse2005:
        """
        Poll Account Updates
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: InlineResponse2005.
        """
        ...

    def GetAccountChangesWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2005]:
        """
        Poll Account Updates
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: ApiResponse of InlineResponse2005.
        """
        ...

    def GetAccountInstruments(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Model.InlineResponse2003:
        """
        Account Instruments
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: InlineResponse2003.
        """
        ...

    def GetAccountInstrumentsWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2003]:
        """
        Account Instruments
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: ApiResponse of InlineResponse2003.
        """
        ...

    def GetAccountSummary(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2002:
        """
        Account Summary
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2002.
        """
        ...

    def GetAccountSummaryWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2002]:
        """
        Account Summary
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2002.
        """
        ...

    def GetExternalUserInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Model.InlineResponse20016:
        """
        External User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: InlineResponse20016.
        """
        ...

    def GetExternalUserInfoWithHttpInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20016]:
        """
        External User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: ApiResponse of InlineResponse20016.
        """
        ...

    def GetInstrumentCandles(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> Oanda.RestV20.Model.InlineResponse20029:
        """
        Get Candlesticks
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: InlineResponse20029.
        """
        ...

    def GetInstrumentCandlesWithHttpInfo(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20029]:
        """
        Get Candlesticks
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: ApiResponse of InlineResponse20029.
        """
        ...

    def GetOrder(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2008:
        """
        Get Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2008.
        """
        ...

    def GetOrderWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2008]:
        """
        Get Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2008.
        """
        ...

    def GetPosition(self, authorization: str, accountID: str, instrument: str) -> Oanda.RestV20.Model.InlineResponse20013:
        """
        Instrument Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: InlineResponse20013.
        """
        ...

    def GetPositionWithHttpInfo(self, authorization: str, accountID: str, instrument: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20013]:
        """
        Instrument Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: ApiResponse of InlineResponse20013.
        """
        ...

    def GetPrices(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> Oanda.RestV20.Model.InlineResponse20021:
        """
        Current Account Prices
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: InlineResponse20021.
        """
        ...

    def GetPricesWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20021]:
        """
        Current Account Prices
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: ApiResponse of InlineResponse20021.
        """
        ...

    def GetTrade(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20025:
        """
        Trade Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20025.
        """
        ...

    def GetTradeWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20025]:
        """
        Trade Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20025.
        """
        ...

    def GetTransaction(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20018:
        """
        Transaction Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20018.
        """
        ...

    def GetTransactionWithHttpInfo(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20018]:
        """
        Transaction Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20018.
        """
        ...

    def GetTransactionRange(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Model.InlineResponse20019:
        """
        Transaction ID Range
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: InlineResponse20019.
        """
        ...

    def GetTransactionRangeWithHttpInfo(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transaction ID Range
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: ApiResponse of InlineResponse20019.
        """
        ...

    def GetTransactionsSinceId(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20019:
        """
        Transactions Since ID
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20019.
        """
        ...

    def GetTransactionsSinceIdWithHttpInfo(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transactions Since ID
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20019.
        """
        ...

    def GetUserInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Model.InlineResponse20015:
        """
        User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: InlineResponse20015.
        """
        ...

    def GetUserInfoWithHttpInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20015]:
        """
        User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: ApiResponse of InlineResponse20015.
        """
        ...

    def ListAccounts(self, authorization: str) -> Oanda.RestV20.Model.InlineResponse200:
        """
        List Accounts
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: InlineResponse200.
        """
        ...

    def ListAccountsWithHttpInfo(self, authorization: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse200]:
        """
        List Accounts
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: ApiResponse of InlineResponse200.
        """
        ...

    def ListOpenPositions(self, authorization: str, accountID: str) -> Oanda.RestV20.Model.InlineResponse20012:
        """
        Open Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: InlineResponse20012.
        """
        ...

    def ListOpenPositionsWithHttpInfo(self, authorization: str, accountID: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20012]:
        """
        Open Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: ApiResponse of InlineResponse20012.
        """
        ...

    def ListOpenTrades(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20024:
        """
        List Open Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20024.
        """
        ...

    def ListOpenTradesWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20024]:
        """
        List Open Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20024.
        """
        ...

    def ListOrders(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Model.InlineResponse2006:
        """
        List Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: InlineResponse2006.
        """
        ...

    def ListOrdersWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2006]:
        """
        List Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: ApiResponse of InlineResponse2006.
        """
        ...

    def ListPendingOrders(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2007:
        """
        Pending Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2007.
        """
        ...

    def ListPendingOrdersWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2007]:
        """
        Pending Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2007.
        """
        ...

    def ListPositions(self, authorization: str, accountID: str) -> Oanda.RestV20.Model.InlineResponse20011:
        """
        List Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: InlineResponse20011.
        """
        ...

    def ListPositionsWithHttpInfo(self, authorization: str, accountID: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20011]:
        """
        List Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: ApiResponse of InlineResponse20011.
        """
        ...

    def ListTrades(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Model.InlineResponse20023:
        """
        List Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: InlineResponse20023.
        """
        ...

    def ListTradesWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20023]:
        """
        List Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: ApiResponse of InlineResponse20023.
        """
        ...

    def ListTransactions(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Model.InlineResponse20017:
        """
        List Transactions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: InlineResponse20017.
        """
        ...

    def ListTransactionsWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20017]:
        """
        List Transactions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: ApiResponse of InlineResponse20017.
        """
        ...

    def ReplaceOrder(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2011:
        """
        Replace Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2011.
        """
        ...

    def ReplaceOrderWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2011]:
        """
        Replace Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2011.
        """
        ...

    def SetOrderClientExtensions(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20010:
        """
        Set Order Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20010.
        """
        ...

    def SetOrderClientExtensionsWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20010]:
        """
        Set Order Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20010.
        """
        ...

    def SetTradeClientExtensions(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20027:
        """
        Set Trade Client Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20027.
        """
        ...

    def SetTradeClientExtensionsWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20027]:
        """
        Set Trade Client Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20027.
        """
        ...

    def SetTradeDependentOrders(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20028:
        """
        Set Dependent Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20028.
        """
        ...

    def SetTradeDependentOrdersWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20028]:
        """
        Set Dependent Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20028.
        """
        ...

    def StreamPricing(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> Oanda.RestV20.Model.InlineResponse20022:
        """
        Price Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: InlineResponse20022.
        """
        ...

    def StreamPricingWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20022]:
        """
        Price Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: ApiResponse of InlineResponse20022.
        """
        ...

    def StreamTransactions(self, authorization: str, accountID: str) -> Oanda.RestV20.Model.InlineResponse20020:
        """
        Transaction Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: InlineResponse20020.
        """
        ...

    def StreamTransactionsWithHttpInfo(self, authorization: str, accountID: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20020]:
        """
        Transaction Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: ApiResponse of InlineResponse20020.
        """
        ...

    def CancelOrderAsync(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2009]:
        ...

    def CancelOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2009]]:
        """
        Cancel Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2009).
        """
        ...

    def ClosePositionAsync(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20014]:
        """
        Close Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20014.
        """
        ...

    def ClosePositionAsyncWithHttpInfo(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20014]]:
        """
        Close Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20014).
        """
        ...

    def CloseTradeAsync(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20026]:
        """
        Close Trade
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20026.
        """
        ...

    def CloseTradeAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20026]]:
        """
        Close Trade
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20026).
        """
        ...

    def ConfigureAccountAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2004]:
        """
        Configure Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: Task of InlineResponse2004.
        """
        ...

    def ConfigureAccountAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2004]]:
        """
        Configure Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: Task of ApiResponse (InlineResponse2004).
        """
        ...

    def CreateOrderAsync(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse201]:
        """
        Create Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse201.
        """
        ...

    def CreateOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse201]]:
        """
        Create Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse201).
        """
        ...

    def GetAccountAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2001]:
        """
        Account Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2001.
        """
        ...

    def GetAccountAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2001]]:
        """
        Account Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2001).
        """
        ...

    def GetAccountChangesAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2005]:
        """
        Poll Account Updates
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: Task of InlineResponse2005.
        """
        ...

    def GetAccountChangesAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2005]]:
        """
        Poll Account Updates
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: Task of ApiResponse (InlineResponse2005).
        """
        ...

    def GetAccountInstrumentsAsync(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2003]:
        """
        Account Instruments
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: Task of InlineResponse2003.
        """
        ...

    def GetAccountInstrumentsAsyncWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2003]]:
        """
        Account Instruments
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: Task of ApiResponse (InlineResponse2003).
        """
        ...

    def GetAccountSummaryAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2002]:
        """
        Account Summary
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2002.
        """
        ...

    def GetAccountSummaryAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2002]]:
        """
        Account Summary
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2002).
        """
        ...

    def GetExternalUserInfoAsync(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20016]:
        """
        External User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of InlineResponse20016.
        """
        ...

    def GetExternalUserInfoAsyncWithHttpInfo(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20016]]:
        """
        External User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of ApiResponse (InlineResponse20016).
        """
        ...

    def GetInstrumentCandlesAsync(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20029]:
        """
        Get Candlesticks
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: Task of InlineResponse20029.
        """
        ...

    def GetInstrumentCandlesAsyncWithHttpInfo(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20029]]:
        """
        Get Candlesticks
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: Task of ApiResponse (InlineResponse20029).
        """
        ...

    def GetOrderAsync(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2008]:
        """
        Get Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2008.
        """
        ...

    def GetOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2008]]:
        """
        Get Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2008).
        """
        ...

    def GetPositionAsync(self, authorization: str, accountID: str, instrument: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20013]:
        """
        Instrument Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: Task of InlineResponse20013.
        """
        ...

    def GetPositionAsyncWithHttpInfo(self, authorization: str, accountID: str, instrument: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20013]]:
        """
        Instrument Position
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: Task of ApiResponse (InlineResponse20013).
        """
        ...

    def GetPricesAsync(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20021]:
        """
        Current Account Prices
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: Task of InlineResponse20021.
        """
        ...

    def GetPricesAsyncWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20021]]:
        """
        Current Account Prices
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: Task of ApiResponse (InlineResponse20021).
        """
        ...

    def GetTradeAsync(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20025]:
        """
        Trade Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20025.
        """
        ...

    def GetTradeAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20025]]:
        """
        Trade Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20025).
        """
        ...

    def GetTransactionAsync(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20018]:
        """
        Transaction Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20018.
        """
        ...

    def GetTransactionAsyncWithHttpInfo(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20018]]:
        """
        Transaction Details
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20018).
        """
        ...

    def GetTransactionRangeAsync(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transaction ID Range
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: Task of InlineResponse20019.
        """
        ...

    def GetTransactionRangeAsyncWithHttpInfo(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]]:
        """
        Transaction ID Range
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: Task of ApiResponse (InlineResponse20019).
        """
        ...

    def GetTransactionsSinceIdAsync(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transactions Since ID
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20019.
        """
        ...

    def GetTransactionsSinceIdAsyncWithHttpInfo(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]]:
        """
        Transactions Since ID
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20019).
        """
        ...

    def GetUserInfoAsync(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20015]:
        """
        User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of InlineResponse20015.
        """
        ...

    def GetUserInfoAsyncWithHttpInfo(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20015]]:
        """
        User Info
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of ApiResponse (InlineResponse20015).
        """
        ...

    def ListAccountsAsync(self, authorization: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse200]:
        """
        List Accounts
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: Task of InlineResponse200.
        """
        ...

    def ListAccountsAsyncWithHttpInfo(self, authorization: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse200]]:
        """
        List Accounts
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: Task of ApiResponse (InlineResponse200).
        """
        ...

    def ListOpenPositionsAsync(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20012]:
        """
        Open Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of InlineResponse20012.
        """
        ...

    def ListOpenPositionsAsyncWithHttpInfo(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20012]]:
        """
        Open Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of ApiResponse (InlineResponse20012).
        """
        ...

    def ListOpenTradesAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20024]:
        """
        List Open Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20024.
        """
        ...

    def ListOpenTradesAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20024]]:
        """
        List Open Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20024).
        """
        ...

    def ListOrdersAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2006]:
        """
        List Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: Task of InlineResponse2006.
        """
        ...

    def ListOrdersAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2006]]:
        """
        List Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: Task of ApiResponse (InlineResponse2006).
        """
        ...

    def ListPendingOrdersAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2007]:
        """
        Pending Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2007.
        """
        ...

    def ListPendingOrdersAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2007]]:
        """
        Pending Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2007).
        """
        ...

    def ListPositionsAsync(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20011]:
        """
        List Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of InlineResponse20011.
        """
        ...

    def ListPositionsAsyncWithHttpInfo(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20011]]:
        """
        List Positions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of ApiResponse (InlineResponse20011).
        """
        ...

    def ListTradesAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20023]:
        """
        List Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: Task of InlineResponse20023.
        """
        ...

    def ListTradesAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20023]]:
        """
        List Trades
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: Task of ApiResponse (InlineResponse20023).
        """
        ...

    def ListTransactionsAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20017]:
        """
        List Transactions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: Task of InlineResponse20017.
        """
        ...

    def ListTransactionsAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20017]]:
        """
        List Transactions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: Task of ApiResponse (InlineResponse20017).
        """
        ...

    def ReplaceOrderAsync(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2011]:
        """
        Replace Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2011.
        """
        ...

    def ReplaceOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2011]]:
        """
        Replace Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2011).
        """
        ...

    def SetOrderClientExtensionsAsync(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20010]:
        """
        Set Order Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20010.
        """
        ...

    def SetOrderClientExtensionsAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20010]]:
        """
        Set Order Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20010).
        """
        ...

    def SetTradeClientExtensionsAsync(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20027]:
        """
        Set Trade Client Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20027.
        """
        ...

    def SetTradeClientExtensionsAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20027]]:
        """
        Set Trade Client Extensions
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20027).
        """
        ...

    def SetTradeDependentOrdersAsync(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20028]:
        """
        Set Dependent Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20028.
        """
        ...

    def SetTradeDependentOrdersAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20028]]:
        """
        Set Dependent Orders
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20028).
        """
        ...

    def StreamPricingAsync(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20022]:
        """
        Price Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: Task of InlineResponse20022.
        """
        ...

    def StreamPricingAsyncWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20022]]:
        """
        Price Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: Task of ApiResponse (InlineResponse20022).
        """
        ...

    def StreamTransactionsAsync(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20020]:
        """
        Transaction Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of InlineResponse20020.
        """
        ...

    def StreamTransactionsAsyncWithHttpInfo(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20020]]:
        """
        Transaction Stream
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of ApiResponse (InlineResponse20020).
        """
        ...


class DefaultApi(System.Object, Oanda.RestV20.Api.IDefaultApi):
    """Represents a collection of functions to interact with the API endpoints"""

    @property
    def Configuration(self) -> Oanda.RestV20.Client.Configuration:
        """Gets or sets the configuration object"""
        ...

    @Configuration.setter
    def Configuration(self, value: Oanda.RestV20.Client.Configuration):
        """Gets or sets the configuration object"""
        ...

    @property
    def ExceptionFactory(self) -> Oanda_RestV20_Client_ExceptionFactory:
        """Provides a factory method hook for the creation of exceptions."""
        ...

    @ExceptionFactory.setter
    def ExceptionFactory(self, value: Oanda_RestV20_Client_ExceptionFactory):
        """Provides a factory method hook for the creation of exceptions."""
        ...

    def ListPendingOrdersAsJson(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> str:
        """
        Pending Orders List all pending Orders in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: JSON string response.
        """
        ...

    @typing.overload
    def CreateOrder(self, authorization: str, accountID: str, createOrderBody: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse201]:
        """
        Create Order Create an Order for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse201.
        """
        ...

    @typing.overload
    def ReplaceOrder(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2011]:
        """
        Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2011.
        """
        ...

    @typing.overload
    def __init__(self, basePath: str) -> None:
        """Initializes a new instance of the DefaultApi class."""
        ...

    @typing.overload
    def __init__(self, configuration: Oanda.RestV20.Client.Configuration = None) -> None:
        """
        Initializes a new instance of the DefaultApi class
        using Configuration object
        
        :param configuration: An instance of Configuration
        """
        ...

    def GetBasePath(self) -> str:
        """Gets the base path of the API client."""
        ...

    def SetBasePath(self, basePath: str) -> None:
        """Sets the base path of the API client."""
        ...

    def DefaultHeader(self) -> System.Collections.Generic.Dictionary[str, str]:
        """
        Gets the default header.
        
        :returns: Dictionary of HTTP header.
        """
        ...

    def AddDefaultHeader(self, key: str, value: str) -> None:
        """
        Add default header.
        
        :param key: Header field name.
        :param value: Header field value.
        """
        ...

    def CancelOrder(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2009:
        """
        Cancel Order Cancel a pending Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2009.
        """
        ...

    def CancelOrderWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2009]:
        """
        Cancel Order Cancel a pending Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2009.
        """
        ...

    def CancelOrderAsync(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2009]:
        """
        Cancel Order Cancel a pending Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2009.
        """
        ...

    def CancelOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2009]]:
        """
        Cancel Order Cancel a pending Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2009).
        """
        ...

    def ClosePosition(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20014:
        """
        Close Position Closeout the open Position for a specific instrument in an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20014.
        """
        ...

    def ClosePositionWithHttpInfo(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20014]:
        """
        Close Position Closeout the open Position for a specific instrument in an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20014.
        """
        ...

    def ClosePositionAsync(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20014]:
        """
        Close Position Closeout the open Position for a specific instrument in an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20014.
        """
        ...

    def ClosePositionAsyncWithHttpInfo(self, authorization: str, accountID: str, instrument: str, closePositionBody: Oanda.RestV20.Model.ClosePositionBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20014]]:
        """
        Close Position Closeout the open Position for a specific instrument in an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :param closePositionBody: Representation of how to close the position
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20014).
        """
        ...

    def CloseTrade(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20026:
        """
        Close Trade Close (partially or fully) a specific open Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20026.
        """
        ...

    def CloseTradeWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20026]:
        """
        Close Trade Close (partially or fully) a specific open Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20026.
        """
        ...

    def CloseTradeAsync(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20026]:
        """
        Close Trade Close (partially or fully) a specific open Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20026.
        """
        ...

    def CloseTradeAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, closeTradeBody: Oanda.RestV20.Model.CloseTradeBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20026]]:
        """
        Close Trade Close (partially or fully) a specific open Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param closeTradeBody: Details of how much of the open Trade to close.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20026).
        """
        ...

    def ConfigureAccount(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> Oanda.RestV20.Model.InlineResponse2004:
        """
        Configure Account Set the client-configurable portions of an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: InlineResponse2004.
        """
        ...

    def ConfigureAccountWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2004]:
        """
        Configure Account Set the client-configurable portions of an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: ApiResponse of InlineResponse2004.
        """
        ...

    def ConfigureAccountAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2004]:
        """
        Configure Account Set the client-configurable portions of an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: Task of InlineResponse2004.
        """
        ...

    def ConfigureAccountAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, configureAccountBody: Oanda.RestV20.Model.ConfigureAccountBody = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2004]]:
        """
        Configure Account Set the client-configurable portions of an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param configureAccountBody: Representation of the Account configuration to set (optional)
        :returns: Task of ApiResponse (InlineResponse2004).
        """
        ...

    @typing.overload
    def CreateOrder(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse201:
        """
        Create Order Create an Order for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse201.
        """
        ...

    def CreateOrderWithHttpInfo(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse201]:
        """
        Create Order Create an Order for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse201.
        """
        ...

    def CreateOrderAsync(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse201]:
        """
        Create Order Create an Order for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse201.
        """
        ...

    def CreateOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, createOrderBody: Oanda.RestV20.Model.CreateOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse201]]:
        """
        Create Order Create an Order for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse201).
        """
        ...

    def GetAccount(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2001:
        """
        Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2001.
        """
        ...

    def GetAccountWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2001]:
        """
        Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2001.
        """
        ...

    def GetAccountAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2001]:
        """
        Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2001.
        """
        ...

    def GetAccountAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2001]]:
        """
        Account Details Get the full details for a single Account that a client has access to. Full pending Order, open Trade and open Position representations are provided.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2001).
        """
        ...

    def GetAccountChanges(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> Oanda.RestV20.Model.InlineResponse2005:
        """
        Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: InlineResponse2005.
        """
        ...

    def GetAccountChangesWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2005]:
        """
        Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: ApiResponse of InlineResponse2005.
        """
        ...

    def GetAccountChangesAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2005]:
        """
        Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: Task of InlineResponse2005.
        """
        ...

    def GetAccountChangesAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, sinceTransactionID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2005]]:
        """
        Poll Account Updates Endpoint used to poll an Account for its current state and changes since a specified TransactionID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param sinceTransactionID: ID of the Transaction to get Account changes since. (optional)
        :returns: Task of ApiResponse (InlineResponse2005).
        """
        ...

    def GetAccountInstruments(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Model.InlineResponse2003:
        """
        Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: InlineResponse2003.
        """
        ...

    def GetAccountInstrumentsWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2003]:
        """
        Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: ApiResponse of InlineResponse2003.
        """
        ...

    def GetAccountInstrumentsAsync(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2003]:
        """
        Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: Task of InlineResponse2003.
        """
        ...

    def GetAccountInstrumentsAsyncWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2003]]:
        """
        Account Instruments Get the list of tradeable instruments for the given Account. The list of tradeable instruments is dependent on the regulatory division that the Account is located in, thus should be the same for all Accounts owned by a single user.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of instruments to query specifically. (optional)
        :returns: Task of ApiResponse (InlineResponse2003).
        """
        ...

    def GetAccountSummary(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2002:
        """
        Account Summary Get a summary for a single Account that a client has access to.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2002.
        """
        ...

    def GetAccountSummaryWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2002]:
        """
        Account Summary Get a summary for a single Account that a client has access to.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2002.
        """
        ...

    def GetAccountSummaryAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2002]:
        """
        Account Summary Get a summary for a single Account that a client has access to.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2002.
        """
        ...

    def GetAccountSummaryAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2002]]:
        """
        Account Summary Get a summary for a single Account that a client has access to.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2002).
        """
        ...

    def GetExternalUserInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Model.InlineResponse20016:
        """
        External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: InlineResponse20016.
        """
        ...

    def GetExternalUserInfoWithHttpInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20016]:
        """
        External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: ApiResponse of InlineResponse20016.
        """
        ...

    def GetExternalUserInfoAsync(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20016]:
        """
        External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of InlineResponse20016.
        """
        ...

    def GetExternalUserInfoAsyncWithHttpInfo(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20016]]:
        """
        External User Info Fetch the externally-available user information for the specified user. This endpoint is intended to be used by 3rd parties that have been authorized by a user to view their personal information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of ApiResponse (InlineResponse20016).
        """
        ...

    def GetInstrumentCandles(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> Oanda.RestV20.Model.InlineResponse20029:
        """
        Get Candlesticks Fetch candlestick data for an instrument.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: InlineResponse20029.
        """
        ...

    def GetInstrumentCandlesWithHttpInfo(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20029]:
        """
        Get Candlesticks Fetch candlestick data for an instrument.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: ApiResponse of InlineResponse20029.
        """
        ...

    def GetInstrumentCandlesAsync(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20029]:
        """
        Get Candlesticks Fetch candlestick data for an instrument.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: Task of InlineResponse20029.
        """
        ...

    def GetInstrumentCandlesAsyncWithHttpInfo(self, authorization: str, instrument: str, acceptDatetimeFormat: str = None, price: str = None, granularity: str = None, count: typing.Optional[int] = None, _from: str = None, to: str = None, smooth: typing.Optional[bool] = None, includeFirst: typing.Optional[bool] = None, dailyAlignment: typing.Optional[int] = None, alignmentTimezone: str = None, weeklyAlignment: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20029]]:
        """
        Get Candlesticks Fetch candlestick data for an instrument.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param instrument: Name of the Instrument
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param price: The Price component(s) to get candlestick data for. Can contain any combination of the characters \\"M\\" (midpoint candles) \\"B\\" (bid candles) and \\"A\\" (ask candles). (optional)
        :param granularity: The granularity of the candlesticks to fetch (optional)
        :param count: The number of candlesticks to return in the reponse. Count should not be specified if both the start and end parameters are provided, as the time range combined with the graularity will determine the number of candlesticks to return. (optional)
        :param _from: The start of the time range to fetch candlesticks for. (optional)
        :param to: The end of the time range to fetch candlesticks for. (optional)
        :param smooth: A flag that controls whether the candlestick is \\"smoothed\\" or not.  A smoothed candlestick uses the previous candle's close price as its open price, while an unsmoothed candlestick uses the first price from its time range as its open price. (optional)
        :param includeFirst: A flag that controls whether the candlestick that is covered by the from time should be included in the results. This flag enables clients to use the timestamp of the last completed candlestick received to poll for future candlesticks but avoid receiving the previous candlestick repeatedly. (optional)
        :param dailyAlignment: The hour of the day (in the specified timezone) to use for granularities that have daily alignments. (optional)
        :param alignmentTimezone: The timezone to use for the dailyAlignment parameter. Candlesticks with daily alignment will be aligned to the dailyAlignment hour within the alignmentTimezone. (optional)
        :param weeklyAlignment: The day of the week used for granularities that have weekly alignment. (optional)
        :returns: Task of ApiResponse (InlineResponse20029).
        """
        ...

    def GetOrder(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2008:
        """
        Get Order Get details for a single Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2008.
        """
        ...

    def GetOrderWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2008]:
        """
        Get Order Get details for a single Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2008.
        """
        ...

    def GetOrderAsync(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2008]:
        """
        Get Order Get details for a single Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2008.
        """
        ...

    def GetOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2008]]:
        """
        Get Order Get details for a single Order in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2008).
        """
        ...

    def GetPosition(self, authorization: str, accountID: str, instrument: str) -> Oanda.RestV20.Model.InlineResponse20013:
        """
        Instrument Position Get the details of a single Instrument's Position in an Account. The Position may by open or not.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: InlineResponse20013.
        """
        ...

    def GetPositionWithHttpInfo(self, authorization: str, accountID: str, instrument: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20013]:
        """
        Instrument Position Get the details of a single Instrument's Position in an Account. The Position may by open or not.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: ApiResponse of InlineResponse20013.
        """
        ...

    def GetPositionAsync(self, authorization: str, accountID: str, instrument: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20013]:
        """
        Instrument Position Get the details of a single Instrument's Position in an Account. The Position may by open or not.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: Task of InlineResponse20013.
        """
        ...

    def GetPositionAsyncWithHttpInfo(self, authorization: str, accountID: str, instrument: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20013]]:
        """
        Instrument Position Get the details of a single Instrument's Position in an Account. The Position may by open or not.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instrument: Name of the Instrument
        :returns: Task of ApiResponse (InlineResponse20013).
        """
        ...

    def GetPrices(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> Oanda.RestV20.Model.InlineResponse20021:
        """
        Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: InlineResponse20021.
        """
        ...

    def GetPricesWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20021]:
        """
        Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: ApiResponse of InlineResponse20021.
        """
        ...

    def GetPricesAsync(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20021]:
        """
        Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: Task of InlineResponse20021.
        """
        ...

    def GetPricesAsyncWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, since: str = None, includeUnitsAvailable: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20021]]:
        """
        Current Account Prices Get pricing information for a specified list of Instruments within an Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to get pricing for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param since: Date/Time filter to apply to the returned prices. Only prices with a time later than this filter will be provided. (optional)
        :param includeUnitsAvailable: Flag that enables the inclusion of the unitsAvailable field in the returned Price objects. (optional)
        :returns: Task of ApiResponse (InlineResponse20021).
        """
        ...

    def GetTrade(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20025:
        """
        Trade Details Get the details of a specific Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20025.
        """
        ...

    def GetTradeWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20025]:
        """
        Trade Details Get the details of a specific Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20025.
        """
        ...

    def GetTradeAsync(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20025]:
        """
        Trade Details Get the details of a specific Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20025.
        """
        ...

    def GetTradeAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20025]]:
        """
        Trade Details Get the details of a specific Trade in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20025).
        """
        ...

    def GetTransaction(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20018:
        """
        Transaction Details Get the details of a single Account Transaction.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20018.
        """
        ...

    def GetTransactionWithHttpInfo(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20018]:
        """
        Transaction Details Get the details of a single Account Transaction.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20018.
        """
        ...

    def GetTransactionAsync(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20018]:
        """
        Transaction Details Get the details of a single Account Transaction.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20018.
        """
        ...

    def GetTransactionAsyncWithHttpInfo(self, authorization: str, accountID: str, transactionID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20018]]:
        """
        Transaction Details Get the details of a single Account Transaction.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param transactionID: A Transaction ID
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20018).
        """
        ...

    def GetTransactionRange(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Model.InlineResponse20019:
        """
        Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: InlineResponse20019.
        """
        ...

    def GetTransactionRangeWithHttpInfo(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: ApiResponse of InlineResponse20019.
        """
        ...

    def GetTransactionRangeAsync(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: Task of InlineResponse20019.
        """
        ...

    def GetTransactionRangeAsyncWithHttpInfo(self, authorization: str, accountID: str, _from: str, to: str, acceptDatetimeFormat: str = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]]:
        """
        Transaction ID Range Get a range of Transactions for an Account based on the Transaction IDs.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param _from: The starting Transacion ID (inclusive) to fetch.
        :param to: The ending Transaction ID (inclusive) to fetch.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param type: The filter that restricts the types of Transactions to retreive. (optional)
        :returns: Task of ApiResponse (InlineResponse20019).
        """
        ...

    def GetTransactionsSinceId(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20019:
        """
        Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20019.
        """
        ...

    def GetTransactionsSinceIdWithHttpInfo(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20019.
        """
        ...

    def GetTransactionsSinceIdAsync(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20019]:
        """
        Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20019.
        """
        ...

    def GetTransactionsSinceIdAsyncWithHttpInfo(self, authorization: str, accountID: str, id: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20019]]:
        """
        Transactions Since ID Get a range of Transactions for an Account starting at (but not including) a provided Transaction ID.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param id: The ID of the last Transacion fetched. This query will return all Transactions newer than the TransactionID.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20019).
        """
        ...

    def GetUserInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Model.InlineResponse20015:
        """
        User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: InlineResponse20015.
        """
        ...

    def GetUserInfoWithHttpInfo(self, authorization: str, userSpecifier: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20015]:
        """
        User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: ApiResponse of InlineResponse20015.
        """
        ...

    def GetUserInfoAsync(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20015]:
        """
        User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of InlineResponse20015.
        """
        ...

    def GetUserInfoAsyncWithHttpInfo(self, authorization: str, userSpecifier: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20015]]:
        """
        User Info Fetch the user information for the specified user. This endpoint is intended to be used by the user themself to obtain their own information.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param userSpecifier: The User Specifier
        :returns: Task of ApiResponse (InlineResponse20015).
        """
        ...

    def ListAccounts(self, authorization: str) -> Oanda.RestV20.Model.InlineResponse200:
        """
        List Accounts Get a list of all Accounts authorized for the provided token.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: InlineResponse200.
        """
        ...

    def ListAccountsWithHttpInfo(self, authorization: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse200]:
        """
        List Accounts Get a list of all Accounts authorized for the provided token.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: ApiResponse of InlineResponse200.
        """
        ...

    def ListAccountsAsync(self, authorization: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse200]:
        """
        List Accounts Get a list of all Accounts authorized for the provided token.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: Task of InlineResponse200.
        """
        ...

    def ListAccountsAsyncWithHttpInfo(self, authorization: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse200]]:
        """
        List Accounts Get a list of all Accounts authorized for the provided token.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :returns: Task of ApiResponse (InlineResponse200).
        """
        ...

    def ListOpenPositions(self, authorization: str, accountID: str) -> Oanda.RestV20.Model.InlineResponse20012:
        """
        Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: InlineResponse20012.
        """
        ...

    def ListOpenPositionsWithHttpInfo(self, authorization: str, accountID: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20012]:
        """
        Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: ApiResponse of InlineResponse20012.
        """
        ...

    def ListOpenPositionsAsync(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20012]:
        """
        Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of InlineResponse20012.
        """
        ...

    def ListOpenPositionsAsyncWithHttpInfo(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20012]]:
        """
        Open Positions List all open Positions for an Account. An open Position is a Position in an Account that currently has a Trade opened for it.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of ApiResponse (InlineResponse20012).
        """
        ...

    def ListOpenTrades(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20024:
        """
        List Open Trades Get the list of open Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20024.
        """
        ...

    def ListOpenTradesWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20024]:
        """
        List Open Trades Get the list of open Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20024.
        """
        ...

    def ListOpenTradesAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20024]:
        """
        List Open Trades Get the list of open Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20024.
        """
        ...

    def ListOpenTradesAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20024]]:
        """
        List Open Trades Get the list of open Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20024).
        """
        ...

    def ListOrders(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Model.InlineResponse2006:
        """
        List Orders Get a list of Orders for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: InlineResponse2006.
        """
        ...

    def ListOrdersWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2006]:
        """
        List Orders Get a list of Orders for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: ApiResponse of InlineResponse2006.
        """
        ...

    def ListOrdersAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2006]:
        """
        List Orders Get a list of Orders for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: Task of InlineResponse2006.
        """
        ...

    def ListOrdersAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2006]]:
        """
        List Orders Get a list of Orders for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Order IDs to retrieve (optional)
        :param state: The state to filter the requested Orders by (optional)
        :param instrument: The instrument to filter the requested orders by (optional)
        :param count: The maximum number of Orders to return (optional)
        :param beforeID: The maximum Order ID to return. If not provided the most recent Orders in the Account are returned (optional)
        :returns: Task of ApiResponse (InlineResponse2006).
        """
        ...

    def ListPendingOrders(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2007:
        """
        Pending Orders List all pending Orders in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2007.
        """
        ...

    def ListPendingOrdersWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2007]:
        """
        Pending Orders List all pending Orders in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2007.
        """
        ...

    def ListPendingOrdersAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2007]:
        """
        Pending Orders List all pending Orders in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2007.
        """
        ...

    def ListPendingOrdersAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2007]]:
        """
        Pending Orders List all pending Orders in an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2007).
        """
        ...

    def ListPositions(self, authorization: str, accountID: str) -> Oanda.RestV20.Model.InlineResponse20011:
        """
        List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: InlineResponse20011.
        """
        ...

    def ListPositionsWithHttpInfo(self, authorization: str, accountID: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20011]:
        """
        List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: ApiResponse of InlineResponse20011.
        """
        ...

    def ListPositionsAsync(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20011]:
        """
        List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of InlineResponse20011.
        """
        ...

    def ListPositionsAsyncWithHttpInfo(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20011]]:
        """
        List Positions List all Positions for an Account. The Positions returned are for every instrument that has had a position during the lifetime of an the Account.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of ApiResponse (InlineResponse20011).
        """
        ...

    def ListTrades(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Model.InlineResponse20023:
        """
        List Trades Get a list of Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: InlineResponse20023.
        """
        ...

    def ListTradesWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20023]:
        """
        List Trades Get a list of Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: ApiResponse of InlineResponse20023.
        """
        ...

    def ListTradesAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20023]:
        """
        List Trades Get a list of Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: Task of InlineResponse20023.
        """
        ...

    def ListTradesAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, ids: System.Collections.Generic.List[str] = None, state: str = None, instrument: str = None, count: typing.Optional[int] = None, beforeID: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20023]]:
        """
        List Trades Get a list of Trades for an Account
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param ids: List of Trade IDs to retrieve. (optional)
        :param state: The state to filter the requested Trades by. (optional)
        :param instrument: The instrument to filter the requested Trades by. (optional)
        :param count: The maximum number of Trades to return. (optional)
        :param beforeID: The maximum Trade ID to return. If not provided the most recent Trades in the Account are returned. (optional)
        :returns: Task of ApiResponse (InlineResponse20023).
        """
        ...

    def ListTransactions(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Model.InlineResponse20017:
        """
        List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: InlineResponse20017.
        """
        ...

    def ListTransactionsWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20017]:
        """
        List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: ApiResponse of InlineResponse20017.
        """
        ...

    def ListTransactionsAsync(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20017]:
        """
        List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: Task of InlineResponse20017.
        """
        ...

    def ListTransactionsAsyncWithHttpInfo(self, authorization: str, accountID: str, acceptDatetimeFormat: str = None, _from: str = None, to: str = None, pageSize: typing.Optional[int] = None, type: System.Collections.Generic.List[str] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20017]]:
        """
        List Transactions Get a list of Transactions pages that satisfy a time-based Transaction query.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param _from: The starting time (inclusive) of the time range for the Transactions being queried. (optional)
        :param to: The ending time (inclusive) of the time range for the Transactions being queried. (optional)
        :param pageSize: The number of Transactions to include in each page of the results. (optional)
        :param type: A filter for restricting the types of Transactions to retreive. (optional)
        :returns: Task of ApiResponse (InlineResponse20017).
        """
        ...

    @typing.overload
    def ReplaceOrder(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse2011:
        """
        Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse2011.
        """
        ...

    def ReplaceOrderWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2011]:
        """
        Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse2011.
        """
        ...

    def ReplaceOrderAsync(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse2011]:
        """
        Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse2011.
        """
        ...

    def ReplaceOrderAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, replaceOrderBody: Oanda.RestV20.Model.ReplaceOrderBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse2011]]:
        """
        Replace Order Replace an Order in an Account by simultaneously cancelling it and creating a replacement Order
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param replaceOrderBody: Specification of the replacing Order. The replacing order must have the same type as the replaced Order.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse2011).
        """
        ...

    def SetOrderClientExtensions(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20010:
        """
        Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20010.
        """
        ...

    def SetOrderClientExtensionsWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20010]:
        """
        Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20010.
        """
        ...

    def SetOrderClientExtensionsAsync(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20010]:
        """
        Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20010.
        """
        ...

    def SetOrderClientExtensionsAsyncWithHttpInfo(self, authorization: str, accountID: str, orderSpecifier: str, setOrderClientExtensionsBody: Oanda.RestV20.Model.SetOrderClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20010]]:
        """
        Set Order Extensions Update the Client Extensions for an Order in an Account. Do not set, modify, or delete clientExtensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param orderSpecifier: The Order Specifier
        :param setOrderClientExtensionsBody: Representation of the replacing Order
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20010).
        """
        ...

    def SetTradeClientExtensions(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20027:
        """
        Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20027.
        """
        ...

    def SetTradeClientExtensionsWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20027]:
        """
        Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20027.
        """
        ...

    def SetTradeClientExtensionsAsync(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20027]:
        """
        Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20027.
        """
        ...

    def SetTradeClientExtensionsAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeClientExtensionsBody: Oanda.RestV20.Model.SetTradeClientExtensionsBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20027]]:
        """
        Set Trade Client Extensions Update the Client Extensions for a Trade. Do not add, update, or delete the Client Extensions if your account is associated with MT4.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeClientExtensionsBody: Details of how to modify the Trade's Client Extensions.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20027).
        """
        ...

    def SetTradeDependentOrders(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Model.InlineResponse20028:
        """
        Set Dependent Orders Create, replace and cancel a Trade's dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: InlineResponse20028.
        """
        ...

    def SetTradeDependentOrdersWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20028]:
        """
        Set Dependent Orders Create, replace and cancel a Trade's dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: ApiResponse of InlineResponse20028.
        """
        ...

    def SetTradeDependentOrdersAsync(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20028]:
        """
        Set Dependent Orders Create, replace and cancel a Trade's dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of InlineResponse20028.
        """
        ...

    def SetTradeDependentOrdersAsyncWithHttpInfo(self, authorization: str, accountID: str, tradeSpecifier: str, setTradeDependentOrdersBody: Oanda.RestV20.Model.SetTradeDependentOrdersBody, acceptDatetimeFormat: str = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20028]]:
        """
        Set Dependent Orders Create, replace and cancel a Trade's dependent Orders (Take Profit, Stop Loss and Trailing Stop Loss) through the Trade itself
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param tradeSpecifier: Specifier for the Trade
        :param setTradeDependentOrdersBody: Details of how to modify the Trade's dependent Orders.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :returns: Task of ApiResponse (InlineResponse20028).
        """
        ...

    def StreamPricing(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> Oanda.RestV20.Model.InlineResponse20022:
        """
        Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: InlineResponse20022.
        """
        ...

    def StreamPricingWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20022]:
        """
        Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: ApiResponse of InlineResponse20022.
        """
        ...

    def StreamPricingAsync(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20022]:
        """
        Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: Task of InlineResponse20022.
        """
        ...

    def StreamPricingAsyncWithHttpInfo(self, authorization: str, accountID: str, instruments: System.Collections.Generic.List[str], acceptDatetimeFormat: str = None, snapshot: typing.Optional[bool] = None) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20022]]:
        """
        Price Stream Get a stream of Account Prices starting from when the request is made. This pricing stream does not include every single price created for the Account, but instead will provide at most 4 prices per second (every 250 milliseconds) for each instrument being requested. If more than one price is created for an instrument during the 250 millisecond window, only the price in effect at the end of the window is sent. This means that during periods of rapid price movement, subscribers to this stream will not be sent every price. Pricing windows for different connections to the price stream are not all aligned in the same way (i.e. they are not all aligned to the top of the second). This means that during periods of rapid price movement, different subscribers may observe different prices depending on their alignment.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :param instruments: List of Instruments to stream Prices for.
        :param acceptDatetimeFormat: Format of DateTime fields in the request and response. (optional)
        :param snapshot: Flag that enables/disables the sending of a pricing snapshot when initially connecting to the stream. (optional)
        :returns: Task of ApiResponse (InlineResponse20022).
        """
        ...

    def StreamTransactions(self, authorization: str, accountID: str) -> Oanda.RestV20.Model.InlineResponse20020:
        """
        Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: InlineResponse20020.
        """
        ...

    def StreamTransactionsWithHttpInfo(self, authorization: str, accountID: str) -> Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20020]:
        """
        Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: ApiResponse of InlineResponse20020.
        """
        ...

    def StreamTransactionsAsync(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Model.InlineResponse20020]:
        """
        Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of InlineResponse20020.
        """
        ...

    def StreamTransactionsAsyncWithHttpInfo(self, authorization: str, accountID: str) -> System.Threading.Tasks.Task[Oanda.RestV20.Client.ApiResponse[Oanda.RestV20.Model.InlineResponse20020]]:
        """
        Transaction Stream Get a stream of Transactions for an Account starting from when the request is made.
        
        :param authorization: The authorization bearer token previously obtained by the client
        :param accountID: Account Identifier
        :returns: Task of ApiResponse (InlineResponse20020).
        """
        ...


