#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Общие компоненты - Утилиты и совместимость

Модуль содержит общие компоненты, используемые во всех пакетах:
- Утилиты для работы с данными
- Совместимость с зарубежными библиотеками
- Общие константы и конфигурации
"""

__version__ = "1.0.0"
__author__ = "NativeMind.ru & УРАБИ.РФ"

# Импорт основных модулей
from . import utils
from . import compat
from . import config

# Основные классы для импорта
__all__ = [
    "utils",
    "compat", 
    "config",
    "__version__",
    "__author__",
]

# Информация о модуле
MODULE_INFO = {
    "name": "Общие компоненты",
    "description": "Утилиты и совместимость для всех пакетов",
    "version": __version__,
    "author": __author__,
    "components": {
        "utils": "Утилиты для работы с данными",
        "compat": "Совместимость с зарубежными библиотеками",
        "config": "Общие конфигурации и константы"
    },
    "features": [
        "Кроссплатформенная совместимость",
        "Оптимизация под российские платформы",
        "Интеграция с ГОСТ стандартами",
        "Поддержка квантовых алгоритмов",
        "Локализация для русского языка"
    ]
}

def get_module_info():
    """Получить информацию о модуле общих компонентов"""
    return MODULE_INFO.copy()

def get_components():
    """Получить список компонентов"""
    return MODULE_INFO["components"].copy()

def get_features():
    """Получить список возможностей"""
    return MODULE_INFO["features"].copy()
