[![PyPI](https://img.shields.io/pypi/v/acoustotreams)](https://pypi.org/project/acoustotreams)
![License](https://img.shields.io/github/license/NikUstimenko/acoustotreams)
[![Documentation Status](https://img.shields.io/badge/docs-online-brightgreen)](https://NikUstimenko.github.io/acoustotreams)

# acoustotreams

The package `acoustotreams` adopts the framework of the `treams` package for acoustic wave scattering in finite and periodic arrangements of particles, based on the T-matrix method.

## Installation

### Installation using pip

To install the package with pip, use

```sh
pip install acoustotreams
```
Preliminarily, you have to also install original `treams` as well as `numpy` and `scipy`
```sh
pip install treams
```

## Documentation

The documentation can be found at https://NikUstimenko.github.io/acoustotreams.

## Publications

When using this code please cite:

## Features

* [x] T-matrix calculations using a spherical or cylindrical wave basis set
* [x] Scattering from clusters of particles
* [x] Scattering from particles and clusters arranged in 3d-, 2d-, and 1d-lattices
* [x] Calculation of sound propagation in stratified media
* [x] Band calculation in crystal structures
