function Cz = GetCz(alpha,beta,drn,del,dnos,Wx,Wy,V,l)
% --------------------------------------------------------------
%       Вычисление коэффициента боковой силы Cz.
% --------------------------------------------------------------
% Cz = GetCz(alpha,beta,drn,del,dnos,Wx,Wy,V) вычисляет коэффициент боковой
%    силы в зависимости от углов атаки и скольжения, отклонения 
%    элеронов и руля направления и угловых скоростей крена и рыскания.
% alpha - угол атаки, рад.
% beta - угол скольжения, рад.
% drn - отклонение руля направления, рад.
% del - отклонение элеронов (дифференциальное), рад.
% dnos - отклонение носков крыла, рад.
% V - воздушная скорость, м/с
% Wx - угловая скорость крена, рад/с
% Wy - угловая скорость рыскания, рад/с
%
% Зависимости заданы в виде таблиц.
% Таблицы интерполяции хранятся в оперативной памяти для ускорения
% численного расчёта.
% --------------------------------------------------------------
persistent init_mdl
persistent alpha1 alpha2 beta1 Cz1 Cz_nos1 Czdel20 Czdel20_nos
persistent Czdrn30 Czwy1 dCzwy_nos1 Czwx1 dCzwx_nos1
persistent interpCz interpCz_nos interpCzwx1 interpCzwx2 interpCzwy1 interpCzwy2 interpCzdel interpCzdel_nos interpCzdrn

% Инициализация
if isempty(init_mdl)

init_mdl = 1;

alpha1 = deg2rad([-20 -15 -10 -5 0 5 10 15 20 25 30 35 40 45 50 55 60 70 80 90]);
alpha2 = deg2rad([-20 -15 -10 -5 0 5 10 15 20 25 30 35 40 45]);
beta1 = deg2rad([-30 -25 -20 -15 -10 -8 -6 -4 -2 0 2 4 6 8 10 15 20 25 30]);

% Коэффициент боковой силы в зависимости от угла атаки и скольжения.
% Cz = f(alpha, beta)
Cz1 = [0.3677	0.307	0.246	0.1844	0.1062	0.085	0.0677	0.038	0.0186	0	-0.0232	-0.0467	-0.0747	-0.1078	-0.1421	-0.2221	-0.2861	-0.3461	-0.4081;
    0.4019	0.322	0.2651	0.1964	0.1332	0.1039	0.0753	0.0442	0.0175	0	-0.0188	-0.0402	-0.0681	-0.1004	-0.1317	-0.193	-0.254	-0.319	-0.398;
    0.4367	0.3823	0.3185	0.2462	0.1513	0.1156	0.076	0.0434	0.0161	0	-0.0124	-0.043	-0.0792	-0.1171	-0.1542	-0.2482	-0.3212	-0.3842	-0.4382;
    0.5538	0.4778	0.3758	0.2818	0.1833	0.1449	0.1055	0.0662	0.0325	0	-0.042	-0.0763	-0.1177	-0.1575	-0.2072	-0.3041	-0.4001	-0.5013	-0.5794;
    0.6218	0.5258	0.4208	0.3088	0.2014	0.1553	0.1138	0.0726	0.0371	0	-0.0394	-0.0764	-0.1191	-0.1674	-0.2134	-0.3198	-0.4315	-0.5369	-0.64;
    0.6544	0.5514	0.4294	0.3124	0.2028	0.1607	0.1133	0.0767	0.0331	0	-0.0383	-0.0819	-0.1233	-0.1705	-0.2173	-0.3257	-0.443	-0.5506	-0.6514;
    0.6255	0.5185	0.4225	0.3065	0.2016	0.1597	0.1131	0.0748	0.0345	0	-0.0383	-0.0786	-0.1204	-0.1668	-0.2171	-0.3204	-0.4347	-0.5313	-0.6371;
    0.5885	0.4665	0.3755	0.2875	0.1837	0.1473	0.1069	0.0652	0.0298	0	-0.0383	-0.077	-0.12	-0.1642	-0.2056	-0.3091	-0.3966	-0.4868	-0.61;
    0.5783	0.4633	0.3383	0.2563	0.1814	0.1504	0.1116	0.0703	0.0332	0	-0.0248	-0.0558	-0.0984	-0.1366	-0.1729	-0.2479	-0.328	-0.4542	-0.5698;
    0.5005	0.4195	0.3005	0.2295	0.1643	0.1409	0.1029	0.0654	0.0343	0	-0.0335	-0.0677	-0.1028	-0.1369	-0.1692	-0.2337	-0.3044	-0.4241	-0.503;
    0.3751	0.3161	0.2291	0.1411	0.0927	0.1057	0.0911	0.063	0.0297	0	-0.0306	-0.0647	-0.0906	-0.1159	-0.1353	-0.1841	-0.2743	-0.36	-0.4189;
    0.3292	0.2952	0.2112	0.1472	0.0857	0.0581	0.0651	0.0563	0.0264	0	-0.0214	-0.0513	-0.0806	-0.0971	-0.1022	-0.1632	-0.2282	-0.3141	-0.3488;
    0.447	0.3885	0.3025	0.2135	0.0748	0.0531	0.0303	0.036	0.0123	0	-0.032	-0.0484	-0.0664	-0.0958	-0.1075	-0.1539	-0.1575	-0.1807	-0.2242;
    0.1634	0.0894	0.0444	0.0894	0.0782	0.0612	0.0458	0.0398	0.0279	0	-0.0868	-0.1048	-0.1365	-0.1541	-0.183	-0.194	-0.1506	-0.1951	-0.2662;
    0.1366	0.1036	0.0916	0.1556	0.0866	0.0785	0.0555	0.0399	0.0302	0	-0.0178	-0.0791	-0.106	-0.1177	-0.1508	-0.2201	-0.1565	-0.1679	-0.2008;
    0.1735	0.1355	0.1795	0.1725	0.1104	0.0926	0.0663	0.046	0.0424	0	-0.0087	-0.0718	-0.1065	-0.1225	-0.1468	-0.209	-0.2153	-0.1709	-0.2107;
    0.2233	0.1713	0.2083	0.1883	0.123	0.1051	0.0788	0.0546	0.0474	0	-0.0048	-0.0571	-0.084	-0.1047	-0.1242	-0.1885	-0.2077	-0.1719	-0.2099;
    0.2609	0.2279	0.1739	0.1469	0.1074	0.0941	0.0765	0.0564	0.0371	0	-0.0113	-0.03	-0.0477	-0.0715	-0.0859	-0.1266	-0.1534	-0.2078	-0.2421;
    0.3055	0.2595	0.2165	0.1635	0.1096	0.0871	0.0753	0.0498	0.0212	0	-0.0203	-0.0361	-0.0655	-0.0804	-0.1027	-0.1554	-0.2075	-0.2495	-0.2954;
    0.3078	0.2498	0.1998	0.1568	0.1089	0.0843	0.0658	0.0446	0.0203	0	-0.0263	-0.0418	-0.0611	-0.0836	-0.1068	-0.1547	-0.1986	-0.2474	-0.3047];


% Коэффициент боковой силы в зависимости от угла атаки и скольжения,
% носки выпущены.
% Cz_nos = f(alpha2,beta)
Cz_nos1 = [0.3692	0.2991	0.2417	0.1692	0.1078	0.0874	0.0837	0.0572	0.026	0	-0.0258	-0.0592	-0.0863	-0.1209	-0.1504	-0.2106	-0.2836	-0.3396	-0.4106;
    0.4368	0.3797	0.3249	0.2636	0.1826	0.1456	0.1068	0.0701	0.0336	0	-0.0337	-0.0702	-0.11	-0.15	-0.1902	-0.2712	-0.3332	-0.3882	-0.4452;
    0.5	0.4441	0.3671	0.2896	0.1871	0.1475	0.1096	0.0757	0.0377	0	-0.0339	-0.0708	-0.1108	-0.1513	-0.1949	-0.2978	-0.3758	-0.4528	-0.5078;
    0.5683	0.4913	0.3913	0.2943	0.1926	0.149	0.1125	0.0723	0.0369	0	-0.0363	-0.0765	-0.1169	-0.1644	-0.2132	-0.3148	-0.4118	-0.513	-0.5889;
    0.6293	0.5313	0.4173	0.3053	0.2024	0.1582	0.1116	0.0729	0.0374	0	-0.0374	-0.0776	-0.1223	-0.1712	-0.2158	-0.3196	-0.4308	-0.5443	-0.6426;
    0.6397	0.5367	0.4267	0.3097	0.2042	0.163	0.1174	0.0775	0.0394	0	-0.0352	-0.0785	-0.1189	-0.1689	-0.215	-0.3218	-0.4364	-0.5448	-0.6496;
    0.6132	0.5192	0.4302	0.3142	0.208	0.1631	0.1187	0.0784	0.037	0	-0.0378	-0.0774	-0.1228	-0.1664	-0.2153	-0.3196	-0.4353	-0.5237	-0.6177;
    0.5416	0.4876	0.4126	0.3066	0.202	0.1576	0.1168	0.0718	0.0377	0	-0.0368	-0.0784	-0.1194	-0.1636	-0.2096	-0.3143	-0.4223	-0.4947	-0.5499;
    0.475	0.375	0.295	0.23	0.1576	0.1254	0.0919	0.059	0.0282	0	-0.0313	-0.067	-0.1023	-0.1374	-0.171	-0.2452	-0.3089	-0.3869	-0.488;
    0.4878	0.3708	0.2508	0.1578	0.1176	0.1174	0.0893	0.0585	0.0286	0	-0.0301	-0.0566	-0.0925	-0.1126	-0.1321	-0.1714	-0.2647	-0.385	-0.5025;
    0.3436	0.3226	0.2286	0.1396	0.0825	0.0801	0.0757	0.0549	0.0287	0	-0.0289	-0.0527	-0.0724	-0.0939	-0.1136	-0.1694	-0.2589	-0.3511	-0.3742;
    0.2437	0.2267	0.1757	0.1307	0.0776	0.0602	0.0535	0.0407	0.0181	0	-0.0214	-0.0537	-0.0808	-0.1009	-0.1226	-0.1766	-0.2208	-0.2714	-0.2901;
    0.1976	0.1776	0.1566	0.1286	0.0906	0.0737	0.0593	0.0505	0.0188	0	-0.0286	-0.0516	-0.0737	-0.0938	-0.1132	-0.1503	-0.1791	-0.1996	-0.2195;
    0.1741	0.1251	0.1201	0.132	0.111	0.0854	0.055	0.0339	0.0183	0	-0.0544	-0.0929	-0.1312	-0.1581	-0.1766	-0.1977	-0.1859	-0.19	-0.2385];


% Коэффициент боковой силы при максимальном отклонении элеронов (20 град)
% Czdel20 = f(alpha1, beta)
Czdel20 = [0.3838    0.3204    0.2946    0.2275    0.1467    0.1200    0.1010    0.0717    0.0500    0.0281    0.0028   -0.0154   -0.0412   -0.0694   -0.0949  -0.1760   -0.2440   -0.2700   -0.3340;
    0.4012    0.3333    0.2847    0.2150    0.1508    0.1247    0.0954    0.0678    0.0423    0.0197    0.0005   -0.0202   -0.0461   -0.0809   -0.1126  -0.1770   -0.2470   -0.2950   -0.3650;
    0.4314    0.3741    0.3207    0.2418    0.1741    0.1349    0.1001    0.0680    0.0377    0.0222    0.0061   -0.0245   -0.0574   -0.0935   -0.1290  -0.1956   -0.2740   -0.3300   -0.3850;
    0.6020    0.5160    0.4170    0.3160    0.2062    0.1668    0.1288    0.0892    0.0521    0.0164   -0.0150   -0.0528   -0.0877   -0.1308   -0.1726  -0.2831   -0.3847   -0.4831   -0.5657;
    0.6590    0.5630    0.4490    0.3300    0.2130    0.1799    0.1390    0.0963    0.0573    0.0197   -0.0166   -0.0528   -0.0957   -0.1350   -0.1821  -0.3000   -0.4190   -0.5326   -0.6294;
    0.6950    0.6020    0.4820    0.3510    0.2172    0.1820    0.1412    0.0990    0.0591    0.0214   -0.0161   -0.0497   -0.0954   -0.1380   -0.1830  -0.3051   -0.4355   -0.5553   -0.6470;
    0.6660    0.5800    0.4660    0.3480    0.2238    0.1879    0.1437    0.1038    0.0605    0.0229   -0.0148   -0.0527   -0.0940   -0.1373   -0.1887  -0.3044   -0.4332   -0.5456   -0.6322;
    0.6480    0.5370    0.4410    0.3300    0.2204    0.1801    0.1390    0.0993    0.0593    0.0237   -0.0123   -0.0489   -0.0936   -0.1332   -0.1799  -0.2899   -0.4017   -0.4962   -0.6006;
    0.5720    0.4820    0.3860    0.2980    0.1930    0.1520    0.1166    0.0750    0.0327    0.0028   -0.0200   -0.0510   -0.0889   -0.1273   -0.1667  -0.2716   -0.3586   -0.4536   -0.5415;
    0.4880    0.4070    0.3100    0.2380    0.1590    0.1381    0.1047    0.0727    0.0355    0.0026   -0.0283   -0.0604   -0.0949   -0.1305   -0.1690  -0.2478   -0.3194   -0.4177   -0.4989;
    0.3648    0.3061    0.2154    0.1340    0.0845    0.0978    0.0869    0.0608    0.0290    0.0002   -0.0287   -0.0586   -0.0904   -0.1165   -0.1395  -0.1890   -0.2704   -0.3614   -0.4198;
    0.2994    0.2420    0.1674    0.1058    0.0417    0.0217    0.0334    0.0285    0.0024   -0.0225   -0.0446   -0.0699   -0.0971   -0.1160   -0.1368  -0.2009   -0.2625   -0.3371   -0.3945;
    0.0967    0.0825    0.0349    0.0078   -0.0310   -0.0492   -0.0576   -0.0533   -0.0696   -0.0840   -0.1036   -0.1271   -0.1460   -0.1763   -0.1919  -0.2328   -0.2557   -0.3029   -0.3183;
    0.0810    0.0531    0.0351    0.0212    0.0102   -0.0205   -0.0229   -0.0361   -0.0442   -0.0494   -0.0912   -0.1570   -0.1801   -0.1989   -0.2187  -0.2301   -0.2058   -0.2404   -0.3097;
    0.0761    0.0531    0.0482    0.0482    0.0154    0.0135   -0.0053   -0.0296   -0.0443   -0.0598   -0.0783   -0.1238   -0.1508   -0.1465   -0.2012  -0.2347   -0.2328   -0.2361   -0.2620;
    0.0959    0.0721    0.1041    0.0881    0.0241    0.0054   -0.0056   -0.0441   -0.0575   -0.0849   -0.0894   -0.1331   -0.1645   -0.1724   -0.2089  -0.2714   -0.2862   -0.2529   -0.2759;
    0.1232    0.1021    0.1151    0.0882    0.0311    0.0001   -0.0094   -0.0503   -0.0647   -0.0920   -0.0976   -0.1289   -0.1540   -0.1714   -0.1950  -0.2546   -0.2846   -0.2656   -0.2868;
    0.2272    0.1961    0.1399    0.0880    0.0531    0.0247    0.0069   -0.0224   -0.0421   -0.0497   -0.0801   -0.0890   -0.0983   -0.1196   -0.1425  -0.1745   -0.2219   -0.2780   -0.3083;
    0.2981    0.2535    0.2045    0.1432    0.0976    0.0788    0.0535    0.0446    0.0136   -0.0046   -0.0404   -0.0582   -0.0748   -0.0950   -0.1186  -0.1638   -0.2218   -0.2731   -0.3171;
    0.2845    0.2302    0.1800    0.1510    0.0998    0.0777    0.0577    0.0351    0.0111   -0.0048   -0.0320   -0.0476   -0.0770   -0.0989   -0.1204 -0.1735   -0.2153   -0.2572   -0.3173];


% Коэффициент боковой силы при максимальном отклонении элеронов (20 град),
% носки выпущены.
% Czdel20_nos = f(alpha2,beta)
Czdel20_nos = [0.3860    0.3207    0.2777    0.1838    0.1290    0.1215    0.1051    0.0758    0.0498    0.0247   -0.0067   -0.0334   -0.0645   -0.0939   -0.1248  -0.1790   -0.2730   -0.3160   -0.3810;
    0.4337    0.3695    0.3280    0.2622    0.2002    0.1669    0.1309    0.0961    0.0619    0.0268   -0.0070   -0.0415   -0.0775   -0.1183   -0.1560  -0.2170   -0.2840   -0.3250   -0.3890;
    0.4861    0.4153    0.3594    0.2824    0.2069    0.1715    0.1318    0.0978    0.0646    0.0305   -0.0061   -0.0415   -0.0769   -0.1130   -0.1533  -0.2310   -0.3050   -0.3630   -0.4320;
    0.6320    0.5470    0.4410    0.3320    0.2109    0.1775    0.1379    0.0940    0.0585    0.0202   -0.0132   -0.0538   -0.0901   -0.1326   -0.1786  -0.2971   -0.4064   -0.5121   -0.5958;
    0.6660    0.5750    0.4540    0.3370    0.2128    0.1776    0.1396    0.0957    0.0565    0.0209   -0.0179   -0.0552   -0.0964   -0.1347   -0.1802  -0.3049   -0.4233   -0.5437   -0.6344;
    0.6660    0.5790    0.4590    0.3350    0.2162    0.1801    0.1401    0.0992    0.0539    0.0190   -0.0204   -0.0569   -0.0980   -0.1424   -0.1904  -0.3091   -0.4328   -0.5514   -0.6382;
    0.6450    0.5620    0.4580    0.3360    0.2190    0.1828    0.1381    0.0955    0.0562    0.0164   -0.0231   -0.0582   -0.1041   -0.1462   -0.1962  -0.3136   -0.4322   -0.5393   -0.6208;
    0.5900    0.5370    0.4570    0.3300    0.2147    0.1780    0.1337    0.0950    0.0505    0.0151   -0.0223   -0.0583   -0.0998   -0.1438   -0.1882  -0.3026   -0.4297   -0.5085   -0.5603;
    0.4880    0.4110    0.3400    0.2720    0.1807    0.1512    0.1150    0.0776    0.0466    0.0162   -0.0156   -0.0489   -0.0836   -0.1150   -0.1545  -0.2450   -0.3136   -0.3841   -0.4615;
    0.4920    0.3630    0.2720    0.1810    0.1246    0.1206    0.0935    0.0676    0.0338    0.0010   -0.0261   -0.0531   -0.0801   -0.1061   -0.1274  -0.1823   -0.2714   -0.3631   -0.4930;
    0.3320    0.3150    0.2240    0.1320    0.0719    0.0731    0.0650    0.0458    0.0239   -0.0032   -0.0273   -0.0595   -0.0801   -0.1000   -0.1137  -0.1726   -0.2629   -0.3540   -0.3701;
    0.2660    0.2230    0.1320    0.0840    0.0274    0.0248    0.0229    0.0129   -0.0080   -0.0215   -0.0520   -0.0758   -0.1105   -0.1253   -0.1542  -0.2105   -0.2563   -0.2938   -0.3373;
    0.1320    0.0870    0.0740    0.0500    0.0012   -0.0165   -0.0197   -0.0465   -0.0602   -0.0807   -0.1014   -0.1290   -0.1431   -0.1644   -0.1864  -0.2334   -0.2568   -0.2685   -0.3138;
    0.1020    0.0520    0.0690    0.0650    0.0456    0.0212    0.0018   -0.0260   -0.0392   -0.0611   -0.1056   -0.1607   -0.1729   -0.1961   -0.2268  -0.2456   -0.2495   -0.2313   -0.2828];


% Коэффициент боковой силы при максимальном отклонении РН (-30 градусов)
% Czdrn30 = f(alpha1, beta)
Czdrn30 = [0.4196    0.3510    0.2977    0.2414    0.1906    0.1827    0.1760    0.1446    0.1264    0.0945    0.0772    0.0538    0.0320   -0.0018   -0.0465  -0.0970   -0.1530   -0.2050   -0.2730;
    0.4427    0.3724    0.3174    0.2511    0.2112    0.2011    0.1772    0.1445    0.1184    0.0940    0.0772    0.0562    0.0311   -0.0067   -0.0436  -0.0830   -0.1380   -0.1930   -0.2630;
    0.4833    0.4258    0.3790    0.3075    0.2320    0.2096    0.1780    0.1412    0.1105    0.0931    0.0779    0.0540    0.0190   -0.0229   -0.0651  -0.1420   -0.2130   -0.2600   -0.3170;
    0.6060    0.5400    0.4750    0.3640    0.2611    0.2271    0.1901    0.1528    0.1192    0.0827    0.0522    0.0158   -0.0255   -0.0703   -0.1178  -0.2213   -0.3327   -0.4000   -0.4680;
    0.6350    0.5660    0.4960    0.3800    0.2698    0.2407    0.1979    0.1572    0.1202    0.0821    0.0492    0.0147   -0.0297   -0.0788   -0.1309  -0.2407   -0.3564   -0.4250   -0.4950;
    0.6600    0.5990    0.5160    0.3960    0.2806    0.2500    0.2038    0.1616    0.1190    0.0849    0.0500    0.0101   -0.0318   -0.0815   -0.1332  -0.2481   -0.3668   -0.4390   -0.5100;
    0.6960    0.5960    0.5240    0.4080    0.2908    0.2407    0.1979    0.1574    0.1152    0.0796    0.0456    0.0106   -0.0390   -0.0855   -0.1374  -0.2443   -0.3619   -0.4340   -0.5350;
    0.6710    0.5570    0.4770    0.3630    0.2599    0.2368    0.1999    0.1597    0.1196    0.0849    0.0492    0.0136   -0.0333   -0.0770   -0.1236  -0.2280   -0.3396   -0.4200   -0.5350;
    0.6550    0.5430    0.4380    0.3490    0.2371    0.2163    0.1941    0.1455    0.1181    0.0783    0.0473    0.0199   -0.0179   -0.0538   -0.0913  -0.2012   -0.2911   -0.4010   -0.5100;
    0.5700    0.4800    0.3920    0.3070    0.2184    0.2124    0.1925    0.1638    0.1249    0.0879    0.0546    0.0232   -0.0160   -0.0520   -0.0897  -0.1783   -0.2651   -0.3620   -0.4590;
    0.4000    0.3400    0.2640    0.1920    0.1182    0.1428    0.1596    0.1458    0.1217    0.0930    0.0568    0.0278   -0.0026   -0.0388   -0.0760  -0.1488   -0.2219   -0.3000   -0.3600;
    0.3340    0.3150    0.2530    0.1910    0.1029    0.0868    0.0927    0.1048    0.0829    0.0593    0.0439    0.0179   -0.0112   -0.0407   -0.0687  -0.1570   -0.2196   -0.2910   -0.3100;
    0.1520    0.1620    0.1190    0.0910    0.0369    0.0042    0.0064   -0.0024   -0.0064   -0.0096   -0.0377   -0.0541   -0.0850   -0.1087   -0.1438  -0.1967   -0.2260   -0.2711   -0.2624;
    0.1890    0.1190    0.0890    0.1030    0.0721    0.0605    0.0554    0.0611    0.0425    0.0143   -0.0656   -0.0957   -0.1198   -0.1519   -0.1691  -0.1979   -0.1835   -0.2141   -0.2827;
    0.1420    0.0970    0.0930    0.1100    0.0760    0.0743    0.0617    0.0325    0.0290    0.0065   -0.0306   -0.0627   -0.1022   -0.1332   -0.1556  -0.1912   -0.1719   -0.1739   -0.2190;
    0.1590    0.1190    0.1600    0.1450    0.0930    0.0694    0.0464    0.0102    0.0061   -0.0183   -0.0384   -0.0944   -0.1225   -0.1557   -0.1753  -0.2277   -0.2434   -0.2003   -0.2400;
    0.1760    0.1410    0.1750    0.1460    0.0952    0.0644    0.0423    0.0019   -0.0112   -0.0357   -0.0464   -0.0974   -0.1185   -0.1145   -0.1705  -0.2213   -0.2515   -0.2160   -0.2518;
    0.2400    0.2000    0.1700    0.1440    0.0874    0.0679    0.0561    0.0254   -0.0017   -0.0228   -0.0390   -0.0545   -0.0697   -0.0898   -0.1161  -0.1731   -0.1991   -0.2307   -0.2705;
    0.2950    0.2480    0.2080    0.1550    0.1110    0.0902    0.0731    0.0578    0.0328    0.0210   -0.0034   -0.0241   -0.0535   -0.0712   -0.0992  -0.1449   -0.1978   -0.2422   -0.2889;
    0.3000    0.2410    0.1910    0.1580    0.1054    0.0784    0.0628    0.0482    0.0252    0.0064   -0.0112   -0.0323   -0.0634   -0.0829   -0.1004  -0.1527   -0.1861   -0.2362   -0.2997];

% Производная боковой силы по угловой скорости рыскания
% Czwy = f(alpha1)
Czwy1 = [1.4400    1.4400    1.4400    1.0500    0.9810    0.9390    0.9990    0.9810    0.8190    0.4830    0.5900    1.2100   -0.4930   -1.0400   -1.2100  -1.5800   -1.3700   -0.0259   -0.1270    0.1930]';
Czwy1 = -Czwy1;

% Приращение Czwy при выпуске носков
% dCzwy_nos = f(alpha2)
dCzwy_nos1 = [-0.5580   -0.5580   -0.5580   -0.1980   -0.1070    0.0270   -0.0850   -0.0460    0.3310    0.2150    0.4300   -0.0600   -0.3740   -0.1870 ]'; 
dCzwy_nos1 = -dCzwy_nos1;

% Производная боковой силы по угловой скорости крена
% Czwx = f(alpha1)
Czwx1 = [0.0333    0.0333    0.0333   -0.1770    0.0055    0.0679    0.3100    0.2340    0.3440    0.3620    0.6110    0.5290    0.2980   -2.2700    0.9710   1.0200    2.9000    0.4510   -0.2940   -0.2610]';

% Приращение Czwx при выпуске носков
% dCzwx_nos = f(alpha2)
dCzwx_nos1 = [-0.1410   -0.1410   -0.1410    0.0690   -0.1970    0.0601   -0.1210   -0.0520    0.0750    0.1060   -0.0770   -0.6420   -0.2550   -0.1280]';      

interpCz = csaps({alpha1, beta1}, Cz1, 1.0 - 1.0e-5);
interpCz_nos = csaps({alpha2, beta1}, Cz_nos1, 1.0 - 1.0e-5);
interpCzwx1 = pchip(alpha1, Czwx1);
interpCzwx2 = pchip(alpha2, dCzwx_nos1);
interpCzwy1 = pchip(alpha1, Czwy1);
interpCzwy2 = pchip(alpha2, dCzwy_nos1);
interpCzdel = csaps({alpha1, beta1}, Czdel20, 1.0 - 1.0e-5);
interpCzdel_nos = csaps({alpha2, beta1}, Czdel20_nos, 1.0 - 1.0e-5);
interpCzdrn = csaps({alpha1, beta1}, Czdrn30, 1.0 - 1.0e-5);
end

ntraj = size(alpha, 2);
Cz = zeros(1, ntraj);
Cz_nos = zeros(1, ntraj);
Czwx = zeros(1, ntraj);
Czwy = zeros(1, ntraj);
Czdel = zeros(1, ntraj);
Czdel_nos = zeros(1, ntraj);
Czdrn = zeros(1, ntraj);
for i = 1 : ntraj
    Cz(i) = fnval(interpCz, {(alpha(i)), (beta(i))});
    Cz_nos(i) = fnval(interpCz_nos, {(alpha(i)), (beta(i))});
    Czwx(i) = fnval(interpCzwx1, alpha(i)) + fnval(interpCzwx2, alpha(i)).*(dnos / deg2rad(25));
    Czwy(i) = fnval(interpCzwy1, alpha(i)) + fnval(interpCzwy2, alpha(i)).*(dnos / deg2rad(25));
    Czdel(i) = fnval(interpCzdel, {(alpha(i)), (beta(i))});
    Czdel_nos(i) = fnval(interpCzdel_nos, {(alpha(i)), (beta(i))});
    Czdrn(i) = fnval(interpCzdrn, {(alpha(i)), (beta(i))});
end

% Cборка
dCz_nos = Cz_nos - Cz;
dCzdel = Czdel - Cz;
dCzdel_nos = Czdel_nos - Cz_nos - dCzdel;
dCzdrn = Czdrn - Cz;

Cz = Cz + dCz_nos.*(dnos / deg2rad(25)) + ...
          (dCzdel + dCzdel_nos.*(dnos / deg2rad(25))).*(del / deg2rad(20)) + ...
          dCzdrn.*(drn / deg2rad(-30)) + ...
          Czwx.*((Wx.*l)./(2 * V)) + Czwy.*((Wy.*l)./(2 * V));
