"""
Константы для отображения состояний и управляющих сигналов.

Этот модуль содержит словари с LaTeX-форматированием для отображения названий
состояний и управляющих сигналов на графиках и в документации. Поддерживаются
как русские, так и английские обозначения для различных параметров летательных
аппаратов.

Доступные словари:
- state_to_latex_rus: Русские обозначения состояний
- state_to_latex_eng: Английские обозначения состояний
- ref_state_to_latex_rus: Русские обозначения опорных состояний
- ref_state_to_latex_eng: Английские обозначения опорных состояний
- control_to_latex_rus: Русские обозначения управляющих сигналов
- control_to_latex_eng: Английские обозначения управляющих сигналов
"""

state_to_latex_rus = {
    "alpha": r"$\alpha$" + ", град.",
    "beta": r"$\beta$" + ", град.",
    "wx": r"$\omega_x$" + ", град./с",
    "wy": r"$\omega_y$" + ", град./с",
    "wz": r"$\omega_z$" + ", град./с",
    # eng названия состояний
    "q": r"$\omega_z$" + ", град./с",
    "u": r"$u$" + ", м/с",
    "gamma": r"$\gamma$" + ", град.",
    "phi": r"$\gamma$" + ", град.",
    "psi": r"$\varpsi$" + ", град.",
    "theta": r"$\vartheta$" + ", град.",
    "stab": r"$\delta_{B}$" + ", град.",
    "ele": r"$\delta_{B}$" + ", град.",
    "ail": r"$\delta_{Э}$" + ", град.",
    "dir": r"$\delta_{Н}$" + ", град.",
    "rud": r"$\delta_{Н}$" + ", град.",
    "dstab": r"$\dot{\delta_{B}}$" + ", град./с",
    "dail": r"$\dot{\delta_{Э}}$" + ", град./с",
    "ddir": r"$\dot{\delta_{Н}}$" + ", град./с",
    "altitude": r"Высота" + ", м.",
}

ref_state_to_latex_rus = {
    "alpha": r"$\alpha^{ref}$" + ", град.",
    "beta": r"$\beta^{ref}$" + ", град.",
    "wx": r"$\omega^{ref}_x$" + ", град./с",
    "wy": r"$\omega^{ref}_y$" + ", град./с",
    "wz": r"$\omega^{ref}_z$" + ", град./с",
    "q": r"$\omega^{ref}_z$" + ", град./с",
    "gamma": r"$\gamma^{ref}$" + ", град.",
    "phi": r"$\gamma^{ref}$" + ", град.",
    "psi": r"$\varpsi^{ref}$" + ", град.",
    "theta": r"$\vartheta^{ref}$" + ", град.",
    "stab": r"$\delta^{ref}_{B}$" + ", град.",
    "ele": r"$\delta{ref}_{B}$" + ", град.",
    "ail": r"$\delta{ref}_{Э}$" + ", град.",
    "dir": r"$\delta{ref}_{Н}$" + ", град.",
    "rud": r"$\delta{ref}_{Н}$" + ", град.",
    "altitude": r"Высота" + ", м.",
}

ref_state_to_latex_eng = {
    "alpha": r"$\alpha^{ref}$" + ", deg",
    "beta": r"$\beta^{ref}$" + ", deg.",
    "wx": r"$\omega^{ref}_x$" + ", deg./s",
    "wy": r"$\omega^{ref}_y$" + ", deg./s",
    "wz": r"$\omega^{ref}_z$" + ", deg./s",
    "gamma": r"$\gamma^{ref}$" + ", deg.",
    "phi": r"$\gamma^{ref}$" + ", deg.",
    "psi": r"$\varpsi^{ref}$" + ", deg.",
    "theta": r"$\vartheta^{ref}$" + ", deg.",
    "stab": r"$\delta^{ref}_{S_{act}}$" + ", deg.",
    "ele": r"$\delta^{ref}_{S_{act}}$" + ", deg.",
    "ail": r"$\delta^{ref}_{A_{act}}$" + ", deg.",
    "dir": r"$\delta^{ref}_{D_{act}}$" + ", deg.",
    "rud": r"$\delta^{ref}_{D_{act}}$" + ", deg.",
}


state_to_latex_eng = {
    "alpha": r"$\alpha$" + ", deg",
    "beta": r"$\beta$" + ", deg.",
    "wx": r"$\omega_x$" + ", deg./s",
    "wy": r"$\omega_y$" + ", deg./s",
    "wz": r"$\omega_z$" + ", deg./s",
    "gamma": r"$\gamma$" + ", deg.",
    "phi": r"$\gamma$" + ", deg.",
    "psi": r"$\varpsi$" + ", deg.",
    "theta": r"$\vartheta$" + ", deg.",
    "stab": r"$\delta_{S_{act}}$" + ", deg.",
    "ele": r"$\delta_{S_{act}}$" + ", deg.",
    "ail": r"$\delta_{A_{act}}$" + ", deg.",
    "dir": r"$\delta_{D_{act}}$" + ", deg.",
    "rud": r"$\delta_{D_{act}}$" + ", deg.",
    "dstab": r"$\dot{\delta_{D}}$" + ", deg./s",
    "dail": r"$\dot{\delta_{A}}$" + ", deg./s",
    "ddir": r"$\dot{\delta_{D}}$" + ", deg./s",
}

control_to_latex_rus = {
    "stab": r"$\delta_{S_{act}}$" + ", град.",
    "ele": r"$\delta_{S_{act}}$" + ", град.",
    "ail": r"$\delta_{A_{act}}$" + ", град.",
    "dir": r"$\delta_{D_{act}}$" + ", град.",
    "rud": r"$\delta_{D_{act}}$" + ", град.",
}

control_to_latex_eng = {
    "stab": r"$\delta_{B_{act}}$" + ", deg.",
    "ele": r"$\delta_{B_{act}}$" + ", deg.",
    "ail": r"$\delta_{Э_{act}}$" + ", deg.",
    "dir": r"$\delta_{Н_{act}}$" + ", deg.",
    "rud": r"$\delta_{Н_{act}}$" + ", deg.",
}
