import os, sys

from AnyQt.QtCore import QRect
from AnyQt.QtWidgets import QApplication, QFileDialog, QMessageBox

from orangewidget import gui
from orangewidget.widget import Input

from oasys2.widget.widget import OWWidget
from oasys2.widget import gui as oasysgui
from oasys2.canvas.util.canvas_util import add_widget_parameters_to_module

from orangecontrib.srw.util.python_script import PythonConsole
from orangecontrib.srw.util.srw_objects import SRWData

class SRWPythonScriptSE(OWWidget):

    name = "SRW Python Script (SE)"
    description = "SRW Python Script (SE)"
    icon = "icons/python_script_se.png"
    maintainer = "Luca Rebuffi"
    maintainer_email = "lrebuffi(@at@)anl.gov"
    priority = 1
    category = "Data Display Tools"
    keywords = ["data", "file", "load", "read"]

    class Inputs:
        srw_data = Input("SRWData", SRWData, default=True, auto_summary=False)

    WIDGET_WIDTH = 950
    WIDGET_HEIGHT = 650

    want_main_area=1
    want_control_area = 0

    input_srw_data=None

    def __init__(self):
        super().__init__()

        geom = QApplication.primaryScreen().geometry()
        self.setGeometry(QRect(round(geom.width()*0.05),
                               round(geom.height()*0.05),
                               round(min(geom.width()*0.98, self.WIDGET_WIDTH)),
                               round(min(geom.height()*0.95, self.WIDGET_HEIGHT))))

        self.setMaximumHeight(self.WIDGET_HEIGHT)
        self.setMaximumWidth(self.WIDGET_WIDTH)

        gen_box = gui.widgetBox(self.mainArea, "SRW Native Code: SE", addSpace=False, orientation="horizontal")

        tabs_setting = oasysgui.tabWidget(gen_box)
        tabs_setting.setFixedHeight(self.WIDGET_HEIGHT-60)
        tabs_setting.setFixedWidth(self.WIDGET_WIDTH-60)

        tab_scr = oasysgui.createTabPage(tabs_setting, "Python Script")
        tab_out = oasysgui.createTabPage(tabs_setting, "System Output")

        self.pythonScript = oasysgui.textArea(readOnly=False)
        self.pythonScript.setStyleSheet("background-color: white; font-family: Courier, monospace;")
        self.pythonScript.setMaximumHeight(self.WIDGET_HEIGHT - 300)

        script_box = oasysgui.widgetBox(tab_scr, "", addSpace=False, orientation="vertical", height=self.WIDGET_HEIGHT - 80, width=self.WIDGET_WIDTH - 80)
        script_box.layout().addWidget(self.pythonScript)

        console_box = oasysgui.widgetBox(script_box, "", addSpace=True, orientation="vertical",
                                          height=150, width=self.WIDGET_WIDTH - 80)

        self.console = PythonConsole(self.__dict__, self)
        console_box.layout().addWidget(self.console)

        self.shadow_output = oasysgui.textArea()

        out_box = oasysgui.widgetBox(tab_out, "System Output", addSpace=True, orientation="horizontal", height=self.WIDGET_HEIGHT - 80)
        out_box.layout().addWidget(self.shadow_output)

        #############################

        button_box = oasysgui.widgetBox(tab_scr, "", addSpace=True, orientation="horizontal")

        gui.button(button_box, self, "Run Script", callback=self.execute_script, height=40)
        gui.button(button_box, self, "Save Script to File", callback=self.save_script, height=40)

    def execute_script(self):
        self._script = str(self.pythonScript.toPlainText())
        self.console.write("\nRunning script:\n")
        self.console.push("exec(_script)")
        self.console.new_prompt(sys.ps1)

    def save_script(self):
        file_name = QFileDialog.getSaveFileName(self, "Save File to Disk", os.getcwd(), filter='*.py')[0]

        if not file_name is None:
            if not file_name.strip() == "":
                file = open(file_name, "w")
                file.write(str(self.pythonScript.toPlainText()))
                file.close()

                QMessageBox.information(self, "QMessageBox.information()",
                                              "File " + file_name + " written to disk",
                                              QMessageBox.Ok)

    @Inputs.srw_data
    def set_input(self, srw_data):
        if not srw_data is None:
            self.input_srw_data = srw_data

            self.pythonScript.setText("")

            try:
                self.pythonScript.setText(self.input_srw_data.get_srw_beamline().to_python_code([srw_data.get_srw_wavefront(), False]))
            except Exception as e:
                self.pythonScript.setText("Problem in writing python script:\n" + str(sys.exc_info()[0]) + ": " + str(sys.exc_info()[1]))

                if self.IS_DEVELOP: raise e

add_widget_parameters_to_module(__name__)