"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// In order to confirm that we avoid name collisions on the event binding with both multiple constructs and multiple stacks,
// launch two stacks with two constructs at the same time using
//  cdk-integ integ.second-long-stack-name.js integ.long-stack-name.js --no-clean
// and confirm that all topics are publishing messages.
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const events = require("aws-cdk-lib/aws-events");
const aws_cdk_lib_2 = require("aws-cdk-lib");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
const app = new aws_cdk_lib_2.App();
const stackTwo = new aws_cdk_lib_2.Stack(app, core_1.generateIntegStackName(__filename) + 'ThisIsTheLongestNameForAStackItMustBeGreaterThanSixtyFourCharactersLongAndThisShouldJustAboutDoItNoItMustBeABitLessShort');
const propsTwo = {
    eventRuleProps: {
        schedule: events.Schedule.rate(aws_cdk_lib_1.Duration.minutes(1))
    }
};
new lib_1.EventbridgeToSns(stackTwo, 'test-construct', propsTwo);
new lib_1.EventbridgeToSns(stackTwo, 'second-construct', propsTwo);
new integ_tests_alpha_1.IntegTest(stackTwo, 'Integ', { testCases: [
        stackTwo
    ] });
//# sourceMappingURL=data:application/json;base64,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