"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyxetabase.rest_clients._parent_rest_clients import _ParentRestClient


class CVDB(_ParentRestClient):
    """
    This class contains methods for the 'Analysis - CVDB' webservices
    PATH: /{apiVersion}/analysis/cvdb
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(CVDB, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def update_acl(self, data=None, **options):
        """
        Update the set of permissions granted in CVDB for the OpenCGA users
            that have access to the clinical analyses.
        PATH: /{apiVersion}/analysis/cvdb/acl/update

        :param dict data: Parameters for the ACL updating task
            (cvdb-acl-update). (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='analysis', resource='update', subcategory='cvdb/acl', data=data, **options)

    def aggregate_analysis(self, **options):
        """
        Calculate and fetch clinical analysis aggregation stats.
        PATH: /{apiVersion}/analysis/cvdb/analysis/aggregate

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        :param str field: List of facet fields separated by semicolons, e.g.:
            type;disorderId. For nested faceted fields use >>, e.g.:
            type>>disorderId. Accepted values: studyId, type, disorderId,
            fileNames, probandId, probandDisorderIds, probandPhenotypeNames,
            familyId, familyPhenotypeNames, familyMemberIds, panelIds, status.
        """

        return self._get(category='analysis', resource='aggregate', subcategory='cvdb/analysis', **options)

    def query_analysis(self, **options):
        """
        Filter and fetch clinical analyses from CVDB.
        PATH: /{apiVersion}/analysis/cvdb/analysis/query

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        """

        return self._get(category='analysis', resource='query', subcategory='cvdb/analysis', **options)

    def aggregate_evidence(self, **options):
        """
        Calculate and fetch clinical variant evidence aggregation stats.
        PATH: /{apiVersion}/analysis/cvdb/evidence/aggregate

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        :param str field: List of facet fields separated by semicolons, e.g.:
            geneName;tier. For nested faceted fields use >>, e.g.:
            geneName>>tier. Accepted values: caId, ciId, cvId, variantId,
            studyId, phenotypeNames, geneName, transcriptId, soTermNames,
            xrefIds, panelId, mois, penetrance, acmgs, tier,
            clinicalSignificance, drugResponse, traitAssociation,
            functionalEffect, tumorigenesis, otherClassifications,
            rolesInCancer, reviewAcmgs, reviewTier, reviewClinicalSignificance.
        """

        return self._get(category='analysis', resource='aggregate', subcategory='cvdb/evidence', **options)

    def query_evidence(self, **options):
        """
        Filter and fetch clinical variant evidences from CVDB.
        PATH: /{apiVersion}/analysis/cvdb/evidence/query

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        """

        return self._get(category='analysis', resource='query', subcategory='cvdb/evidence', **options)

    def run_index(self, data=None, **options):
        """
        Index clinical analyses of a OpenCGA project, a study or a list of
            clinical analyses into CVDB.
        PATH: /{apiVersion}/analysis/cvdb/index/run

        :param dict data: Parameters: Index clinical analyses of a OpenCGA
            project, a study or a list of clinical analyses into CVDB.
            (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_description: Job description.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='analysis', resource='run', subcategory='cvdb/index', data=data, **options)

    def aggregate_interpretation(self, **options):
        """
        Calculate and fetch clinical interpretation aggregation stats.
        PATH: /{apiVersion}/analysis/cvdb/interpretation/aggregate

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        :param str field: List of facet fields separated by semicolons, e.g.:
            panelIds;methodName. For nested faceted fields use >>, e.g.:
            panelIds>>methodName. Accepted values: caId, studyId, primary,
            panelIds, analystId, analystName, analystEmail, analystAssignedBy,
            analystDate, methodName, methodVersion, methodCommit, statusId,
            statusDescription, statusType, statusDate, creationDate,
            modificationDate, version.
        """

        return self._get(category='analysis', resource='aggregate', subcategory='cvdb/interpretation', **options)

    def query_interpretation(self, **options):
        """
        Filter and fetch clinical interpretations from CVDB.
        PATH: /{apiVersion}/analysis/cvdb/interpretation/query

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        """

        return self._get(category='analysis', resource='query', subcategory='cvdb/interpretation', **options)

    def aggregate_variant(self, **options):
        """
        Calculate and fetch clinical variant aggregation stats.
        PATH: /{apiVersion}/analysis/cvdb/variant/aggregate

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        :param str field: List of facet fields separated by semicolons, e.g.:
            type;biotypes. For nested faceted fields use >>, e.g.:
            type>>biotypes. Accepted values: caId, ciId, variantId, studyId,
            primary, discussionAuthor, discussionDate,discussionText,
            confidenceValue, confidenceAuthor, confidenceDate, tags, status,
            chromosome, start, end, xrefs, type, release, studies, phastCons,
            phylop, gerp, caddRaw, caddScaled, sift, siftDesc, polyphen,
            polyphenDesc, genes, biotypes, soAcc, clinicalSig.
        """

        return self._get(category='analysis', resource='aggregate', subcategory='cvdb/variant', **options)

    def query_variant(self, **options):
        """
        Filter and fetch clinical variants from CVDB.
        PATH: /{apiVersion}/analysis/cvdb/variant/query

        :param str project: Project ID.
        :param str study: Study ID (or list of study IDs separated by commas).
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param str ca_id: Clinical analysis ID (or list of IDs separated by
            commas).
        :param str ca_description: Clinical analysis description (word or list
            of words contained in the text, if the words are separated by a
            comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ca_type: Clinical analysis type (or list of types separated
            by commas).
        :param str ca_disorder_id: Clinical analysis disorder ID (or list of
            IDs separated by commas).
        :param str ca_filename: Clinical analysis filename (or list of
            filenames separated by commas).
        :param str ca_proband_id: Clinical analysis proband ID (or list of IDs
            separated by commas).
        :param str ca_proband_disorder_id: Clinical analysis proband disorder
            ID (or list of disorder IDs separated by commas).
        :param str ca_proband_phenotype_name: Clinical analysis proband
            phenotype name (or list of phenotype names separated by commas).
        :param str ca_family_id: Clinical analysis family ID (or list of IDs
            separated by commas).
        :param str ca_family_phenotype_name: Clinical analysis family
            phenotype names (or list of names separated by commas).
        :param str ca_family_member_id: Clinical analysis family member ID (or
            list of IDs separated by commas).
        :param str ca_report: Clinical analysis report text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str ca_status: Clinical analysis status (or list of status
            separated by commas).
        :param bool ca_locked: Clinical analysis locked (true or false).
        :param str ci_id: Clinical interpretation ID (or list of IDs separated
            by commas).
        :param bool ci_primary: Clinical interpretation primary (true or
            false).
        :param str ci_description: Clinical interpretation description (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str ci_panel_id: Clinical interpretation panel ID or name (or
            list of IDs or names separated by commas).
        :param str ci_analyst_id: Clinical interpretation analyst ID (or list
            of IDs separated by commas).
        :param str ci_analyst_name: Clinical interpretation analyst name (or
            list of names separated by commas).
        :param str ci_analyst_email: Clinical interpretation analyst e-mail
            (or list of e-mails separated by commas).
        :param str ci_analyst_assigned_by: Clinical interpretation analyst
            assignee name (or list of names separated by commas).
        :param str ci_analyst_date: Clinical interpretation analyst date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_method_name: Clinical interpretation method name (or
            list of names separated by commas).
        :param str ci_method_version: Clinical interpretation method version
            (or list of versions separated by commas).
        :param str ci_method_commit: Clinical interpretation method commit (or
            list of commits separated by commas).
        :param str ci_method_dependencies: Clinical interpretation method
            dependencies (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_comments: Clinical interpretation comment text (word or
            list of words contained in the text, if the words are separated by
            a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param bool ci_locked: Clinical interpretation locked (true or false).
        :param str ci_status_id: Clinical interpretation status ID (or list of
            IDs separated by commas). Valid values: NOT_STARTED, ACTIVE, DONE,
            CLOSED.
        :param str ci_status_name: Clinical interpretation status name (or
            list of names separated by commas).
        :param str ci_status_description: Clinical interpretation status
            description (word or list of words contained in the text, if the
            words are separated by a comma an OR will be applied; if the words
            are separated by a semicolon, an AND will be applied).
        :param str ci_status_date: Clinical interpretation status date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_creation_date: Clinical interpretation creation date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str ci_modification_date: Clinical interpretation modification
            date (or list of dates separated by commas), with format
            YYYYMMDDhhmmss, e.g.: 20231026120345; range is available
            start_date-end_date, e.g.: 20231001000000-20231101000000.
        :param int ci_version: Clinical interpretation version number (or list
            of versions separated by commas).
        :param str cv_id: Clinical variant ID (or list of IDs separated by
            commas).
        :param str cv_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cv_primary_finding: Clinical variant is a primary finding
            (true or false).
        :param bool cv_primary_interpretation: Clinical variant belongs to the
            primary interpretation (true or false).
        :param str cv_comments: Clinical variant comment text (word or list of
            words contained in the text, if the words are separated by a comma
            an OR will be applied; if the words are separated by a semicolon,
            an AND will be applied).
        :param str cv_discussion_author: Clinical variant discussion author
            (or list of authors separated by commas).
        :param str cv_discussion_date: Clinical variant discussion date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_discussion_text: Clinical variant discussion text (word
            or list of words contained in the text, if the words are separated
            by a comma an OR will be applied; if the words are separated by a
            semicolon, an AND will be applied).
        :param str cv_confidence_value: Clinical variant confidence value (or
            list of values separated by commas).
        :param str cv_confidence_author: Clinical variant confidence author
            (or list of authors separated by commas).
        :param str cv_confidence_date: Clinical variant confidence date (or
            list of dates separated by commas), with format YYYYMMDDhhmmss,
            e.g.: 20231026120345; range is available start_date-end_date, e.g.:
            20231001000000-20231101000000.
        :param str cv_tag: Clinical variant tag (or list of tags separated by
            commas).
        :param str cv_status: Clinical variant status (or list of status
            separated by commas).
        :param str cv_region: Variant region (or list of regions, these can be
            just a single chromosome name or regions in the format
            chr:start-end, e.g.: 2,3:100000-200000).
        :param str cv_biotype: Variant biotype, e.g. protein_coding (or list
            of biotypes separated by commas).
        :param str cv_ct: Variant SO consequence type (or list of SOs
            separated by commas), e.g. missense_variant,stop_lost or
            SO:0001583,SO:0001578. Accepts aliases 'loss_of_function' and
            'protein_altering'.
        :param str cv_transcript_flag: Variant transcript flag (or list of
            flags separated by commas), e.g. canonical, CCDS, basic, LRG, MANE
            Select, MANE Plus Clinical, EGLH_HaemOnc, TSO500.
        :param str cv_gene: Variant gene (or list genes separated by commas),
            most gene IDs are accepted (HGNC, Ensembl gene, ...).
        :param str cv_xref: Variant external reference (or list of references
            separated by commas), these can be genes, proteins or variants.
            Accepted IDs include HGNC, Ensembl genes, dbSNP, ClinVar, HPO,
            Cosmic, ...
        :param str cv_annot_role_in_cancer_genes: Variant rol in cancer genes
            (or list of roles separated by commas).
        :param str cv_type: Variant type or list of types, accepted values are
            SNV, MNV, INDEL, SV, COPY_NUMBER, COPY_NUMBER_LOSS,
            COPY_NUMBER_GAIN, INSERTION, DELETION, DUPLICATION,
            TANDEM_DUPLICATION, BREAKEND, e.g. SNV,INDEL.
        :param str cv_protein_substitution: Variant protein substitution score
            (or list of scores separated by commas), include SIFT and PolyPhen.
            You can query using the score {protein_score}[<|>|<=|>=]{number} or
            the description {protein_score}[~=|=]{description} e.g.
            polyphen>0.1,sift=tolerant.
        :param str cv_conservation: Variant conservation score (or list of
            scores separated by commas) with the format
            {conservation_score}[<|>|<=|>=]{number} e.g.
            phastCons>0.5,phylop<0.1,gerp>0.1.
        :param str cv_functional_score: Variant functional score (or list of
            scores separated by commas) with the format
            {functional_score}[<|>|<=|>=]{number} e.g. cadd_scaled>5.2 ,
            cadd_raw<=0.3.
        :param str cv_population_frequency_alt: Variant alternate population
            frequency (or list of frequencies separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_maf: Variant population minor
            allele frequency (or list of frequencies separated by commas), with
            the format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_population_frequency_ref: Variant reference population
            frequency (or list of frequences separated by commas), with the
            format {study}:{population}[<|>|<=|>=]{number}. e.g.
            1000G:ALL<0.01.
        :param str cv_cohort_stats_alt: Variant alternate allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_maf: Variant minor allele frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_ref: Variant reference allele frequency (or
            list of frequencies separated by commas), with the foramt
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL<=0.4.
        :param str cv_cohort_stats_pass: Variant filter PASS frequency (or
            list of frequencies separated by commas), with the format
            [{study:}]{cohort}[<|>|<=|>=]{number}. e.g. ALL>0.8.
        :param str cv_score: Variant score (or list of scores separated by
            commas), with the format: [{study:}]{score}[<|>|<=|>=]{number}.
        :param str cv_annot_go_genes: Variant gene GO (or list of GOs
            separated by commas).
        :param str cv_annot_expression_genes: Variant gene expression (or list
            of expressions separated by commas).
        :param str cv_gene_trait_id: Variant gene trait association ID (or
            list of trait IDs separated by commas), e.g. 'umls:C0007222' ,
            'OMIM:269600'.
        :param str cv_trait: Variant Trait (or list of traits separated by
            commas), based on ClinVar, HPO, COSMIC, i.e.: IDs, histologies,
            descriptions,...
        :param str cv_protein_keyword: Uniprot protein variant annotation
            keyword (or list of keywords separated by commas).
        :param str cve_variant_id: Variant ID (or list of IDs separated by
            commas).
        :param bool cve_primary_finding: Clinical variant evidence belongs to
            a primary finding (true or false).
        :param bool cve_primary_interpretation: Clinical variant evidence
            belongs to the primary interpretation (true or false).
        :param str cve_phenotype_name: Clinical variant evidence phenotype
            name (or names separated by commas).
        :param str cve_gene_name: Clinical variant evidence gene name (or
            names separated by commas).
        :param str cve_transcript_id: Clinical variant evidence transcript ID
            (or IDs separated by commas).
        :param str cve_so_term_name: Clinical variant evidence sequence
            ontology name (or names separated by commas).
        :param str cve_xref_id: Clinical variant evidence Xref ID (or IDs
            separated by commas).
        :param str cve_panel_id: Clinical variant evidence panel ID (or IDs
            separated by commas).
        :param str cve_moi: Clinical variant evidence mode of inheritance (or
            list of modes of inheritance separated by commas), valid values:
            AUTOSOMAL_DOMINANT, AUTOSOMAL_RECESSIVE, X_LINKED_DOMINANT,
            X_LINKED_RECESSIVE, Y_LINKED, MITOCHONDRIAL, DE_NOVO,
            MENDELIAN_ERROR, COMPOUND_HETEROZYGOUS, UNKNOWN.
        :param str cve_penetrance: Clinical variant evidence penetrance (or
            list of penetrance values separated by commas), valid values:
            COMPLETE, INCOMPLETE, UNKNOWN.
        :param str cve_acmg: Clinical variant evidence ACMG (or ACGMs
            separated by commas).
        :param str cve_tier: Clinical variant evidence tier (or list of tier
            values separated by commas).
        :param str cve_clinical_significance: Clinical variant evidence
            clinical significance (or list of clinical  significances separated
            by commas).
        :param str cve_drug_response: Clinical variant evidence drug response
            (or list of drug responses separated by commas).
        :param str cve_trait_association: Clinical variant evidence trait
            association (or list of traits separated by commas).
        :param str cve_functional_effect: Clinical variant evidence functional
            effect (or list of functional effects separated by commas).
        :param str cve_tumorigenesis: Clinical variant evidence tumorigenesis
            (or list of tumorigenesis values separated by commas).
        :param str cve_other_classification: Clinical variant evidence
            other-classification (or list of other  classification values
            separated by commas).
        :param str cve_role_in_cancer: Clinical variant evidence role in
            cancer (or roles in cancer separated by commas).
        :param str cve_review_acmg: Clinical variant evidence review ACMG (or
            ACGMs separated by commas).
        :param str cve_review_tier: Clinical variant evidence review tier (or
            list of tier values separated by commas).
        :param str cve_review_clinical_significance: Clinical variant evidence
            review clinical significance (or list of clinical significances
            separated by commas).
        :param str cve_review_text: Clinical variant evidence review text
            (word or list of words contained in the text, if the words are
            separated by a comma an OR will be applied; if the words are
            separated by a semicolon, an AND will be applied).
        """

        return self._get(category='analysis', resource='query', subcategory='cvdb/variant', **options)

    def stats_variant(self, variant_id, **options):
        """
        Get clinical variant summary from CVDB.
        PATH: /{apiVersion}/analysis/cvdb/variant/{variantId}/stats

        :param str variant_id: Variant ID (or comma separated list of variant
            IDs). (REQUIRED)
        :param str project: Project ID(or command separated list of project
            IDs).
        """

        return self._get(category='analysis', resource='stats', subcategory='cvdb/variant', second_query_id=variant_id, **options)

