"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyxetabase.rest_clients._parent_rest_clients import _ParentRestClient


class Study(_ParentRestClient):
    """
    This class contains methods for the 'Studies' webservices
    PATH: /{apiVersion}/studies
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Study, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def update_acl(self, members, action, data=None, **options):
        """
        Update the set of permissions granted for the member.
        PATH: /{apiVersion}/studies/acl/{members}/update

        :param dict data: JSON containing the parameters to modify ACLs.
            'template' could be either 'admin', 'analyst' or 'view_only'.
            (REQUIRED)
        :param str action: Action to be performed [ADD, SET, REMOVE or RESET].
            Allowed values: ['SET ADD REMOVE RESET'] (REQUIRED)
        :param str members: Comma separated list of user or group ids.
            (REQUIRED)
        """

        options['action'] = action
        return self._post(category='studies', resource='update', subcategory='acl', second_query_id=members, data=data, **options)

    def create(self, data=None, **options):
        """
        Create a new study.
        PATH: /{apiVersion}/studies/create

        :param dict data: study. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str project: Project [organization@]project where project can
            be either the ID or the alias.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='studies', resource='create', data=data, **options)

    def search(self, project, **options):
        """
        Search studies.
        PATH: /{apiVersion}/studies/search

        :param str project: Project [organization@]project where project can
            be either the ID or the alias. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param str name: Study name.
        :param str id: Study ID.
        :param str alias: Study alias.
        :param str fqn: Study full qualified name.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str internal_status: Filter by internal status.
        :param str status: Filter by status.
        :param str attributes: Attributes.
        :param str release: Release value.
        """

        options['project'] = project
        return self._get(category='studies', resource='search', **options)

    def acl(self, studies, **options):
        """
        Return the acl of the study. If member is provided, it will only
            return the acl for the member.
        PATH: /{apiVersion}/studies/{studies}/acl

        :param str studies: Comma separated list of Studies
            [[organization@]project:]study where study and project can be
            either the ID or UUID up to a maximum of 100. (REQUIRED)
        :param str member: User or group id.
        :param bool silent: Boolean to retrieve all possible entries that are
            queried for, false to raise an exception whenever one of the
            entries looked for cannot be shown for whichever reason.
        """

        return self._get(category='studies', resource='acl', query_id=studies, **options)

    def info(self, studies, **options):
        """
        Fetch study information.
        PATH: /{apiVersion}/studies/{studies}/info

        :param str studies: Comma separated list of Studies
            [[organization@]project:]study where study and project can be
            either the ID or UUID up to a maximum of 100. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        """

        return self._get(category='studies', resource='info', query_id=studies, **options)

    def search_audit(self, study, **options):
        """
        Search audit collection.
        PATH: /{apiVersion}/studies/{study}/audit/search

        :param str study: Study ID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param int limit: Number of results to be returned.
        :param int skip: Number of results to skip.
        :param bool count: Get the total number of results matching the query.
            Deactivated by default.
        :param str operation_id: Audit operation UUID.
        :param str user_id: User ID.
        :param str action: Action performed by the user.
        :param str resource: Resource involved. Allowed values: ['AUDIT NOTE
            ORGANIZATION USER PROJECT STUDY FILE SAMPLE JOB INDIVIDUAL COHORT
            DISEASE_PANEL FAMILY CLINICAL_ANALYSIS INTERPRETATION VARIANT
            ALIGNMENT CLINICAL EXPRESSION RGA FUNCTIONAL WORKFLOW RESOURCE']
        :param str resource_id: Resource ID.
        :param str resource_uuid: resource UUID.
        :param str status: Filter by status. Allowed values: ['SUCCESS ERROR']
        :param str date: Date. Format: yyyyMMddHHmmss. Examples: >2018,
            2017-2018, <201805.
        """

        return self._get(category='studies', resource='search', query_id=study, subcategory='audit', **options)

    def groups(self, study, **options):
        """
        Return the groups present in the study. For owners and administrators
            only.
        PATH: /{apiVersion}/studies/{study}/groups

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str id: Group id. If provided, it will only fetch information
            for the provided group.
        :param bool silent: Boolean to retrieve all possible entries that are
            queried for, false to raise an exception whenever one of the
            entries looked for cannot be shown for whichever reason.
        """

        return self._get(category='studies', resource='groups', query_id=study, **options)

    def sync_groups(self, study, data=None, **options):
        """
        Associate a remote group from an authentication origin with a local
            group in a study.
        PATH: /{apiVersion}/studies/{study}/groups/sync

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        """

        return self._post(category='studies', resource='sync', query_id=study, subcategory='groups', data=data, **options)

    def update_groups(self, study, data=None, **options):
        """
        Add or remove a group.
        PATH: /{apiVersion}/studies/{study}/groups/update

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str action: Action to be performed: ADD or REMOVE a group.
            Allowed values: ['ADD REMOVE']
        """

        return self._post(category='studies', resource='update', query_id=study, subcategory='groups', data=data, **options)

    def update_groups_users(self, study, group, data=None, **options):
        """
        Add, set or remove users from an existing group.
        PATH: /{apiVersion}/studies/{study}/groups/{group}/users/update

        :param dict data: JSON containing the parameters. (REQUIRED)
        :param str group: Group name. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str action: Action to be performed: ADD, SET or REMOVE users
            to/from a group. Allowed values: ['ADD SET REMOVE']
        """

        return self._post(category='studies', resource='users/update', query_id=study, subcategory='groups', second_query_id=group, data=data, **options)

    def create_notes(self, study, data=None, **options):
        """
        Create a new note.
        PATH: /{apiVersion}/studies/{study}/notes/create

        :param dict data: JSON containing the Note to be added. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='studies', resource='create', query_id=study, subcategory='notes', data=data, **options)

    def search_notes(self, study, **options):
        """
        Search for notes of scope STUDY.
        PATH: /{apiVersion}/studies/{study}/notes/search

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str creation_date: Creation date. Format: yyyyMMddHHmmss.
            Examples: >2018, 2017-2018, <201805.
        :param str modification_date: Modification date. Format:
            yyyyMMddHHmmss. Examples: >2018, 2017-2018, <201805.
        :param str id: Note unique identifier.
        :param str type: Note type.
        :param str uuid: Unique 32-character identifier assigned automatically
            by OpenCGA.
        :param str user_id: User that wrote that Note.
        :param str tags: Note tags.
        :param str visibility: Visibility of the Note.
        :param str version: Autoincremental version assigned to the registered
            entry. By default, updates does not create new versions. To enable
            versioning, users must set the `incVersion` flag from the /update
            web service when updating the document.
        """

        return self._get(category='studies', resource='search', query_id=study, subcategory='notes', **options)

    def delete_notes(self, study, id, **options):
        """
        Delete note.
        PATH: /{apiVersion}/studies/{study}/notes/{id}/delete

        :param str id: Note unique identifier. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._delete(category='studies', resource='delete', query_id=study, subcategory='notes', second_query_id=id, **options)

    def update_notes(self, study, id, data=None, **options):
        """
        Update a note.
        PATH: /{apiVersion}/studies/{study}/notes/{id}/update

        :param dict data: JSON containing the Note fields to be updated.
            (REQUIRED)
        :param str id: Note unique identifier. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param str tags_action: Action to be performed if the array of tags is
            being updated. Allowed values: ['ADD SET REMOVE']
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='studies', resource='update', query_id=study, subcategory='notes', second_query_id=id, data=data, **options)

    def permission_rules(self, study, entity, **options):
        """
        Fetch permission rules.
        PATH: /{apiVersion}/studies/{study}/permissionRules

        :param str entity: Entity where the permission rules should be applied
            to. Allowed values: ['SAMPLES FILES COHORTS INDIVIDUALS FAMILIES
            JOBS CLINICAL_ANALYSES DISEASE_PANELS'] (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        """

        options['entity'] = entity
        return self._get(category='studies', resource='permissionRules', query_id=study, **options)

    def update_permission_rules(self, study, entity, data=None, **options):
        """
        Add or remove a permission rule.
        PATH: /{apiVersion}/studies/{study}/permissionRules/update

        :param dict data: JSON containing the permission rule to be created or
            removed. (REQUIRED)
        :param str entity: Entity where the permission rules should be applied
            to. Allowed values: ['SAMPLES FILES COHORTS INDIVIDUALS FAMILIES
            JOBS CLINICAL_ANALYSES DISEASE_PANELS'] (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str action: Action to be performed: ADD to add a new permission
            rule; REMOVE to remove all permissions assigned by an existing
            permission rule (even if it overlaps any manual permission); REVERT
            to remove all permissions assigned by an existing permission rule
            (keep manual overlaps); NONE to remove an existing permission rule
            without removing any permissions that could have been assigned
            already by the permission rule. Allowed values: ['ADD REMOVE REVERT
            NONE']
        """

        options['entity'] = entity
        return self._post(category='studies', resource='update', query_id=study, subcategory='permissionRules', data=data, **options)

    def run_templates(self, study, data=None, **options):
        """
        Execute template.
        PATH: /{apiVersion}/studies/{study}/templates/run

        :param dict data: Template loader parameters. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str job_id: Job ID. It must be a unique string within the
            study. An ID will be autogenerated automatically if not provided.
        :param str job_depends_on: Comma separated list of existing job IDs
            the job will depend on.
        :param str job_description: Job description.
        :param str job_tags: Job tags.
        :param str job_scheduled_start_time: Time when the job is scheduled to
            start.
        :param str job_priority: Priority of the job.
        :param bool job_dry_run: Flag indicating that the job will be executed
            in dry-run mode. In this mode, OpenCGA will validate that all
            parameters and prerequisites are correctly set for successful
            execution, but the job will not actually run.
        """

        return self._post(category='studies', resource='run', query_id=study, subcategory='templates', data=data, **options)

    def upload_templates(self, study, **options):
        """
        Resource to upload a zipped template.
        PATH: /{apiVersion}/studies/{study}/templates/upload

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param inputstream file: File to upload.
        """

        return self._post(category='studies', resource='upload', query_id=study, subcategory='templates', **options)

    def delete_templates(self, study, template_id, **options):
        """
        Delete template.
        PATH: /{apiVersion}/studies/{study}/templates/{templateId}/delete

        :param str template_id: Template id. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        """

        return self._delete(category='studies', resource='delete', query_id=study, subcategory='templates', second_query_id=template_id, **options)

    def update(self, study, data=None, **options):
        """
        Update some study attributes.
        PATH: /{apiVersion}/studies/{study}/update

        :param dict data: JSON containing the params to be updated. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str include: Fields included in the response, whole JSON path
            must be provided.
        :param str exclude: Fields excluded in the response, whole JSON path
            must be provided.
        :param bool include_result: Flag indicating to include the created or
            updated document result in the response.
        """

        return self._post(category='studies', resource='update', query_id=study, data=data, **options)

    def sync_users(self, study, authentication_origin_id, **options):
        """
        Synchronize all users from the remote groups of a given authentication
            origin.
        PATH: /{apiVersion}/studies/{study}/users/sync

        :param str authentication_origin_id: Authentication origin ID.
            (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        """

        options['authenticationOriginId'] = authentication_origin_id
        return self._post(category='studies', resource='sync', query_id=study, subcategory='users', **options)

    def variable_sets(self, study, **options):
        """
        Fetch variableSets from a study.
        PATH: /{apiVersion}/studies/{study}/variableSets

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str id: Id of the variableSet to be retrieved. If no id is
            passed, it will show all the variableSets of the study.
        """

        return self._get(category='studies', resource='variableSets', query_id=study, **options)

    def update_variable_sets(self, study, data=None, **options):
        """
        Add or remove a variableSet.
        PATH: /{apiVersion}/studies/{study}/variableSets/update

        :param dict data: JSON containing the VariableSet to be created or
            removed. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str action: Action to be performed: ADD, REMOVE or FORCE_REMOVE
            a variableSet. Allowed values: ['ADD REMOVE FORCE_REMOVE']
        """

        return self._post(category='studies', resource='update', query_id=study, subcategory='variableSets', data=data, **options)

    def update_variable_sets_variables(self, study, variable_set, data=None, **options):
        """
        Add or remove variables to a VariableSet.
        PATH: /{apiVersion}/studies/{study}/variableSets/{variableSet}/variables/update

        :param dict data: JSON containing the variable to be added or removed.
            For removing, only the variable id will be needed. (REQUIRED)
        :param str variable_set: VariableSet id of the VariableSet to be
            updated. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID. (REQUIRED)
        :param str action: Action to be performed: ADD or REMOVE a variable.
            Allowed values: ['ADD REMOVE']
        """

        return self._post(category='studies', resource='variables/update', query_id=study, subcategory='variableSets', second_query_id=variable_set, data=data, **options)

