# Release 0.8.155

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.106` to `0.8.155`


## General

This release is an incremental release as part of the road map for `v.0.9.0`. Please see the full details of the planned changes here: [v0.9.0 Roadmap](../road_maps/0_9_0.md). 


## API Changes
-  Artifact attribute 'uuid' to the more appropriate 'name'
	
	```
	my_model.uuid
	<is now>
	my_model.name
	```

- `capture_uuid` to `capture_name`
	
	```
	end.inference(df, capture_uuid="my_inference_run")
	<is now>
	end.inference(df, capture_name="my_inference_run")
	```
	
- The training holdout method have removed the id_column arg (this information is already known by the FeatureSet)
	
	```
    fs.set_training_holdouts(id_column="my_id", holdout_ids):
    fs.get_training_holdouts(id_column="my_id") 
    <is now>
    fs.set_training_holdouts(holdout_ids):
    fs.get_training_holdouts()
	```

## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.106...v0.8.155" target="_blank">Code Diff v0.8.106 --> v0.8.155</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***What do you call that feeling like you’ve done this before?
              Deja-moo***

## Questions?
<img align="right" src="../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


