# Release 0.8.71

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.60` to `0.8.71`


## General
This release is an incremental release as part of the road map for `v.0.9.0`. Please see the full details of the planned changes here: [v0.9.0 Roadmap](../road_maps/0_9_0.md). 

### Dash Thread Safety
We learned that thread safety is good when using plugin classes. We had a model plugin class that was setting an attribute in one callback and then using that attribute in another callback, this mostly worked until it didn't. Anyway so the Inference Run dropdown box on the Models page now actually works correctly.


## API Changes
None

## Internal Changes
When using PandasToFeatures it will overwrite FeatureSets if you give the same name. This behavior is expected. The issue was that it was super eager about doing that and would do it during class initiation, so we've moved that logic to when `transform()` is called.

```
# Create a Feature Set from a DataFrame
df_to_features = PandasToFeatures("test_features")
df_to_features.set_input(data_df, id_column="id", one_hot_columns=["food"])
df_to_features.set_output_tags(["test", "small"])
df_to_features.transform()      <--- Overwrite happens here
```


## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.60...v0.8.71" target="_blank">Code Diff v0.8.60 --> v0.8.71</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***What do you call that feeling like you’ve done this before?
              Deja-moo***

## Questions?
<img align="right" src="../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


