# Release 0.8.46

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.42` to `0.8.46`


## General
This release is an incremental release as part of the road map for `v.0.9.0`. Please see the full details of the planned changes here: [v0.9.0 Roadmap](../../road_maps/0_9_0.md). 

## New Deprecation Warnings
We're starting to put in deprecation warning as we streamline classes and APIs. If you're using a class or method that's going to be deprecated you'll see a log message like this:

```
my_class = SomeOldClass()
WARNING SomeOldClass is deprecated and will be removed in version 0.9.
```

In general these warning messages will be annoying but they will help us smoothly transistion and streamline our Classes and APIs.

## Deprecations
- **AWSServiceBroker:** Replaced by the **Meta()** class

## API Changes
**Meta()**

The new `Meta()` class will provide API that aligns with the AWS `list` and `describe` API. We'll have functionality for listing objects (models, feature sets, etc) and then functionality around the details for a named artifact.

```
meta = Meta()
models_list = meta.models()  # List API
end_list = meta.endpoints()  # List API

fs_dict = meta.feature_set("my_fs") # Describe API
model_dict = meta.model("my_model") # Describe API
```

For more details see: [Meta Class](../../api_classes/meta.md)

The new Meta() API will be used inside of the Artifact classes (see Internal Changes...Artifacts... below)

**Artifact Classes**

The artifact classes (DataSource, FeatureSet, Model, Endpoint) have had some old arguments removed.

```
DataSource(force_refresh=True)  -> Gone (remove it)
FeatureSet(force_refresh=True)  -> Gone (remove it)
Model(force_refresh=True)       -> Gone (remove it)
Model(legacy=True)              -> Gone (remove it)
```

## Improvements
**Scalability**

The changes to caching and the Meta() class should allow better horizontal scaling, we'll flex out the stress tests for upcoming releases before `0.9.0`.

**Table Names starting with Numbers**

Some of the Athena queries didn't properly escape the tables names and if you created a DataSource/FeatureSet with a name that started with a number the query would fail. Fixed now. :)

## Internal Changes
**Meta()**

`Meta()` doesn't do any caching now. If you want to use Caching as part of your meta data retrieval use the `CachedMeta()` class.

**Artifacts**

We're got rid of most (soon all) caching for individual Artifacts, if you're constructing an artifact object, you probably want detailed information that's 'up to date' and waiting a bit is probably fine. **Note:** We'll still make these instantiations as fast as we can, removing the caching logic will as least simplify the implementations.

## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.42...v0.8.46" target="_blank">Code Diff v0.8.42 --> v0.8.46</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***That feeling like you’ve done this before?
      .... Deja-moo***

## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


