# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class EloConfigModel(BaseModel):
    """
    These parameters affect how the ELO algorithms behaves
    """ # noqa: E501
    starting_elo: Optional[StrictInt] = Field(default=None, description="The starting ELO score for each datapoint.", alias="startingElo")
    k_factor: Optional[StrictInt] = Field(default=None, description="The K-factor to use in the ELO calculation. Determines the maximum possible change in a player's Elo rating after a single match. Higher K-Factor values result in larger rating changes.", alias="kFactor")
    scaling_factor: Optional[StrictInt] = Field(default=None, description="Scaling factor to use in the ELO calculation. Adjusts the sensitivity of the Elo rating system to differences in player ratings. It affects how much the rating changes based on the expected outcome versus the actual outcome.", alias="scalingFactor")
    __properties: ClassVar[List[str]] = ["startingElo", "kFactor", "scalingFactor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EloConfigModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EloConfigModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "startingElo": obj.get("startingElo"),
            "kFactor": obj.get("kFactor"),
            "scalingFactor": obj.get("scalingFactor")
        })
        return _obj


