# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UploadFilesFromS3BucketModel(BaseModel):
    """
    The model for uploading files from an S3 bucket to a dataset.
    """ # noqa: E501
    dataset_id: StrictStr = Field(description="The id of the dataset to upload the files to.", alias="datasetId")
    bucket_name: StrictStr = Field(description="The name of the S3 bucket to upload the files from.", alias="bucketName")
    region: Optional[StrictStr] = Field(default=None, description="The region of the S3 bucket.")
    source_prefix: StrictStr = Field(description="The prefix of the files to upload.", alias="sourcePrefix")
    access_key: Optional[StrictStr] = Field(default=None, description="The access key to use for the S3 bucket.", alias="accessKey")
    secret_key: Optional[StrictStr] = Field(default=None, description="The secret key to use for the S3 bucket.", alias="secretKey")
    use_custom_aws_credentials: Optional[StrictBool] = Field(default=None, description="Whether to use custom AWS credentials.", alias="useCustomAwsCredentials")
    clear_dataset: Optional[StrictBool] = Field(default=None, description="Whether to clear the dataset before uploading the files.", alias="clearDataset")
    __properties: ClassVar[List[str]] = ["datasetId", "bucketName", "region", "sourcePrefix", "accessKey", "secretKey", "useCustomAwsCredentials", "clearDataset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UploadFilesFromS3BucketModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if region (nullable) is None
        # and model_fields_set contains the field
        if self.region is None and "region" in self.model_fields_set:
            _dict['region'] = None

        # set to None if access_key (nullable) is None
        # and model_fields_set contains the field
        if self.access_key is None and "access_key" in self.model_fields_set:
            _dict['accessKey'] = None

        # set to None if secret_key (nullable) is None
        # and model_fields_set contains the field
        if self.secret_key is None and "secret_key" in self.model_fields_set:
            _dict['secretKey'] = None

        # set to None if use_custom_aws_credentials (nullable) is None
        # and model_fields_set contains the field
        if self.use_custom_aws_credentials is None and "use_custom_aws_credentials" in self.model_fields_set:
            _dict['useCustomAwsCredentials'] = None

        # set to None if clear_dataset (nullable) is None
        # and model_fields_set contains the field
        if self.clear_dataset is None and "clear_dataset" in self.model_fields_set:
            _dict['clearDataset'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UploadFilesFromS3BucketModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datasetId": obj.get("datasetId"),
            "bucketName": obj.get("bucketName"),
            "region": obj.get("region"),
            "sourcePrefix": obj.get("sourcePrefix"),
            "accessKey": obj.get("accessKey"),
            "secretKey": obj.get("secretKey"),
            "useCustomAwsCredentials": obj.get("useCustomAwsCredentials"),
            "clearDataset": obj.get("clearDataset")
        })
        return _obj


