import { Construct } from 'constructs';
/**
 * slack event notify interface.
 */
export interface ISlackEventNotify {
    /**
     * slack Webhook Url for Lambda send message to slack.
     */
    readonly slackWebhookUrl: string;
    /**
     * slack Channel Name for Lambda send message to slack.
     */
    readonly slackChannelName: string;
}
/**
 * event notify interface.
 */
export interface EventNotifyProps {
    /**
     * Line Notify Token for Lambda send notify permission.
     *
     * @default - none
     */
    readonly lineNotifyToken?: string | undefined;
    /**
     * Notify target to Slack channel.
     *
     * @default - none
     */
    readonly slack?: ISlackEventNotify;
}
/**
 * Event Notfiy Construct Class.
 */
export declare class EventNotify extends Construct {
    constructor(scope: Construct, id: string, props?: EventNotifyProps);
}
