"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventNotify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const target = require("aws-cdk-lib/aws-events-targets");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
/**
 * Event Notfiy Construct Class.
 */
class EventNotify extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!props?.lineNotifyToken && !props?.slack) {
            throw new Error('Please input lineNotifyToken or slack options');
        }
        const lambdaFun = new lambda.Function(this, 'lambda_fun', {
            handler: 'linenotify.lambda_handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '../function')),
            runtime: lambda.Runtime.PYTHON_3_12,
            timeout: cdk.Duration.minutes(3),
            logRetention: logs.RetentionDays.THREE_DAYS,
            environment: {
                LINE_NOTIFY_TOKEN: props?.lineNotifyToken ? props?.lineNotifyToken : 'none',
                SLACK_WEBHOOK_URL: props?.slack?.slackWebhookUrl ? props?.slack?.slackWebhookUrl : 'none',
                SLACK_CHANNEL_NAME: props?.slack?.slackChannelName ? props?.slack?.slackChannelName : 'none',
            },
        });
        const eventNotifyTarget = new target.LambdaFunction(lambdaFun);
        new events.Rule(this, 'EventBusConsoleLoginEvent', {
            ruleName: 'EventBusConsoleLoginEvent',
            description: 'Console login in specific region',
            targets: [eventNotifyTarget],
            eventPattern: {
                detailType: ['AWS Console Sign In via CloudTrail'],
            },
        });
    }
}
exports.EventNotify = EventNotify;
_a = JSII_RTTI_SYMBOL_1;
EventNotify[_a] = { fqn: "cdk-events-notify.EventNotify", version: "2.2.55" };
//# sourceMappingURL=data:application/json;base64,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