"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const _1 = require("./");
const app = new cdk.App();
[
    'us-east-1',
    'ap-northeast-1',
].forEach(region => {
    const stack = new cdk.Stack(app, `integ-stack-${region}`, {
        env: {
            region: region,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        },
    });
    new _1.EventNotify(stack, 'LineslackEventNotify', {
        lineNotifyToken: process.env.LINE_NOTIFY_TOKEN,
        slack: {
            slackChannelName: `${process.env.SLACK_CHANNEL_NAME}`,
            slackWebhookUrl: `${process.env.SLACK_WEBHOOK_URL}`,
        },
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUNBQW1DO0FBQ25DLHlCQUFpQztBQUdqQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQjtJQUNFLFdBQVc7SUFDWCxnQkFBZ0I7Q0FDakIsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLEVBQUU7SUFDakIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxlQUFlLE1BQU0sRUFBRSxFQUFFO1FBQ3hELEdBQUcsRUFBRTtZQUNILE1BQU0sRUFBRSxNQUFNO1lBQ2QsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1NBQ3pDO0tBQ0YsQ0FBQyxDQUFDO0lBQ0gsSUFBSSxjQUFXLENBQUMsS0FBSyxFQUFFLHNCQUFzQixFQUFFO1FBQzdDLGVBQWUsRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQjtRQUM5QyxLQUFLLEVBQUU7WUFDTCxnQkFBZ0IsRUFBRSxHQUFHLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUU7WUFDckQsZUFBZSxFQUFFLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRTtTQUNwRDtLQUNGLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEV2ZW50Tm90aWZ5IH0gZnJvbSAnLi8nO1xuXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbltcbiAgJ3VzLWVhc3QtMScsXG4gICdhcC1ub3J0aGVhc3QtMScsXG5dLmZvckVhY2gocmVnaW9uID0+IHtcbiAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgYGludGVnLXN0YWNrLSR7cmVnaW9ufWAsIHtcbiAgICBlbnY6IHtcbiAgICAgIHJlZ2lvbjogcmVnaW9uLFxuICAgICAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbiAgICB9LFxuICB9KTtcbiAgbmV3IEV2ZW50Tm90aWZ5KHN0YWNrLCAnTGluZXNsYWNrRXZlbnROb3RpZnknLCB7XG4gICAgbGluZU5vdGlmeVRva2VuOiBwcm9jZXNzLmVudi5MSU5FX05PVElGWV9UT0tFTixcbiAgICBzbGFjazoge1xuICAgICAgc2xhY2tDaGFubmVsTmFtZTogYCR7cHJvY2Vzcy5lbnYuU0xBQ0tfQ0hBTk5FTF9OQU1FfWAsXG4gICAgICBzbGFja1dlYmhvb2tVcmw6IGAke3Byb2Nlc3MuZW52LlNMQUNLX1dFQkhPT0tfVVJMfWAsXG4gICAgfSxcbiAgfSk7XG59KTtcblxuXG4iXX0=