#define DOCSTRING_LERP "lerp, invlerp and remap\nExported for convenience, since these are internally used in the LerpThing.\n\nThese are your normal lerp functions.\n\n    lerp(a: float, b:float, t) -> float\n        Returns interpolation from a to b at point in time t\n\n    invlerp(a: float, b: float, v: float) -> float\n        Returns t for interpolation from a to b at point v.\n\n    remap(a0: float, b0: float, a1: float, b1: float, v0: float) -> float\n        Maps point v0 in range a0/b0 onto range a1/b1.\n\n\"point in time\" in this context means between 0 and 1.\n\n    lerp(0, 10, 0.5) --> 5\n    invlerp(0, 10, 5) --> 0.5\n    remap(0, 10, 0, 100, 5) --> 50\n"
#define DOCSTRING_COOLDOWN "Track a cooldown over a period of time.\n\n    cooldown = Cooldown(5)\n\n    while True:\n        do_stuff()\n\n        if key_pressed\n            if key == 'P':\n                cooldown.pause()\n            elif key == 'ESC':\n                cooldown.start()\n\n        if cooldown.cold():\n            launch_stuff()\n            cooldown.reset()\n\nCooldown can be used to time sprite animation frame changes,\nweapon cooldown in shmups, all sorts of events when programming a\ngame.\n\nIf you want to use the cooldown more as a timing gauge, e.g. to\nmodify acceleration of a sprite over time, have a look at the\n`LerpThing` class in this package, which makes this incredibly\neasy.\n\nWhen instantiated (and started), Cooldown stores the current time.\nThe cooldown will become `cold` when the given duration has passed.\n\nWhile a cooldown is paused, the remaining time doesn't change.\n\nAt any time, the cooldown can be reset to its initial or a new\nvalue.\n\nA cooldown can be compared to int/float/bool, in which case the\n`remaining` property is used.\n\nCooldown provides a \"copy constructor\", meaning you can\ninitialize a new cooldown with an existing one.  The full state\nof the initial cooldown is used, including `paused`, `wrap`, and\nthe remaining time.\n\nWhen a cooldown is reset, depending on when you checked the\n`cold` state, more time may have passed than the actual cooldown\nduration.\n\nThe `wrap` attribute decides, if the cooldown then is just reset\nback to the duration, or if this additional time is taken into\naccount.  The `wrap` argument of the `reset` function overwrites\nthe default configuration of the cooldown instance.\n\n    c0 = Cooldown(5)\n    c1 = Cooldown(5, wrap=True)\n    sleep(7)\n    c0.temperature, c1.temperature\n        --> -2.000088164 -2.0000879129999998\n\n    c0.reset()\n    c1.reset()\n    c0.temperature, c1.temperature\n        --> 4.999999539 2.999883194\n\n    sleep(7)\n    c0.temperature, c1.temperature\n        --> -2.000189442 -4.000306759000001\n\n    c0.reset(wrap=True)\n    c1.reset(wrap=False)\n    c0.temperature, c1.temperature\n        --> 2.999748423 4.999999169\n\nA cooldown can be used as an iterator, returning the time\nremaining.\n\n    for t in Cooldown(5):\n        print(t)\n        sleep(1)\n\n    4.998921067\n    3.998788201\n    2.998640238\n    1.9984825379999993\n    0.998318566\n\n\nArguments\n---------\nduration: float | pgcooldown.Cooldown\n    Time to cooldown in seconds\n\ncold: bool = False\n    Start the cooldown already cold, e.g. for initial events.\n\npaused: bool = False\n    Created the cooldown in paused state.  Use `cooldown.start()` to\n    run it.\n\nwrap: bool = False\n    Set the reset mode to wrapped (see above).\n    Can be overwritten by the `wrap` argument to the `reset` function.\n\n\nAttributes\n----------\nAll attributes are read/write.\n\nduration: float\n    When calling `reset`, the cooldown is set to this value. Can be\n    assigned to directly or by calling `cooldown.reset(duration)`\n\ntemperature: float\n    The time left (or passed) until cooldown.  Will go negative once the\n    cooldown time has passed.\n\nremaining: float\n    Same as temperature, but will not go below 0.  When assigning, a\n    negative value will be reset to 0.\n\nnormalized: float\n    returns the current \"distance\" in the cooldown between 0 and 1, with\n    one being cold.  Ideal for being used in an easing function or lerp.\n\npaused: bool\n    to check if the cooldown is paused.  Alternatively use\n    cooldown.pause()/.start()/.is_paused() if you prefer methods.\n\nwrap: bool\n    Activate or deactivate wrap mode.\n\n\nMethods\n-------\nCooldown provides a __repr__, the comparism methods <, <=, ==, >=, >,\ncan be converted to float/int/bool, and can be used as an iterator.  The\n'temperature' value is used for all operations, so results can be\nnegative.  As an iterator, StopIteration is raised when the temperature\ngoes below 0 though.\n\ncold(): bool\n    Has the time of the cooldown run out?\n\nhot(): bool\n    Is there stil time remaining before cooldown?  This is just for\n    convenience to not write `not cooldown.cold()` all over the place.\n\nreset([new-duration], *, wrap=bool):\n    Resets the cooldown.  Without argument, resets to the current\n    duration, otherwise the given value.  See wrap for nuance.\n\n    `reset()` return `self`, so it can e.g. be chained with `pause()`\n\n\npause(), start(), is_paused():\n    Pause, start, check the cooldown.  Time is frozen during the\n    pause.\n\nset_to(val):\n    Same as `cooldown.temperature = val`.\n\nset_cold():\n    Same as `cooldown.temperature = 0`.\n"
