from typing import Any, Callable, final
from dataclasses import InitVar, dataclass

__all__: list[str]

def lerp(a: float, b: float, t: float) -> float: ...
def invlerp(a: float, b: float, v: float) -> float: ...
def remap(a0: float, a1: float, b0: float, b1: float, v: float) -> float: ...

@final
class Cooldown:
    duration: float
    normalized: float
    paused: bool
    remaining: float
    temperature: float
    wrap: bool

    def __bool__(self) -> bool: ...
    def __call__(self, *args: Any, **kwargs: Any) -> float: ...
    def __eq__(self, other: object) -> bool: ...
    def __float__(self) -> float: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __init__(self, duration: float, cold: bool = False, paused: bool = False) -> None: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __repr__(self) -> str: ...
    def cold(self) -> bool: ...
    def hot(self) -> bool: ...
    def is_paused(self) -> bool: ...
    def pause(self) -> None: ...
    def reset(self, new: int = 0, wrap: bool = False) -> None: ...
    def set_cold(self) -> None: ...
    def set_to(self, t: int = 0) -> None: ...
    def start(self) -> None: ...

@dataclass
class LerpThing:
    vt0: float
    vt1: float
    duration: InitVar[Cooldown | float]
    ease: Callable[[float], float] = ...
    repeat: int = ...
    def __bool__(self) -> bool: ...
    def __call__(self) -> float: ...
    def __eq__(self, other: object) -> bool: ...
    def __float__(self) -> float: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __init__(self, vt0: float, vt1: float, duration: float, ease=Callable[[float], float], repeat: int = 0) -> None: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __post_init__(self, duration: Cooldown | float) -> None: ...
    def finished(self) -> bool: ...

class AutoLerpThing:
    def __set_name__(self, obj: Any, name: str) -> None: ...
    def __set__(self, obj: Any, val: float) -> None: ...
    def __get__(self, obj: Any, parent: Any): ...

@dataclass(order=True)
class Cronjob:
    cooldown: Cooldown | float
    task: Callable
    repeat: bool
    def __post_init__(self) -> None: ...
    def __init__(self, cooldown: Cooldown, task: Callable, repeat: bool) -> None: ...

class CronD:
    heap: list
    def __init__(self) -> None: ...
    def add(self, cooldown: Cooldown, task: Callable, repeat: bool = False): ...
    def remove(self, cid: int) -> None: ...
    def update(self) -> None: ...
