# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/10_shovill.ipynb.

# %% auto 0
__all__ = ['process_shovill_data', 'process_shovill_data_from_cli']

# %% ../nbs/10_shovill.ipynb 2
# That export there, it makes sure this code goes into the module.

# standard libs
import os
import re

# Common to template
# add into settings.ini, requirements, package name is python-dotenv, for conda build ensure `conda config --add channels conda-forge`
import dotenv  # for loading config from .env files, https://pypi.org/project/python-dotenv/
import envyaml  # Allows to loads env vars into a yaml file, https://github.com/thesimj/envyaml
import fastcore  # To add functionality related to nbdev development, https://github.com/fastai/fastcore/
from fastcore import (
    test,
)
from fastcore.script import (
    call_parse,
)  # for @call_parse, https://fastcore.fast.ai/script
import json  # for nicely printing json and yaml
from fastcore import test
from . import core

# %% ../nbs/10_shovill.ipynb 6
def process_shovill_data(
    input_path: str, output_path: str = "./output.tsv", average_coverage: float = True
):
    """
    Command-line interface for processing Shovill data.

    This function sets up an argument parser to handle command-line arguments for processing Shovill log output files.
    It supports specifying input and output file paths.

    Arguments:
        input_path (str): Path to the input file.
        output_path (str): Path to the output file (default: './output.tsv').
        average_coverage (float): Whether to calculate average coverage (default: True).
    """

    df = core.DataFrame()

    if not os.path.exists(input_path):
        raise FileNotFoundError(f"The input file {input_path} does not exist.")

    with open(input_path, "r") as f:
        for line in f:
            match = re.search(r"Average coverage is ([\d\.]+) and alpha is", line)
            if match:
                avg_coverage = float(match.group(1))
                break

    data_frame_columns = ["Average_Coverage"]
    # Add columns to DataFrame
    if average_coverage:
        if avg_coverage is None:
            df.add_column("Average_Coverage", [None])
        else:
            df.add_column("Average_Coverage", [avg_coverage])

    # df.show()

    df.export_data(output_path, file_type="tsv")


@call_parse
def process_shovill_data_from_cli(
    input_path: str, output_path: str = "./output.tsv", average_coverage: float = True
):
    process_shovill_data(input_path, output_path, average_coverage)
