# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKubeOidcResult',
    'AwaitableGetKubeOidcResult',
    'get_kube_oidc',
    'get_kube_oidc_output',
]

@pulumi.output_type
class GetKubeOidcResult:
    """
    A collection of values returned by getKubeOidc.
    """
    def __init__(__self__, client_id=None, id=None, issuer_url=None, kube_id=None, oidc_ca_content=None, oidc_groups_claims=None, oidc_groups_prefix=None, oidc_required_claims=None, oidc_signing_algs=None, oidc_username_claim=None, oidc_username_prefix=None, service_name=None):
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_url and not isinstance(issuer_url, str):
            raise TypeError("Expected argument 'issuer_url' to be a str")
        pulumi.set(__self__, "issuer_url", issuer_url)
        if kube_id and not isinstance(kube_id, str):
            raise TypeError("Expected argument 'kube_id' to be a str")
        pulumi.set(__self__, "kube_id", kube_id)
        if oidc_ca_content and not isinstance(oidc_ca_content, str):
            raise TypeError("Expected argument 'oidc_ca_content' to be a str")
        pulumi.set(__self__, "oidc_ca_content", oidc_ca_content)
        if oidc_groups_claims and not isinstance(oidc_groups_claims, list):
            raise TypeError("Expected argument 'oidc_groups_claims' to be a list")
        pulumi.set(__self__, "oidc_groups_claims", oidc_groups_claims)
        if oidc_groups_prefix and not isinstance(oidc_groups_prefix, str):
            raise TypeError("Expected argument 'oidc_groups_prefix' to be a str")
        pulumi.set(__self__, "oidc_groups_prefix", oidc_groups_prefix)
        if oidc_required_claims and not isinstance(oidc_required_claims, list):
            raise TypeError("Expected argument 'oidc_required_claims' to be a list")
        pulumi.set(__self__, "oidc_required_claims", oidc_required_claims)
        if oidc_signing_algs and not isinstance(oidc_signing_algs, list):
            raise TypeError("Expected argument 'oidc_signing_algs' to be a list")
        pulumi.set(__self__, "oidc_signing_algs", oidc_signing_algs)
        if oidc_username_claim and not isinstance(oidc_username_claim, str):
            raise TypeError("Expected argument 'oidc_username_claim' to be a str")
        pulumi.set(__self__, "oidc_username_claim", oidc_username_claim)
        if oidc_username_prefix and not isinstance(oidc_username_prefix, str):
            raise TypeError("Expected argument 'oidc_username_prefix' to be a str")
        pulumi.set(__self__, "oidc_username_prefix", oidc_username_prefix)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The OIDC client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> Optional[str]:
        """
        The OIDC issuer url.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="kubeId")
    def kube_id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "kube_id")

    @property
    @pulumi.getter(name="oidcCaContent")
    def oidc_ca_content(self) -> Optional[str]:
        return pulumi.get(self, "oidc_ca_content")

    @property
    @pulumi.getter(name="oidcGroupsClaims")
    def oidc_groups_claims(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "oidc_groups_claims")

    @property
    @pulumi.getter(name="oidcGroupsPrefix")
    def oidc_groups_prefix(self) -> Optional[str]:
        return pulumi.get(self, "oidc_groups_prefix")

    @property
    @pulumi.getter(name="oidcRequiredClaims")
    def oidc_required_claims(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "oidc_required_claims")

    @property
    @pulumi.getter(name="oidcSigningAlgs")
    def oidc_signing_algs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "oidc_signing_algs")

    @property
    @pulumi.getter(name="oidcUsernameClaim")
    def oidc_username_claim(self) -> Optional[str]:
        return pulumi.get(self, "oidc_username_claim")

    @property
    @pulumi.getter(name="oidcUsernamePrefix")
    def oidc_username_prefix(self) -> Optional[str]:
        return pulumi.get(self, "oidc_username_prefix")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetKubeOidcResult(GetKubeOidcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubeOidcResult(
            client_id=self.client_id,
            id=self.id,
            issuer_url=self.issuer_url,
            kube_id=self.kube_id,
            oidc_ca_content=self.oidc_ca_content,
            oidc_groups_claims=self.oidc_groups_claims,
            oidc_groups_prefix=self.oidc_groups_prefix,
            oidc_required_claims=self.oidc_required_claims,
            oidc_signing_algs=self.oidc_signing_algs,
            oidc_username_claim=self.oidc_username_claim,
            oidc_username_prefix=self.oidc_username_prefix,
            service_name=self.service_name)


def get_kube_oidc(client_id: Optional[str] = None,
                  issuer_url: Optional[str] = None,
                  kube_id: Optional[str] = None,
                  oidc_ca_content: Optional[str] = None,
                  oidc_groups_claims: Optional[Sequence[str]] = None,
                  oidc_groups_prefix: Optional[str] = None,
                  oidc_required_claims: Optional[Sequence[str]] = None,
                  oidc_signing_algs: Optional[Sequence[str]] = None,
                  oidc_username_claim: Optional[str] = None,
                  oidc_username_prefix: Optional[str] = None,
                  service_name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubeOidcResult:
    """
    Use this data source to get a OVHcloud Managed Kubernetes Service cluster OIDC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    oidc = ovh.CloudProject.get_kube_oidc(service_name="XXXXXX",
        kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
    pulumi.export("oidc-val", oidc.client_id)
    ```


    :param str client_id: The OIDC client ID.
    :param str issuer_url: The OIDC issuer url.
    :param str kube_id: The id of the managed kubernetes cluster.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['issuerUrl'] = issuer_url
    __args__['kubeId'] = kube_id
    __args__['oidcCaContent'] = oidc_ca_content
    __args__['oidcGroupsClaims'] = oidc_groups_claims
    __args__['oidcGroupsPrefix'] = oidc_groups_prefix
    __args__['oidcRequiredClaims'] = oidc_required_claims
    __args__['oidcSigningAlgs'] = oidc_signing_algs
    __args__['oidcUsernameClaim'] = oidc_username_claim
    __args__['oidcUsernamePrefix'] = oidc_username_prefix
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getKubeOidc:getKubeOidc', __args__, opts=opts, typ=GetKubeOidcResult).value

    return AwaitableGetKubeOidcResult(
        client_id=pulumi.get(__ret__, 'client_id'),
        id=pulumi.get(__ret__, 'id'),
        issuer_url=pulumi.get(__ret__, 'issuer_url'),
        kube_id=pulumi.get(__ret__, 'kube_id'),
        oidc_ca_content=pulumi.get(__ret__, 'oidc_ca_content'),
        oidc_groups_claims=pulumi.get(__ret__, 'oidc_groups_claims'),
        oidc_groups_prefix=pulumi.get(__ret__, 'oidc_groups_prefix'),
        oidc_required_claims=pulumi.get(__ret__, 'oidc_required_claims'),
        oidc_signing_algs=pulumi.get(__ret__, 'oidc_signing_algs'),
        oidc_username_claim=pulumi.get(__ret__, 'oidc_username_claim'),
        oidc_username_prefix=pulumi.get(__ret__, 'oidc_username_prefix'),
        service_name=pulumi.get(__ret__, 'service_name'))


@_utilities.lift_output_func(get_kube_oidc)
def get_kube_oidc_output(client_id: Optional[pulumi.Input[Optional[str]]] = None,
                         issuer_url: Optional[pulumi.Input[Optional[str]]] = None,
                         kube_id: Optional[pulumi.Input[str]] = None,
                         oidc_ca_content: Optional[pulumi.Input[Optional[str]]] = None,
                         oidc_groups_claims: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         oidc_groups_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                         oidc_required_claims: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         oidc_signing_algs: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         oidc_username_claim: Optional[pulumi.Input[Optional[str]]] = None,
                         oidc_username_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                         service_name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKubeOidcResult]:
    """
    Use this data source to get a OVHcloud Managed Kubernetes Service cluster OIDC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    oidc = ovh.CloudProject.get_kube_oidc(service_name="XXXXXX",
        kube_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxx")
    pulumi.export("oidc-val", oidc.client_id)
    ```


    :param str client_id: The OIDC client ID.
    :param str issuer_url: The OIDC issuer url.
    :param str kube_id: The id of the managed kubernetes cluster.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    ...
