# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubeArgs', 'Kube']

@pulumi.input_type
class KubeArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 customization_apiservers: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]] = None,
                 customization_kube_proxy: Optional[pulumi.Input['KubeCustomizationKubeProxyArgs']] = None,
                 customizations: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_network_configuration: Optional[pulumi.Input['KubePrivateNetworkConfigurationArgs']] = None,
                 private_network_id: Optional[pulumi.Input[str]] = None,
                 update_policy: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Kube resource.
        :param pulumi.Input[str] region: a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]] customization_apiservers: Kubernetes API server customization
        :param pulumi.Input['KubeCustomizationKubeProxyArgs'] customization_kube_proxy: Kubernetes kube-proxy customization
        :param pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]] customizations: **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        :param pulumi.Input[str] kube_proxy_mode: Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        :param pulumi.Input[str] name: The name of the kubernetes cluster.
        :param pulumi.Input['KubePrivateNetworkConfigurationArgs'] private_network_configuration: The private network configuration
        :param pulumi.Input[str] private_network_id: OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.
               
               > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        :param pulumi.Input[str] update_policy: Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        :param pulumi.Input[str] version: kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "service_name", service_name)
        if customization_apiservers is not None:
            pulumi.set(__self__, "customization_apiservers", customization_apiservers)
        if customization_kube_proxy is not None:
            pulumi.set(__self__, "customization_kube_proxy", customization_kube_proxy)
        if customizations is not None:
            warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
            pulumi.log.warn("""customizations is deprecated: Use customization_apiserver instead""")
        if customizations is not None:
            pulumi.set(__self__, "customizations", customizations)
        if kube_proxy_mode is not None:
            pulumi.set(__self__, "kube_proxy_mode", kube_proxy_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_network_configuration is not None:
            pulumi.set(__self__, "private_network_configuration", private_network_configuration)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="customizationApiservers")
    def customization_apiservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]]:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "customization_apiservers")

    @customization_apiservers.setter
    def customization_apiservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]]):
        pulumi.set(self, "customization_apiservers", value)

    @property
    @pulumi.getter(name="customizationKubeProxy")
    def customization_kube_proxy(self) -> Optional[pulumi.Input['KubeCustomizationKubeProxyArgs']]:
        """
        Kubernetes kube-proxy customization
        """
        return pulumi.get(self, "customization_kube_proxy")

    @customization_kube_proxy.setter
    def customization_kube_proxy(self, value: Optional[pulumi.Input['KubeCustomizationKubeProxyArgs']]):
        pulumi.set(self, "customization_kube_proxy", value)

    @property
    @pulumi.getter
    def customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]]]:
        """
        **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        """
        warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
        pulumi.log.warn("""customizations is deprecated: Use customization_apiserver instead""")

        return pulumi.get(self, "customizations")

    @customizations.setter
    def customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]]]):
        pulumi.set(self, "customizations", value)

    @property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @kube_proxy_mode.setter
    def kube_proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_proxy_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworkConfiguration")
    def private_network_configuration(self) -> Optional[pulumi.Input['KubePrivateNetworkConfigurationArgs']]:
        """
        The private network configuration
        """
        return pulumi.get(self, "private_network_configuration")

    @private_network_configuration.setter
    def private_network_configuration(self, value: Optional[pulumi.Input['KubePrivateNetworkConfigurationArgs']]):
        pulumi.set(self, "private_network_configuration", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.

        > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        """
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _KubeState:
    def __init__(__self__, *,
                 control_plane_is_up_to_date: Optional[pulumi.Input[bool]] = None,
                 customization_apiservers: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]] = None,
                 customization_kube_proxy: Optional[pulumi.Input['KubeCustomizationKubeProxyArgs']] = None,
                 customizations: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]]] = None,
                 is_up_to_date: Optional[pulumi.Input[bool]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[str]] = None,
                 kubeconfig: Optional[pulumi.Input[str]] = None,
                 kubeconfig_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['KubeKubeconfigAttributeArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_upgrade_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 nodes_url: Optional[pulumi.Input[str]] = None,
                 private_network_configuration: Optional[pulumi.Input['KubePrivateNetworkConfigurationArgs']] = None,
                 private_network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_policy: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Kube resources.
        :param pulumi.Input[bool] control_plane_is_up_to_date: True if control-plane is up-to-date.
        :param pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]] customization_apiservers: Kubernetes API server customization
        :param pulumi.Input['KubeCustomizationKubeProxyArgs'] customization_kube_proxy: Kubernetes kube-proxy customization
        :param pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]] customizations: **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        :param pulumi.Input[bool] is_up_to_date: True if all nodes and control-plane are up-to-date.
        :param pulumi.Input[str] kube_proxy_mode: Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        :param pulumi.Input[str] kubeconfig: The kubeconfig file. Use this file to connect to your kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KubeKubeconfigAttributeArgs']]] kubeconfig_attributes: The kubeconfig file attributes.
        :param pulumi.Input[str] name: The name of the kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] next_upgrade_versions: Kubernetes versions available for upgrade.
        :param pulumi.Input[str] nodes_url: Cluster nodes URL.
        :param pulumi.Input['KubePrivateNetworkConfigurationArgs'] private_network_configuration: The private network configuration
        :param pulumi.Input[str] private_network_id: OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.
               
               > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        :param pulumi.Input[str] region: a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[str] status: Cluster status. Should be normally set to 'READY'.
        :param pulumi.Input[str] update_policy: Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        :param pulumi.Input[str] url: Management URL of your cluster.
        :param pulumi.Input[str] version: kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        if control_plane_is_up_to_date is not None:
            pulumi.set(__self__, "control_plane_is_up_to_date", control_plane_is_up_to_date)
        if customization_apiservers is not None:
            pulumi.set(__self__, "customization_apiservers", customization_apiservers)
        if customization_kube_proxy is not None:
            pulumi.set(__self__, "customization_kube_proxy", customization_kube_proxy)
        if customizations is not None:
            warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
            pulumi.log.warn("""customizations is deprecated: Use customization_apiserver instead""")
        if customizations is not None:
            pulumi.set(__self__, "customizations", customizations)
        if is_up_to_date is not None:
            pulumi.set(__self__, "is_up_to_date", is_up_to_date)
        if kube_proxy_mode is not None:
            pulumi.set(__self__, "kube_proxy_mode", kube_proxy_mode)
        if kubeconfig is not None:
            pulumi.set(__self__, "kubeconfig", kubeconfig)
        if kubeconfig_attributes is not None:
            pulumi.set(__self__, "kubeconfig_attributes", kubeconfig_attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_upgrade_versions is not None:
            pulumi.set(__self__, "next_upgrade_versions", next_upgrade_versions)
        if nodes_url is not None:
            pulumi.set(__self__, "nodes_url", nodes_url)
        if private_network_configuration is not None:
            pulumi.set(__self__, "private_network_configuration", private_network_configuration)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="controlPlaneIsUpToDate")
    def control_plane_is_up_to_date(self) -> Optional[pulumi.Input[bool]]:
        """
        True if control-plane is up-to-date.
        """
        return pulumi.get(self, "control_plane_is_up_to_date")

    @control_plane_is_up_to_date.setter
    def control_plane_is_up_to_date(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "control_plane_is_up_to_date", value)

    @property
    @pulumi.getter(name="customizationApiservers")
    def customization_apiservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]]:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "customization_apiservers")

    @customization_apiservers.setter
    def customization_apiservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationApiserverArgs']]]]):
        pulumi.set(self, "customization_apiservers", value)

    @property
    @pulumi.getter(name="customizationKubeProxy")
    def customization_kube_proxy(self) -> Optional[pulumi.Input['KubeCustomizationKubeProxyArgs']]:
        """
        Kubernetes kube-proxy customization
        """
        return pulumi.get(self, "customization_kube_proxy")

    @customization_kube_proxy.setter
    def customization_kube_proxy(self, value: Optional[pulumi.Input['KubeCustomizationKubeProxyArgs']]):
        pulumi.set(self, "customization_kube_proxy", value)

    @property
    @pulumi.getter
    def customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]]]:
        """
        **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        """
        warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
        pulumi.log.warn("""customizations is deprecated: Use customization_apiserver instead""")

        return pulumi.get(self, "customizations")

    @customizations.setter
    def customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeCustomizationArgs']]]]):
        pulumi.set(self, "customizations", value)

    @property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> Optional[pulumi.Input[bool]]:
        """
        True if all nodes and control-plane are up-to-date.
        """
        return pulumi.get(self, "is_up_to_date")

    @is_up_to_date.setter
    def is_up_to_date(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_up_to_date", value)

    @property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @kube_proxy_mode.setter
    def kube_proxy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kube_proxy_mode", value)

    @property
    @pulumi.getter
    def kubeconfig(self) -> Optional[pulumi.Input[str]]:
        """
        The kubeconfig file. Use this file to connect to your kubernetes cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @kubeconfig.setter
    def kubeconfig(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubeconfig", value)

    @property
    @pulumi.getter(name="kubeconfigAttributes")
    def kubeconfig_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubeKubeconfigAttributeArgs']]]]:
        """
        The kubeconfig file attributes.
        """
        return pulumi.get(self, "kubeconfig_attributes")

    @kubeconfig_attributes.setter
    def kubeconfig_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubeKubeconfigAttributeArgs']]]]):
        pulumi.set(self, "kubeconfig_attributes", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextUpgradeVersions")
    def next_upgrade_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Kubernetes versions available for upgrade.
        """
        return pulumi.get(self, "next_upgrade_versions")

    @next_upgrade_versions.setter
    def next_upgrade_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "next_upgrade_versions", value)

    @property
    @pulumi.getter(name="nodesUrl")
    def nodes_url(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster nodes URL.
        """
        return pulumi.get(self, "nodes_url")

    @nodes_url.setter
    def nodes_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nodes_url", value)

    @property
    @pulumi.getter(name="privateNetworkConfiguration")
    def private_network_configuration(self) -> Optional[pulumi.Input['KubePrivateNetworkConfigurationArgs']]:
        """
        The private network configuration
        """
        return pulumi.get(self, "private_network_configuration")

    @private_network_configuration.setter
    def private_network_configuration(self, value: Optional[pulumi.Input['KubePrivateNetworkConfigurationArgs']]):
        pulumi.set(self, "private_network_configuration", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.

        > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster status. Should be normally set to 'READY'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        """
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_policy", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Management URL of your cluster.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Kube(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customization_apiservers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationApiserverArgs']]]]] = None,
                 customization_kube_proxy: Optional[pulumi.Input[pulumi.InputType['KubeCustomizationKubeProxyArgs']]] = None,
                 customizations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationArgs']]]]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_network_configuration: Optional[pulumi.Input[pulumi.InputType['KubePrivateNetworkConfigurationArgs']]] = None,
                 private_network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 update_policy: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        OVHcloud Managed Kubernetes Service clusters can be imported using the `service_name` and the `id` of the cluster, separated by "/" E.g., bash

        ```sh
         $ pulumi import ovh:CloudProject/kube:Kube my_kube_cluster service_name/kube_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationApiserverArgs']]]] customization_apiservers: Kubernetes API server customization
        :param pulumi.Input[pulumi.InputType['KubeCustomizationKubeProxyArgs']] customization_kube_proxy: Kubernetes kube-proxy customization
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationArgs']]]] customizations: **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        :param pulumi.Input[str] kube_proxy_mode: Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        :param pulumi.Input[str] name: The name of the kubernetes cluster.
        :param pulumi.Input[pulumi.InputType['KubePrivateNetworkConfigurationArgs']] private_network_configuration: The private network configuration
        :param pulumi.Input[str] private_network_id: OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.
               
               > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        :param pulumi.Input[str] region: a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[str] update_policy: Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        :param pulumi.Input[str] version: kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        OVHcloud Managed Kubernetes Service clusters can be imported using the `service_name` and the `id` of the cluster, separated by "/" E.g., bash

        ```sh
         $ pulumi import ovh:CloudProject/kube:Kube my_kube_cluster service_name/kube_id
        ```

        :param str resource_name: The name of the resource.
        :param KubeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customization_apiservers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationApiserverArgs']]]]] = None,
                 customization_kube_proxy: Optional[pulumi.Input[pulumi.InputType['KubeCustomizationKubeProxyArgs']]] = None,
                 customizations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationArgs']]]]] = None,
                 kube_proxy_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_network_configuration: Optional[pulumi.Input[pulumi.InputType['KubePrivateNetworkConfigurationArgs']]] = None,
                 private_network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 update_policy: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubeArgs.__new__(KubeArgs)

            __props__.__dict__["customization_apiservers"] = customization_apiservers
            __props__.__dict__["customization_kube_proxy"] = customization_kube_proxy
            __props__.__dict__["customizations"] = customizations
            __props__.__dict__["kube_proxy_mode"] = kube_proxy_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["private_network_configuration"] = private_network_configuration
            __props__.__dict__["private_network_id"] = private_network_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["version"] = version
            __props__.__dict__["control_plane_is_up_to_date"] = None
            __props__.__dict__["is_up_to_date"] = None
            __props__.__dict__["kubeconfig"] = None
            __props__.__dict__["kubeconfig_attributes"] = None
            __props__.__dict__["next_upgrade_versions"] = None
            __props__.__dict__["nodes_url"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeconfig", "kubeconfigAttributes"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Kube, __self__).__init__(
            'ovh:CloudProject/kube:Kube',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            control_plane_is_up_to_date: Optional[pulumi.Input[bool]] = None,
            customization_apiservers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationApiserverArgs']]]]] = None,
            customization_kube_proxy: Optional[pulumi.Input[pulumi.InputType['KubeCustomizationKubeProxyArgs']]] = None,
            customizations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationArgs']]]]] = None,
            is_up_to_date: Optional[pulumi.Input[bool]] = None,
            kube_proxy_mode: Optional[pulumi.Input[str]] = None,
            kubeconfig: Optional[pulumi.Input[str]] = None,
            kubeconfig_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeKubeconfigAttributeArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            next_upgrade_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            nodes_url: Optional[pulumi.Input[str]] = None,
            private_network_configuration: Optional[pulumi.Input[pulumi.InputType['KubePrivateNetworkConfigurationArgs']]] = None,
            private_network_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_policy: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'Kube':
        """
        Get an existing Kube resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] control_plane_is_up_to_date: True if control-plane is up-to-date.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationApiserverArgs']]]] customization_apiservers: Kubernetes API server customization
        :param pulumi.Input[pulumi.InputType['KubeCustomizationKubeProxyArgs']] customization_kube_proxy: Kubernetes kube-proxy customization
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeCustomizationArgs']]]] customizations: **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        :param pulumi.Input[bool] is_up_to_date: True if all nodes and control-plane are up-to-date.
        :param pulumi.Input[str] kube_proxy_mode: Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        :param pulumi.Input[str] kubeconfig: The kubeconfig file. Use this file to connect to your kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KubeKubeconfigAttributeArgs']]]] kubeconfig_attributes: The kubeconfig file attributes.
        :param pulumi.Input[str] name: The name of the kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] next_upgrade_versions: Kubernetes versions available for upgrade.
        :param pulumi.Input[str] nodes_url: Cluster nodes URL.
        :param pulumi.Input[pulumi.InputType['KubePrivateNetworkConfigurationArgs']] private_network_configuration: The private network configuration
        :param pulumi.Input[str] private_network_id: OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.
               
               > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        :param pulumi.Input[str] region: a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        :param pulumi.Input[str] status: Cluster status. Should be normally set to 'READY'.
        :param pulumi.Input[str] update_policy: Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        :param pulumi.Input[str] url: Management URL of your cluster.
        :param pulumi.Input[str] version: kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubeState.__new__(_KubeState)

        __props__.__dict__["control_plane_is_up_to_date"] = control_plane_is_up_to_date
        __props__.__dict__["customization_apiservers"] = customization_apiservers
        __props__.__dict__["customization_kube_proxy"] = customization_kube_proxy
        __props__.__dict__["customizations"] = customizations
        __props__.__dict__["is_up_to_date"] = is_up_to_date
        __props__.__dict__["kube_proxy_mode"] = kube_proxy_mode
        __props__.__dict__["kubeconfig"] = kubeconfig
        __props__.__dict__["kubeconfig_attributes"] = kubeconfig_attributes
        __props__.__dict__["name"] = name
        __props__.__dict__["next_upgrade_versions"] = next_upgrade_versions
        __props__.__dict__["nodes_url"] = nodes_url
        __props__.__dict__["private_network_configuration"] = private_network_configuration
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["url"] = url
        __props__.__dict__["version"] = version
        return Kube(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="controlPlaneIsUpToDate")
    def control_plane_is_up_to_date(self) -> pulumi.Output[bool]:
        """
        True if control-plane is up-to-date.
        """
        return pulumi.get(self, "control_plane_is_up_to_date")

    @property
    @pulumi.getter(name="customizationApiservers")
    def customization_apiservers(self) -> pulumi.Output[Sequence['outputs.KubeCustomizationApiserver']]:
        """
        Kubernetes API server customization
        """
        return pulumi.get(self, "customization_apiservers")

    @property
    @pulumi.getter(name="customizationKubeProxy")
    def customization_kube_proxy(self) -> pulumi.Output[Optional['outputs.KubeCustomizationKubeProxy']]:
        """
        Kubernetes kube-proxy customization
        """
        return pulumi.get(self, "customization_kube_proxy")

    @property
    @pulumi.getter
    def customizations(self) -> pulumi.Output[Sequence['outputs.KubeCustomization']]:
        """
        **Deprecated** (Optional) Use `customization_apiserver` and `customization_kube_proxy` instead. Kubernetes cluster customization
        """
        warnings.warn("""Use customization_apiserver instead""", DeprecationWarning)
        pulumi.log.warn("""customizations is deprecated: Use customization_apiserver instead""")

        return pulumi.get(self, "customizations")

    @property
    @pulumi.getter(name="isUpToDate")
    def is_up_to_date(self) -> pulumi.Output[bool]:
        """
        True if all nodes and control-plane are up-to-date.
        """
        return pulumi.get(self, "is_up_to_date")

    @property
    @pulumi.getter(name="kubeProxyMode")
    def kube_proxy_mode(self) -> pulumi.Output[str]:
        """
        Selected mode for kube-proxy. **Changing this value recreates the resource, including ETCD user data.** Defaults to `iptables`.
        """
        return pulumi.get(self, "kube_proxy_mode")

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[str]:
        """
        The kubeconfig file. Use this file to connect to your kubernetes cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter(name="kubeconfigAttributes")
    def kubeconfig_attributes(self) -> pulumi.Output[Sequence['outputs.KubeKubeconfigAttribute']]:
        """
        The kubeconfig file attributes.
        """
        return pulumi.get(self, "kubeconfig_attributes")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextUpgradeVersions")
    def next_upgrade_versions(self) -> pulumi.Output[Sequence[str]]:
        """
        Kubernetes versions available for upgrade.
        """
        return pulumi.get(self, "next_upgrade_versions")

    @property
    @pulumi.getter(name="nodesUrl")
    def nodes_url(self) -> pulumi.Output[str]:
        """
        Cluster nodes URL.
        """
        return pulumi.get(self, "nodes_url")

    @property
    @pulumi.getter(name="privateNetworkConfiguration")
    def private_network_configuration(self) -> pulumi.Output[Optional['outputs.KubePrivateNetworkConfiguration']]:
        """
        The private network configuration
        """
        return pulumi.get(self, "private_network_configuration")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[Optional[str]]:
        """
        OpenStack private network (or vRack) ID to use. **Changing this value recreates the resource, including ETCD user data.** Defaults - not use private network.

        > __WARNING__ Updating the private network ID resets the cluster so that all user data is deleted.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        a valid OVHcloud public cloud region ID in which the kubernetes cluster will be available. Ex.: "GRA1". Defaults to all public cloud regions. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The id of the public cloud project. If omitted, the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used. **Changing this value recreates the resource.**
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Cluster status. Should be normally set to 'READY'.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[str]:
        """
        Cluster update policy. Choose between [ALWAYS_UPDATE, MINIMAL_DOWNTIME, NEVER_UPDATE].
        """
        return pulumi.get(self, "update_policy")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        Management URL of your cluster.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        kubernetes version to use. Changing this value updates the resource. Defaults to the latest available.
        """
        return pulumi.get(self, "version")

