# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDatabaseIntegrationsResult',
    'AwaitableGetDatabaseIntegrationsResult',
    'get_database_integrations',
    'get_database_integrations_output',
]

@pulumi.output_type
class GetDatabaseIntegrationsResult:
    """
    A collection of values returned by getDatabaseIntegrations.
    """
    def __init__(__self__, cluster_id=None, engine=None, id=None, integration_ids=None, service_name=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if integration_ids and not isinstance(integration_ids, list):
            raise TypeError("Expected argument 'integration_ids' to be a list")
        pulumi.set(__self__, "integration_ids", integration_ids)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrationIds")
    def integration_ids(self) -> Sequence[str]:
        """
        The list of integrations ids of the database cluster associated with the project.
        """
        return pulumi.get(self, "integration_ids")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetDatabaseIntegrationsResult(GetDatabaseIntegrationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseIntegrationsResult(
            cluster_id=self.cluster_id,
            engine=self.engine,
            id=self.id,
            integration_ids=self.integration_ids,
            service_name=self.service_name)


def get_database_integrations(cluster_id: Optional[str] = None,
                              engine: Optional[str] = None,
                              service_name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseIntegrationsResult:
    """
    Use this data source to get the list of integrations of a database cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    integrations = ovh.CloudProjectDatabase.get_database_integrations(service_name="XXX",
        engine="YYY",
        cluster_id="ZZZ")
    pulumi.export("integrationIds", integrations.integration_ids)
    ```


    :param str cluster_id: Cluster ID
    :param str engine: The engine of the database cluster you want to list integrations. To get a full list of available engine visit:
           [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
           All engines available exept `mongodb`
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['engine'] = engine
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProjectDatabase/getDatabaseIntegrations:getDatabaseIntegrations', __args__, opts=opts, typ=GetDatabaseIntegrationsResult).value

    return AwaitableGetDatabaseIntegrationsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        integration_ids=pulumi.get(__ret__, 'integration_ids'),
        service_name=pulumi.get(__ret__, 'service_name'))


@_utilities.lift_output_func(get_database_integrations)
def get_database_integrations_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                     engine: Optional[pulumi.Input[str]] = None,
                                     service_name: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseIntegrationsResult]:
    """
    Use this data source to get the list of integrations of a database cluster associated with a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    integrations = ovh.CloudProjectDatabase.get_database_integrations(service_name="XXX",
        engine="YYY",
        cluster_id="ZZZ")
    pulumi.export("integrationIds", integrations.integration_ids)
    ```


    :param str cluster_id: Cluster ID
    :param str engine: The engine of the database cluster you want to list integrations. To get a full list of available engine visit:
           [public documentation](https://docs.ovh.com/gb/en/publiccloud/databases).
           All engines available exept `mongodb`
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    ...
