# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 identities: pulumi.Input[Sequence[pulumi.Input[str]]],
                 resources: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: List of identities affected by the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: List of resources affected by the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[str] name: Name of the policy, must be unique
        """
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "resources", resources)
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of identities affected by the policy
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of resources affected by the policy
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of actions allowed on resources by identities
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        """
        return pulumi.get(self, "excepts")

    @excepts.setter
    def excepts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excepts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy, must be unique
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[str] created_at: Creation date of this group.
        :param pulumi.Input[str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: List of identities affected by the policy
        :param pulumi.Input[str] name: Name of the policy, must be unique
        :param pulumi.Input[str] owner: Owner of the policy.
        :param pulumi.Input[bool] read_only: Indicates that the policy is a default one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: List of resources affected by the policy
        :param pulumi.Input[str] updated_at: Date of the last update of this group.
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of actions allowed on resources by identities
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        """
        return pulumi.get(self, "excepts")

    @excepts.setter
    def excepts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excepts", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of identities affected by the policy
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the policy, must be unique
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the policy.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the policy is a default one.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of resources affected by the policy
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates an IAM policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        account = ovh.Me.get_me()
        my_group = ovh.me.IdentityGroup("myGroup", description="my_group created in Terraform")
        manager = ovh.iam.Policy("manager",
            description="Users are allowed to use the OVH manager",
            identities=[my_group.group_urn],
            resources=[account.account_urn],
            allows=[
                "account:apiovh:me/get",
                "account:apiovh:me/supportLevel/get",
                "account:apiovh:me/certificates/get",
                "account:apiovh:me/tag/get",
                "account:apiovh:services/get",
                "account:apiovh:*",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: List of identities affected by the policy
        :param pulumi.Input[str] name: Name of the policy, must be unique
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: List of resources affected by the policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an IAM policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        account = ovh.Me.get_me()
        my_group = ovh.me.IdentityGroup("myGroup", description="my_group created in Terraform")
        manager = ovh.iam.Policy("manager",
            description="Users are allowed to use the OVH manager",
            identities=[my_group.group_urn],
            resources=[account.account_urn],
            allows=[
                "account:apiovh:me/get",
                "account:apiovh:me/supportLevel/get",
                "account:apiovh:me/certificates/get",
                "account:apiovh:me/tag/get",
                "account:apiovh:services/get",
                "account:apiovh:*",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["allows"] = allows
            __props__.__dict__["description"] = description
            __props__.__dict__["excepts"] = excepts
            if identities is None and not opts.urn:
                raise TypeError("Missing required property 'identities'")
            __props__.__dict__["identities"] = identities
            __props__.__dict__["name"] = name
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["created_at"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["read_only"] = None
            __props__.__dict__["updated_at"] = None
        super(Policy, __self__).__init__(
            'ovh:Iam/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            excepts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[str] created_at: Creation date of this group.
        :param pulumi.Input[str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: List of identities affected by the policy
        :param pulumi.Input[str] name: Name of the policy, must be unique
        :param pulumi.Input[str] owner: Owner of the policy.
        :param pulumi.Input[bool] read_only: Indicates that the policy is a default one.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: List of resources affected by the policy
        :param pulumi.Input[str] updated_at: Date of the last update of this group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["allows"] = allows
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["excepts"] = excepts
        __props__.__dict__["identities"] = identities
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["resources"] = resources
        __props__.__dict__["updated_at"] = updated_at
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allows(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of actions allowed on resources by identities
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def excepts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        """
        return pulumi.get(self, "excepts")

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Sequence[str]]:
        """
        List of identities affected by the policy
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the policy, must be unique
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        Owner of the policy.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[bool]:
        """
        Indicates that the policy is a default one.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence[str]]:
        """
        List of resources affected by the policy
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

