# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCartProductResult',
    'AwaitableGetCartProductResult',
    'get_cart_product',
    'get_cart_product_output',
]

@pulumi.output_type
class GetCartProductResult:
    """
    A collection of values returned by getCartProduct.
    """
    def __init__(__self__, cart_id=None, id=None, product=None, results=None):
        if cart_id and not isinstance(cart_id, str):
            raise TypeError("Expected argument 'cart_id' to be a str")
        pulumi.set(__self__, "cart_id", cart_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @property
    @pulumi.getter(name="cartId")
    def cart_id(self) -> str:
        return pulumi.get(self, "cart_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def product(self) -> str:
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetCartProductResultResult']:
        """
        products results
        """
        return pulumi.get(self, "results")


class AwaitableGetCartProductResult(GetCartProductResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCartProductResult(
            cart_id=self.cart_id,
            id=self.id,
            product=self.product,
            results=self.results)


def get_cart_product(cart_id: Optional[str] = None,
                     product: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCartProductResult:
    """
    Use this data source to retrieve information of order cart product products.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    myaccount = ovh.Me.get_me()
    mycart = ovh.Order.get_cart(ovh_subsidiary=myaccount.ovh_subsidiary)
    plans = ovh.Order.get_cart_product(cart_id=mycart.id,
        product="...")
    ```


    :param str cart_id: Cart identifier
    :param str product: product
    """
    __args__ = dict()
    __args__['cartId'] = cart_id
    __args__['product'] = product
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Order/getCartProduct:getCartProduct', __args__, opts=opts, typ=GetCartProductResult).value

    return AwaitableGetCartProductResult(
        cart_id=pulumi.get(__ret__, 'cart_id'),
        id=pulumi.get(__ret__, 'id'),
        product=pulumi.get(__ret__, 'product'),
        results=pulumi.get(__ret__, 'results'))


@_utilities.lift_output_func(get_cart_product)
def get_cart_product_output(cart_id: Optional[pulumi.Input[str]] = None,
                            product: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCartProductResult]:
    """
    Use this data source to retrieve information of order cart product products.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    myaccount = ovh.Me.get_me()
    mycart = ovh.Order.get_cart(ovh_subsidiary=myaccount.ovh_subsidiary)
    plans = ovh.Order.get_cart_product(cart_id=mycart.id,
        product="...")
    ```


    :param str cart_id: Cart identifier
    :param str product: product
    """
    ...
