# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v4.api_client import ApiClient
from tiledb.client._common.api_v4.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v4.exceptions import ApiValueError  # noqa: F401


class AcademyApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_academy_lessons(self, **kwargs):  # noqa: E501
        """Get information about user lessons  # noqa: E501

        Get a list of user lessons with details about each of them  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_academy_lessons(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AcademyLessonsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_academy_lessons_with_http_info(**kwargs)  # noqa: E501

    def get_academy_lessons_with_http_info(self, **kwargs):  # noqa: E501
        """Get information about user lessons  # noqa: E501

        Get a list of user lessons with details about each of them  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_academy_lessons_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AcademyLessonsListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_academy_lessons" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/academy/lessons",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AcademyLessonsListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_academy_questionnaire(self, questionnaire_id, **kwargs):  # noqa: E501
        """Get academy questionnaire information for user  # noqa: E501

        Get academy questionnaire information for user. For example, questionnaire version, completion status and user answers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_academy_questionnaire(questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str questionnaire_id: questionnaire's id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AcademyQuestionnaireListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_academy_questionnaire_with_http_info(
            questionnaire_id, **kwargs
        )  # noqa: E501

    def get_academy_questionnaire_with_http_info(
        self, questionnaire_id, **kwargs
    ):  # noqa: E501
        """Get academy questionnaire information for user  # noqa: E501

        Get academy questionnaire information for user. For example, questionnaire version, completion status and user answers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_academy_questionnaire_with_http_info(questionnaire_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str questionnaire_id: questionnaire's id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AcademyQuestionnaireListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["questionnaire_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_academy_questionnaire" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'questionnaire_id' is set
        if self.api_client.client_side_validation and (
            "questionnaire_id" not in local_var_params  # noqa: E501
            or local_var_params["questionnaire_id"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `questionnaire_id` when calling `get_academy_questionnaire`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "questionnaire_id" in local_var_params:
            path_params["questionnaire_id"] = local_var_params[
                "questionnaire_id"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/academy/questionnaires/{questionnaire_id}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AcademyQuestionnaireListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def put_academy_lessons(self, academy_lesson, **kwargs):  # noqa: E501
        """Academy lessons to create  # noqa: E501

        Create one or more user lessons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_academy_lessons(academy_lesson, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[AcademyLesson] academy_lesson: Academy lesson to create (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.put_academy_lessons_with_http_info(
            academy_lesson, **kwargs
        )  # noqa: E501

    def put_academy_lessons_with_http_info(
        self, academy_lesson, **kwargs
    ):  # noqa: E501
        """Academy lessons to create  # noqa: E501

        Create one or more user lessons  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_academy_lessons_with_http_info(academy_lesson, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[AcademyLesson] academy_lesson: Academy lesson to create (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["academy_lesson"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_academy_lessons" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'academy_lesson' is set
        if self.api_client.client_side_validation and (
            "academy_lesson" not in local_var_params  # noqa: E501
            or local_var_params["academy_lesson"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `academy_lesson` when calling `put_academy_lessons`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "academy_lesson" in local_var_params:
            body_params = local_var_params["academy_lesson"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/academy/lessons",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def put_academy_questionnaire(
        self, questionnaire_id, academy_questionnaire_put_request, **kwargs
    ):  # noqa: E501
        """Create or update academy questionnaire  # noqa: E501

        Create a new questionnaire or update an existing one  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_academy_questionnaire(questionnaire_id, academy_questionnaire_put_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str questionnaire_id: questionnaire's id (required)
        :param AcademyQuestionnairePutRequest academy_questionnaire_put_request: academy lesson to create (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.put_academy_questionnaire_with_http_info(
            questionnaire_id, academy_questionnaire_put_request, **kwargs
        )  # noqa: E501

    def put_academy_questionnaire_with_http_info(
        self, questionnaire_id, academy_questionnaire_put_request, **kwargs
    ):  # noqa: E501
        """Create or update academy questionnaire  # noqa: E501

        Create a new questionnaire or update an existing one  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_academy_questionnaire_with_http_info(questionnaire_id, academy_questionnaire_put_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str questionnaire_id: questionnaire's id (required)
        :param AcademyQuestionnairePutRequest academy_questionnaire_put_request: academy lesson to create (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["questionnaire_id", "academy_questionnaire_put_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_academy_questionnaire" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'questionnaire_id' is set
        if self.api_client.client_side_validation and (
            "questionnaire_id" not in local_var_params  # noqa: E501
            or local_var_params["questionnaire_id"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `questionnaire_id` when calling `put_academy_questionnaire`"
            )  # noqa: E501
        # verify the required parameter 'academy_questionnaire_put_request' is set
        if self.api_client.client_side_validation and (
            "academy_questionnaire_put_request" not in local_var_params  # noqa: E501
            or local_var_params["academy_questionnaire_put_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `academy_questionnaire_put_request` when calling `put_academy_questionnaire`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "questionnaire_id" in local_var_params:
            path_params["questionnaire_id"] = local_var_params[
                "questionnaire_id"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "academy_questionnaire_put_request" in local_var_params:
            body_params = local_var_params["academy_questionnaire_put_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/academy/questionnaires/{questionnaire_id}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
