# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v4.api_client import ApiClient
from tiledb.client._common.api_v4.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v4.exceptions import ApiValueError  # noqa: F401


class ActivitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list_activities_in_teamspace(
        self, workspace, teamspace, **kwargs
    ):  # noqa: E501
        """Retrieve cloud activities in a teamspace  # noqa: E501

        This endpoint returns a list of activities based on the provided filters. The filters work cumulatively. For example, if you filter by subject and object, the response will include activities that match both filters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_activities_in_teamspace(workspace, teamspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order: Specifies the sorting direction for the results returned by the query. Defaults to `desc`. Can be one of the following: - asc - desc
        :param str order_by: Controls what field to order the activities by. Defaults to `recorded_at`.
        :param str id: The ID of the activity to filter activities by
        :param APIVersion api_version: The API version to filter activities by
        :param list[str] subject: The username of the subject to filter activities by.
        :param list[EntityTypes] object_type: The type of the object to filter activities by. Multiple values can be provided to filter by any of the specified types.
        :param str object_id: The asset ID of the object to filter activities by
        :param list[str] action_type: The action (that was performed on the object) to filter activities by. Multiple values can be provided to filter by any of the specified actions.
        :param datetime recorded_after: The time after which activities were recorded
        :param datetime recorded_before: The time before which activities were recorded
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActivitiesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_activities_in_teamspace_with_http_info(
            workspace, teamspace, **kwargs
        )  # noqa: E501

    def list_activities_in_teamspace_with_http_info(
        self, workspace, teamspace, **kwargs
    ):  # noqa: E501
        """Retrieve cloud activities in a teamspace  # noqa: E501

        This endpoint returns a list of activities based on the provided filters. The filters work cumulatively. For example, if you filter by subject and object, the response will include activities that match both filters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_activities_in_teamspace_with_http_info(workspace, teamspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order: Specifies the sorting direction for the results returned by the query. Defaults to `desc`. Can be one of the following: - asc - desc
        :param str order_by: Controls what field to order the activities by. Defaults to `recorded_at`.
        :param str id: The ID of the activity to filter activities by
        :param APIVersion api_version: The API version to filter activities by
        :param list[str] subject: The username of the subject to filter activities by.
        :param list[EntityTypes] object_type: The type of the object to filter activities by. Multiple values can be provided to filter by any of the specified types.
        :param str object_id: The asset ID of the object to filter activities by
        :param list[str] action_type: The action (that was performed on the object) to filter activities by. Multiple values can be provided to filter by any of the specified actions.
        :param datetime recorded_after: The time after which activities were recorded
        :param datetime recorded_before: The time before which activities were recorded
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActivitiesListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "page",
            "per_page",
            "order",
            "order_by",
            "id",
            "api_version",
            "subject",
            "object_type",
            "object_id",
            "action_type",
            "recorded_after",
            "recorded_before",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_activities_in_teamspace" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `list_activities_in_teamspace`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `list_activities_in_teamspace`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501

        query_params = []
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501
        if (
            "order" in local_var_params and local_var_params["order"] is not None
        ):  # noqa: E501
            query_params.append(("order", local_var_params["order"]))  # noqa: E501
        if (
            "order_by" in local_var_params and local_var_params["order_by"] is not None
        ):  # noqa: E501
            query_params.append(
                ("order_by", local_var_params["order_by"])
            )  # noqa: E501
        if (
            "id" in local_var_params and local_var_params["id"] is not None
        ):  # noqa: E501
            query_params.append(("id", local_var_params["id"]))  # noqa: E501
        if (
            "api_version" in local_var_params
            and local_var_params["api_version"] is not None
        ):  # noqa: E501
            query_params.append(
                ("api_version", local_var_params["api_version"])
            )  # noqa: E501
        if (
            "subject" in local_var_params and local_var_params["subject"] is not None
        ):  # noqa: E501
            query_params.append(("subject", local_var_params["subject"]))  # noqa: E501
            collection_formats["subject"] = "multi"  # noqa: E501
        if (
            "object_type" in local_var_params
            and local_var_params["object_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("object_type", local_var_params["object_type"])
            )  # noqa: E501
            collection_formats["object_type"] = "multi"  # noqa: E501
        if (
            "object_id" in local_var_params
            and local_var_params["object_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("object_id", local_var_params["object_id"])
            )  # noqa: E501
        if (
            "action_type" in local_var_params
            and local_var_params["action_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("action_type", local_var_params["action_type"])
            )  # noqa: E501
            collection_formats["action_type"] = "multi"  # noqa: E501
        if (
            "recorded_after" in local_var_params
            and local_var_params["recorded_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("recorded_after", local_var_params["recorded_after"])
            )  # noqa: E501
        if (
            "recorded_before" in local_var_params
            and local_var_params["recorded_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("recorded_before", local_var_params["recorded_before"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/activities/{workspace}/{teamspace}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ActivitiesListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_activities_in_workspace(self, workspace, **kwargs):  # noqa: E501
        """Retrieve cloud activities in a workspace  # noqa: E501

        This endpoint returns a list of activities based on the provided filters. The filters work cumulatively. For example, if you filter by subject and object, the response will include activities that match both filters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_activities_in_workspace(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order: Specifies the sorting direction for the results returned by the query. Defaults to `desc`. Can be one of the following: - asc - desc
        :param str order_by: Controls what field to order the activities by. Defaults to `recorded_at`.
        :param str id: The ID of the activity to filter activities by
        :param APIVersion api_version: The API version to filter activities by
        :param list[str] subject: The username of the subject to filter activities by.
        :param list[EntityTypes] object_type: The type of the object to filter activities by. Multiple values can be provided to filter by any of the specified types.
        :param str object_id: The asset ID of the object to filter activities by
        :param list[str] action_type: The action (that was performed on the object) to filter activities by. Multiple values can be provided to filter by any of the specified actions.
        :param datetime recorded_after: The time after which activities were recorded
        :param datetime recorded_before: The time before which activities were recorded
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ActivitiesListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_activities_in_workspace_with_http_info(
            workspace, **kwargs
        )  # noqa: E501

    def list_activities_in_workspace_with_http_info(
        self, workspace, **kwargs
    ):  # noqa: E501
        """Retrieve cloud activities in a workspace  # noqa: E501

        This endpoint returns a list of activities based on the provided filters. The filters work cumulatively. For example, if you filter by subject and object, the response will include activities that match both filters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_activities_in_workspace_with_http_info(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order: Specifies the sorting direction for the results returned by the query. Defaults to `desc`. Can be one of the following: - asc - desc
        :param str order_by: Controls what field to order the activities by. Defaults to `recorded_at`.
        :param str id: The ID of the activity to filter activities by
        :param APIVersion api_version: The API version to filter activities by
        :param list[str] subject: The username of the subject to filter activities by.
        :param list[EntityTypes] object_type: The type of the object to filter activities by. Multiple values can be provided to filter by any of the specified types.
        :param str object_id: The asset ID of the object to filter activities by
        :param list[str] action_type: The action (that was performed on the object) to filter activities by. Multiple values can be provided to filter by any of the specified actions.
        :param datetime recorded_after: The time after which activities were recorded
        :param datetime recorded_before: The time before which activities were recorded
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ActivitiesListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "page",
            "per_page",
            "order",
            "order_by",
            "id",
            "api_version",
            "subject",
            "object_type",
            "object_id",
            "action_type",
            "recorded_after",
            "recorded_before",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_activities_in_workspace" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `list_activities_in_workspace`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501
        if (
            "order" in local_var_params and local_var_params["order"] is not None
        ):  # noqa: E501
            query_params.append(("order", local_var_params["order"]))  # noqa: E501
        if (
            "order_by" in local_var_params and local_var_params["order_by"] is not None
        ):  # noqa: E501
            query_params.append(
                ("order_by", local_var_params["order_by"])
            )  # noqa: E501
        if (
            "id" in local_var_params and local_var_params["id"] is not None
        ):  # noqa: E501
            query_params.append(("id", local_var_params["id"]))  # noqa: E501
        if (
            "api_version" in local_var_params
            and local_var_params["api_version"] is not None
        ):  # noqa: E501
            query_params.append(
                ("api_version", local_var_params["api_version"])
            )  # noqa: E501
        if (
            "subject" in local_var_params and local_var_params["subject"] is not None
        ):  # noqa: E501
            query_params.append(("subject", local_var_params["subject"]))  # noqa: E501
            collection_formats["subject"] = "multi"  # noqa: E501
        if (
            "object_type" in local_var_params
            and local_var_params["object_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("object_type", local_var_params["object_type"])
            )  # noqa: E501
            collection_formats["object_type"] = "multi"  # noqa: E501
        if (
            "object_id" in local_var_params
            and local_var_params["object_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("object_id", local_var_params["object_id"])
            )  # noqa: E501
        if (
            "action_type" in local_var_params
            and local_var_params["action_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("action_type", local_var_params["action_type"])
            )  # noqa: E501
            collection_formats["action_type"] = "multi"  # noqa: E501
        if (
            "recorded_after" in local_var_params
            and local_var_params["recorded_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("recorded_after", local_var_params["recorded_after"])
            )  # noqa: E501
        if (
            "recorded_before" in local_var_params
            and local_var_params["recorded_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("recorded_before", local_var_params["recorded_before"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/activities/{workspace}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ActivitiesListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
