# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v4.api_client import ApiClient
from tiledb.client._common.api_v4.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v4.exceptions import ApiValueError  # noqa: F401


class AssetsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_asset(self, workspace, teamspace, asset, **kwargs):  # noqa: E501
        """Unregister or delete an asset  # noqa: E501

        Unregister or delete an asset in the specified workspace and teamspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param bool delete_assets: If `true`, the entity's assets will be deregistered in TileDB *and* deleted from the underlying storage (e.g., S3). If `false`, the entity's assets will be deregistered in TileDB but remain in the underlying storage.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_asset_with_http_info(
            workspace, teamspace, asset, **kwargs
        )  # noqa: E501

    def delete_asset_with_http_info(
        self, workspace, teamspace, asset, **kwargs
    ):  # noqa: E501
        """Unregister or delete an asset  # noqa: E501

        Unregister or delete an asset in the specified workspace and teamspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_with_http_info(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param bool delete_assets: If `true`, the entity's assets will be deregistered in TileDB *and* deleted from the underlying storage (e.g., S3). If `false`, the entity's assets will be deregistered in TileDB but remain in the underlying storage.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "asset", "delete_assets"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `delete_asset`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `delete_asset`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `delete_asset`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []
        if (
            "delete_assets" in local_var_params
            and local_var_params["delete_assets"] is not None
        ):  # noqa: E501
            query_params.append(
                ("delete-assets", local_var_params["delete_assets"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_asset_metadata(
        self, workspace, teamspace, asset, metadata_key, **kwargs
    ):  # noqa: E501
        """Delete asset metadata  # noqa: E501

        Delete one or more metadata keys for the given asset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_metadata(workspace, teamspace, asset, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param list[str] metadata_key: One or more metadata keys to delete (required)
        :param int start_timestamp: Start timestamp in milliseconds since epoch
        :param int end_timestamp: End timestamp in milliseconds since epoch
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_asset_metadata_with_http_info(
            workspace, teamspace, asset, metadata_key, **kwargs
        )  # noqa: E501

    def delete_asset_metadata_with_http_info(
        self, workspace, teamspace, asset, metadata_key, **kwargs
    ):  # noqa: E501
        """Delete asset metadata  # noqa: E501

        Delete one or more metadata keys for the given asset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_asset_metadata_with_http_info(workspace, teamspace, asset, metadata_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param list[str] metadata_key: One or more metadata keys to delete (required)
        :param int start_timestamp: Start timestamp in milliseconds since epoch
        :param int end_timestamp: End timestamp in milliseconds since epoch
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "asset",
            "metadata_key",
            "start_timestamp",
            "end_timestamp",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `delete_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `delete_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `delete_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and (
            "metadata_key" not in local_var_params  # noqa: E501
            or local_var_params["metadata_key"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `metadata_key` when calling `delete_asset_metadata`"
            )  # noqa: E501

        if self.api_client.client_side_validation and (
            "metadata_key" in local_var_params  # noqa: E501
            and len(local_var_params["metadata_key"]) < 1
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `metadata_key` when calling `delete_asset_metadata`, number of items must be greater than or equal to `1`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []
        if (
            "start_timestamp" in local_var_params
            and local_var_params["start_timestamp"] is not None
        ):  # noqa: E501
            query_params.append(
                ("start_timestamp", local_var_params["start_timestamp"])
            )  # noqa: E501
        if (
            "end_timestamp" in local_var_params
            and local_var_params["end_timestamp"] is not None
        ):  # noqa: E501
            query_params.append(
                ("end_timestamp", local_var_params["end_timestamp"])
            )  # noqa: E501
        if (
            "metadata_key" in local_var_params
            and local_var_params["metadata_key"] is not None
        ):  # noqa: E501
            query_params.append(
                ("metadata_key", local_var_params["metadata_key"])
            )  # noqa: E501
            collection_formats["metadata_key"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}/metadata",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_asset(self, workspace, teamspace, asset, **kwargs):  # noqa: E501
        """Retrieve asset  # noqa: E501

        Retrieve the asset by the given asset_id or path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_asset_with_http_info(
            workspace, teamspace, asset, **kwargs
        )  # noqa: E501

    def get_asset_with_http_info(
        self, workspace, teamspace, asset, **kwargs
    ):  # noqa: E501
        """Retrieve asset  # noqa: E501

        Retrieve the asset by the given asset_id or path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_with_http_info(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetGetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "asset"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_asset`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `get_asset`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `get_asset`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetGetResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_asset_metadata(self, workspace, teamspace, asset, **kwargs):  # noqa: E501
        """Retrieve asset's metadata  # noqa: E501

        Retrieve the given asset's metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_metadata(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param int start_timestamp: Start timestamp in milliseconds since epoch
        :param int end_timestamp: End timestamp in milliseconds since epoch
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetMetadataListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_asset_metadata_with_http_info(
            workspace, teamspace, asset, **kwargs
        )  # noqa: E501

    def get_asset_metadata_with_http_info(
        self, workspace, teamspace, asset, **kwargs
    ):  # noqa: E501
        """Retrieve asset's metadata  # noqa: E501

        Retrieve the given asset's metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_metadata_with_http_info(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param int start_timestamp: Start timestamp in milliseconds since epoch
        :param int end_timestamp: End timestamp in milliseconds since epoch
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetMetadataListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "asset",
            "start_timestamp",
            "end_timestamp",
            "page",
            "per_page",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `get_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `get_asset_metadata`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []
        if (
            "start_timestamp" in local_var_params
            and local_var_params["start_timestamp"] is not None
        ):  # noqa: E501
            query_params.append(
                ("start_timestamp", local_var_params["start_timestamp"])
            )  # noqa: E501
        if (
            "end_timestamp" in local_var_params
            and local_var_params["end_timestamp"] is not None
        ):  # noqa: E501
            query_params.append(
                ("end_timestamp", local_var_params["end_timestamp"])
            )  # noqa: E501
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}/metadata",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetMetadataListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_asset_properties(self, workspace, teamspace, asset, **kwargs):  # noqa: E501
        """Retrieve asset's properties  # noqa: E501

        Retrieve the given asset's properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_properties(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetPropertyListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_asset_properties_with_http_info(
            workspace, teamspace, asset, **kwargs
        )  # noqa: E501

    def get_asset_properties_with_http_info(
        self, workspace, teamspace, asset, **kwargs
    ):  # noqa: E501
        """Retrieve asset's properties  # noqa: E501

        Retrieve the given asset's properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_properties_with_http_info(workspace, teamspace, asset, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetPropertyListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "asset"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_properties" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_asset_properties`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `get_asset_properties`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `get_asset_properties`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}/properties",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetPropertyListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_assets_in_path(self, workspace, teamspace, path, **kwargs):  # noqa: E501
        """Retrieve all assets in a given path  # noqa: E501

        Retrieve all assets in a given path, e.g., a request for `/a/b/c` will return the assets `a`, `b`, and `c`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_in_path(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path for which to retrieve assets (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetPathResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_assets_in_path_with_http_info(
            workspace, teamspace, path, **kwargs
        )  # noqa: E501

    def get_assets_in_path_with_http_info(
        self, workspace, teamspace, path, **kwargs
    ):  # noqa: E501
        """Retrieve all assets in a given path  # noqa: E501

        Retrieve all assets in a given path, e.g., a request for `/a/b/c` will return the assets `a`, `b`, and `c`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_assets_in_path_with_http_info(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path for which to retrieve assets (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetPathResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "path"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assets_in_path" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_assets_in_path`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `get_assets_in_path`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `get_assets_in_path`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/path/{workspace}/{teamspace}/{path}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetPathResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_assets(self, workspace, teamspace, path, **kwargs):  # noqa: E501
        """Retrieves asset listing for the given teamspace  # noqa: E501

        End point to retrieve assets for the passed teamspace   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_assets(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path for which to retrieve assets (required)
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param AssetType asset_type: asset type to filter to
        :param str created_by: users that created the asset to filter to
        :param str order_by: order by string
        :param str expand: expand api response with supplemental information
        :param bool include_system_assets: if true, system assets (like overlay arrays and groups) are returned
        :param bool x_show_hidden_assets: Set to 'false' to exclude hidden (dot starting) assets from the response.  Defaults to 'true' (including hidden assets).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_assets_with_http_info(
            workspace, teamspace, path, **kwargs
        )  # noqa: E501

    def list_assets_with_http_info(
        self, workspace, teamspace, path, **kwargs
    ):  # noqa: E501
        """Retrieves asset listing for the given teamspace  # noqa: E501

        End point to retrieve assets for the passed teamspace   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_assets_with_http_info(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path for which to retrieve assets (required)
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param AssetType asset_type: asset type to filter to
        :param str created_by: users that created the asset to filter to
        :param str order_by: order by string
        :param str expand: expand api response with supplemental information
        :param bool include_system_assets: if true, system assets (like overlay arrays and groups) are returned
        :param bool x_show_hidden_assets: Set to 'false' to exclude hidden (dot starting) assets from the response.  Defaults to 'true' (including hidden assets).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "path",
            "page",
            "per_page",
            "asset_type",
            "created_by",
            "order_by",
            "expand",
            "include_system_assets",
            "x_show_hidden_assets",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assets" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `list_assets`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `list_assets`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `list_assets`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501
        if (
            "asset_type" in local_var_params
            and local_var_params["asset_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("asset_type", local_var_params["asset_type"])
            )  # noqa: E501
        if (
            "created_by" in local_var_params
            and local_var_params["created_by"] is not None
        ):  # noqa: E501
            query_params.append(
                ("created_by", local_var_params["created_by"])
            )  # noqa: E501
        if (
            "order_by" in local_var_params and local_var_params["order_by"] is not None
        ):  # noqa: E501
            query_params.append(
                ("order_by", local_var_params["order_by"])
            )  # noqa: E501
        if (
            "expand" in local_var_params and local_var_params["expand"] is not None
        ):  # noqa: E501
            query_params.append(("expand", local_var_params["expand"]))  # noqa: E501
        if (
            "include_system_assets" in local_var_params
            and local_var_params["include_system_assets"] is not None
        ):  # noqa: E501
            query_params.append(
                ("include_system_assets", local_var_params["include_system_assets"])
            )  # noqa: E501

        header_params = {}
        if "x_show_hidden_assets" in local_var_params:
            header_params["X-SHOW-HIDDEN-ASSETS"] = local_var_params[
                "x_show_hidden_assets"
            ]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/list/{workspace}/{teamspace}/{path}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def move_assets(
        self, workspace, teamspace, assets_move_request, **kwargs
    ):  # noqa: E501
        """Move assets (array, group & files)  # noqa: E501

        Move assets (array, group & files) in the specified workspace and teamspace to a target folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_assets(workspace, teamspace, assets_move_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param AssetsMoveRequest assets_move_request: The assets move request body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.move_assets_with_http_info(
            workspace, teamspace, assets_move_request, **kwargs
        )  # noqa: E501

    def move_assets_with_http_info(
        self, workspace, teamspace, assets_move_request, **kwargs
    ):  # noqa: E501
        """Move assets (array, group & files)  # noqa: E501

        Move assets (array, group & files) in the specified workspace and teamspace to a target folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_assets_with_http_info(workspace, teamspace, assets_move_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param AssetsMoveRequest assets_move_request: The assets move request body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "assets_move_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_assets" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `move_assets`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `move_assets`"
            )  # noqa: E501
        # verify the required parameter 'assets_move_request' is set
        if self.api_client.client_side_validation and (
            "assets_move_request" not in local_var_params  # noqa: E501
            or local_var_params["assets_move_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `assets_move_request` when calling `move_assets`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "assets_move_request" in local_var_params:
            body_params = local_var_params["assets_move_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/move/{workspace}/{teamspace}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def register_asset(
        self, workspace, teamspace, path, asset_register_request, **kwargs
    ):  # noqa: E501
        """Register an asset (array, group & files)  # noqa: E501

        Register an asset for the given user in the specified workspace and teamspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_asset(workspace, teamspace, path, asset_register_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path in the teamspace where the asset will be registered. No existing asset can have the same path. The asset's name will be the last element of the path. That is, if the path is `/path/to/asset`, the asset's name will be `asset`.  (required)
        :param AssetRegisterRequest asset_register_request: The asset registration request body (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.register_asset_with_http_info(
            workspace, teamspace, path, asset_register_request, **kwargs
        )  # noqa: E501

    def register_asset_with_http_info(
        self, workspace, teamspace, path, asset_register_request, **kwargs
    ):  # noqa: E501
        """Register an asset (array, group & files)  # noqa: E501

        Register an asset for the given user in the specified workspace and teamspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_asset_with_http_info(workspace, teamspace, path, asset_register_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path in the teamspace where the asset will be registered. No existing asset can have the same path. The asset's name will be the last element of the path. That is, if the path is `/path/to/asset`, the asset's name will be `asset`.  (required)
        :param AssetRegisterRequest asset_register_request: The asset registration request body (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "path", "asset_register_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_asset" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `register_asset`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `register_asset`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `register_asset`"
            )  # noqa: E501
        # verify the required parameter 'asset_register_request' is set
        if self.api_client.client_side_validation and (
            "asset_register_request" not in local_var_params  # noqa: E501
            or local_var_params["asset_register_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset_register_request` when calling `register_asset`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "asset_register_request" in local_var_params:
            body_params = local_var_params["asset_register_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/register/{workspace}/{teamspace}/{path}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def search_assets(self, workspace, **kwargs):  # noqa: E501
        """Search Assets  # noqa: E501

        Search Assets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_assets(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param bool x_show_hidden_assets: Set to 'false' to exclude hidden (dot starting) assets from the response.  Defaults to 'true' (including hidden assets).
        :param str q: Search query text. Supports boolean operators for precise searching:  **Basic Search:** - `term` - prefix match (finds \"term\", \"terms\", \"terminal\") - `\"exact phrase\"` - exact phrase match (use quotes for multi-word phrases) - `term1 term2` - finds documents with ANY term (implicit OR)  **Boolean Operators:** - `term1 AND term2` - requires BOTH terms - `term1 OR term2` - requires EITHER term (explicit OR) - `NOT term` - excludes a term - `(term1 OR term2) AND term3` - use parentheses to group expressions  **Examples:** - `\"machine learning\" AND python` - exact phrase with Python - `golang AND (api OR service)` - Go with either API or service - `python NOT deprecated` - Python but exclude deprecated items  Operators are case-insensitive. Precedence: NOT > AND > OR
        :param str path: asset path prefix
        :param str sort: sort order for results. Valid values [relevance, recency, name]
        :param str sort_dir: sort direction for results. Valid values [asc, desc]. Case-insensitive.
        :param list[str] teamspace: teamspace_id, limit results to assets of one or more teamspaces
        :param list[str] teamspace_exclude: teamspace_id, exclude results from one or more teamspaces
        :param list[str] filters: subexpressions for matching asset system fields  {key}{op}{value}  key one of: `created_at` `updated_at` `created_by` `type`  op one of: `<` `>` `<=` `>=` `=` `!=` `:`  op `:` sets up a between-expression where two valid values {lo}..{hi}, equivalent to {lo} <= x <= {hi}  Date values (`created_at`, `updated_at`) can be relative times in the past (`today`, `yesterday`, `week`, `month`, `year`), or any prefix of \"2006-01-02T15:04:05.000000000\" in UTC, or RFC 3339 format \"2006-01-02T15:04:05Z07:00\" (optionally with all `.123456789` digits of nanoseconds).  `type` values should be one of the string enum values that an `Asset.type` field can take on. See [GET asset](#tag/assets/operation/getAsset) for the return data Asset description.
        :param list[str] metadata: subexpressions for matching user metadata  {key}{op}{value}  op one of: `<` `>` `<=` `>=` `=` `!=` `:`  op `:` sets up a between-expression where two valid values {lo}..{hi}, equivalent to {lo} <= x <= {hi}  keys and values can be any user value set on asset metadata.
        :param bool public: boolean toggle for including or excluding public teamspaces from search
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.search_assets_with_http_info(workspace, **kwargs)  # noqa: E501

    def search_assets_with_http_info(self, workspace, **kwargs):  # noqa: E501
        """Search Assets  # noqa: E501

        Search Assets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_assets_with_http_info(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param bool x_show_hidden_assets: Set to 'false' to exclude hidden (dot starting) assets from the response.  Defaults to 'true' (including hidden assets).
        :param str q: Search query text. Supports boolean operators for precise searching:  **Basic Search:** - `term` - prefix match (finds \"term\", \"terms\", \"terminal\") - `\"exact phrase\"` - exact phrase match (use quotes for multi-word phrases) - `term1 term2` - finds documents with ANY term (implicit OR)  **Boolean Operators:** - `term1 AND term2` - requires BOTH terms - `term1 OR term2` - requires EITHER term (explicit OR) - `NOT term` - excludes a term - `(term1 OR term2) AND term3` - use parentheses to group expressions  **Examples:** - `\"machine learning\" AND python` - exact phrase with Python - `golang AND (api OR service)` - Go with either API or service - `python NOT deprecated` - Python but exclude deprecated items  Operators are case-insensitive. Precedence: NOT > AND > OR
        :param str path: asset path prefix
        :param str sort: sort order for results. Valid values [relevance, recency, name]
        :param str sort_dir: sort direction for results. Valid values [asc, desc]. Case-insensitive.
        :param list[str] teamspace: teamspace_id, limit results to assets of one or more teamspaces
        :param list[str] teamspace_exclude: teamspace_id, exclude results from one or more teamspaces
        :param list[str] filters: subexpressions for matching asset system fields  {key}{op}{value}  key one of: `created_at` `updated_at` `created_by` `type`  op one of: `<` `>` `<=` `>=` `=` `!=` `:`  op `:` sets up a between-expression where two valid values {lo}..{hi}, equivalent to {lo} <= x <= {hi}  Date values (`created_at`, `updated_at`) can be relative times in the past (`today`, `yesterday`, `week`, `month`, `year`), or any prefix of \"2006-01-02T15:04:05.000000000\" in UTC, or RFC 3339 format \"2006-01-02T15:04:05Z07:00\" (optionally with all `.123456789` digits of nanoseconds).  `type` values should be one of the string enum values that an `Asset.type` field can take on. See [GET asset](#tag/assets/operation/getAsset) for the return data Asset description.
        :param list[str] metadata: subexpressions for matching user metadata  {key}{op}{value}  op one of: `<` `>` `<=` `>=` `=` `!=` `:`  op `:` sets up a between-expression where two valid values {lo}..{hi}, equivalent to {lo} <= x <= {hi}  keys and values can be any user value set on asset metadata.
        :param bool public: boolean toggle for including or excluding public teamspaces from search
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "x_show_hidden_assets",
            "q",
            "path",
            "sort",
            "sort_dir",
            "teamspace",
            "teamspace_exclude",
            "filters",
            "metadata",
            "public",
            "page",
            "per_page",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_assets" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `search_assets`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if "q" in local_var_params and local_var_params["q"] is not None:  # noqa: E501
            query_params.append(("q", local_var_params["q"]))  # noqa: E501
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
        if (
            "sort_dir" in local_var_params and local_var_params["sort_dir"] is not None
        ):  # noqa: E501
            query_params.append(
                ("sort_dir", local_var_params["sort_dir"])
            )  # noqa: E501
        if (
            "teamspace" in local_var_params
            and local_var_params["teamspace"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace", local_var_params["teamspace"])
            )  # noqa: E501
            collection_formats["teamspace"] = "multi"  # noqa: E501
        if (
            "teamspace_exclude" in local_var_params
            and local_var_params["teamspace_exclude"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace_exclude", local_var_params["teamspace_exclude"])
            )  # noqa: E501
            collection_formats["teamspace_exclude"] = "multi"  # noqa: E501
        if (
            "filters" in local_var_params and local_var_params["filters"] is not None
        ):  # noqa: E501
            query_params.append(("filters", local_var_params["filters"]))  # noqa: E501
            collection_formats["filters"] = "multi"  # noqa: E501
        if (
            "metadata" in local_var_params and local_var_params["metadata"] is not None
        ):  # noqa: E501
            query_params.append(
                ("metadata", local_var_params["metadata"])
            )  # noqa: E501
            collection_formats["metadata"] = "multi"  # noqa: E501
        if (
            "public" in local_var_params and local_var_params["public"] is not None
        ):  # noqa: E501
            query_params.append(("public", local_var_params["public"]))  # noqa: E501
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501

        header_params = {}
        if "x_show_hidden_assets" in local_var_params:
            header_params["X-SHOW-HIDDEN-ASSETS"] = local_var_params[
                "x_show_hidden_assets"
            ]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/search/{workspace}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def search_assets_indexer(self, **kwargs):  # noqa: E501
        """Search Assets Indexer  # noqa: E501

        Do Search Assets Indexer work for some time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_assets_indexer(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str run: run time (default 55s)
        :param str poll: idle polling frequency (default 1s)
        :param str unindexed: index unindexed assets
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetIndexerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.search_assets_indexer_with_http_info(**kwargs)  # noqa: E501

    def search_assets_indexer_with_http_info(self, **kwargs):  # noqa: E501
        """Search Assets Indexer  # noqa: E501

        Do Search Assets Indexer work for some time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_assets_indexer_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str run: run time (default 55s)
        :param str poll: idle polling frequency (default 1s)
        :param str unindexed: index unindexed assets
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetIndexerResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["run", "poll", "unindexed"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_assets_indexer" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "run" in local_var_params and local_var_params["run"] is not None
        ):  # noqa: E501
            query_params.append(("run", local_var_params["run"]))  # noqa: E501
        if (
            "poll" in local_var_params and local_var_params["poll"] is not None
        ):  # noqa: E501
            query_params.append(("poll", local_var_params["poll"]))  # noqa: E501
        if (
            "unindexed" in local_var_params
            and local_var_params["unindexed"] is not None
        ):  # noqa: E501
            query_params.append(
                ("unindexed", local_var_params["unindexed"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/search_index",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetIndexerResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_asset(
        self, workspace, teamspace, asset, asset_update_request, **kwargs
    ):  # noqa: E501
        """Update asset  # noqa: E501

        Update the asset by the given asset_id or path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset(workspace, teamspace, asset, asset_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param AssetUpdateRequest asset_update_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_asset_with_http_info(
            workspace, teamspace, asset, asset_update_request, **kwargs
        )  # noqa: E501

    def update_asset_with_http_info(
        self, workspace, teamspace, asset, asset_update_request, **kwargs
    ):  # noqa: E501
        """Update asset  # noqa: E501

        Update the asset by the given asset_id or path  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_with_http_info(workspace, teamspace, asset, asset_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param AssetUpdateRequest asset_update_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "asset", "asset_update_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `update_asset`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `update_asset`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `update_asset`"
            )  # noqa: E501
        # verify the required parameter 'asset_update_request' is set
        if self.api_client.client_side_validation and (
            "asset_update_request" not in local_var_params  # noqa: E501
            or local_var_params["asset_update_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset_update_request` when calling `update_asset`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "asset_update_request" in local_var_params:
            body_params = local_var_params["asset_update_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_asset_metadata(
        self, workspace, teamspace, asset, asset_metadata_save_request_inner, **kwargs
    ):  # noqa: E501
        """Update the given asset's metadata pair  # noqa: E501

        Update asset's metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_metadata(workspace, teamspace, asset, asset_metadata_save_request_inner, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param list[AssetMetadataSaveRequestInner] asset_metadata_save_request_inner: asset metadata pairs to update (required)
        :param int start_timestamp: Start timestamp in milliseconds since epoch
        :param int end_timestamp: End timestamp in milliseconds since epoch
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetMetadataSaveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_asset_metadata_with_http_info(
            workspace, teamspace, asset, asset_metadata_save_request_inner, **kwargs
        )  # noqa: E501

    def update_asset_metadata_with_http_info(
        self, workspace, teamspace, asset, asset_metadata_save_request_inner, **kwargs
    ):  # noqa: E501
        """Update the given asset's metadata pair  # noqa: E501

        Update asset's metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_metadata_with_http_info(workspace, teamspace, asset, asset_metadata_save_request_inner, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param list[AssetMetadataSaveRequestInner] asset_metadata_save_request_inner: asset metadata pairs to update (required)
        :param int start_timestamp: Start timestamp in milliseconds since epoch
        :param int end_timestamp: End timestamp in milliseconds since epoch
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetMetadataSaveResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "asset",
            "asset_metadata_save_request_inner",
            "start_timestamp",
            "end_timestamp",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `update_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `update_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `update_asset_metadata`"
            )  # noqa: E501
        # verify the required parameter 'asset_metadata_save_request_inner' is set
        if self.api_client.client_side_validation and (
            "asset_metadata_save_request_inner" not in local_var_params  # noqa: E501
            or local_var_params["asset_metadata_save_request_inner"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset_metadata_save_request_inner` when calling `update_asset_metadata`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []
        if (
            "start_timestamp" in local_var_params
            and local_var_params["start_timestamp"] is not None
        ):  # noqa: E501
            query_params.append(
                ("start_timestamp", local_var_params["start_timestamp"])
            )  # noqa: E501
        if (
            "end_timestamp" in local_var_params
            and local_var_params["end_timestamp"] is not None
        ):  # noqa: E501
            query_params.append(
                ("end_timestamp", local_var_params["end_timestamp"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "asset_metadata_save_request_inner" in local_var_params:
            body_params = local_var_params["asset_metadata_save_request_inner"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}/metadata",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetMetadataSaveResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_asset_properties(
        self, workspace, teamspace, asset, asset_property_save_request_inner, **kwargs
    ):  # noqa: E501
        """Update the given asset's property pair  # noqa: E501

        Update asset's properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_properties(workspace, teamspace, asset, asset_property_save_request_inner, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param list[AssetPropertySaveRequestInner] asset_property_save_request_inner: asset property pairs to update (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetPropertySaveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_asset_properties_with_http_info(
            workspace, teamspace, asset, asset_property_save_request_inner, **kwargs
        )  # noqa: E501

    def update_asset_properties_with_http_info(
        self, workspace, teamspace, asset, asset_property_save_request_inner, **kwargs
    ):  # noqa: E501
        """Update the given asset's property pair  # noqa: E501

        Update asset's properties  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_asset_properties_with_http_info(workspace, teamspace, asset, asset_property_save_request_inner, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str asset: The asset id or path for which to retrieve assets (required)
        :param list[AssetPropertySaveRequestInner] asset_property_save_request_inner: asset property pairs to update (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetPropertySaveResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "asset",
            "asset_property_save_request_inner",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_properties" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `update_asset_properties`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `update_asset_properties`"
            )  # noqa: E501
        # verify the required parameter 'asset' is set
        if self.api_client.client_side_validation and (
            "asset" not in local_var_params  # noqa: E501
            or local_var_params["asset"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset` when calling `update_asset_properties`"
            )  # noqa: E501
        # verify the required parameter 'asset_property_save_request_inner' is set
        if self.api_client.client_side_validation and (
            "asset_property_save_request_inner" not in local_var_params  # noqa: E501
            or local_var_params["asset_property_save_request_inner"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `asset_property_save_request_inner` when calling `update_asset_properties`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "asset" in local_var_params:
            path_params["asset"] = local_var_params["asset"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "asset_property_save_request_inner" in local_var_params:
            body_params = local_var_params["asset_property_save_request_inner"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/assets/item/{workspace}/{teamspace}/{asset}/properties",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetPropertySaveResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
