# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v4.api_client import ApiClient
from tiledb.client._common.api_v4.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v4.exceptions import ApiValueError  # noqa: F401


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def file_get(self, workspace, teamspace, path, **kwargs):  # noqa: E501
        """Download the file at the given path  # noqa: E501

        End point to download the file at the given path   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_get(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param str range: The range of bytes to fetch. Supports only single ranges.
        :param bool presigned: If true, returns a presigned S3 URL instead of the file contents
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FilePresignedURLResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.file_get_with_http_info(
            workspace, teamspace, path, **kwargs
        )  # noqa: E501

    def file_get_with_http_info(
        self, workspace, teamspace, path, **kwargs
    ):  # noqa: E501
        """Download the file at the given path  # noqa: E501

        End point to download the file at the given path   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_get_with_http_info(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param str range: The range of bytes to fetch. Supports only single ranges.
        :param bool presigned: If true, returns a presigned S3 URL instead of the file contents
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FilePresignedURLResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "path", "range", "presigned"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_get" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `file_get`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `file_get`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `file_get`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []
        if (
            "presigned" in local_var_params
            and local_var_params["presigned"] is not None
        ):  # noqa: E501
            query_params.append(
                ("presigned", local_var_params["presigned"])
            )  # noqa: E501

        header_params = {}
        if "range" in local_var_params:
            header_params["Range"] = local_var_params["range"]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/xml", "application/octet-stream"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/files/{workspace}/{teamspace}/{path}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FilePresignedURLResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def file_head(self, workspace, teamspace, path, **kwargs):  # noqa: E501
        """Get information about the file at the given path  # noqa: E501

        End point to get information about the file at the given path   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_head(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.file_head_with_http_info(
            workspace, teamspace, path, **kwargs
        )  # noqa: E501

    def file_head_with_http_info(
        self, workspace, teamspace, path, **kwargs
    ):  # noqa: E501
        """Get information about the file at the given path  # noqa: E501

        End point to get information about the file at the given path   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_head_with_http_info(workspace, teamspace, path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "path"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_head" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `file_head`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `file_head`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `file_head`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/files/{workspace}/{teamspace}/{path}",
            "HEAD",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def file_move(
        self, workspace, teamspace, path, x_tile_db_rename_to, **kwargs
    ):  # noqa: E501
        """Move the given path to the destination  # noqa: E501

        Move a file or directory to the given destination   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_move(workspace, teamspace, path, x_tile_db_rename_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param str x_tile_db_rename_to: The destination folder to move this file or directory (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.file_move_with_http_info(
            workspace, teamspace, path, x_tile_db_rename_to, **kwargs
        )  # noqa: E501

    def file_move_with_http_info(
        self, workspace, teamspace, path, x_tile_db_rename_to, **kwargs
    ):  # noqa: E501
        """Move the given path to the destination  # noqa: E501

        Move a file or directory to the given destination   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.file_move_with_http_info(workspace, teamspace, path, x_tile_db_rename_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param str x_tile_db_rename_to: The destination folder to move this file or directory (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "path", "x_tile_db_rename_to"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method file_move" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `file_move`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `file_move`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `file_move`"
            )  # noqa: E501
        # verify the required parameter 'x_tile_db_rename_to' is set
        if self.api_client.client_side_validation and (
            "x_tile_db_rename_to" not in local_var_params  # noqa: E501
            or local_var_params["x_tile_db_rename_to"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `x_tile_db_rename_to` when calling `file_move`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []

        header_params = {}
        if "x_tile_db_rename_to" in local_var_params:
            header_params["X-TileDB-Rename-To"] = local_var_params[
                "x_tile_db_rename_to"
            ]  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/files/{workspace}/{teamspace}/{path}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def folder_list(
        self, workspace, teamspace, list_type, delimiter, **kwargs
    ):  # noqa: E501
        """List folders and files contained in a folder  # noqa: E501

        End point to list files and folders for the passed teamspace   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.folder_list(workspace, teamspace, list_type, delimiter, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param int list_type: Required for S3 API compatibility, must be set to 2. (required)
        :param str delimiter: The string that delimits the path segments. Only forward slash is supported (required)
        :param str prefix: The directory of files to list.
        :param int max_keys: The maximum number of items to return.
        :param str continuation_token: Used to resume an incomplete list operation
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.folder_list_with_http_info(
            workspace, teamspace, list_type, delimiter, **kwargs
        )  # noqa: E501

    def folder_list_with_http_info(
        self, workspace, teamspace, list_type, delimiter, **kwargs
    ):  # noqa: E501
        """List folders and files contained in a folder  # noqa: E501

        End point to list files and folders for the passed teamspace   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.folder_list_with_http_info(workspace, teamspace, list_type, delimiter, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param int list_type: Required for S3 API compatibility, must be set to 2. (required)
        :param str delimiter: The string that delimits the path segments. Only forward slash is supported (required)
        :param str prefix: The directory of files to list.
        :param int max_keys: The maximum number of items to return.
        :param str continuation_token: Used to resume an incomplete list operation
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "list_type",
            "delimiter",
            "prefix",
            "max_keys",
            "continuation_token",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method folder_list" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `folder_list`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `folder_list`"
            )  # noqa: E501
        # verify the required parameter 'list_type' is set
        if self.api_client.client_side_validation and (
            "list_type" not in local_var_params  # noqa: E501
            or local_var_params["list_type"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `list_type` when calling `folder_list`"
            )  # noqa: E501
        # verify the required parameter 'delimiter' is set
        if self.api_client.client_side_validation and (
            "delimiter" not in local_var_params  # noqa: E501
            or local_var_params["delimiter"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `delimiter` when calling `folder_list`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501

        query_params = []
        if (
            "prefix" in local_var_params and local_var_params["prefix"] is not None
        ):  # noqa: E501
            query_params.append(("prefix", local_var_params["prefix"]))  # noqa: E501
        if (
            "list_type" in local_var_params
            and local_var_params["list_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("list-type", local_var_params["list_type"])
            )  # noqa: E501
        if (
            "delimiter" in local_var_params
            and local_var_params["delimiter"] is not None
        ):  # noqa: E501
            query_params.append(
                ("delimiter", local_var_params["delimiter"])
            )  # noqa: E501
        if (
            "max_keys" in local_var_params and local_var_params["max_keys"] is not None
        ):  # noqa: E501
            query_params.append(
                ("max-keys", local_var_params["max_keys"])
            )  # noqa: E501
        if (
            "continuation_token" in local_var_params
            and local_var_params["continuation_token"] is not None
        ):  # noqa: E501
            query_params.append(
                ("continuation-token", local_var_params["continuation_token"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/files/{workspace}/{teamspace}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FileListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def upload_part(self, workspace, teamspace, path, body, **kwargs):  # noqa: E501
        """Upload Part  # noqa: E501

        Uploads a part in a multipart upload session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_part(workspace, teamspace, path, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param file body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.upload_part_with_http_info(
            workspace, teamspace, path, body, **kwargs
        )  # noqa: E501

    def upload_part_with_http_info(
        self, workspace, teamspace, path, body, **kwargs
    ):  # noqa: E501
        """Upload Part  # noqa: E501

        Uploads a part in a multipart upload session.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_part_with_http_info(workspace, teamspace, path, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str path: The path to the file (required)
        :param file body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "path", "body"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_part" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `upload_part`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `upload_part`"
            )  # noqa: E501
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and (
            "path" not in local_var_params  # noqa: E501
            or local_var_params["path"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `path` when calling `upload_part`"
            )  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and (
            "body" not in local_var_params  # noqa: E501
            or local_var_params["body"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `body` when calling `upload_part`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "path" in local_var_params:
            path_params["path"] = local_var_params["path"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in local_var_params:
            body_params = local_var_params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/xml"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/files/{workspace}/{teamspace}/{path}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
