# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v4.api_client import ApiClient
from tiledb.client._common.api_v4.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v4.exceptions import ApiValueError  # noqa: F401


class FoldersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_folder(
        self, workspace, teamspace, folder, folder_create_request_inner, **kwargs
    ):  # noqa: E501
        """Create a folder in the given teamspace  # noqa: E501

        Create a new folder in the given teamspace   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_folder(workspace, teamspace, folder, folder_create_request_inner, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str folder: The path to the folder or the folder's assetID (required)
        :param FolderCreateRequestInner folder_create_request_inner: folder to create (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FolderCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_folder_with_http_info(
            workspace, teamspace, folder, folder_create_request_inner, **kwargs
        )  # noqa: E501

    def create_folder_with_http_info(
        self, workspace, teamspace, folder, folder_create_request_inner, **kwargs
    ):  # noqa: E501
        """Create a folder in the given teamspace  # noqa: E501

        Create a new folder in the given teamspace   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_folder_with_http_info(workspace, teamspace, folder, folder_create_request_inner, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str folder: The path to the folder or the folder's assetID (required)
        :param FolderCreateRequestInner folder_create_request_inner: folder to create (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FolderCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "folder", "folder_create_request_inner"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_folder" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `create_folder`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `create_folder`"
            )  # noqa: E501
        # verify the required parameter 'folder' is set
        if self.api_client.client_side_validation and (
            "folder" not in local_var_params  # noqa: E501
            or local_var_params["folder"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder` when calling `create_folder`"
            )  # noqa: E501
        # verify the required parameter 'folder_create_request_inner' is set
        if self.api_client.client_side_validation and (
            "folder_create_request_inner" not in local_var_params  # noqa: E501
            or local_var_params["folder_create_request_inner"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_create_request_inner` when calling `create_folder`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "folder" in local_var_params:
            path_params["folder"] = local_var_params["folder"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "folder_create_request_inner" in local_var_params:
            body_params = local_var_params["folder_create_request_inner"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/folders/{workspace}/{teamspace}/{folder}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FolderCreateResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_folder(self, workspace, teamspace, folder, **kwargs):  # noqa: E501
        """Retrieve a folder's content  # noqa: E501

        Retrieve the given folder's content  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder(workspace, teamspace, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str folder: The path to the folder or the folder's assetID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FolderGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_folder_with_http_info(
            workspace, teamspace, folder, **kwargs
        )  # noqa: E501

    def get_folder_with_http_info(
        self, workspace, teamspace, folder, **kwargs
    ):  # noqa: E501
        """Retrieve a folder's content  # noqa: E501

        Retrieve the given folder's content  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder_with_http_info(workspace, teamspace, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str folder: The path to the folder or the folder's assetID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FolderGetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "folder"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folder" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_folder`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `get_folder`"
            )  # noqa: E501
        # verify the required parameter 'folder' is set
        if self.api_client.client_side_validation and (
            "folder" not in local_var_params  # noqa: E501
            or local_var_params["folder"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder` when calling `get_folder`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "folder" in local_var_params:
            path_params["folder"] = local_var_params["folder"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/folders/{workspace}/{teamspace}/{folder}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FolderGetResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_folder_contents(self, workspace, teamspace, folder, **kwargs):  # noqa: E501
        """Retrieve a folder  # noqa: E501

        Retrieve the given folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder_contents(workspace, teamspace, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str folder: The path to the folder or the folder's assetID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FolderContentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_folder_contents_with_http_info(
            workspace, teamspace, folder, **kwargs
        )  # noqa: E501

    def get_folder_contents_with_http_info(
        self, workspace, teamspace, folder, **kwargs
    ):  # noqa: E501
        """Retrieve a folder  # noqa: E501

        Retrieve the given folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_folder_contents_with_http_info(workspace, teamspace, folder, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace: The teamspace name or id (required)
        :param str folder: The path to the folder or the folder's assetID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FolderContentsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "folder"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folder_contents" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_folder_contents`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `get_folder_contents`"
            )  # noqa: E501
        # verify the required parameter 'folder' is set
        if self.api_client.client_side_validation and (
            "folder" not in local_var_params  # noqa: E501
            or local_var_params["folder"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder` when calling `get_folder_contents`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501
        if "folder" in local_var_params:
            path_params["folder"] = local_var_params["folder"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/folders/{workspace}/{teamspace}/{folder}/contents",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FolderContentsResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
