# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client._common.api_v4.api_client import ApiClient
from tiledb.client._common.api_v4.exceptions import ApiTypeError  # noqa: F401
from tiledb.client._common.api_v4.exceptions import ApiValueError  # noqa: F401


class StoragesettingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_storage_setting(
        self, workspace, storage_settings_create_request, **kwargs
    ):  # noqa: E501
        """Create a new storage setting  # noqa: E501

        create a storage setting  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_storage_setting(workspace, storage_settings_create_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param StorageSettingsCreateRequest storage_settings_create_request: The request body containing the storage setting to create (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageSettingsCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_storage_setting_with_http_info(
            workspace, storage_settings_create_request, **kwargs
        )  # noqa: E501

    def create_storage_setting_with_http_info(
        self, workspace, storage_settings_create_request, **kwargs
    ):  # noqa: E501
        """Create a new storage setting  # noqa: E501

        create a storage setting  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_storage_setting_with_http_info(workspace, storage_settings_create_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param StorageSettingsCreateRequest storage_settings_create_request: The request body containing the storage setting to create (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageSettingsCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "storage_settings_create_request", "teamspace_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_storage_setting" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `create_storage_setting`"
            )  # noqa: E501
        # verify the required parameter 'storage_settings_create_request' is set
        if self.api_client.client_side_validation and (
            "storage_settings_create_request" not in local_var_params  # noqa: E501
            or local_var_params["storage_settings_create_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `storage_settings_create_request` when calling `create_storage_setting`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if (
            "teamspace_id" in local_var_params
            and local_var_params["teamspace_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace_id", local_var_params["teamspace_id"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "storage_settings_create_request" in local_var_params:
            body_params = local_var_params["storage_settings_create_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/storagesettings/{workspace}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="StorageSettingsCreateResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_storage_setting_by_id(self, stset_id, workspace, **kwargs):  # noqa: E501
        """Delete storage setting  # noqa: E501

        Delete the storage setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storage_setting_by_id(stset_id, workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stset_id: The storage setting id in the form stset_9m4e2mr0ui3e8a215n4g (required)
        :param str workspace: The workspace name or id (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.delete_storage_setting_by_id_with_http_info(
            stset_id, workspace, **kwargs
        )  # noqa: E501

    def delete_storage_setting_by_id_with_http_info(
        self, stset_id, workspace, **kwargs
    ):  # noqa: E501
        """Delete storage setting  # noqa: E501

        Delete the storage setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storage_setting_by_id_with_http_info(stset_id, workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stset_id: The storage setting id in the form stset_9m4e2mr0ui3e8a215n4g (required)
        :param str workspace: The workspace name or id (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["stset_id", "workspace", "teamspace_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storage_setting_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'stset_id' is set
        if self.api_client.client_side_validation and (
            "stset_id" not in local_var_params  # noqa: E501
            or local_var_params["stset_id"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `stset_id` when calling `delete_storage_setting_by_id`"
            )  # noqa: E501
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `delete_storage_setting_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "stset_id" in local_var_params:
            path_params["stset_id"] = local_var_params["stset_id"]  # noqa: E501
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if (
            "teamspace_id" in local_var_params
            and local_var_params["teamspace_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace_id", local_var_params["teamspace_id"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/storagesettings/{workspace}/{stset_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_storage_setting_by_id(self, stset_id, workspace, **kwargs):  # noqa: E501
        """Get storage setting  # noqa: E501

        get information about storage setting by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_setting_by_id(stset_id, workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stset_id: The storage setting id in the form stset_9m4e2mr0ui3e8a215n4g (required)
        :param str workspace: The workspace name or id (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageSettingGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_storage_setting_by_id_with_http_info(
            stset_id, workspace, **kwargs
        )  # noqa: E501

    def get_storage_setting_by_id_with_http_info(
        self, stset_id, workspace, **kwargs
    ):  # noqa: E501
        """Get storage setting  # noqa: E501

        get information about storage setting by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storage_setting_by_id_with_http_info(stset_id, workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stset_id: The storage setting id in the form stset_9m4e2mr0ui3e8a215n4g (required)
        :param str workspace: The workspace name or id (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageSettingGetResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["stset_id", "workspace", "teamspace_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storage_setting_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'stset_id' is set
        if self.api_client.client_side_validation and (
            "stset_id" not in local_var_params  # noqa: E501
            or local_var_params["stset_id"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `stset_id` when calling `get_storage_setting_by_id`"
            )  # noqa: E501
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `get_storage_setting_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "stset_id" in local_var_params:
            path_params["stset_id"] = local_var_params["stset_id"]  # noqa: E501
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if (
            "teamspace_id" in local_var_params
            and local_var_params["teamspace_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace_id", local_var_params["teamspace_id"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/storagesettings/{workspace}/{stset_id}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="StorageSettingGetResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_storage_settings(self, workspace, **kwargs):  # noqa: E501
        """Get storage settings  # noqa: E501

        list the storage settings available for the user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_storage_settings(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StorageSettingsListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_storage_settings_with_http_info(
            workspace, **kwargs
        )  # noqa: E501

    def list_storage_settings_with_http_info(self, workspace, **kwargs):  # noqa: E501
        """Get storage settings  # noqa: E501

        list the storage settings available for the user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_storage_settings_with_http_info(workspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: The workspace name or id (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StorageSettingsListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace_id", "page", "per_page"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_storage_settings" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `list_storage_settings`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if (
            "teamspace_id" in local_var_params
            and local_var_params["teamspace_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace_id", local_var_params["teamspace_id"])
            )  # noqa: E501
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/storagesettings/{workspace}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="StorageSettingsListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def patch_storage_setting_by_id(
        self, stset_id, workspace, storage_setting_update_request, **kwargs
    ):  # noqa: E501
        """Update storage setting  # noqa: E501

        update storage setting given by the user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_storage_setting_by_id(stset_id, workspace, storage_setting_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stset_id: The storage setting id in the form stset_9m4e2mr0ui3e8a215n4g (required)
        :param str workspace: The workspace name or id (required)
        :param StorageSettingUpdateRequest storage_setting_update_request: storage setting update details (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.patch_storage_setting_by_id_with_http_info(
            stset_id, workspace, storage_setting_update_request, **kwargs
        )  # noqa: E501

    def patch_storage_setting_by_id_with_http_info(
        self, stset_id, workspace, storage_setting_update_request, **kwargs
    ):  # noqa: E501
        """Update storage setting  # noqa: E501

        update storage setting given by the user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_storage_setting_by_id_with_http_info(stset_id, workspace, storage_setting_update_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str stset_id: The storage setting id in the form stset_9m4e2mr0ui3e8a215n4g (required)
        :param str workspace: The workspace name or id (required)
        :param StorageSettingUpdateRequest storage_setting_update_request: storage setting update details (required)
        :param str teamspace_id: Teamspace id should be empty, if the request is about an action on workspace level
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "stset_id",
            "workspace",
            "storage_setting_update_request",
            "teamspace_id",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_storage_setting_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'stset_id' is set
        if self.api_client.client_side_validation and (
            "stset_id" not in local_var_params  # noqa: E501
            or local_var_params["stset_id"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `stset_id` when calling `patch_storage_setting_by_id`"
            )  # noqa: E501
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `patch_storage_setting_by_id`"
            )  # noqa: E501
        # verify the required parameter 'storage_setting_update_request' is set
        if self.api_client.client_side_validation and (
            "storage_setting_update_request" not in local_var_params  # noqa: E501
            or local_var_params["storage_setting_update_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `storage_setting_update_request` when calling `patch_storage_setting_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "stset_id" in local_var_params:
            path_params["stset_id"] = local_var_params["stset_id"]  # noqa: E501
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501

        query_params = []
        if (
            "teamspace_id" in local_var_params
            and local_var_params["teamspace_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("teamspace_id", local_var_params["teamspace_id"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "storage_setting_update_request" in local_var_params:
            body_params = local_var_params["storage_setting_update_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth", "OAuth2"]  # noqa: E501

        return self.api_client.call_api(
            "/v4/storagesettings/{workspace}/{stset_id}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
