# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class Activity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "activity_id": "str",
        "api_version": "APIVersion",
        "subject": "OneOfUser",
        "action": "str",
        "object": "OneOfActivityAssetActivityToken",
        "array_task": "ActivityArrayTask",
        "extra_data": "OneOfExtraDataMembersExtraDataMetadataExtraDataAffectedExtraDataQueryStats",
        "workspace": "WorkspaceLight",
        "teamspace": "TeamspaceLight",
        "recorded_at": "datetime",
    }

    attribute_map = {
        "activity_id": "activity_id",
        "api_version": "api_version",
        "subject": "subject",
        "action": "action",
        "object": "object",
        "array_task": "array_task",
        "extra_data": "extra_data",
        "workspace": "workspace",
        "teamspace": "teamspace",
        "recorded_at": "recorded_at",
    }

    def __init__(
        self,
        activity_id=None,
        api_version=None,
        subject=None,
        action=None,
        object=None,
        array_task=None,
        extra_data=None,
        workspace=None,
        teamspace=None,
        recorded_at=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Activity - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._activity_id = None
        self._api_version = None
        self._subject = None
        self._action = None
        self._object = None
        self._array_task = None
        self._extra_data = None
        self._workspace = None
        self._teamspace = None
        self._recorded_at = None
        self.discriminator = None

        self.activity_id = activity_id
        self.api_version = api_version
        self.subject = subject
        self.action = action
        self.object = object
        if array_task is not None:
            self.array_task = array_task
        if extra_data is not None:
            self.extra_data = extra_data
        if workspace is not None:
            self.workspace = workspace
        if teamspace is not None:
            self.teamspace = teamspace
        self.recorded_at = recorded_at

    @property
    def activity_id(self):
        """Gets the activity_id of this Activity.  # noqa: E501

        The activity's ID  # noqa: E501

        :return: The activity_id of this Activity.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this Activity.

        The activity's ID  # noqa: E501

        :param activity_id: The activity_id of this Activity.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and activity_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `activity_id`, must not be `None`"
            )  # noqa: E501

        self._activity_id = activity_id

    @property
    def api_version(self):
        """Gets the api_version of this Activity.  # noqa: E501


        :return: The api_version of this Activity.  # noqa: E501
        :rtype: APIVersion
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """Sets the api_version of this Activity.


        :param api_version: The api_version of this Activity.  # noqa: E501
        :type: APIVersion
        """
        if (
            self.local_vars_configuration.client_side_validation and api_version is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `api_version`, must not be `None`"
            )  # noqa: E501

        self._api_version = api_version

    @property
    def subject(self):
        """Gets the subject of this Activity.  # noqa: E501


        :return: The subject of this Activity.  # noqa: E501
        :rtype: OneOfUser
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this Activity.


        :param subject: The subject of this Activity.  # noqa: E501
        :type: OneOfUser
        """
        if (
            self.local_vars_configuration.client_side_validation and subject is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `subject`, must not be `None`"
            )  # noqa: E501

        self._subject = subject

    @property
    def action(self):
        """Gets the action of this Activity.  # noqa: E501

        The action that was performed on the object  # noqa: E501

        :return: The action of this Activity.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this Activity.

        The action that was performed on the object  # noqa: E501

        :param action: The action of this Activity.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and action is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `action`, must not be `None`"
            )  # noqa: E501
        allowed_values = [
            "create",
            "read",
            "update",
            "delete",
            "start-notebook",
            "stop-notebook",
            "read-metadata",
            "add-metadata",
            "update-metadata",
            "remove-metadata",
            "add-content",
            "add-content-via-move",
            "remove-content",
            "read-content",
            "query-read",
            "query-write",
            "query-delete",
            "delete-fragments",
            "delete-fragments-list",
            "register",
        ]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and action not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}".format(  # noqa: E501
                    action, allowed_values
                )
            )

        self._action = action

    @property
    def object(self):
        """Gets the object of this Activity.  # noqa: E501


        :return: The object of this Activity.  # noqa: E501
        :rtype: OneOfActivityAssetActivityToken
        """
        return self._object

    @object.setter
    def object(self, object):
        """Sets the object of this Activity.


        :param object: The object of this Activity.  # noqa: E501
        :type: OneOfActivityAssetActivityToken
        """
        if (
            self.local_vars_configuration.client_side_validation and object is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `object`, must not be `None`"
            )  # noqa: E501

        self._object = object

    @property
    def array_task(self):
        """Gets the array_task of this Activity.  # noqa: E501


        :return: The array_task of this Activity.  # noqa: E501
        :rtype: ActivityArrayTask
        """
        return self._array_task

    @array_task.setter
    def array_task(self, array_task):
        """Sets the array_task of this Activity.


        :param array_task: The array_task of this Activity.  # noqa: E501
        :type: ActivityArrayTask
        """

        self._array_task = array_task

    @property
    def extra_data(self):
        """Gets the extra_data of this Activity.  # noqa: E501


        :return: The extra_data of this Activity.  # noqa: E501
        :rtype: OneOfExtraDataMembersExtraDataMetadataExtraDataAffectedExtraDataQueryStats
        """
        return self._extra_data

    @extra_data.setter
    def extra_data(self, extra_data):
        """Sets the extra_data of this Activity.


        :param extra_data: The extra_data of this Activity.  # noqa: E501
        :type: OneOfExtraDataMembersExtraDataMetadataExtraDataAffectedExtraDataQueryStats
        """

        self._extra_data = extra_data

    @property
    def workspace(self):
        """Gets the workspace of this Activity.  # noqa: E501


        :return: The workspace of this Activity.  # noqa: E501
        :rtype: WorkspaceLight
        """
        return self._workspace

    @workspace.setter
    def workspace(self, workspace):
        """Sets the workspace of this Activity.


        :param workspace: The workspace of this Activity.  # noqa: E501
        :type: WorkspaceLight
        """

        self._workspace = workspace

    @property
    def teamspace(self):
        """Gets the teamspace of this Activity.  # noqa: E501


        :return: The teamspace of this Activity.  # noqa: E501
        :rtype: TeamspaceLight
        """
        return self._teamspace

    @teamspace.setter
    def teamspace(self, teamspace):
        """Sets the teamspace of this Activity.


        :param teamspace: The teamspace of this Activity.  # noqa: E501
        :type: TeamspaceLight
        """

        self._teamspace = teamspace

    @property
    def recorded_at(self):
        """Gets the recorded_at of this Activity.  # noqa: E501

        The time the activity was recorded  # noqa: E501

        :return: The recorded_at of this Activity.  # noqa: E501
        :rtype: datetime
        """
        return self._recorded_at

    @recorded_at.setter
    def recorded_at(self, recorded_at):
        """Sets the recorded_at of this Activity.

        The time the activity was recorded  # noqa: E501

        :param recorded_at: The recorded_at of this Activity.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and recorded_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `recorded_at`, must not be `None`"
            )  # noqa: E501

        self._recorded_at = recorded_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Activity):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Activity):
            return True

        return self.to_dict() != other.to_dict()
