# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class APIToken(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "token_id": "str",
        "name": "str",
        "created_at": "datetime",
        "expires_at": "datetime",
        "api_key": "str",
        "workspace_id": "str",
        "scope": "TokenScope",
    }

    attribute_map = {
        "token_id": "token_id",
        "name": "name",
        "created_at": "created_at",
        "expires_at": "expires_at",
        "api_key": "api_key",
        "workspace_id": "workspace_id",
        "scope": "scope",
    }

    def __init__(
        self,
        token_id=None,
        name=None,
        created_at=None,
        expires_at=None,
        api_key=None,
        workspace_id=None,
        scope=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """APIToken - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._token_id = None
        self._name = None
        self._created_at = None
        self._expires_at = None
        self._api_key = None
        self._workspace_id = None
        self._scope = None
        self.discriminator = None

        self.token_id = token_id
        self.name = name
        self.created_at = created_at
        self.expires_at = expires_at
        self.api_key = api_key
        if workspace_id is not None:
            self.workspace_id = workspace_id
        self.scope = scope

    @property
    def token_id(self):
        """Gets the token_id of this APIToken.  # noqa: E501

        The token's ID  # noqa: E501

        :return: The token_id of this APIToken.  # noqa: E501
        :rtype: str
        """
        return self._token_id

    @token_id.setter
    def token_id(self, token_id):
        """Sets the token_id of this APIToken.

        The token's ID  # noqa: E501

        :param token_id: The token_id of this APIToken.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and token_id is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `token_id`, must not be `None`"
            )  # noqa: E501

        self._token_id = token_id

    @property
    def name(self):
        """Gets the name of this APIToken.  # noqa: E501

        The name of the token  # noqa: E501

        :return: The name of this APIToken.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this APIToken.

        The name of the token  # noqa: E501

        :param name: The name of this APIToken.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501

        self._name = name

    @property
    def created_at(self):
        """Gets the created_at of this APIToken.  # noqa: E501

        The creation date and time of the token  # noqa: E501

        :return: The created_at of this APIToken.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this APIToken.

        The creation date and time of the token  # noqa: E501

        :param created_at: The created_at of this APIToken.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def expires_at(self):
        """Gets the expires_at of this APIToken.  # noqa: E501

        The expiration date and time of the token  # noqa: E501

        :return: The expires_at of this APIToken.  # noqa: E501
        :rtype: datetime
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this APIToken.

        The expiration date and time of the token  # noqa: E501

        :param expires_at: The expires_at of this APIToken.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and expires_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `expires_at`, must not be `None`"
            )  # noqa: E501

        self._expires_at = expires_at

    @property
    def api_key(self):
        """Gets the api_key of this APIToken.  # noqa: E501

        The secret API key that's used for authentication. If workspace_id is set, the format of the key is \"tiledb-<workspace ID>-<random bytes>\". Otherwise, the format is a JWT.   # noqa: E501

        :return: The api_key of this APIToken.  # noqa: E501
        :rtype: str
        """
        return self._api_key

    @api_key.setter
    def api_key(self, api_key):
        """Sets the api_key of this APIToken.

        The secret API key that's used for authentication. If workspace_id is set, the format of the key is \"tiledb-<workspace ID>-<random bytes>\". Otherwise, the format is a JWT.   # noqa: E501

        :param api_key: The api_key of this APIToken.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and api_key is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `api_key`, must not be `None`"
            )  # noqa: E501

        self._api_key = api_key

    @property
    def workspace_id(self):
        """Gets the workspace_id of this APIToken.  # noqa: E501

        The workspace ID of the token (if API token)  # noqa: E501

        :return: The workspace_id of this APIToken.  # noqa: E501
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """Sets the workspace_id of this APIToken.

        The workspace ID of the token (if API token)  # noqa: E501

        :param workspace_id: The workspace_id of this APIToken.  # noqa: E501
        :type: str
        """

        self._workspace_id = workspace_id

    @property
    def scope(self):
        """Gets the scope of this APIToken.  # noqa: E501


        :return: The scope of this APIToken.  # noqa: E501
        :rtype: TokenScope
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this APIToken.


        :param scope: The scope of this APIToken.  # noqa: E501
        :type: TokenScope
        """
        if (
            self.local_vars_configuration.client_side_validation and scope is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `scope`, must not be `None`"
            )  # noqa: E501

        self._scope = scope

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, APIToken):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, APIToken):
            return True

        return self.to_dict() != other.to_dict()
