# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class File(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "url": "str",
        "id": "str",
        "partition_values": "dict(str, object)",
        "size": "int",
        "timestamp": "int",
        "version": "int",
        "stats": "str",
        "expiration_timestamp": "int",
    }

    attribute_map = {
        "url": "url",
        "id": "id",
        "partition_values": "partitionValues",
        "size": "size",
        "timestamp": "timestamp",
        "version": "version",
        "stats": "stats",
        "expiration_timestamp": "expirationTimestamp",
    }

    def __init__(
        self,
        url=None,
        id=None,
        partition_values=None,
        size=None,
        timestamp=None,
        version=None,
        stats=None,
        expiration_timestamp=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """File - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._url = None
        self._id = None
        self._partition_values = None
        self._size = None
        self._timestamp = None
        self._version = None
        self._stats = None
        self._expiration_timestamp = None
        self.discriminator = None

        self.url = url
        self.id = id
        self.partition_values = partition_values
        self.size = size
        if timestamp is not None:
            self.timestamp = timestamp
        if version is not None:
            self.version = version
        if stats is not None:
            self.stats = stats
        if expiration_timestamp is not None:
            self.expiration_timestamp = expiration_timestamp

    @property
    def url(self):
        """Gets the url of this File.  # noqa: E501

        An https url that a client can use to read the file directly. The same file in different responses may have different urls.  # noqa: E501

        :return: The url of this File.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this File.

        An https url that a client can use to read the file directly. The same file in different responses may have different urls.  # noqa: E501

        :param url: The url of this File.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and url is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `url`, must not be `None`"
            )  # noqa: E501

        self._url = url

    @property
    def id(self):
        """Gets the id of this File.  # noqa: E501

        A unique string for the file in a table. The same file is guaranteed to have the same id across multiple requests. A client may cache the file content and use this id as a key to decide whether to use the cached file content.  # noqa: E501

        :return: The id of this File.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this File.

        A unique string for the file in a table. The same file is guaranteed to have the same id across multiple requests. A client may cache the file content and use this id as a key to decide whether to use the cached file content.  # noqa: E501

        :param id: The id of this File.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def partition_values(self):
        """Gets the partition_values of this File.  # noqa: E501

        A map from partition column to value for this file. See Partition Value Serialization for how to parse the partition values. When the table doesn't have partition columns, this will be an empty map.  # noqa: E501

        :return: The partition_values of this File.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._partition_values

    @partition_values.setter
    def partition_values(self, partition_values):
        """Sets the partition_values of this File.

        A map from partition column to value for this file. See Partition Value Serialization for how to parse the partition values. When the table doesn't have partition columns, this will be an empty map.  # noqa: E501

        :param partition_values: The partition_values of this File.  # noqa: E501
        :type: dict(str, object)
        """
        if (
            self.local_vars_configuration.client_side_validation
            and partition_values is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `partition_values`, must not be `None`"
            )  # noqa: E501

        self._partition_values = partition_values

    @property
    def size(self):
        """Gets the size of this File.  # noqa: E501

        The size of this file in bytes.  # noqa: E501

        :return: The size of this File.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this File.

        The size of this file in bytes.  # noqa: E501

        :param size: The size of this File.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation and size is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `size`, must not be `None`"
            )  # noqa: E501

        self._size = size

    @property
    def timestamp(self):
        """Gets the timestamp of this File.  # noqa: E501

        The timestamp of the file in milliseconds from epoch.  # noqa: E501

        :return: The timestamp of this File.  # noqa: E501
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this File.

        The timestamp of the file in milliseconds from epoch.  # noqa: E501

        :param timestamp: The timestamp of this File.  # noqa: E501
        :type: int
        """

        self._timestamp = timestamp

    @property
    def version(self):
        """Gets the version of this File.  # noqa: E501

        The table version of this file.  # noqa: E501

        :return: The version of this File.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this File.

        The table version of this file.  # noqa: E501

        :param version: The version of this File.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def stats(self):
        """Gets the stats of this File.  # noqa: E501

        Contains statistics (e.g., count, min/max values for columns) about the data in this file. This field may be missing. A file may or may not have stats. This is a serialized JSON string which can be deserialized to a Statistics Struct. A client can decide whether to use stats or drop it.  # noqa: E501

        :return: The stats of this File.  # noqa: E501
        :rtype: str
        """
        return self._stats

    @stats.setter
    def stats(self, stats):
        """Sets the stats of this File.

        Contains statistics (e.g., count, min/max values for columns) about the data in this file. This field may be missing. A file may or may not have stats. This is a serialized JSON string which can be deserialized to a Statistics Struct. A client can decide whether to use stats or drop it.  # noqa: E501

        :param stats: The stats of this File.  # noqa: E501
        :type: str
        """

        self._stats = stats

    @property
    def expiration_timestamp(self):
        """Gets the expiration_timestamp of this File.  # noqa: E501

        The unix timestamp corresponding to the expiration of the url, in milliseconds, returned when the server supports the feature.  # noqa: E501

        :return: The expiration_timestamp of this File.  # noqa: E501
        :rtype: int
        """
        return self._expiration_timestamp

    @expiration_timestamp.setter
    def expiration_timestamp(self, expiration_timestamp):
        """Sets the expiration_timestamp of this File.

        The unix timestamp corresponding to the expiration of the url, in milliseconds, returned when the server supports the feature.  # noqa: E501

        :param expiration_timestamp: The expiration_timestamp of this File.  # noqa: E501
        :type: int
        """

        self._expiration_timestamp = expiration_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, File):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, File):
            return True

        return self.to_dict() != other.to_dict()
