# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class QueryTableRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "predicate_hints": "str",
        "json_predicate_hints": "str",
        "limit_hint": "str",
        "version": "int",
        "timestamp": "str",
        "starting_version": "int",
        "ending_version": "int",
    }

    attribute_map = {
        "predicate_hints": "predicateHints",
        "json_predicate_hints": "jsonPredicateHints",
        "limit_hint": "limitHint",
        "version": "version",
        "timestamp": "timestamp",
        "starting_version": "startingVersion",
        "ending_version": "endingVersion",
    }

    def __init__(
        self,
        predicate_hints=None,
        json_predicate_hints=None,
        limit_hint=None,
        version=None,
        timestamp=None,
        starting_version=None,
        ending_version=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """QueryTableRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._predicate_hints = None
        self._json_predicate_hints = None
        self._limit_hint = None
        self._version = None
        self._timestamp = None
        self._starting_version = None
        self._ending_version = None
        self.discriminator = None

        if predicate_hints is not None:
            self.predicate_hints = predicate_hints
        if json_predicate_hints is not None:
            self.json_predicate_hints = json_predicate_hints
        if limit_hint is not None:
            self.limit_hint = limit_hint
        if version is not None:
            self.version = version
        if timestamp is not None:
            self.timestamp = timestamp
        if starting_version is not None:
            self.starting_version = starting_version
        if ending_version is not None:
            self.ending_version = ending_version

    @property
    def predicate_hints(self):
        """Gets the predicate_hints of this QueryTableRequest.  # noqa: E501

        a list of SQL boolean expressions using a restricted subset of SQL, in a JSON array. When it's present, the server will use the provided predicates as a hint to apply the SQL predicates on the returned files.   Filtering files based on the SQL predicates is BEST EFFORT. The server may return files that don't satisfy the predicates.   If the server fails to parse one of the SQL predicates, or fails to evaluate it, the server may skip it.   Predicate expressions are conjunctive (AND-ed together). When it's absent, the server will return all of files in the table. This will be deprecated once all the client and server implementation move to using jsonPredicateHints below.   # noqa: E501

        :return: The predicate_hints of this QueryTableRequest.  # noqa: E501
        :rtype: str
        """
        return self._predicate_hints

    @predicate_hints.setter
    def predicate_hints(self, predicate_hints):
        """Sets the predicate_hints of this QueryTableRequest.

        a list of SQL boolean expressions using a restricted subset of SQL, in a JSON array. When it's present, the server will use the provided predicates as a hint to apply the SQL predicates on the returned files.   Filtering files based on the SQL predicates is BEST EFFORT. The server may return files that don't satisfy the predicates.   If the server fails to parse one of the SQL predicates, or fails to evaluate it, the server may skip it.   Predicate expressions are conjunctive (AND-ed together). When it's absent, the server will return all of files in the table. This will be deprecated once all the client and server implementation move to using jsonPredicateHints below.   # noqa: E501

        :param predicate_hints: The predicate_hints of this QueryTableRequest.  # noqa: E501
        :type: str
        """

        self._predicate_hints = predicate_hints

    @property
    def json_predicate_hints(self):
        """Gets the json_predicate_hints of this QueryTableRequest.  # noqa: E501

        query predicates on partition columns specified using a structured JSON format. When it's present, the server will try to use the predicates to filter table's files, which could boost query performance.   As with predicateHints, this filtering is BEST EFFORT. The server may return files that don't satisfy the predicates.   If the server encounters any errors during predicate processing (for example, invalid syntax or non existing columns), it will skip filtering and return all the files. When it's absent, the server will return all the files in the table.   # noqa: E501

        :return: The json_predicate_hints of this QueryTableRequest.  # noqa: E501
        :rtype: str
        """
        return self._json_predicate_hints

    @json_predicate_hints.setter
    def json_predicate_hints(self, json_predicate_hints):
        """Sets the json_predicate_hints of this QueryTableRequest.

        query predicates on partition columns specified using a structured JSON format. When it's present, the server will try to use the predicates to filter table's files, which could boost query performance.   As with predicateHints, this filtering is BEST EFFORT. The server may return files that don't satisfy the predicates.   If the server encounters any errors during predicate processing (for example, invalid syntax or non existing columns), it will skip filtering and return all the files. When it's absent, the server will return all the files in the table.   # noqa: E501

        :param json_predicate_hints: The json_predicate_hints of this QueryTableRequest.  # noqa: E501
        :type: str
        """

        self._json_predicate_hints = json_predicate_hints

    @property
    def limit_hint(self):
        """Gets the limit_hint of this QueryTableRequest.  # noqa: E501

        an optional limit number. It's a hint from the client to tell the server how many rows in the table the client plans to read. The server can use this hint to return only some files by using the file stats. For example, when running SELECT * FROM table LIMIT 1000, the client can set limitHint to 1000.  # noqa: E501

        :return: The limit_hint of this QueryTableRequest.  # noqa: E501
        :rtype: str
        """
        return self._limit_hint

    @limit_hint.setter
    def limit_hint(self, limit_hint):
        """Sets the limit_hint of this QueryTableRequest.

        an optional limit number. It's a hint from the client to tell the server how many rows in the table the client plans to read. The server can use this hint to return only some files by using the file stats. For example, when running SELECT * FROM table LIMIT 1000, the client can set limitHint to 1000.  # noqa: E501

        :param limit_hint: The limit_hint of this QueryTableRequest.  # noqa: E501
        :type: str
        """

        self._limit_hint = limit_hint

    @property
    def version(self):
        """Gets the version of this QueryTableRequest.  # noqa: E501

        an optional version number. If set, will return files as of the specified version of the table. This is only supported on tables with history sharing enabled.  # noqa: E501

        :return: The version of this QueryTableRequest.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this QueryTableRequest.

        an optional version number. If set, will return files as of the specified version of the table. This is only supported on tables with history sharing enabled.  # noqa: E501

        :param version: The version of this QueryTableRequest.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def timestamp(self):
        """Gets the timestamp of this QueryTableRequest.  # noqa: E501

        an optional timestamp string in the Timestamp Format,. If set, will return files as of the table version corresponding to the specified timestamp. This is only supported on tables with history sharing enabled.  # noqa: E501

        :return: The timestamp of this QueryTableRequest.  # noqa: E501
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this QueryTableRequest.

        an optional timestamp string in the Timestamp Format,. If set, will return files as of the table version corresponding to the specified timestamp. This is only supported on tables with history sharing enabled.  # noqa: E501

        :param timestamp: The timestamp of this QueryTableRequest.  # noqa: E501
        :type: str
        """

        self._timestamp = timestamp

    @property
    def starting_version(self):
        """Gets the starting_version of this QueryTableRequest.  # noqa: E501

        an optional version number. If set, will return all data change files since startingVersion, inclusive, including historical metadata if seen in the delta log.  # noqa: E501

        :return: The starting_version of this QueryTableRequest.  # noqa: E501
        :rtype: int
        """
        return self._starting_version

    @starting_version.setter
    def starting_version(self, starting_version):
        """Sets the starting_version of this QueryTableRequest.

        an optional version number. If set, will return all data change files since startingVersion, inclusive, including historical metadata if seen in the delta log.  # noqa: E501

        :param starting_version: The starting_version of this QueryTableRequest.  # noqa: E501
        :type: int
        """

        self._starting_version = starting_version

    @property
    def ending_version(self):
        """Gets the ending_version of this QueryTableRequest.  # noqa: E501

        an optional version number, only used if startingVersion is set. If set, the server can use it as a hint to avoid returning data change files after endingVersion. This is not enforcement. Hence, when sending the endingVersion parameter, the client should still handle the case that it may receive files after endingVersion.  # noqa: E501

        :return: The ending_version of this QueryTableRequest.  # noqa: E501
        :rtype: int
        """
        return self._ending_version

    @ending_version.setter
    def ending_version(self, ending_version):
        """Sets the ending_version of this QueryTableRequest.

        an optional version number, only used if startingVersion is set. If set, the server can use it as a hint to avoid returning data change files after endingVersion. This is not enforcement. Hence, when sending the endingVersion parameter, the client should still handle the case that it may receive files after endingVersion.  # noqa: E501

        :param ending_version: The ending_version of this QueryTableRequest.  # noqa: E501
        :type: int
        """

        self._ending_version = ending_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryTableRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QueryTableRequest):
            return True

        return self.to_dict() != other.to_dict()
