# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class TableMetadataResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "min_reader_version": "int",
        "id": "str",
        "name": "str",
        "description": "str",
        "format": "Format",
        "schema": "Schema",
        "schema_string": "str",
        "partition_columns": "list[str]",
        "configuration": "dict(str, object)",
        "version": "int",
        "size": "int",
        "num_files": "int",
    }

    attribute_map = {
        "min_reader_version": "minReaderVersion",
        "id": "id",
        "name": "name",
        "description": "description",
        "format": "format",
        "schema": "schema",
        "schema_string": "schemaString",
        "partition_columns": "partitionColumns",
        "configuration": "configuration",
        "version": "version",
        "size": "size",
        "num_files": "numFiles",
    }

    def __init__(
        self,
        min_reader_version=None,
        id=None,
        name=None,
        description=None,
        format=None,
        schema=None,
        schema_string=None,
        partition_columns=None,
        configuration=None,
        version=None,
        size=None,
        num_files=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TableMetadataResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._min_reader_version = None
        self._id = None
        self._name = None
        self._description = None
        self._format = None
        self._schema = None
        self._schema_string = None
        self._partition_columns = None
        self._configuration = None
        self._version = None
        self._size = None
        self._num_files = None
        self.discriminator = None

        self.min_reader_version = min_reader_version
        self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        self.format = format
        if schema is not None:
            self.schema = schema
        self.schema_string = schema_string
        self.partition_columns = partition_columns
        if configuration is not None:
            self.configuration = configuration
        if version is not None:
            self.version = version
        if size is not None:
            self.size = size
        if num_files is not None:
            self.num_files = num_files

    @property
    def min_reader_version(self):
        """Gets the min_reader_version of this TableMetadataResponse.  # noqa: E501

        The minimum version of the protocol that a client must implement in order to correctly read a Delta Lake table. Currently it’s always 1. It will be changed in future when we introduce non-forward-compatible changes that require clients to implement.  # noqa: E501

        :return: The min_reader_version of this TableMetadataResponse.  # noqa: E501
        :rtype: int
        """
        return self._min_reader_version

    @min_reader_version.setter
    def min_reader_version(self, min_reader_version):
        """Sets the min_reader_version of this TableMetadataResponse.

        The minimum version of the protocol that a client must implement in order to correctly read a Delta Lake table. Currently it’s always 1. It will be changed in future when we introduce non-forward-compatible changes that require clients to implement.  # noqa: E501

        :param min_reader_version: The min_reader_version of this TableMetadataResponse.  # noqa: E501
        :type: int
        """
        if (
            self.local_vars_configuration.client_side_validation
            and min_reader_version is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `min_reader_version`, must not be `None`"
            )  # noqa: E501

        self._min_reader_version = min_reader_version

    @property
    def id(self):
        """Gets the id of this TableMetadataResponse.  # noqa: E501

        Unique identifier for this table  # noqa: E501

        :return: The id of this TableMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TableMetadataResponse.

        Unique identifier for this table  # noqa: E501

        :param id: The id of this TableMetadataResponse.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this TableMetadataResponse.  # noqa: E501

        User-provided identifier for this table  # noqa: E501

        :return: The name of this TableMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TableMetadataResponse.

        User-provided identifier for this table  # noqa: E501

        :param name: The name of this TableMetadataResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this TableMetadataResponse.  # noqa: E501

        User-provided description for this table  # noqa: E501

        :return: The description of this TableMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TableMetadataResponse.

        User-provided description for this table  # noqa: E501

        :param description: The description of this TableMetadataResponse.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def format(self):
        """Gets the format of this TableMetadataResponse.  # noqa: E501


        :return: The format of this TableMetadataResponse.  # noqa: E501
        :rtype: Format
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this TableMetadataResponse.


        :param format: The format of this TableMetadataResponse.  # noqa: E501
        :type: Format
        """
        if (
            self.local_vars_configuration.client_side_validation and format is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `format`, must not be `None`"
            )  # noqa: E501

        self._format = format

    @property
    def schema(self):
        """Gets the schema of this TableMetadataResponse.  # noqa: E501


        :return: The schema of this TableMetadataResponse.  # noqa: E501
        :rtype: Schema
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """Sets the schema of this TableMetadataResponse.


        :param schema: The schema of this TableMetadataResponse.  # noqa: E501
        :type: Schema
        """

        self._schema = schema

    @property
    def schema_string(self):
        """Gets the schema_string of this TableMetadataResponse.  # noqa: E501

        Schema of the table. This is a serialized JSON string which can be deserialized to a Schema Object.  # noqa: E501

        :return: The schema_string of this TableMetadataResponse.  # noqa: E501
        :rtype: str
        """
        return self._schema_string

    @schema_string.setter
    def schema_string(self, schema_string):
        """Sets the schema_string of this TableMetadataResponse.

        Schema of the table. This is a serialized JSON string which can be deserialized to a Schema Object.  # noqa: E501

        :param schema_string: The schema_string of this TableMetadataResponse.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and schema_string is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `schema_string`, must not be `None`"
            )  # noqa: E501

        self._schema_string = schema_string

    @property
    def partition_columns(self):
        """Gets the partition_columns of this TableMetadataResponse.  # noqa: E501

        An array containing the names of columns by which the data should be partitioned. When a table doesn’t have partition columns, this will be an empty array.  # noqa: E501

        :return: The partition_columns of this TableMetadataResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._partition_columns

    @partition_columns.setter
    def partition_columns(self, partition_columns):
        """Sets the partition_columns of this TableMetadataResponse.

        An array containing the names of columns by which the data should be partitioned. When a table doesn’t have partition columns, this will be an empty array.  # noqa: E501

        :param partition_columns: The partition_columns of this TableMetadataResponse.  # noqa: E501
        :type: list[str]
        """
        if (
            self.local_vars_configuration.client_side_validation
            and partition_columns is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `partition_columns`, must not be `None`"
            )  # noqa: E501

        self._partition_columns = partition_columns

    @property
    def configuration(self):
        """Gets the configuration of this TableMetadataResponse.  # noqa: E501

        A map containing configuration options for the table  # noqa: E501

        :return: The configuration of this TableMetadataResponse.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this TableMetadataResponse.

        A map containing configuration options for the table  # noqa: E501

        :param configuration: The configuration of this TableMetadataResponse.  # noqa: E501
        :type: dict(str, object)
        """

        self._configuration = configuration

    @property
    def version(self):
        """Gets the version of this TableMetadataResponse.  # noqa: E501

        The table version the metadata corresponds to, returned when querying table data with a version or timestamp parameter, or cdf query with includeHistoricalMetadata set to true.  # noqa: E501

        :return: The version of this TableMetadataResponse.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this TableMetadataResponse.

        The table version the metadata corresponds to, returned when querying table data with a version or timestamp parameter, or cdf query with includeHistoricalMetadata set to true.  # noqa: E501

        :param version: The version of this TableMetadataResponse.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def size(self):
        """Gets the size of this TableMetadataResponse.  # noqa: E501

        The size of the table in bytes, will be returned if available in the delta log.  # noqa: E501

        :return: The size of this TableMetadataResponse.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this TableMetadataResponse.

        The size of the table in bytes, will be returned if available in the delta log.  # noqa: E501

        :param size: The size of this TableMetadataResponse.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def num_files(self):
        """Gets the num_files of this TableMetadataResponse.  # noqa: E501

        The number of files in the table, will be returned if available in the delta log.  # noqa: E501

        :return: The num_files of this TableMetadataResponse.  # noqa: E501
        :rtype: int
        """
        return self._num_files

    @num_files.setter
    def num_files(self, num_files):
        """Sets the num_files of this TableMetadataResponse.

        The number of files in the table, will be returned if available in the delta log.  # noqa: E501

        :param num_files: The num_files of this TableMetadataResponse.  # noqa: E501
        :type: int
        """

        self._num_files = num_files

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TableMetadataResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TableMetadataResponse):
            return True

        return self.to_dict() != other.to_dict()
