# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class TeamspacesCreateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "description": "str",
        "icon": "str",
        "visibility": "TeamspaceVisibility",
        "default_credential": "TeamspaceDefaultCredential",
        "default_storage_setting": "StorageSettingsForTeamspaceCreateRequest",
    }

    attribute_map = {
        "name": "name",
        "description": "description",
        "icon": "icon",
        "visibility": "visibility",
        "default_credential": "default_credential",
        "default_storage_setting": "default_storage_setting",
    }

    def __init__(
        self,
        name=None,
        description=None,
        icon=None,
        visibility=None,
        default_credential=None,
        default_storage_setting=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TeamspacesCreateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._icon = None
        self._visibility = None
        self._default_credential = None
        self._default_storage_setting = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        if icon is not None:
            self.icon = icon
        self.visibility = visibility
        if default_credential is not None:
            self.default_credential = default_credential
        if default_storage_setting is not None:
            self.default_storage_setting = default_storage_setting

    @property
    def name(self):
        """Gets the name of this TeamspacesCreateRequest.  # noqa: E501

        The teamspace name  # noqa: E501

        :return: The name of this TeamspacesCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TeamspacesCreateRequest.

        The teamspace name  # noqa: E501

        :param name: The name of this TeamspacesCreateRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and name is not None
            and len(name) > 64
        ):
            raise ValueError(
                "Invalid value for `name`, length must be less than or equal to `64`"
            )  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this TeamspacesCreateRequest.  # noqa: E501

        The teamspace description  # noqa: E501

        :return: The description of this TeamspacesCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this TeamspacesCreateRequest.

        The teamspace description  # noqa: E501

        :param description: The description of this TeamspacesCreateRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def icon(self):
        """Gets the icon of this TeamspacesCreateRequest.  # noqa: E501

        The teamspace icon as a UTF8-encoded Unicode symbol, e.g. 🚀  # noqa: E501

        :return: The icon of this TeamspacesCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """Sets the icon of this TeamspacesCreateRequest.

        The teamspace icon as a UTF8-encoded Unicode symbol, e.g. 🚀  # noqa: E501

        :param icon: The icon of this TeamspacesCreateRequest.  # noqa: E501
        :type: str
        """

        self._icon = icon

    @property
    def visibility(self):
        """Gets the visibility of this TeamspacesCreateRequest.  # noqa: E501


        :return: The visibility of this TeamspacesCreateRequest.  # noqa: E501
        :rtype: TeamspaceVisibility
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """Sets the visibility of this TeamspacesCreateRequest.


        :param visibility: The visibility of this TeamspacesCreateRequest.  # noqa: E501
        :type: TeamspaceVisibility
        """
        if (
            self.local_vars_configuration.client_side_validation and visibility is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `visibility`, must not be `None`"
            )  # noqa: E501

        self._visibility = visibility

    @property
    def default_credential(self):
        """Gets the default_credential of this TeamspacesCreateRequest.  # noqa: E501


        :return: The default_credential of this TeamspacesCreateRequest.  # noqa: E501
        :rtype: TeamspaceDefaultCredential
        """
        return self._default_credential

    @default_credential.setter
    def default_credential(self, default_credential):
        """Sets the default_credential of this TeamspacesCreateRequest.


        :param default_credential: The default_credential of this TeamspacesCreateRequest.  # noqa: E501
        :type: TeamspaceDefaultCredential
        """

        self._default_credential = default_credential

    @property
    def default_storage_setting(self):
        """Gets the default_storage_setting of this TeamspacesCreateRequest.  # noqa: E501


        :return: The default_storage_setting of this TeamspacesCreateRequest.  # noqa: E501
        :rtype: StorageSettingsForTeamspaceCreateRequest
        """
        return self._default_storage_setting

    @default_storage_setting.setter
    def default_storage_setting(self, default_storage_setting):
        """Sets the default_storage_setting of this TeamspacesCreateRequest.


        :param default_storage_setting: The default_storage_setting of this TeamspacesCreateRequest.  # noqa: E501
        :type: StorageSettingsForTeamspaceCreateRequest
        """

        self._default_storage_setting = default_storage_setting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TeamspacesCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TeamspacesCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
