# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class TokenCreateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "scope": "TokenScope",
        "workspace_id": "str",
        "expires_at": "datetime",
    }

    attribute_map = {
        "name": "name",
        "scope": "scope",
        "workspace_id": "workspace_id",
        "expires_at": "expires_at",
    }

    def __init__(
        self,
        name=None,
        scope=None,
        workspace_id=None,
        expires_at=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TokenCreateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._scope = None
        self._workspace_id = None
        self._expires_at = None
        self.discriminator = None

        if name is not None:
            self.name = name
        self.scope = scope
        if workspace_id is not None:
            self.workspace_id = workspace_id
        if expires_at is not None:
            self.expires_at = expires_at

    @property
    def name(self):
        """Gets the name of this TokenCreateRequest.  # noqa: E501

        A human-readable name for the token. The name must be provided if the token is an API token (i.e. if `workspace_id` is provided).   # noqa: E501

        :return: The name of this TokenCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TokenCreateRequest.

        A human-readable name for the token. The name must be provided if the token is an API token (i.e. if `workspace_id` is provided).   # noqa: E501

        :param name: The name of this TokenCreateRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def scope(self):
        """Gets the scope of this TokenCreateRequest.  # noqa: E501


        :return: The scope of this TokenCreateRequest.  # noqa: E501
        :rtype: TokenScope
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this TokenCreateRequest.


        :param scope: The scope of this TokenCreateRequest.  # noqa: E501
        :type: TokenScope
        """
        if (
            self.local_vars_configuration.client_side_validation and scope is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `scope`, must not be `None`"
            )  # noqa: E501

        self._scope = scope

    @property
    def workspace_id(self):
        """Gets the workspace_id of this TokenCreateRequest.  # noqa: E501

        The workspace ID or Name that the token will be scoped for. This must be provided if the token is meant to be an API token (instead of a session token).   # noqa: E501

        :return: The workspace_id of this TokenCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """Sets the workspace_id of this TokenCreateRequest.

        The workspace ID or Name that the token will be scoped for. This must be provided if the token is meant to be an API token (instead of a session token).   # noqa: E501

        :param workspace_id: The workspace_id of this TokenCreateRequest.  # noqa: E501
        :type: str
        """

        self._workspace_id = workspace_id

    @property
    def expires_at(self):
        """Gets the expires_at of this TokenCreateRequest.  # noqa: E501

        The expiration date and time of the token. If no expiration date is provided, the server will set the default expiration date.   # noqa: E501

        :return: The expires_at of this TokenCreateRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this TokenCreateRequest.

        The expiration date and time of the token. If no expiration date is provided, the server will set the default expiration date.   # noqa: E501

        :param expires_at: The expires_at of this TokenCreateRequest.  # noqa: E501
        :type: datetime
        """

        self._expires_at = expires_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TokenCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TokenCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
